/*
 * Decompiled with CFR 0.152.
 */
package android.support.customtabs;

import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public interface ICustomTabsCallback
extends IInterface {
    public static final String DESCRIPTOR = "android$support$customtabs$ICustomTabsCallback".replace('$', '.');

    public void onNavigationEvent(int var1, Bundle var2) throws RemoteException;

    public void extraCallback(String var1, Bundle var2) throws RemoteException;

    public void onMessageChannelReady(Bundle var1) throws RemoteException;

    public void onPostMessage(String var1, Bundle var2) throws RemoteException;

    public void onRelationshipValidationResult(int var1, Uri var2, boolean var3, Bundle var4) throws RemoteException;

    public Bundle extraCallbackWithResult(String var1, Bundle var2) throws RemoteException;

    public void onActivityResized(int var1, int var2, Bundle var3) throws RemoteException;

    public void onWarmupCompleted(Bundle var1) throws RemoteException;

    public void onActivityLayout(int var1, int var2, int var3, int var4, int var5, Bundle var6) throws RemoteException;

    public void onMinimized(Bundle var1) throws RemoteException;

    public void onUnminimized(Bundle var1) throws RemoteException;

    public static class _Parcel {
        private static <T> T readTypedObject(Parcel parcel, Parcelable.Creator<T> c) {
            if (parcel.readInt() != 0) {
                return (T)c.createFromParcel(parcel);
            }
            return null;
        }

        private static <T extends Parcelable> void writeTypedObject(Parcel parcel, T value, int parcelableFlags) {
            if (value != null) {
                parcel.writeInt(1);
                value.writeToParcel(parcel, parcelableFlags);
            } else {
                parcel.writeInt(0);
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements ICustomTabsCallback {
        static final int TRANSACTION_onNavigationEvent = 2;
        static final int TRANSACTION_extraCallback = 3;
        static final int TRANSACTION_onMessageChannelReady = 4;
        static final int TRANSACTION_onPostMessage = 5;
        static final int TRANSACTION_onRelationshipValidationResult = 6;
        static final int TRANSACTION_extraCallbackWithResult = 7;
        static final int TRANSACTION_onActivityResized = 8;
        static final int TRANSACTION_onWarmupCompleted = 9;
        static final int TRANSACTION_onActivityLayout = 10;
        static final int TRANSACTION_onMinimized = 11;
        static final int TRANSACTION_onUnminimized = 12;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICustomTabsCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICustomTabsCallback) {
                return (ICustomTabsCallback)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 2: {
                    int _arg0 = data.readInt();
                    Bundle _arg1 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.onNavigationEvent(_arg0, _arg1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.extraCallback(_arg0, _arg1);
                    break;
                }
                case 4: {
                    Bundle _arg0 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.onMessageChannelReady(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.onPostMessage(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    Uri _arg1 = (Uri)_Parcel.readTypedObject(data, Uri.CREATOR);
                    boolean _arg2 = 0 != data.readInt();
                    Bundle _arg3 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.onRelationshipValidationResult(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    Bundle _result = this.extraCallbackWithResult(_arg0, _arg1);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, (Parcelable)_result, 1);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    Bundle _arg2 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.onActivityResized(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    Bundle _arg0 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.onWarmupCompleted(_arg0);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    Bundle _arg5 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.onActivityLayout(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 11: {
                    Bundle _arg0 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.onMinimized(_arg0);
                    break;
                }
                case 12: {
                    Bundle _arg0 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    this.onUnminimized(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ICustomTabsCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNavigationEvent(int navigationEvent, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(navigationEvent);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void extraCallback(String callbackName, Bundle args) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(callbackName);
                    _Parcel.writeTypedObject(_data, (Parcelable)args, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessageChannelReady(Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPostMessage(String message, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(message);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRelationshipValidationResult(int relation, Uri origin, boolean result, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(relation);
                    _Parcel.writeTypedObject(_data, (Parcelable)origin, 0);
                    _data.writeInt(result ? 1 : 0);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle extraCallbackWithResult(String callbackName, Bundle args) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(callbackName);
                    _Parcel.writeTypedObject(_data, (Parcelable)args, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = (Bundle)_Parcel.readTypedObject(_reply, Bundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityResized(int height, int width, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(height);
                    _data.writeInt(width);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWarmupCompleted(Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityLayout(int left, int top, int right, int bottom, int state, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(left);
                    _data.writeInt(top);
                    _data.writeInt(right);
                    _data.writeInt(bottom);
                    _data.writeInt(state);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMinimized(Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUnminimized(Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICustomTabsCallback {
        @Override
        public void onNavigationEvent(int navigationEvent, Bundle extras) throws RemoteException {
        }

        @Override
        public void extraCallback(String callbackName, Bundle args) throws RemoteException {
        }

        @Override
        public void onMessageChannelReady(Bundle extras) throws RemoteException {
        }

        @Override
        public void onPostMessage(String message, Bundle extras) throws RemoteException {
        }

        @Override
        public void onRelationshipValidationResult(int relation, Uri origin, boolean result, Bundle extras) throws RemoteException {
        }

        @Override
        public Bundle extraCallbackWithResult(String callbackName, Bundle args) throws RemoteException {
            return null;
        }

        @Override
        public void onActivityResized(int height, int width, Bundle extras) throws RemoteException {
        }

        @Override
        public void onWarmupCompleted(Bundle extras) throws RemoteException {
        }

        @Override
        public void onActivityLayout(int left, int top, int right, int bottom, int state, Bundle extras) throws RemoteException {
        }

        @Override
        public void onMinimized(Bundle extras) throws RemoteException {
        }

        @Override
        public void onUnminimized(Bundle extras) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

