/*
 * Decompiled with CFR 0.152.
 */
package android.support.customtabs;

import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.customtabs.ICustomTabsCallback;
import androidx.annotation.RestrictTo;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public interface ICustomTabsService
extends IInterface {
    public static final String DESCRIPTOR = "android$support$customtabs$ICustomTabsService".replace('$', '.');

    public boolean warmup(long var1) throws RemoteException;

    public boolean newSession(ICustomTabsCallback var1) throws RemoteException;

    public boolean newSessionWithExtras(ICustomTabsCallback var1, Bundle var2) throws RemoteException;

    public boolean mayLaunchUrl(ICustomTabsCallback var1, Uri var2, Bundle var3, List<Bundle> var4) throws RemoteException;

    public Bundle extraCommand(String var1, Bundle var2) throws RemoteException;

    public boolean updateVisuals(ICustomTabsCallback var1, Bundle var2) throws RemoteException;

    public boolean requestPostMessageChannel(ICustomTabsCallback var1, Uri var2) throws RemoteException;

    public boolean requestPostMessageChannelWithExtras(ICustomTabsCallback var1, Uri var2, Bundle var3) throws RemoteException;

    public int postMessage(ICustomTabsCallback var1, String var2, Bundle var3) throws RemoteException;

    public boolean validateRelationship(ICustomTabsCallback var1, int var2, Uri var3, Bundle var4) throws RemoteException;

    public boolean receiveFile(ICustomTabsCallback var1, Uri var2, int var3, Bundle var4) throws RemoteException;

    public boolean isEngagementSignalsApiAvailable(ICustomTabsCallback var1, Bundle var2) throws RemoteException;

    public boolean setEngagementSignalsCallback(ICustomTabsCallback var1, IBinder var2, Bundle var3) throws RemoteException;

    public static class _Parcel {
        private static <T> T readTypedObject(Parcel parcel, Parcelable.Creator<T> c) {
            if (parcel.readInt() != 0) {
                return (T)c.createFromParcel(parcel);
            }
            return null;
        }

        private static <T extends Parcelable> void writeTypedObject(Parcel parcel, T value, int parcelableFlags) {
            if (value != null) {
                parcel.writeInt(1);
                value.writeToParcel(parcel, parcelableFlags);
            } else {
                parcel.writeInt(0);
            }
        }

        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N = value.size();
                parcel.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    _Parcel.writeTypedObject(parcel, (Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements ICustomTabsService {
        static final int TRANSACTION_warmup = 2;
        static final int TRANSACTION_newSession = 3;
        static final int TRANSACTION_newSessionWithExtras = 10;
        static final int TRANSACTION_mayLaunchUrl = 4;
        static final int TRANSACTION_extraCommand = 5;
        static final int TRANSACTION_updateVisuals = 6;
        static final int TRANSACTION_requestPostMessageChannel = 7;
        static final int TRANSACTION_requestPostMessageChannelWithExtras = 11;
        static final int TRANSACTION_postMessage = 8;
        static final int TRANSACTION_validateRelationship = 9;
        static final int TRANSACTION_receiveFile = 12;
        static final int TRANSACTION_isEngagementSignalsApiAvailable = 13;
        static final int TRANSACTION_setEngagementSignalsCallback = 14;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICustomTabsService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICustomTabsService) {
                return (ICustomTabsService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 2: {
                    long _arg0 = data.readLong();
                    boolean _result = this.warmup(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 3: {
                    ICustomTabsCallback _arg0 = ICustomTabsCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.newSession(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 10: {
                    ICustomTabsCallback _arg0 = ICustomTabsCallback.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    boolean _result = this.newSessionWithExtras(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 4: {
                    ICustomTabsCallback _arg0 = ICustomTabsCallback.Stub.asInterface(data.readStrongBinder());
                    Uri _arg1 = (Uri)_Parcel.readTypedObject(data, Uri.CREATOR);
                    Bundle _arg2 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    ArrayList _arg3 = data.createTypedArrayList(Bundle.CREATOR);
                    boolean _result = this.mayLaunchUrl(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    Bundle _result = this.extraCommand(_arg0, _arg1);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, (Parcelable)_result, 1);
                    break;
                }
                case 6: {
                    ICustomTabsCallback _arg0 = ICustomTabsCallback.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    boolean _result = this.updateVisuals(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 7: {
                    ICustomTabsCallback _arg0 = ICustomTabsCallback.Stub.asInterface(data.readStrongBinder());
                    Uri _arg1 = (Uri)_Parcel.readTypedObject(data, Uri.CREATOR);
                    boolean _result = this.requestPostMessageChannel(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 11: {
                    ICustomTabsCallback _arg0 = ICustomTabsCallback.Stub.asInterface(data.readStrongBinder());
                    Uri _arg1 = (Uri)_Parcel.readTypedObject(data, Uri.CREATOR);
                    Bundle _arg2 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    boolean _result = this.requestPostMessageChannelWithExtras(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 8: {
                    ICustomTabsCallback _arg0 = ICustomTabsCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    Bundle _arg2 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    int _result = this.postMessage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 9: {
                    ICustomTabsCallback _arg0 = ICustomTabsCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    Uri _arg2 = (Uri)_Parcel.readTypedObject(data, Uri.CREATOR);
                    Bundle _arg3 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    boolean _result = this.validateRelationship(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 12: {
                    ICustomTabsCallback _arg0 = ICustomTabsCallback.Stub.asInterface(data.readStrongBinder());
                    Uri _arg1 = (Uri)_Parcel.readTypedObject(data, Uri.CREATOR);
                    int _arg2 = data.readInt();
                    Bundle _arg3 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    boolean _result = this.receiveFile(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 13: {
                    ICustomTabsCallback _arg0 = ICustomTabsCallback.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    boolean _result = this.isEngagementSignalsApiAvailable(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 14: {
                    ICustomTabsCallback _arg0 = ICustomTabsCallback.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg1 = data.readStrongBinder();
                    Bundle _arg2 = (Bundle)_Parcel.readTypedObject(data, Bundle.CREATOR);
                    boolean _result = this.setEngagementSignalsCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ICustomTabsService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean warmup(long flags) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeLong(flags);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean newSession(ICustomTabsCallback callback) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean newSessionWithExtras(ICustomTabsCallback callback, Bundle extras) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)callback);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean mayLaunchUrl(ICustomTabsCallback callback, Uri url, Bundle extras, List<Bundle> otherLikelyBundles) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)callback);
                    _Parcel.writeTypedObject(_data, (Parcelable)url, 0);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    _Parcel.writeTypedList(_data, otherLikelyBundles, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle extraCommand(String commandName, Bundle args) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(commandName);
                    _Parcel.writeTypedObject(_data, (Parcelable)args, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = (Bundle)_Parcel.readTypedObject(_reply, Bundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean updateVisuals(ICustomTabsCallback callback, Bundle bundle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)callback);
                    _Parcel.writeTypedObject(_data, (Parcelable)bundle, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestPostMessageChannel(ICustomTabsCallback callback, Uri postMessageOrigin) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)callback);
                    _Parcel.writeTypedObject(_data, (Parcelable)postMessageOrigin, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestPostMessageChannelWithExtras(ICustomTabsCallback callback, Uri postMessageOrigin, Bundle extras) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)callback);
                    _Parcel.writeTypedObject(_data, (Parcelable)postMessageOrigin, 0);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int postMessage(ICustomTabsCallback callback, String message, Bundle extras) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)callback);
                    _data.writeString(message);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean validateRelationship(ICustomTabsCallback callback, int relation, Uri origin, Bundle extras) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)callback);
                    _data.writeInt(relation);
                    _Parcel.writeTypedObject(_data, (Parcelable)origin, 0);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean receiveFile(ICustomTabsCallback callback, Uri uri, int purpose, Bundle extras) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)callback);
                    _Parcel.writeTypedObject(_data, (Parcelable)uri, 0);
                    _data.writeInt(purpose);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEngagementSignalsApiAvailable(ICustomTabsCallback customTabsCallback, Bundle extras) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)customTabsCallback);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setEngagementSignalsCallback(ICustomTabsCallback customTabsCallback, IBinder callback, Bundle extras) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)customTabsCallback);
                    _data.writeStrongBinder(callback);
                    _Parcel.writeTypedObject(_data, (Parcelable)extras, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ICustomTabsService {
        @Override
        public boolean warmup(long flags) throws RemoteException {
            return false;
        }

        @Override
        public boolean newSession(ICustomTabsCallback callback) throws RemoteException {
            return false;
        }

        @Override
        public boolean newSessionWithExtras(ICustomTabsCallback callback, Bundle extras) throws RemoteException {
            return false;
        }

        @Override
        public boolean mayLaunchUrl(ICustomTabsCallback callback, Uri url, Bundle extras, List<Bundle> otherLikelyBundles) throws RemoteException {
            return false;
        }

        @Override
        public Bundle extraCommand(String commandName, Bundle args) throws RemoteException {
            return null;
        }

        @Override
        public boolean updateVisuals(ICustomTabsCallback callback, Bundle bundle) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestPostMessageChannel(ICustomTabsCallback callback, Uri postMessageOrigin) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestPostMessageChannelWithExtras(ICustomTabsCallback callback, Uri postMessageOrigin, Bundle extras) throws RemoteException {
            return false;
        }

        @Override
        public int postMessage(ICustomTabsCallback callback, String message, Bundle extras) throws RemoteException {
            return 0;
        }

        @Override
        public boolean validateRelationship(ICustomTabsCallback callback, int relation, Uri origin, Bundle extras) throws RemoteException {
            return false;
        }

        @Override
        public boolean receiveFile(ICustomTabsCallback callback, Uri uri, int purpose, Bundle extras) throws RemoteException {
            return false;
        }

        @Override
        public boolean isEngagementSignalsApiAvailable(ICustomTabsCallback customTabsCallback, Bundle extras) throws RemoteException {
            return false;
        }

        @Override
        public boolean setEngagementSignalsCallback(ICustomTabsCallback customTabsCallback, IBinder callback, Bundle extras) throws RemoteException {
            return false;
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

