/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.customtabs;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.customtabs.ICustomTabsCallback;
import android.support.customtabs.ICustomTabsService;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import androidx.browser.customtabs.CustomTabsSession;
import java.util.ArrayList;
import java.util.List;

public class CustomTabsClient {
    private static final String TAG = "CustomTabsClient";
    private final ICustomTabsService mService;
    private final ComponentName mServiceComponentName;
    private final Context mApplicationContext;

    CustomTabsClient(ICustomTabsService service, ComponentName componentName, Context applicationContext) {
        this.mService = service;
        this.mServiceComponentName = componentName;
        this.mApplicationContext = applicationContext;
    }

    public static boolean bindCustomTabsService(@NonNull Context context, @Nullable String packageName, @NonNull CustomTabsServiceConnection connection) {
        connection.setApplicationContext(context.getApplicationContext());
        Intent intent = new Intent("android.support.customtabs.action.CustomTabsService");
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            intent.setPackage(packageName);
        }
        return context.bindService(intent, (ServiceConnection)connection, 33);
    }

    public static boolean bindCustomTabsServicePreservePriority(@NonNull Context context, @Nullable String packageName, @NonNull CustomTabsServiceConnection connection) {
        connection.setApplicationContext(context.getApplicationContext());
        Intent intent = new Intent("android.support.customtabs.action.CustomTabsService");
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            intent.setPackage(packageName);
        }
        return context.bindService(intent, (ServiceConnection)connection, 1);
    }

    @Nullable
    public static String getPackageName(@NonNull Context context, @Nullable List<String> packages) {
        return CustomTabsClient.getPackageName(context, packages, false);
    }

    @Nullable
    public static String getPackageName(@NonNull Context context, @Nullable List<String> packages, boolean ignoreDefault) {
        ResolveInfo defaultViewHandlerInfo;
        PackageManager pm = context.getPackageManager();
        ArrayList<String> packageNames = packages == null ? new ArrayList<String>() : packages;
        Intent activityIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://"));
        if (!ignoreDefault && (defaultViewHandlerInfo = pm.resolveActivity(activityIntent, 0)) != null) {
            String packageName = defaultViewHandlerInfo.activityInfo.packageName;
            packageNames = new ArrayList(packageNames.size() + 1);
            packageNames.add(packageName);
            if (packages != null) {
                packageNames.addAll(packages);
            }
        }
        Intent serviceIntent = new Intent("android.support.customtabs.action.CustomTabsService");
        for (String packageName : packageNames) {
            serviceIntent.setPackage(packageName);
            if (pm.resolveService(serviceIntent, 0) == null) continue;
            return packageName;
        }
        if (Build.VERSION.SDK_INT >= 30) {
            Log.w((String)TAG, (String)"Unable to find any Custom Tabs packages, you may need to add a <queries> element to your manifest. See the docs for CustomTabsClient#getPackageName.");
        }
        return null;
    }

    public static boolean connectAndInitialize(@NonNull Context context, @NonNull String packageName) {
        if (packageName == null) {
            return false;
        }
        final Context applicationContext = context.getApplicationContext();
        CustomTabsServiceConnection connection = new CustomTabsServiceConnection(){

            @Override
            public final void onCustomTabsServiceConnected(@NonNull ComponentName name, @NonNull CustomTabsClient client) {
                client.warmup(0L);
                applicationContext.unbindService((ServiceConnection)this);
            }

            public void onServiceDisconnected(ComponentName componentName) {
            }
        };
        try {
            return CustomTabsClient.bindCustomTabsService(applicationContext, packageName, connection);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public boolean warmup(long flags) {
        try {
            return this.mService.warmup(flags);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private static PendingIntent createSessionId(Context context, int sessionId) {
        return PendingIntent.getActivity((Context)context, (int)sessionId, (Intent)new Intent(), (int)0x4000000);
    }

    @Nullable
    public CustomTabsSession newSession(@Nullable CustomTabsCallback callback) {
        return this.newSessionInternal(callback, null);
    }

    @Nullable
    public CustomTabsSession newSession(@Nullable CustomTabsCallback callback, int id2) {
        return this.newSessionInternal(callback, CustomTabsClient.createSessionId(this.mApplicationContext, id2));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public static CustomTabsSession.PendingSession newPendingSession(@NonNull Context context, @Nullable CustomTabsCallback callback, int id2) {
        PendingIntent sessionId = CustomTabsClient.createSessionId(context, id2);
        return new CustomTabsSession.PendingSession(callback, sessionId);
    }

    @Nullable
    private CustomTabsSession newSessionInternal(@Nullable CustomTabsCallback callback, @Nullable PendingIntent sessionId) {
        ICustomTabsCallback.Stub wrapper = this.createCallbackWrapper(callback);
        try {
            boolean success;
            if (sessionId != null) {
                Bundle extras = new Bundle();
                extras.putParcelable("android.support.customtabs.extra.SESSION_ID", (Parcelable)sessionId);
                success = this.mService.newSessionWithExtras(wrapper, extras);
            } else {
                success = this.mService.newSession(wrapper);
            }
            if (!success) {
                return null;
            }
        }
        catch (RemoteException e) {
            return null;
        }
        return new CustomTabsSession(this.mService, wrapper, this.mServiceComponentName, sessionId);
    }

    @Nullable
    public Bundle extraCommand(@NonNull String commandName, @Nullable Bundle args) {
        try {
            return this.mService.extraCommand(commandName, args);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private ICustomTabsCallback.Stub createCallbackWrapper(final @Nullable CustomTabsCallback callback) {
        return new ICustomTabsCallback.Stub(){
            private Handler mHandler = new Handler(Looper.getMainLooper());

            @Override
            public void onNavigationEvent(final int navigationEvent, final Bundle extras) {
                if (callback == null) {
                    return;
                }
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onNavigationEvent(navigationEvent, extras);
                    }
                });
            }

            @Override
            public void extraCallback(final String callbackName, final Bundle args) throws RemoteException {
                if (callback == null) {
                    return;
                }
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.extraCallback(callbackName, args);
                    }
                });
            }

            @Override
            public Bundle extraCallbackWithResult(@NonNull String callbackName, @Nullable Bundle args) throws RemoteException {
                if (callback == null) {
                    return null;
                }
                return callback.extraCallbackWithResult(callbackName, args);
            }

            @Override
            public void onMessageChannelReady(final Bundle extras) throws RemoteException {
                if (callback == null) {
                    return;
                }
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onMessageChannelReady(extras);
                    }
                });
            }

            @Override
            public void onPostMessage(final String message, final Bundle extras) throws RemoteException {
                if (callback == null) {
                    return;
                }
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onPostMessage(message, extras);
                    }
                });
            }

            @Override
            public void onRelationshipValidationResult(final int relation, final Uri requestedOrigin, final boolean result, final @Nullable Bundle extras) throws RemoteException {
                if (callback == null) {
                    return;
                }
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onRelationshipValidationResult(relation, requestedOrigin, result, extras);
                    }
                });
            }

            @Override
            public void onActivityResized(final int height, final int width, final @Nullable Bundle extras) throws RemoteException {
                if (callback == null) {
                    return;
                }
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onActivityResized(height, width, extras);
                    }
                });
            }

            @Override
            public void onWarmupCompleted(final @NonNull Bundle extras) throws RemoteException {
                if (callback == null) {
                    return;
                }
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onWarmupCompleted(extras);
                    }
                });
            }

            @Override
            public void onActivityLayout(final int left, final int top, final int right, final int bottom, final int state, final @NonNull Bundle extras) throws RemoteException {
                if (callback == null) {
                    return;
                }
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onActivityLayout(left, top, right, bottom, state, extras);
                    }
                });
            }

            @Override
            public void onMinimized(final @NonNull Bundle extras) throws RemoteException {
                if (callback == null) {
                    return;
                }
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onMinimized(extras);
                    }
                });
            }

            @Override
            public void onUnminimized(final @NonNull Bundle extras) throws RemoteException {
                if (callback == null) {
                    return;
                }
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onUnminimized(extras);
                    }
                });
            }
        };
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public CustomTabsSession attachSession(@NonNull CustomTabsSession.PendingSession session) {
        return this.newSessionInternal(session.getCallback(), session.getId());
    }
}

