/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.trusted;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class TokenContents {
    @NonNull
    private final byte[] mContents;
    @Nullable
    private String mPackageName;
    @Nullable
    private List<byte[]> mFingerprints;

    @NonNull
    static TokenContents deserialize(@NonNull byte[] serialized) {
        return new TokenContents(serialized);
    }

    private TokenContents(@NonNull byte[] contents) {
        this.mContents = contents;
    }

    @NonNull
    static TokenContents create(String packageName, List<byte[]> fingerprints) throws IOException {
        return new TokenContents(TokenContents.createToken(packageName, fingerprints), packageName, fingerprints);
    }

    private TokenContents(@NonNull byte[] contents, @NonNull String packageName, @NonNull List<byte[]> fingerprints) {
        this.mContents = contents;
        this.mPackageName = packageName;
        this.mFingerprints = new ArrayList<byte[]>(fingerprints.size());
        for (byte[] fingerprint : fingerprints) {
            this.mFingerprints.add(Arrays.copyOf(fingerprint, fingerprint.length));
        }
    }

    @NonNull
    public String getPackageName() throws IOException {
        this.parseIfNeeded();
        if (this.mPackageName == null) {
            throw new IllegalStateException();
        }
        return this.mPackageName;
    }

    public int getFingerprintCount() throws IOException {
        this.parseIfNeeded();
        if (this.mFingerprints == null) {
            throw new IllegalStateException();
        }
        return this.mFingerprints.size();
    }

    @NonNull
    public byte[] getFingerprint(int i) throws IOException {
        this.parseIfNeeded();
        if (this.mFingerprints == null) {
            throw new IllegalStateException();
        }
        return Arrays.copyOf(this.mFingerprints.get(i), this.mFingerprints.get(i).length);
    }

    @NonNull
    public byte[] serialize() {
        return Arrays.copyOf(this.mContents, this.mContents.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenContents that = (TokenContents)o;
        return Arrays.equals(this.mContents, that.mContents);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mContents);
    }

    @NonNull
    private static byte[] createToken(@NonNull String packageName, @NonNull List<byte[]> fingerprints) throws IOException {
        Collections.sort(fingerprints, TokenContents::compareByteArrays);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream writer = new DataOutputStream(baos);
        writer.writeUTF(packageName);
        writer.writeInt(fingerprints.size());
        for (byte[] fingerprint : fingerprints) {
            writer.writeInt(fingerprint.length);
            writer.write(fingerprint);
        }
        writer.flush();
        return baos.toByteArray();
    }

    private static int compareByteArrays(byte[] a, byte[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        for (int i = 0; i < Math.min(a.length, b.length); ++i) {
            if (a[i] == b[i]) continue;
            return a[i] - b[i];
        }
        if (a.length != b.length) {
            return a.length - b.length;
        }
        return 0;
    }

    private void parseIfNeeded() throws IOException {
        if (this.mPackageName != null) {
            return;
        }
        DataInputStream reader = new DataInputStream(new ByteArrayInputStream(this.mContents));
        this.mPackageName = reader.readUTF();
        int numFingerprints = reader.readInt();
        this.mFingerprints = new ArrayList<byte[]>(numFingerprints);
        for (int i = 0; i < numFingerprints; ++i) {
            int size = reader.readInt();
            byte[] fingerprint = new byte[size];
            int bytesRead = reader.read(fingerprint);
            if (bytesRead != size) {
                throw new IllegalStateException("Could not read fingerprint");
            }
            this.mFingerprints.add(fingerprint);
        }
    }
}

