/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.viewsintegration;

import android.text.TextWatcher;
import android.text.method.KeyListener;
import android.text.method.NumberKeyListener;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.Preconditions;
import androidx.emoji2.viewsintegration.EmojiEditableFactory;
import androidx.emoji2.viewsintegration.EmojiInputConnection;
import androidx.emoji2.viewsintegration.EmojiKeyListener;
import androidx.emoji2.viewsintegration.EmojiTextWatcher;

public final class EmojiEditTextHelper {
    private int mMaxEmojiCount = Integer.MAX_VALUE;
    private int mEmojiReplaceStrategy = 0;
    private final EditText mEditText;
    private final EmojiTextWatcher mTextWatcher;

    public EmojiEditTextHelper(@NonNull EditText editText) {
        this(editText, true);
    }

    public EmojiEditTextHelper(@NonNull EditText editText, boolean expectInitializedEmojiCompat) {
        Preconditions.checkNotNull((Object)editText, (Object)"editText cannot be null");
        this.mEditText = editText;
        this.mTextWatcher = new EmojiTextWatcher(this.mEditText, expectInitializedEmojiCompat);
        this.mEditText.addTextChangedListener((TextWatcher)this.mTextWatcher);
        this.mEditText.setEditableFactory(EmojiEditableFactory.getInstance());
    }

    public void setMaxEmojiCount(@IntRange(from=0L) int maxEmojiCount) {
        Preconditions.checkArgumentNonnegative((int)maxEmojiCount, (String)"maxEmojiCount should be greater than 0");
        this.mMaxEmojiCount = maxEmojiCount;
        this.mTextWatcher.setMaxEmojiCount(maxEmojiCount);
    }

    public int getMaxEmojiCount() {
        return this.mMaxEmojiCount;
    }

    @Nullable
    public KeyListener getKeyListener(@Nullable KeyListener keyListener) {
        if (keyListener instanceof EmojiKeyListener) {
            return keyListener;
        }
        if (keyListener == null) {
            return null;
        }
        if (keyListener instanceof NumberKeyListener) {
            return keyListener;
        }
        return new EmojiKeyListener(keyListener);
    }

    @Nullable
    public InputConnection onCreateInputConnection(@Nullable InputConnection inputConnection, @NonNull EditorInfo outAttrs) {
        if (inputConnection == null) {
            return null;
        }
        if (inputConnection instanceof EmojiInputConnection) {
            return inputConnection;
        }
        return new EmojiInputConnection((TextView)this.mEditText, inputConnection, outAttrs);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setEmojiReplaceStrategy(int replaceStrategy) {
        this.mEmojiReplaceStrategy = replaceStrategy;
        this.mTextWatcher.setEmojiReplaceStrategy(replaceStrategy);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getEmojiReplaceStrategy() {
        return this.mEmojiReplaceStrategy;
    }

    public boolean isEnabled() {
        return this.mTextWatcher.isEnabled();
    }

    public void setEnabled(boolean isEnabled) {
        this.mTextWatcher.setEnabled(isEnabled);
    }
}

