/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.viewsintegration;

import android.os.Handler;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.widget.EditText;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.emoji2.text.EmojiCompat;
import androidx.emoji2.viewsintegration.EmojiInputFilter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
final class EmojiTextWatcher
implements TextWatcher {
    private final EditText mEditText;
    private final boolean mExpectInitializedEmojiCompat;
    private EmojiCompat.InitCallback mInitCallback;
    private int mMaxEmojiCount = Integer.MAX_VALUE;
    private int mEmojiReplaceStrategy = 0;
    private boolean mEnabled;
    private int mLastEditPosition;
    private int mLastEditLength;

    EmojiTextWatcher(EditText editText, boolean expectInitializedEmojiCompat) {
        this.mEditText = editText;
        this.mExpectInitializedEmojiCompat = expectInitializedEmojiCompat;
        this.mEnabled = true;
    }

    void setMaxEmojiCount(int maxEmojiCount) {
        this.mMaxEmojiCount = maxEmojiCount;
    }

    int getMaxEmojiCount() {
        return this.mMaxEmojiCount;
    }

    int getEmojiReplaceStrategy() {
        return this.mEmojiReplaceStrategy;
    }

    void setEmojiReplaceStrategy(int replaceStrategy) {
        this.mEmojiReplaceStrategy = replaceStrategy;
    }

    public void onTextChanged(CharSequence charSequence, int start, int before, int after) {
        this.mLastEditPosition = start;
        this.mLastEditLength = after;
    }

    private boolean shouldSkipForDisabledOrNotConfigured() {
        return !this.mEnabled || !this.mExpectInitializedEmojiCompat && !EmojiCompat.isConfigured();
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
        if (this.mEditText.isInEditMode() || this.shouldSkipForDisabledOrNotConfigured()) {
            return;
        }
        int pos = this.mLastEditPosition;
        int length = this.mLastEditLength;
        if (length > 0) {
            switch (EmojiCompat.get().getLoadState()) {
                case 1: {
                    EmojiCompat.get().process((CharSequence)s, pos, pos + length, this.mMaxEmojiCount, this.mEmojiReplaceStrategy);
                    break;
                }
                case 0: 
                case 3: {
                    EmojiCompat.get().registerInitCallback(this.getInitCallback());
                    break;
                }
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    EmojiCompat.InitCallback getInitCallback() {
        if (this.mInitCallback == null) {
            this.mInitCallback = new InitCallbackImpl(this.mEditText);
        }
        return this.mInitCallback;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        if (this.mEnabled != isEnabled) {
            if (this.mInitCallback != null) {
                EmojiCompat.get().unregisterInitCallback(this.mInitCallback);
            }
            this.mEnabled = isEnabled;
            if (this.mEnabled) {
                EmojiTextWatcher.processTextOnEnablingEvent(this.mEditText, EmojiCompat.get().getLoadState());
            }
        }
    }

    static void processTextOnEnablingEvent(@Nullable EditText editText, int currentLoadState) {
        if (currentLoadState == 1 && editText != null && editText.isAttachedToWindow()) {
            Editable text = editText.getEditableText();
            int selectionStart = Selection.getSelectionStart((CharSequence)text);
            int selectionEnd = Selection.getSelectionEnd((CharSequence)text);
            EmojiCompat.get().process((CharSequence)text);
            EmojiInputFilter.updateSelection((Spannable)text, selectionStart, selectionEnd);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static class InitCallbackImpl
    extends EmojiCompat.InitCallback
    implements Runnable {
        private final Reference<EditText> mViewRef;

        InitCallbackImpl(EditText editText) {
            this.mViewRef = new WeakReference<EditText>(editText);
        }

        public void onInitialized() {
            super.onInitialized();
            EditText editText = this.mViewRef.get();
            if (editText == null) {
                return;
            }
            Handler handler = editText.getHandler();
            if (handler == null) {
                return;
            }
            handler.post((Runnable)this);
        }

        @Override
        public void run() {
            EditText editText = this.mViewRef.get();
            EmojiTextWatcher.processTextOnEnablingEvent(editText, 1);
        }
    }
}

