/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data.mediastore;

import android.net.Uri;

public final class MediaStoreUtil {
    private static final int MINI_THUMB_WIDTH = 512;
    private static final int MINI_THUMB_HEIGHT = 384;

    private MediaStoreUtil() {
    }

    public static boolean isMediaStoreUri(Uri uri) {
        return uri != null && "content".equals(uri.getScheme()) && "media".equals(uri.getAuthority());
    }

    public static boolean isAndroidPickerUri(Uri uri) {
        return MediaStoreUtil.isMediaStoreUri(uri) && uri.getPathSegments().contains("picker");
    }

    private static boolean isVideoUri(Uri uri) {
        return uri.getPathSegments().contains("video");
    }

    public static boolean isMediaStoreVideoUri(Uri uri) {
        return MediaStoreUtil.isMediaStoreUri(uri) && MediaStoreUtil.isVideoUri(uri);
    }

    public static boolean isMediaStoreImageUri(Uri uri) {
        return MediaStoreUtil.isMediaStoreUri(uri) && !MediaStoreUtil.isVideoUri(uri);
    }

    public static boolean isThumbnailSize(int width, int height) {
        return width != Integer.MIN_VALUE && height != Integer.MIN_VALUE && width <= 512 && height <= 384;
    }
}

