/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import java.io.InputStream;
import java.util.List;

public final class ResourceUriLoader<DataT>
implements ModelLoader<Uri, DataT> {
    private static final int INVALID_RESOURCE_ID = 0;
    private static final String TAG = "ResourceUriLoader";
    private final Context context;
    private final ModelLoader<Integer, DataT> delegate;

    public static ModelLoaderFactory<Uri, InputStream> newStreamFactory(Context context) {
        return new InputStreamFactory(context);
    }

    public static ModelLoaderFactory<Uri, AssetFileDescriptor> newAssetFileDescriptorFactory(Context context) {
        return new AssetFileDescriptorFactory(context);
    }

    ResourceUriLoader(Context context, ModelLoader<Integer, DataT> delegate) {
        this.context = context.getApplicationContext();
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public ModelLoader.LoadData<DataT> buildLoadData(@NonNull Uri uri, int width, int height, @NonNull Options options) {
        List pathSegments = uri.getPathSegments();
        if (pathSegments.size() == 1) {
            return this.parseResourceIdUri(uri, width, height, options);
        }
        if (pathSegments.size() == 2) {
            return this.parseResourceNameUri(uri, width, height, options);
        }
        if (Log.isLoggable((String)TAG, (int)5)) {
            Log.w((String)TAG, (String)("Failed to parse resource uri: " + uri));
        }
        return null;
    }

    @Nullable
    private ModelLoader.LoadData<DataT> parseResourceNameUri(@NonNull Uri uri, int width, int height, @NonNull Options options) {
        List pathSegments = uri.getPathSegments();
        String resourceType = (String)pathSegments.get(0);
        String resourceName = (String)pathSegments.get(1);
        int identifier = this.context.getResources().getIdentifier(resourceName, resourceType, this.context.getPackageName());
        if (identifier == 0) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)("Failed to find resource id for: " + uri));
            }
            return null;
        }
        return this.delegate.buildLoadData(identifier, width, height, options);
    }

    @Nullable
    private ModelLoader.LoadData<DataT> parseResourceIdUri(@NonNull Uri uri, int width, int height, @NonNull Options options) {
        try {
            int resourceId = Integer.parseInt((String)uri.getPathSegments().get(0));
            if (resourceId == 0) {
                if (Log.isLoggable((String)TAG, (int)5)) {
                    Log.w((String)TAG, (String)("Failed to parse a valid non-0 resource id from: " + uri));
                }
                return null;
            }
            return this.delegate.buildLoadData(resourceId, width, height, options);
        }
        catch (NumberFormatException e) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)("Failed to parse resource id from: " + uri), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public boolean handles(@NonNull Uri uri) {
        return "android.resource".equals(uri.getScheme()) && this.context.getPackageName().equals(uri.getAuthority());
    }

    private static final class InputStreamFactory
    implements ModelLoaderFactory<Uri, InputStream> {
        private final Context context;

        InputStreamFactory(Context context) {
            this.context = context;
        }

        @Override
        @NonNull
        public ModelLoader<Uri, InputStream> build(@NonNull MultiModelLoaderFactory multiFactory) {
            return new ResourceUriLoader<InputStream>(this.context, multiFactory.build(Integer.class, InputStream.class));
        }

        @Override
        public void teardown() {
        }
    }

    private static final class AssetFileDescriptorFactory
    implements ModelLoaderFactory<Uri, AssetFileDescriptor> {
        private final Context context;

        AssetFileDescriptorFactory(Context context) {
            this.context = context;
        }

        @Override
        @NonNull
        public ModelLoader<Uri, AssetFileDescriptor> build(@NonNull MultiModelLoaderFactory multiFactory) {
            return new ResourceUriLoader<AssetFileDescriptor>(this.context, multiFactory.build(Integer.class, AssetFileDescriptor.class));
        }

        @Override
        public void teardown() {
        }
    }
}

