/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.os.Build;
import com.bumptech.glide.load.Option;

public abstract class DownsampleStrategy {
    public static final DownsampleStrategy AT_LEAST = new AtLeast();
    public static final DownsampleStrategy AT_MOST = new AtMost();
    public static final DownsampleStrategy FIT_CENTER = new FitCenter();
    public static final DownsampleStrategy CENTER_INSIDE = new CenterInside();
    public static final DownsampleStrategy CENTER_OUTSIDE = new CenterOutside();
    public static final DownsampleStrategy NONE = new None();
    public static final DownsampleStrategy DEFAULT = CENTER_OUTSIDE;
    public static final Option<DownsampleStrategy> OPTION = Option.memory("com.bumptech.glide.load.resource.bitmap.Downsampler.DownsampleStrategy", DEFAULT);
    static final boolean IS_BITMAP_FACTORY_SCALING_SUPPORTED = Build.VERSION.SDK_INT >= 19;

    public abstract float getScaleFactor(int var1, int var2, int var3, int var4);

    public abstract SampleSizeRounding getSampleSizeRounding(int var1, int var2, int var3, int var4);

    private static class AtLeast
    extends DownsampleStrategy {
        AtLeast() {
        }

        @Override
        public float getScaleFactor(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            int minIntegerFactor = Math.min(sourceHeight / requestedHeight, sourceWidth / requestedWidth);
            return minIntegerFactor == 0 ? 1.0f : 1.0f / (float)Integer.highestOneBit(minIntegerFactor);
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return SampleSizeRounding.QUALITY;
        }
    }

    private static class AtMost
    extends DownsampleStrategy {
        AtMost() {
        }

        @Override
        public float getScaleFactor(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            int lesserOrEqualSampleSize;
            int maxIntegerFactor = (int)Math.ceil(Math.max((float)sourceHeight / (float)requestedHeight, (float)sourceWidth / (float)requestedWidth));
            int greaterOrEqualSampleSize = lesserOrEqualSampleSize << ((lesserOrEqualSampleSize = Math.max(1, Integer.highestOneBit(maxIntegerFactor))) < maxIntegerFactor ? 1 : 0);
            return 1.0f / (float)greaterOrEqualSampleSize;
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return SampleSizeRounding.MEMORY;
        }
    }

    private static class FitCenter
    extends DownsampleStrategy {
        FitCenter() {
        }

        @Override
        public float getScaleFactor(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            if (IS_BITMAP_FACTORY_SCALING_SUPPORTED) {
                float widthPercentage = (float)requestedWidth / (float)sourceWidth;
                float heightPercentage = (float)requestedHeight / (float)sourceHeight;
                return Math.min(widthPercentage, heightPercentage);
            }
            int maxIntegerFactor = Math.max(sourceHeight / requestedHeight, sourceWidth / requestedWidth);
            return maxIntegerFactor == 0 ? 1.0f : 1.0f / (float)Integer.highestOneBit(maxIntegerFactor);
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            if (IS_BITMAP_FACTORY_SCALING_SUPPORTED) {
                return SampleSizeRounding.QUALITY;
            }
            return SampleSizeRounding.MEMORY;
        }
    }

    private static class CenterInside
    extends DownsampleStrategy {
        CenterInside() {
        }

        @Override
        public float getScaleFactor(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return Math.min(1.0f, FIT_CENTER.getScaleFactor(sourceWidth, sourceHeight, requestedWidth, requestedHeight));
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return this.getScaleFactor(sourceWidth, sourceHeight, requestedWidth, requestedHeight) == 1.0f ? SampleSizeRounding.QUALITY : FIT_CENTER.getSampleSizeRounding(sourceWidth, sourceHeight, requestedWidth, requestedHeight);
        }
    }

    private static class CenterOutside
    extends DownsampleStrategy {
        CenterOutside() {
        }

        @Override
        public float getScaleFactor(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            float widthPercentage = (float)requestedWidth / (float)sourceWidth;
            float heightPercentage = (float)requestedHeight / (float)sourceHeight;
            return Math.max(widthPercentage, heightPercentage);
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return SampleSizeRounding.QUALITY;
        }
    }

    private static class None
    extends DownsampleStrategy {
        None() {
        }

        @Override
        public float getScaleFactor(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return 1.0f;
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return SampleSizeRounding.QUALITY;
        }
    }

    public static enum SampleSizeRounding {
        MEMORY,
        QUALITY;

    }
}

