/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Log;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import com.bumptech.glide.util.Util;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public final class HardwareConfigState {
    private static final String TAG = "HardwareConfig";
    public static final boolean BLOCK_HARDWARE_BITMAPS_WHEN_GL_CONTEXT_MIGHT_NOT_BE_INITIALIZED = Build.VERSION.SDK_INT < 29;
    @ChecksSdkIntAtLeast(api=28)
    public static final boolean HARDWARE_BITMAPS_SUPPORTED = Build.VERSION.SDK_INT >= 28;
    private static final File FD_SIZE_LIST = new File("/proc/self/fd");
    private static final int MINIMUM_DECODES_BETWEEN_FD_CHECKS = 50;
    private static final int MAXIMUM_FDS_FOR_HARDWARE_CONFIGS_P = 20000;
    private static final int REDUCED_MAX_FDS_FOR_HARDWARE_CONFIGS_P = 500;
    @Deprecated
    public static final int NO_MAX_FD_COUNT = -1;
    private static volatile HardwareConfigState instance;
    private final int sdkBasedMaxFdCount;
    @GuardedBy(value="this")
    private int decodesSinceLastFdCheck;
    @GuardedBy(value="this")
    private boolean isFdSizeBelowHardwareLimit = true;
    private final AtomicBoolean isHardwareConfigAllowedByAppState = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HardwareConfigState getInstance() {
        if (instance != null) return instance;
        Class<HardwareConfigState> clazz = HardwareConfigState.class;
        synchronized (HardwareConfigState.class) {
            if (instance != null) return instance;
            instance = new HardwareConfigState();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @VisibleForTesting
    HardwareConfigState() {
        this.sdkBasedMaxFdCount = 20000;
    }

    public void blockHardwareBitmaps() {
        Util.assertMainThread();
        this.isHardwareConfigAllowedByAppState.set(false);
    }

    public void unblockHardwareBitmaps() {
        Util.assertMainThread();
        this.isHardwareConfigAllowedByAppState.set(true);
    }

    public boolean isHardwareConfigAllowed(int targetWidth, int targetHeight, boolean isHardwareConfigAllowed, boolean isExifOrientationRequired) {
        if (!isHardwareConfigAllowed) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed by caller");
            }
            return false;
        }
        if (!HARDWARE_BITMAPS_SUPPORTED) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed by sdk");
            }
            return false;
        }
        if (this.areHardwareBitmapsBlockedByAppState()) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed by app state");
            }
            return false;
        }
        if (isExifOrientationRequired) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed because exif orientation is required");
            }
            return false;
        }
        if (targetWidth < 0 || targetHeight < 0) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed because of invalid dimensions");
            }
            return false;
        }
        if (!this.isFdSizeBelowHardwareLimit()) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed because there are insufficient FDs");
            }
            return false;
        }
        return true;
    }

    private boolean areHardwareBitmapsBlockedByAppState() {
        return BLOCK_HARDWARE_BITMAPS_WHEN_GL_CONTEXT_MIGHT_NOT_BE_INITIALIZED && !this.isHardwareConfigAllowedByAppState.get();
    }

    @TargetApi(value=26)
    boolean setHardwareConfigIfAllowed(int targetWidth, int targetHeight, BitmapFactory.Options optionsWithScaling, boolean isHardwareConfigAllowed, boolean isExifOrientationRequired) {
        boolean result = this.isHardwareConfigAllowed(targetWidth, targetHeight, isHardwareConfigAllowed, isExifOrientationRequired);
        if (result) {
            optionsWithScaling.inPreferredConfig = Bitmap.Config.HARDWARE;
            optionsWithScaling.inMutable = false;
        }
        return result;
    }

    private static boolean isHardwareBitmapCountReducedOnApi28ByB139097735() {
        if (Build.VERSION.SDK_INT != 28) {
            return false;
        }
        for (String prefixOrModelName : Arrays.asList("GM1900", "GM1901", "GM1903", "GM1911", "GM1915", "ONEPLUS A3000", "ONEPLUS A3010", "ONEPLUS A5010", "ONEPLUS A5000", "ONEPLUS A3003", "ONEPLUS A6000", "ONEPLUS A6003", "ONEPLUS A6010", "ONEPLUS A6013")) {
            if (!Build.MODEL.startsWith(prefixOrModelName)) continue;
            return true;
        }
        return false;
    }

    private int getMaxFdCount() {
        if (HardwareConfigState.isHardwareBitmapCountReducedOnApi28ByB139097735()) {
            return 500;
        }
        return this.sdkBasedMaxFdCount;
    }

    private synchronized boolean isFdSizeBelowHardwareLimit() {
        if (++this.decodesSinceLastFdCheck >= 50) {
            long maxFdCount;
            this.decodesSinceLastFdCheck = 0;
            int currentFds = FD_SIZE_LIST.list().length;
            boolean bl = this.isFdSizeBelowHardwareLimit = (long)currentFds < (maxFdCount = (long)this.getMaxFdCount());
            if (!this.isFdSizeBelowHardwareLimit && Log.isLoggable((String)"Downsampler", (int)5)) {
                Log.w((String)"Downsampler", (String)("Excluding HARDWARE bitmap config because we're over the file descriptor limit, file descriptors " + currentFds + ", limit " + maxFdCount));
            }
        }
        return this.isFdSizeBelowHardwareLimit;
    }
}

