/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.resource.bitmap.Downsampler;
import java.io.IOException;

@RequiresApi(value=21)
public final class ParcelFileDescriptorBitmapDecoder
implements ResourceDecoder<ParcelFileDescriptor, Bitmap> {
    private static final int MAXIMUM_FILE_BYTE_SIZE_FOR_FILE_DESCRIPTOR_DECODER = 0x20000000;
    private final Downsampler downsampler;

    public ParcelFileDescriptorBitmapDecoder(Downsampler downsampler) {
        this.downsampler = downsampler;
    }

    @Override
    public boolean handles(@NonNull ParcelFileDescriptor source, @NonNull Options options) {
        return this.isSafeToTryDecoding(source) && this.downsampler.handles(source);
    }

    private boolean isSafeToTryDecoding(@NonNull ParcelFileDescriptor source) {
        if ("HUAWEI".equalsIgnoreCase(Build.MANUFACTURER) || "HONOR".equalsIgnoreCase(Build.MANUFACTURER)) {
            return source.getStatSize() <= 0x20000000L;
        }
        return true;
    }

    @Override
    @Nullable
    public Resource<Bitmap> decode(@NonNull ParcelFileDescriptor source, int width, int height, @NonNull Options options) throws IOException {
        return this.downsampler.decode(source, width, height, options);
    }
}

