/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.manager;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArrayMap;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.resource.bitmap.HardwareConfigState;
import com.bumptech.glide.manager.ApplicationLifecycle;
import com.bumptech.glide.manager.DoNothingFirstFrameWaiter;
import com.bumptech.glide.manager.EmptyRequestManagerTreeNode;
import com.bumptech.glide.manager.FirstFrameWaiter;
import com.bumptech.glide.manager.FrameWaiter;
import com.bumptech.glide.manager.Lifecycle;
import com.bumptech.glide.manager.LifecycleRequestManagerRetriever;
import com.bumptech.glide.manager.RequestManagerTreeNode;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.util.Collection;
import java.util.Map;

public class RequestManagerRetriever
implements Handler.Callback {
    @VisibleForTesting
    static final String FRAGMENT_TAG = "com.bumptech.glide.manager";
    private volatile RequestManager applicationManager;
    private final RequestManagerFactory factory;
    private final ArrayMap<View, androidx.fragment.app.Fragment> tempViewToSupportFragment = new ArrayMap();
    private final FrameWaiter frameWaiter;
    private final LifecycleRequestManagerRetriever lifecycleRequestManagerRetriever;
    private static final RequestManagerFactory DEFAULT_FACTORY = new RequestManagerFactory(){

        @Override
        @NonNull
        public RequestManager build(@NonNull Glide glide, @NonNull Lifecycle lifecycle, @NonNull RequestManagerTreeNode requestManagerTreeNode, @NonNull Context context) {
            return new RequestManager(glide, lifecycle, requestManagerTreeNode, context);
        }
    };

    public RequestManagerRetriever(@Nullable RequestManagerFactory factory) {
        this.factory = factory != null ? factory : DEFAULT_FACTORY;
        this.lifecycleRequestManagerRetriever = new LifecycleRequestManagerRetriever(this.factory);
        this.frameWaiter = RequestManagerRetriever.buildFrameWaiter();
    }

    private static FrameWaiter buildFrameWaiter() {
        if (!HardwareConfigState.HARDWARE_BITMAPS_SUPPORTED || !HardwareConfigState.BLOCK_HARDWARE_BITMAPS_WHEN_GL_CONTEXT_MIGHT_NOT_BE_INITIALIZED) {
            return new DoNothingFirstFrameWaiter();
        }
        return new FirstFrameWaiter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private RequestManager getApplicationManager(@NonNull Context context) {
        if (this.applicationManager == null) {
            RequestManagerRetriever requestManagerRetriever = this;
            synchronized (requestManagerRetriever) {
                if (this.applicationManager == null) {
                    Glide glide = Glide.get(context.getApplicationContext());
                    this.applicationManager = this.factory.build(glide, new ApplicationLifecycle(), new EmptyRequestManagerTreeNode(), context.getApplicationContext());
                }
            }
        }
        return this.applicationManager;
    }

    @NonNull
    public RequestManager get(@NonNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("You cannot start a load on a null Context");
        }
        if (Util.isOnMainThread() && !(context instanceof Application)) {
            if (context instanceof FragmentActivity) {
                return this.get((FragmentActivity)context);
            }
            if (context instanceof ContextWrapper && ((ContextWrapper)context).getBaseContext().getApplicationContext() != null) {
                return this.get(((ContextWrapper)context).getBaseContext());
            }
        }
        return this.getApplicationManager(context);
    }

    @NonNull
    public RequestManager get(@NonNull FragmentActivity activity) {
        if (Util.isOnBackgroundThread()) {
            return this.get(activity.getApplicationContext());
        }
        RequestManagerRetriever.assertNotDestroyed((Activity)activity);
        this.frameWaiter.registerSelf((Activity)activity);
        boolean isActivityVisible = RequestManagerRetriever.isActivityVisible((Context)activity);
        Glide glide = Glide.get(activity.getApplicationContext());
        return this.lifecycleRequestManagerRetriever.getOrCreate((Context)activity, glide, activity.getLifecycle(), activity.getSupportFragmentManager(), isActivityVisible);
    }

    @NonNull
    public RequestManager get(@NonNull androidx.fragment.app.Fragment fragment) {
        Preconditions.checkNotNull(fragment.getContext(), "You cannot start a load on a fragment before it is attached or after it is destroyed");
        if (Util.isOnBackgroundThread()) {
            return this.get(fragment.getContext().getApplicationContext());
        }
        if (fragment.getActivity() != null) {
            this.frameWaiter.registerSelf((Activity)fragment.getActivity());
        }
        FragmentManager fm = fragment.getChildFragmentManager();
        Context context = fragment.getContext();
        Glide glide = Glide.get(context.getApplicationContext());
        return this.lifecycleRequestManagerRetriever.getOrCreate(context, glide, fragment.getLifecycle(), fm, fragment.isVisible());
    }

    @Deprecated
    @NonNull
    public RequestManager get(@NonNull Activity activity) {
        return this.get(activity.getApplicationContext());
    }

    @NonNull
    public RequestManager get(@NonNull View view) {
        if (Util.isOnBackgroundThread()) {
            return this.get(view.getContext().getApplicationContext());
        }
        Preconditions.checkNotNull(view);
        Preconditions.checkNotNull(view.getContext(), "Unable to obtain a request manager for a view without a Context");
        Activity activity = RequestManagerRetriever.findActivity(view.getContext());
        if (activity == null) {
            return this.get(view.getContext().getApplicationContext());
        }
        if (activity instanceof FragmentActivity) {
            androidx.fragment.app.Fragment fragment = this.findSupportFragment(view, (FragmentActivity)activity);
            return fragment != null ? this.get(fragment) : this.get((FragmentActivity)activity);
        }
        return this.get(view.getContext().getApplicationContext());
    }

    private static void findAllSupportFragmentsWithViews(@Nullable Collection<androidx.fragment.app.Fragment> topLevelFragments, @NonNull Map<View, androidx.fragment.app.Fragment> result) {
        if (topLevelFragments == null) {
            return;
        }
        for (androidx.fragment.app.Fragment fragment : topLevelFragments) {
            if (fragment == null || fragment.getView() == null) continue;
            result.put(fragment.getView(), fragment);
            RequestManagerRetriever.findAllSupportFragmentsWithViews(fragment.getChildFragmentManager().getFragments(), result);
        }
    }

    @Nullable
    private androidx.fragment.app.Fragment findSupportFragment(@NonNull View target, @NonNull FragmentActivity activity) {
        this.tempViewToSupportFragment.clear();
        RequestManagerRetriever.findAllSupportFragmentsWithViews(activity.getSupportFragmentManager().getFragments(), this.tempViewToSupportFragment);
        androidx.fragment.app.Fragment result = null;
        View activityRoot = activity.findViewById(0x1020002);
        View current = target;
        while (!current.equals(activityRoot) && (result = (androidx.fragment.app.Fragment)this.tempViewToSupportFragment.get((Object)current)) == null && current.getParent() instanceof View) {
            current = (View)current.getParent();
        }
        this.tempViewToSupportFragment.clear();
        return result;
    }

    @Nullable
    private static Activity findActivity(@NonNull Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return RequestManagerRetriever.findActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    @TargetApi(value=17)
    private static void assertNotDestroyed(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            throw new IllegalArgumentException("You cannot start a load for a destroyed activity");
        }
    }

    @Deprecated
    @NonNull
    @TargetApi(value=17)
    public RequestManager get(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null) {
            throw new IllegalArgumentException("You cannot start a load on a fragment before it is attached");
        }
        return this.get(fragment.getActivity().getApplicationContext());
    }

    private static boolean isActivityVisible(Context context) {
        Activity activity = RequestManagerRetriever.findActivity(context);
        return activity == null || !activity.isFinishing();
    }

    @Deprecated
    public boolean handleMessage(Message message) {
        return false;
    }

    public static interface RequestManagerFactory {
        @NonNull
        public RequestManager build(@NonNull Glide var1, @NonNull Lifecycle var2, @NonNull RequestManagerTreeNode var3, @NonNull Context var4);
    }
}

