/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request;

import android.graphics.drawable.Drawable;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.FutureTarget;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.util.Util;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestFutureTarget<R>
implements FutureTarget<R>,
RequestListener<R> {
    private static final Waiter DEFAULT_WAITER = new Waiter();
    private final int width;
    private final int height;
    private final boolean assertBackgroundThread;
    private final Waiter waiter;
    @GuardedBy(value="this")
    @Nullable
    private R resource;
    @GuardedBy(value="this")
    @Nullable
    private Request request;
    @GuardedBy(value="this")
    private boolean isCancelled;
    @GuardedBy(value="this")
    private boolean resultReceived;
    @GuardedBy(value="this")
    private boolean loadFailed;
    @GuardedBy(value="this")
    @Nullable
    private GlideException exception;

    public RequestFutureTarget(int width, int height) {
        this(width, height, true, DEFAULT_WAITER);
    }

    RequestFutureTarget(int width, int height, boolean assertBackgroundThread, Waiter waiter) {
        this.width = width;
        this.height = height;
        this.assertBackgroundThread = assertBackgroundThread;
        this.waiter = waiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Request toClear = null;
        RequestFutureTarget requestFutureTarget = this;
        synchronized (requestFutureTarget) {
            if (this.isDone()) {
                return false;
            }
            this.isCancelled = true;
            this.waiter.notifyAll(this);
            if (mayInterruptIfRunning) {
                toClear = this.request;
                this.request = null;
            }
        }
        if (toClear != null) {
            toClear.clear();
        }
        return true;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isCancelled || this.resultReceived || this.loadFailed;
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        try {
            return this.doGet(null);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public R get(long time, @NonNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doGet(timeUnit.toMillis(time));
    }

    @Override
    public void getSize(@NonNull SizeReadyCallback cb) {
        cb.onSizeReady(this.width, this.height);
    }

    @Override
    public void removeCallback(@NonNull SizeReadyCallback cb) {
    }

    @Override
    public synchronized void setRequest(@Nullable Request request) {
        this.request = request;
    }

    @Override
    @Nullable
    public synchronized Request getRequest() {
        return this.request;
    }

    @Override
    public void onLoadCleared(@Nullable Drawable placeholder) {
    }

    @Override
    public void onLoadStarted(@Nullable Drawable placeholder) {
    }

    @Override
    public synchronized void onLoadFailed(@Nullable Drawable errorDrawable) {
    }

    @Override
    public synchronized void onResourceReady(@NonNull R resource, @Nullable Transition<? super R> transition) {
    }

    private synchronized R doGet(Long timeoutMillis) throws ExecutionException, InterruptedException, TimeoutException {
        if (this.assertBackgroundThread && !this.isDone()) {
            Util.assertBackgroundThread();
        }
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.loadFailed) {
            throw new ExecutionException(this.exception);
        }
        if (this.resultReceived) {
            return this.resource;
        }
        if (timeoutMillis == null) {
            this.waiter.waitForTimeout(this, 0L);
        } else if (timeoutMillis > 0L) {
            long now = System.currentTimeMillis();
            long deadline = now + timeoutMillis;
            while (!this.isDone() && now < deadline) {
                this.waiter.waitForTimeout(this, deadline - now);
                now = System.currentTimeMillis();
            }
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.loadFailed) {
            throw new ExecutionException(this.exception);
        }
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (!this.resultReceived) {
            throw new TimeoutException();
        }
        return this.resource;
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public synchronized boolean onLoadFailed(@Nullable GlideException e, Object model, @NonNull Target<R> target, boolean isFirstResource) {
        this.loadFailed = true;
        this.exception = e;
        this.waiter.notifyAll(this);
        return false;
    }

    @Override
    public synchronized boolean onResourceReady(@NonNull R resource, @NonNull Object model, Target<R> target, @NonNull DataSource dataSource, boolean isFirstResource) {
        this.resultReceived = true;
        this.resource = resource;
        this.waiter.notifyAll(this);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String status;
        String toString = super.toString() + "[status=";
        Request pendingRequest = null;
        RequestFutureTarget requestFutureTarget = this;
        synchronized (requestFutureTarget) {
            if (this.isCancelled) {
                status = "CANCELLED";
            } else if (this.loadFailed) {
                status = "FAILURE";
            } else if (this.resultReceived) {
                status = "SUCCESS";
            } else {
                status = "PENDING";
                pendingRequest = this.request;
            }
        }
        if (pendingRequest != null) {
            return toString + status + ", request=[" + pendingRequest + "]]";
        }
        return toString + status + "]";
    }

    @VisibleForTesting
    static class Waiter {
        Waiter() {
        }

        void waitForTimeout(Object toWaitOn, long timeoutMillis) throws InterruptedException {
            toWaitOn.wait(timeoutMillis);
        }

        void notifyAll(Object toNotify) {
            toNotify.notifyAll();
        }
    }
}

