/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;

public final class ExceptionPassthroughInputStream
extends InputStream {
    @GuardedBy(value="POOL")
    private static final Queue<ExceptionPassthroughInputStream> POOL = Util.createQueue(0);
    private InputStream wrapped;
    private IOException exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ExceptionPassthroughInputStream obtain(@NonNull InputStream toWrap) {
        ExceptionPassthroughInputStream result;
        Queue<ExceptionPassthroughInputStream> queue = POOL;
        synchronized (queue) {
            result = POOL.poll();
        }
        if (result == null) {
            result = new ExceptionPassthroughInputStream();
        }
        result.setInputStream(toWrap);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearQueue() {
        Queue<ExceptionPassthroughInputStream> queue = POOL;
        synchronized (queue) {
            while (!POOL.isEmpty()) {
                POOL.remove();
            }
        }
    }

    ExceptionPassthroughInputStream() {
    }

    void setInputStream(@NonNull InputStream toWrap) {
        this.wrapped = toWrap;
    }

    @Override
    public int available() throws IOException {
        return this.wrapped.available();
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    @Override
    public void mark(int readLimit) {
        this.wrapped.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return this.wrapped.markSupported();
    }

    @Override
    public int read() throws IOException {
        try {
            return this.wrapped.read();
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        try {
            return this.wrapped.read(buffer);
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        try {
            return this.wrapped.read(buffer, byteOffset, byteCount);
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrapped.reset();
    }

    @Override
    public long skip(long byteCount) throws IOException {
        try {
            return this.wrapped.skip(byteCount);
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
    }

    @Nullable
    public IOException getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.exception = null;
        this.wrapped = null;
        Queue<ExceptionPassthroughInputStream> queue = POOL;
        synchronized (queue) {
            POOL.offer(this);
        }
    }
}

