/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.badge;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.view.menu.ActionMenuItemView;
import androidx.appcompat.widget.Toolbar;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.badge.BadgeState;
import com.google.android.material.badge.ExperimentalBadgeUtils;
import com.google.android.material.internal.ParcelableSparseArray;
import com.google.android.material.internal.ToolbarUtils;

@ExperimentalBadgeUtils
public class BadgeUtils {
    public static final boolean USE_COMPAT_PARENT = Build.VERSION.SDK_INT < 18;
    private static final String LOG_TAG = "BadgeUtils";

    private BadgeUtils() {
    }

    public static void updateBadgeBounds(@NonNull Rect rect, float centerX, float centerY, float halfWidth, float halfHeight) {
        rect.set((int)(centerX - halfWidth), (int)(centerY - halfHeight), (int)(centerX + halfWidth), (int)(centerY + halfHeight));
    }

    public static void attachBadgeDrawable(@NonNull BadgeDrawable badgeDrawable, @NonNull View anchor) {
        BadgeUtils.attachBadgeDrawable(badgeDrawable, anchor, null);
    }

    public static void attachBadgeDrawable(@NonNull BadgeDrawable badgeDrawable, @NonNull View anchor, @Nullable FrameLayout customBadgeParent) {
        BadgeUtils.setBadgeDrawableBounds(badgeDrawable, anchor, customBadgeParent);
        if (badgeDrawable.getCustomBadgeParent() != null) {
            badgeDrawable.getCustomBadgeParent().setForeground((Drawable)badgeDrawable);
        } else {
            if (USE_COMPAT_PARENT) {
                throw new IllegalArgumentException("Trying to reference null customBadgeParent");
            }
            anchor.getOverlay().add((Drawable)badgeDrawable);
        }
    }

    public static void attachBadgeDrawable(@NonNull BadgeDrawable badgeDrawable, @NonNull Toolbar toolbar, @IdRes int menuItemId) {
        BadgeUtils.attachBadgeDrawable(badgeDrawable, toolbar, menuItemId, null);
    }

    public static void attachBadgeDrawable(final @NonNull BadgeDrawable badgeDrawable, final @NonNull Toolbar toolbar, final @IdRes int menuItemId, final @Nullable FrameLayout customBadgeParent) {
        toolbar.post(new Runnable(){

            @Override
            public void run() {
                ActionMenuItemView menuItemView = ToolbarUtils.getActionMenuItemView(toolbar, menuItemId);
                if (menuItemView != null) {
                    BadgeUtils.setToolbarOffset(badgeDrawable, toolbar.getResources());
                    BadgeUtils.attachBadgeDrawable(badgeDrawable, (View)menuItemView, customBadgeParent);
                    BadgeUtils.attachBadgeContentDescription(badgeDrawable, (View)menuItemView);
                }
            }
        });
    }

    private static void attachBadgeContentDescription(final @NonNull BadgeDrawable badgeDrawable, @NonNull View view) {
        if (Build.VERSION.SDK_INT >= 29 && ViewCompat.hasAccessibilityDelegate((View)view)) {
            ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(view.getAccessibilityDelegate()){

                public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                    super.onInitializeAccessibilityNodeInfo(host, info);
                    info.setContentDescription(badgeDrawable.getContentDescription());
                }
            });
        } else {
            ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

                public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                    super.onInitializeAccessibilityNodeInfo(host, info);
                    info.setContentDescription(badgeDrawable.getContentDescription());
                }
            });
        }
    }

    public static void detachBadgeDrawable(@Nullable BadgeDrawable badgeDrawable, @NonNull View anchor) {
        if (badgeDrawable == null) {
            return;
        }
        if (USE_COMPAT_PARENT || badgeDrawable.getCustomBadgeParent() != null) {
            badgeDrawable.getCustomBadgeParent().setForeground(null);
        } else {
            anchor.getOverlay().remove((Drawable)badgeDrawable);
        }
    }

    public static void detachBadgeDrawable(@Nullable BadgeDrawable badgeDrawable, @NonNull Toolbar toolbar, @IdRes int menuItemId) {
        if (badgeDrawable == null) {
            return;
        }
        ActionMenuItemView menuItemView = ToolbarUtils.getActionMenuItemView(toolbar, menuItemId);
        if (menuItemView != null) {
            BadgeUtils.removeToolbarOffset(badgeDrawable);
            BadgeUtils.detachBadgeDrawable(badgeDrawable, (View)menuItemView);
            BadgeUtils.detachBadgeContentDescription((View)menuItemView);
        } else {
            Log.w((String)LOG_TAG, (String)("Trying to remove badge from a null menuItemView: " + menuItemId));
        }
    }

    private static void detachBadgeContentDescription(@NonNull View view) {
        if (Build.VERSION.SDK_INT >= 29 && ViewCompat.hasAccessibilityDelegate((View)view)) {
            ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(view.getAccessibilityDelegate()){

                public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                    super.onInitializeAccessibilityNodeInfo(host, info);
                    info.setContentDescription(null);
                }
            });
        } else {
            ViewCompat.setAccessibilityDelegate((View)view, null);
        }
    }

    @VisibleForTesting
    static void setToolbarOffset(BadgeDrawable badgeDrawable, Resources resources) {
        badgeDrawable.setAdditionalHorizontalOffset(resources.getDimensionPixelOffset(R.dimen.mtrl_badge_toolbar_action_menu_item_horizontal_offset));
        badgeDrawable.setAdditionalVerticalOffset(resources.getDimensionPixelOffset(R.dimen.mtrl_badge_toolbar_action_menu_item_vertical_offset));
    }

    @VisibleForTesting
    static void removeToolbarOffset(BadgeDrawable badgeDrawable) {
        badgeDrawable.setAdditionalHorizontalOffset(0);
        badgeDrawable.setAdditionalVerticalOffset(0);
    }

    public static void setBadgeDrawableBounds(@NonNull BadgeDrawable badgeDrawable, @NonNull View anchor, @Nullable FrameLayout compatBadgeParent) {
        Rect badgeBounds = new Rect();
        anchor.getDrawingRect(badgeBounds);
        badgeDrawable.setBounds(badgeBounds);
        badgeDrawable.updateBadgeCoordinates(anchor, compatBadgeParent);
    }

    @NonNull
    public static ParcelableSparseArray createParcelableBadgeStates(@NonNull SparseArray<BadgeDrawable> badgeDrawables) {
        ParcelableSparseArray badgeStates = new ParcelableSparseArray();
        for (int i = 0; i < badgeDrawables.size(); ++i) {
            int key = badgeDrawables.keyAt(i);
            BadgeDrawable badgeDrawable = (BadgeDrawable)badgeDrawables.valueAt(i);
            badgeStates.put(key, badgeDrawable != null ? badgeDrawable.getSavedState() : null);
        }
        return badgeStates;
    }

    @NonNull
    public static SparseArray<BadgeDrawable> createBadgeDrawablesFromSavedStates(Context context, @NonNull ParcelableSparseArray badgeStates) {
        SparseArray badgeDrawables = new SparseArray(badgeStates.size());
        for (int i = 0; i < badgeStates.size(); ++i) {
            int key = badgeStates.keyAt(i);
            BadgeState.State savedState = (BadgeState.State)badgeStates.valueAt(i);
            BadgeDrawable badgeDrawable = null;
            if (savedState != null) {
                badgeDrawable = BadgeDrawable.createFromSavedState(context, savedState);
            }
            badgeDrawables.put(key, (Object)badgeDrawable);
        }
        return badgeDrawables;
    }
}

