/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomsheet;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.view.WindowInsetsAnimationCompat;
import androidx.core.view.WindowInsetsCompat;
import com.google.android.material.animation.AnimationUtils;
import java.util.List;

class InsetsAnimationCallback
extends WindowInsetsAnimationCompat.Callback {
    private final View view;
    private int startY;
    private int startTranslationY;
    private final int[] tmpLocation = new int[2];

    public InsetsAnimationCallback(View view) {
        super(0);
        this.view = view;
    }

    public void onPrepare(@NonNull WindowInsetsAnimationCompat windowInsetsAnimationCompat) {
        this.view.getLocationOnScreen(this.tmpLocation);
        this.startY = this.tmpLocation[1];
    }

    @NonNull
    public WindowInsetsAnimationCompat.BoundsCompat onStart(@NonNull WindowInsetsAnimationCompat windowInsetsAnimationCompat, @NonNull WindowInsetsAnimationCompat.BoundsCompat boundsCompat) {
        this.view.getLocationOnScreen(this.tmpLocation);
        int endY = this.tmpLocation[1];
        this.startTranslationY = this.startY - endY;
        this.view.setTranslationY((float)this.startTranslationY);
        return boundsCompat;
    }

    @NonNull
    public WindowInsetsCompat onProgress(@NonNull WindowInsetsCompat insets, @NonNull List<WindowInsetsAnimationCompat> animationList) {
        for (WindowInsetsAnimationCompat animation : animationList) {
            if ((animation.getTypeMask() & WindowInsetsCompat.Type.ime()) == 0) continue;
            float translationY = AnimationUtils.lerp(this.startTranslationY, 0, animation.getInterpolatedFraction());
            this.view.setTranslationY(translationY);
            break;
        }
        return insets;
    }

    public void onEnd(@NonNull WindowInsetsAnimationCompat windowInsetsAnimationCompat) {
        this.view.setTranslationY(0.0f);
    }
}

