/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.carousel.CarouselLayoutManager;

abstract class CarouselOrientationHelper {
    final int orientation;

    private CarouselOrientationHelper(int orientation) {
        this.orientation = orientation;
    }

    static CarouselOrientationHelper createOrientationHelper(CarouselLayoutManager layoutManager, int orientation) {
        switch (orientation) {
            case 0: {
                return CarouselOrientationHelper.createHorizontalHelper(layoutManager);
            }
            case 1: {
                return CarouselOrientationHelper.createVerticalHelper(layoutManager);
            }
        }
        throw new IllegalArgumentException("invalid orientation");
    }

    abstract int getParentLeft();

    abstract int getParentStart();

    abstract int getParentRight();

    abstract int getParentEnd();

    abstract int getParentTop();

    abstract int getParentBottom();

    abstract int getDecoratedCrossAxisMeasurement(View var1);

    abstract void layoutDecoratedWithMargins(View var1, int var2, int var3);

    abstract float getMaskMargins(RecyclerView.LayoutParams var1);

    abstract RectF getMaskRect(float var1, float var2, float var3, float var4);

    abstract void containMaskWithinBounds(RectF var1, RectF var2, RectF var3);

    abstract void moveMaskOnEdgeOutsideBounds(RectF var1, RectF var2, RectF var3);

    abstract void offsetChild(View var1, Rect var2, float var3, float var4);

    private static CarouselOrientationHelper createVerticalHelper(final CarouselLayoutManager carouselLayoutManager) {
        return new CarouselOrientationHelper(1){

            @Override
            int getParentLeft() {
                return carouselLayoutManager.getPaddingLeft();
            }

            @Override
            int getParentStart() {
                return this.getParentTop();
            }

            @Override
            int getParentRight() {
                return carouselLayoutManager.getWidth() - carouselLayoutManager.getPaddingRight();
            }

            @Override
            int getParentEnd() {
                return this.getParentBottom();
            }

            @Override
            int getParentTop() {
                return 0;
            }

            @Override
            int getParentBottom() {
                return carouselLayoutManager.getHeight();
            }

            @Override
            int getDecoratedCrossAxisMeasurement(View child) {
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
                return carouselLayoutManager.getDecoratedMeasuredWidth(child) + params.leftMargin + params.rightMargin;
            }

            @Override
            public void layoutDecoratedWithMargins(View child, int head, int tail) {
                int left = this.getParentLeft();
                int right = left + this.getDecoratedCrossAxisMeasurement(child);
                carouselLayoutManager.layoutDecoratedWithMargins(child, left, head, right, tail);
            }

            @Override
            public float getMaskMargins(RecyclerView.LayoutParams layoutParams) {
                return layoutParams.topMargin + layoutParams.bottomMargin;
            }

            @Override
            public RectF getMaskRect(float childHeight, float childWidth, float maskHeight, float maskWidth) {
                return new RectF(0.0f, maskHeight, childWidth, childHeight - maskHeight);
            }

            @Override
            public void containMaskWithinBounds(RectF maskRect, RectF offsetMaskRect, RectF boundsRect) {
                float diff;
                if (offsetMaskRect.top < boundsRect.top && offsetMaskRect.bottom > boundsRect.top) {
                    diff = boundsRect.top - offsetMaskRect.top;
                    maskRect.top += diff;
                    boundsRect.top += diff;
                }
                if (offsetMaskRect.bottom > boundsRect.bottom && offsetMaskRect.top < boundsRect.bottom) {
                    diff = offsetMaskRect.bottom - boundsRect.bottom;
                    maskRect.bottom = Math.max(maskRect.bottom - diff, maskRect.top);
                    offsetMaskRect.bottom = Math.max(offsetMaskRect.bottom - diff, offsetMaskRect.top);
                }
            }

            @Override
            public void moveMaskOnEdgeOutsideBounds(RectF maskRect, RectF offsetMaskRect, RectF parentBoundsRect) {
                if (offsetMaskRect.bottom <= parentBoundsRect.top) {
                    maskRect.bottom = (float)Math.floor(maskRect.bottom) - 1.0f;
                    maskRect.top = Math.min(maskRect.top, maskRect.bottom);
                }
                if (offsetMaskRect.top >= parentBoundsRect.bottom) {
                    maskRect.top = (float)Math.ceil(maskRect.top) + 1.0f;
                    maskRect.bottom = Math.max(maskRect.top, maskRect.bottom);
                }
            }

            @Override
            public void offsetChild(View child, Rect boundsRect, float halfItemSize, float offsetCenter) {
                float actualCy = (float)boundsRect.top + halfItemSize;
                child.offsetTopAndBottom((int)(offsetCenter - actualCy));
            }
        };
    }

    private static CarouselOrientationHelper createHorizontalHelper(final CarouselLayoutManager carouselLayoutManager) {
        return new CarouselOrientationHelper(0){

            @Override
            int getParentLeft() {
                return 0;
            }

            @Override
            int getParentStart() {
                return carouselLayoutManager.isLayoutRtl() ? this.getParentRight() : this.getParentLeft();
            }

            @Override
            int getParentRight() {
                return carouselLayoutManager.getWidth();
            }

            @Override
            int getParentEnd() {
                return carouselLayoutManager.isLayoutRtl() ? this.getParentLeft() : this.getParentRight();
            }

            @Override
            int getParentTop() {
                return carouselLayoutManager.getPaddingTop();
            }

            @Override
            int getParentBottom() {
                return carouselLayoutManager.getHeight() - carouselLayoutManager.getPaddingBottom();
            }

            @Override
            int getDecoratedCrossAxisMeasurement(View child) {
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
                return carouselLayoutManager.getDecoratedMeasuredHeight(child) + params.topMargin + params.bottomMargin;
            }

            @Override
            public void layoutDecoratedWithMargins(View child, int head, int tail) {
                int top = this.getParentTop();
                int bottom = top + this.getDecoratedCrossAxisMeasurement(child);
                carouselLayoutManager.layoutDecoratedWithMargins(child, head, top, tail, bottom);
            }

            @Override
            public float getMaskMargins(RecyclerView.LayoutParams layoutParams) {
                return layoutParams.rightMargin + layoutParams.leftMargin;
            }

            @Override
            public RectF getMaskRect(float childHeight, float childWidth, float maskHeight, float maskWidth) {
                return new RectF(maskWidth, 0.0f, childWidth - maskWidth, childHeight);
            }

            @Override
            public void containMaskWithinBounds(RectF maskRect, RectF offsetMaskRect, RectF boundsRect) {
                float diff;
                if (offsetMaskRect.left < boundsRect.left && offsetMaskRect.right > boundsRect.left) {
                    diff = boundsRect.left - offsetMaskRect.left;
                    maskRect.left += diff;
                    offsetMaskRect.left += diff;
                }
                if (offsetMaskRect.right > boundsRect.right && offsetMaskRect.left < boundsRect.right) {
                    diff = offsetMaskRect.right - boundsRect.right;
                    maskRect.right = Math.max(maskRect.right - diff, maskRect.left);
                    offsetMaskRect.right = Math.max(offsetMaskRect.right - diff, offsetMaskRect.left);
                }
            }

            @Override
            public void moveMaskOnEdgeOutsideBounds(RectF maskRect, RectF offsetMaskRect, RectF parentBoundsRect) {
                if (offsetMaskRect.right <= parentBoundsRect.left) {
                    maskRect.right = (float)Math.floor(maskRect.right) - 1.0f;
                    maskRect.left = Math.min(maskRect.left, maskRect.right);
                }
                if (offsetMaskRect.left >= parentBoundsRect.right) {
                    maskRect.left = (float)Math.ceil(maskRect.left) + 1.0f;
                    maskRect.right = Math.max(maskRect.left, maskRect.right);
                }
            }

            @Override
            public void offsetChild(View child, Rect boundsRect, float halfItemSize, float offsetCenter) {
                float actualCx = (float)boundsRect.left + halfItemSize;
                child.offsetLeftAndRight((int)(offsetCenter - actualCx));
            }
        };
    }
}

