/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import android.graphics.PointF;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;
import com.google.android.material.carousel.CarouselLayoutManager;

public class CarouselSnapHelper
extends SnapHelper {
    private static final float HORIZONTAL_SNAP_SPEED = 100.0f;
    private static final float VERTICAL_SNAP_SPEED = 50.0f;
    private final boolean disableFling;
    private RecyclerView recyclerView;

    public CarouselSnapHelper() {
        this(true);
    }

    public CarouselSnapHelper(boolean disableFling) {
        this.disableFling = disableFling;
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) {
        super.attachToRecyclerView(recyclerView);
        this.recyclerView = recyclerView;
    }

    @Nullable
    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View view) {
        return this.calculateDistanceToSnap(layoutManager, view, false);
    }

    private int[] calculateDistanceToSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View view, boolean partialSnap) {
        if (!(layoutManager instanceof CarouselLayoutManager)) {
            return new int[]{0, 0};
        }
        int offset = this.distanceToFirstFocalKeyline(view, (CarouselLayoutManager)layoutManager, partialSnap);
        if (layoutManager.canScrollHorizontally()) {
            return new int[]{offset, 0};
        }
        if (layoutManager.canScrollVertically()) {
            return new int[]{0, offset};
        }
        return new int[]{0, 0};
    }

    private int distanceToFirstFocalKeyline(@NonNull View targetView, CarouselLayoutManager layoutManager, boolean partialSnap) {
        return layoutManager.getOffsetToScrollToPositionForSnap(layoutManager.getPosition(targetView), partialSnap);
    }

    @Nullable
    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        return this.findViewNearestFirstKeyline(layoutManager);
    }

    @Nullable
    private View findViewNearestFirstKeyline(RecyclerView.LayoutManager layoutManager) {
        int childCount = layoutManager.getChildCount();
        if (childCount == 0 || !(layoutManager instanceof CarouselLayoutManager)) {
            return null;
        }
        View closestChild = null;
        int absClosest = Integer.MAX_VALUE;
        CarouselLayoutManager carouselLayoutManager = (CarouselLayoutManager)layoutManager;
        for (int i = 0; i < childCount; ++i) {
            View child = layoutManager.getChildAt(i);
            int position = layoutManager.getPosition(child);
            int offset = Math.abs(carouselLayoutManager.getOffsetToScrollToPositionForSnap(position, false));
            if (offset >= absClosest) continue;
            absClosest = offset;
            closestChild = child;
        }
        return closestChild;
    }

    public int findTargetSnapPosition(RecyclerView.LayoutManager layoutManager, int velocityX, int velocityY) {
        View visibleView;
        if (!this.disableFling) {
            return -1;
        }
        int itemCount = layoutManager.getItemCount();
        if (itemCount == 0) {
            return -1;
        }
        View closestChildBeforeKeyline = null;
        int distanceBefore = Integer.MIN_VALUE;
        View closestChildAfterKeyline = null;
        int distanceAfter = Integer.MAX_VALUE;
        int childCount = layoutManager.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = layoutManager.getChildAt(i);
            if (child == null) continue;
            int distance = this.distanceToFirstFocalKeyline(child, (CarouselLayoutManager)layoutManager, false);
            if (distance <= 0 && distance > distanceBefore) {
                distanceBefore = distance;
                closestChildBeforeKeyline = child;
            }
            if (distance < 0 || distance >= distanceAfter) continue;
            distanceAfter = distance;
            closestChildAfterKeyline = child;
        }
        boolean forwardDirection = this.isForwardFling(layoutManager, velocityX, velocityY);
        if (forwardDirection && closestChildAfterKeyline != null) {
            return layoutManager.getPosition(closestChildAfterKeyline);
        }
        if (!forwardDirection && closestChildBeforeKeyline != null) {
            return layoutManager.getPosition(closestChildBeforeKeyline);
        }
        View view = visibleView = forwardDirection ? closestChildBeforeKeyline : closestChildAfterKeyline;
        if (visibleView == null) {
            return -1;
        }
        int visiblePosition = layoutManager.getPosition(visibleView);
        int snapToPosition = visiblePosition + (this.isReverseLayout(layoutManager) == forwardDirection ? -1 : 1);
        if (snapToPosition < 0 || snapToPosition >= itemCount) {
            return -1;
        }
        return snapToPosition;
    }

    private boolean isForwardFling(RecyclerView.LayoutManager layoutManager, int velocityX, int velocityY) {
        if (layoutManager.canScrollHorizontally()) {
            return velocityX > 0;
        }
        return velocityY > 0;
    }

    private boolean isReverseLayout(RecyclerView.LayoutManager layoutManager) {
        RecyclerView.SmoothScroller.ScrollVectorProvider vectorProvider;
        PointF vectorForEnd;
        int itemCount = layoutManager.getItemCount();
        if (layoutManager instanceof RecyclerView.SmoothScroller.ScrollVectorProvider && (vectorForEnd = (vectorProvider = (RecyclerView.SmoothScroller.ScrollVectorProvider)layoutManager).computeScrollVectorForPosition(itemCount - 1)) != null) {
            return vectorForEnd.x < 0.0f || vectorForEnd.y < 0.0f;
        }
        return false;
    }

    @Nullable
    protected RecyclerView.SmoothScroller createScroller(final @NonNull RecyclerView.LayoutManager layoutManager) {
        return layoutManager instanceof RecyclerView.SmoothScroller.ScrollVectorProvider ? new LinearSmoothScroller(this.recyclerView.getContext()){

            protected void onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
                if (CarouselSnapHelper.this.recyclerView != null) {
                    int[] snapDistances = CarouselSnapHelper.this.calculateDistanceToSnap(CarouselSnapHelper.this.recyclerView.getLayoutManager(), targetView, true);
                    int dx = snapDistances[0];
                    int dy = snapDistances[1];
                    int time = this.calculateTimeForDeceleration(Math.max(Math.abs(dx), Math.abs(dy)));
                    if (time > 0) {
                        action.update(dx, dy, time, (Interpolator)this.mDecelerateInterpolator);
                    }
                }
            }

            protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
                if (layoutManager.canScrollVertically()) {
                    return 50.0f / (float)displayMetrics.densityDpi;
                }
                return 100.0f / (float)displayMetrics.densityDpi;
            }
        } : null;
    }
}

