/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.carousel;

import androidx.annotation.NonNull;
import androidx.core.math.MathUtils;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.carousel.Carousel;
import com.google.android.material.carousel.CarouselStrategy;
import com.google.android.material.carousel.KeylineState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class KeylineStateList {
    private static final int NO_INDEX = -1;
    private final KeylineState defaultState;
    private final List<KeylineState> startStateSteps;
    private final List<KeylineState> endStateSteps;
    private final float[] startStateStepsInterpolationPoints;
    private final float[] endStateStepsInterpolationPoints;
    private final float startShiftRange;
    private final float endShiftRange;

    private KeylineStateList(@NonNull KeylineState defaultState, List<KeylineState> startStateSteps, List<KeylineState> endStateSteps) {
        this.defaultState = defaultState;
        this.startStateSteps = Collections.unmodifiableList(startStateSteps);
        this.endStateSteps = Collections.unmodifiableList(endStateSteps);
        this.startShiftRange = startStateSteps.get((int)(startStateSteps.size() - 1)).getFirstKeyline().loc - defaultState.getFirstKeyline().loc;
        this.endShiftRange = defaultState.getLastKeyline().loc - endStateSteps.get((int)(endStateSteps.size() - 1)).getLastKeyline().loc;
        this.startStateStepsInterpolationPoints = KeylineStateList.getStateStepInterpolationPoints(this.startShiftRange, startStateSteps, true);
        this.endStateStepsInterpolationPoints = KeylineStateList.getStateStepInterpolationPoints(this.endShiftRange, endStateSteps, false);
    }

    static KeylineStateList from(Carousel carousel, KeylineState state, float itemMargins, float leftOrTopPadding, float rightOrBottomPadding) {
        return new KeylineStateList(state, KeylineStateList.getStateStepsStart(carousel, state, itemMargins, leftOrTopPadding), KeylineStateList.getStateStepsEnd(carousel, state, itemMargins, rightOrBottomPadding));
    }

    KeylineState getDefaultState() {
        return this.defaultState;
    }

    KeylineState getStartState() {
        return this.startStateSteps.get(this.startStateSteps.size() - 1);
    }

    KeylineState getEndState() {
        return this.endStateSteps.get(this.endStateSteps.size() - 1);
    }

    public KeylineState getShiftedState(float scrollOffset, float minScrollOffset, float maxScrollOffset) {
        return this.getShiftedState(scrollOffset, minScrollOffset, maxScrollOffset, false);
    }

    KeylineState getShiftedState(float scrollOffset, float minScrollOffset, float maxScrollOffset, boolean roundToNearestStep) {
        float[] interpolationPoints;
        List<KeylineState> steps;
        float interpolation;
        float startShiftOffset = minScrollOffset + this.startShiftRange;
        float endShiftOffset = maxScrollOffset - this.endShiftRange;
        float startPaddingShift = this.getStartState().getFirstFocalKeyline().leftOrTopPaddingShift;
        float endPaddingShift = this.getEndState().getLastFocalKeyline().rightOrBottomPaddingShift;
        if (this.startShiftRange == startPaddingShift) {
            startShiftOffset += startPaddingShift;
        }
        if (this.endShiftRange == endPaddingShift) {
            endShiftOffset -= endPaddingShift;
        }
        if (scrollOffset < startShiftOffset) {
            interpolation = AnimationUtils.lerp(1.0f, 0.0f, minScrollOffset, startShiftOffset, scrollOffset);
            steps = this.startStateSteps;
            interpolationPoints = this.startStateStepsInterpolationPoints;
        } else if (scrollOffset > endShiftOffset) {
            interpolation = AnimationUtils.lerp(0.0f, 1.0f, endShiftOffset, maxScrollOffset, scrollOffset);
            steps = this.endStateSteps;
            interpolationPoints = this.endStateStepsInterpolationPoints;
        } else {
            return this.defaultState;
        }
        if (roundToNearestStep) {
            return this.closestStateStepFromInterpolation(steps, interpolation, interpolationPoints);
        }
        return KeylineStateList.lerp(steps, interpolation, interpolationPoints);
    }

    private static KeylineState lerp(List<KeylineState> stateSteps, float interpolation, float[] stateStepsInterpolationPoints) {
        float[] stateStepsRange = KeylineStateList.getStateStepsRange(stateSteps, interpolation, stateStepsInterpolationPoints);
        return KeylineState.lerp(stateSteps.get((int)stateStepsRange[1]), stateSteps.get((int)stateStepsRange[2]), stateStepsRange[0]);
    }

    private static float[] getStateStepsRange(List<KeylineState> stateSteps, float interpolation, float[] stateStepsInterpolationPoints) {
        int numberOfSteps = stateSteps.size();
        float lowerBounds = stateStepsInterpolationPoints[0];
        for (int i = 1; i < numberOfSteps; ++i) {
            float upperBounds = stateStepsInterpolationPoints[i];
            if (interpolation <= upperBounds) {
                int fromIndex = i - 1;
                int toIndex = i;
                float steppedProgress = AnimationUtils.lerp(0.0f, 1.0f, lowerBounds, upperBounds, interpolation);
                return new float[]{steppedProgress, fromIndex, toIndex};
            }
            lowerBounds = upperBounds;
        }
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    private KeylineState closestStateStepFromInterpolation(List<KeylineState> stateSteps, float interpolation, float[] stateStepsInterpolationPoints) {
        float[] stateStepsRange = KeylineStateList.getStateStepsRange(stateSteps, interpolation, stateStepsInterpolationPoints);
        if (stateStepsRange[0] >= 0.5f) {
            return stateSteps.get((int)stateStepsRange[2]);
        }
        return stateSteps.get((int)stateStepsRange[1]);
    }

    private static float[] getStateStepInterpolationPoints(float shiftRange, List<KeylineState> stateSteps, boolean isShiftingLeft) {
        int numberOfSteps = stateSteps.size();
        float[] stateStepsInterpolationPoints = new float[numberOfSteps];
        for (int i = 1; i < numberOfSteps; ++i) {
            KeylineState prevState = stateSteps.get(i - 1);
            KeylineState currState = stateSteps.get(i);
            float distanceShifted = isShiftingLeft ? currState.getFirstKeyline().loc - prevState.getFirstKeyline().loc : prevState.getLastKeyline().loc - currState.getLastKeyline().loc;
            float stepProgress = distanceShifted / shiftRange;
            stateStepsInterpolationPoints[i] = i == numberOfSteps - 1 ? 1.0f : stateStepsInterpolationPoints[i - 1] + stepProgress;
        }
        return stateStepsInterpolationPoints;
    }

    private static boolean isFirstFocalItemAtLeftOfContainer(KeylineState state) {
        float firstFocalItemLeft = state.getFirstFocalKeyline().locOffset - state.getFirstFocalKeyline().maskedItemSize / 2.0f;
        return firstFocalItemLeft >= 0.0f && state.getFirstFocalKeyline() == state.getFirstNonAnchorKeyline();
    }

    private static boolean isLastFocalItemVisibleAtRightOfContainer(Carousel carousel, KeylineState state) {
        float lastFocalItemRight;
        int containerSize = carousel.getContainerHeight();
        if (carousel.isHorizontal()) {
            containerSize = carousel.getContainerWidth();
        }
        return (lastFocalItemRight = state.getLastFocalKeyline().locOffset + state.getLastFocalKeyline().maskedItemSize / 2.0f) <= (float)containerSize && state.getLastFocalKeyline() == state.getLastNonAnchorKeyline();
    }

    private static KeylineState shiftKeylineStateForPadding(KeylineState keylineState, float padding, float carouselSize, boolean leftShift, float childMargins) {
        ArrayList<KeylineState.Keyline> tmpKeylines = new ArrayList<KeylineState.Keyline>(keylineState.getKeylines());
        KeylineState.Builder builder = new KeylineState.Builder(keylineState.getItemSize(), carouselSize);
        int numOfNonAnchorKeylines = keylineState.getNumberOfNonAnchorKeylines();
        float toDecreaseBy = padding / (float)numOfNonAnchorKeylines;
        float nextOffset = 0.0f;
        if (leftShift) {
            nextOffset = padding;
        }
        for (int j = 0; j < tmpKeylines.size(); ++j) {
            KeylineState.Keyline k = (KeylineState.Keyline)tmpKeylines.get(j);
            if (k.isAnchor) {
                builder.addKeyline(k.locOffset, k.mask, k.maskedItemSize, false, true, k.cutoff);
                continue;
            }
            boolean isFocal = j >= keylineState.getFirstFocalKeylineIndex() && j <= keylineState.getLastFocalKeylineIndex();
            float maskedItemSize = k.maskedItemSize - toDecreaseBy;
            float mask = CarouselStrategy.getChildMaskPercentage(maskedItemSize, keylineState.getItemSize(), childMargins);
            float locOffset = nextOffset + maskedItemSize / 2.0f;
            float actualPaddingShift = locOffset - k.locOffset;
            builder.addKeyline(locOffset, mask, maskedItemSize, isFocal, false, k.cutoff, leftShift ? actualPaddingShift : 0.0f, leftShift ? 0.0f : actualPaddingShift);
            nextOffset += maskedItemSize;
        }
        return builder.build();
    }

    private static List<KeylineState> getStateStepsStart(Carousel carousel, KeylineState defaultState, float itemMargins, float leftOrTopPaddingForKeylineShift) {
        float carouselSize;
        ArrayList<KeylineState> steps = new ArrayList<KeylineState>();
        steps.add(defaultState);
        int firstNonAnchorKeylineIndex = KeylineStateList.findFirstNonAnchorKeylineIndex(defaultState);
        float f = carouselSize = carousel.isHorizontal() ? (float)carousel.getContainerWidth() : (float)carousel.getContainerHeight();
        if (KeylineStateList.isFirstFocalItemAtLeftOfContainer(defaultState) || firstNonAnchorKeylineIndex == -1) {
            if (leftOrTopPaddingForKeylineShift > 0.0f) {
                steps.add(KeylineStateList.shiftKeylineStateForPadding(defaultState, leftOrTopPaddingForKeylineShift, carouselSize, true, itemMargins));
            }
            return steps;
        }
        int start = firstNonAnchorKeylineIndex;
        int end = defaultState.getFirstFocalKeylineIndex();
        int numberOfSteps = end - start;
        float originalStart = defaultState.getFirstKeyline().locOffset - defaultState.getFirstKeyline().maskedItemSize / 2.0f;
        if (numberOfSteps <= 0 && defaultState.getFirstFocalKeyline().cutoff > 0.0f) {
            float cutoffs = defaultState.getFirstFocalKeyline().cutoff;
            steps.add(KeylineStateList.shiftKeylinesAndCreateKeylineState(defaultState, originalStart + cutoffs, carouselSize));
            return steps;
        }
        float cutoffs = 0.0f;
        for (int i = 0; i < numberOfSteps; ++i) {
            KeylineState prevStepState = (KeylineState)steps.get(steps.size() - 1);
            int itemOrigIndex = start + i;
            int dstIndex = defaultState.getKeylines().size() - 1;
            cutoffs += defaultState.getKeylines().get((int)itemOrigIndex).cutoff;
            if (itemOrigIndex - 1 >= 0) {
                float originalAdjacentMaskLeft = defaultState.getKeylines().get((int)(itemOrigIndex - 1)).mask;
                dstIndex = KeylineStateList.findFirstIndexAfterLastFocalKeylineWithMask(prevStepState, originalAdjacentMaskLeft) - 1;
            }
            int newFirstFocalIndex = defaultState.getFirstFocalKeylineIndex() - i - 1;
            int newLastFocalIndex = defaultState.getLastFocalKeylineIndex() - i - 1;
            KeylineState shifted = KeylineStateList.moveKeylineAndCreateKeylineState(prevStepState, firstNonAnchorKeylineIndex, dstIndex, originalStart + cutoffs, newFirstFocalIndex, newLastFocalIndex, carouselSize);
            if (i == numberOfSteps - 1 && leftOrTopPaddingForKeylineShift > 0.0f) {
                shifted = KeylineStateList.shiftKeylineStateForPadding(shifted, leftOrTopPaddingForKeylineShift, carouselSize, true, itemMargins);
            }
            steps.add(shifted);
        }
        return steps;
    }

    private static List<KeylineState> getStateStepsEnd(Carousel carousel, KeylineState defaultState, float itemMargins, float rightOrBottomPaddingForKeylineShift) {
        float carouselSize;
        ArrayList<KeylineState> steps = new ArrayList<KeylineState>();
        steps.add(defaultState);
        int lastNonAnchorKeylineIndex = KeylineStateList.findLastNonAnchorKeylineIndex(defaultState);
        float f = carouselSize = carousel.isHorizontal() ? (float)carousel.getContainerWidth() : (float)carousel.getContainerHeight();
        if (KeylineStateList.isLastFocalItemVisibleAtRightOfContainer(carousel, defaultState) || lastNonAnchorKeylineIndex == -1) {
            if (rightOrBottomPaddingForKeylineShift > 0.0f) {
                steps.add(KeylineStateList.shiftKeylineStateForPadding(defaultState, rightOrBottomPaddingForKeylineShift, carouselSize, false, itemMargins));
            }
            return steps;
        }
        int start = defaultState.getLastFocalKeylineIndex();
        int end = lastNonAnchorKeylineIndex;
        int numberOfSteps = end - start;
        float originalStart = defaultState.getFirstKeyline().locOffset - defaultState.getFirstKeyline().maskedItemSize / 2.0f;
        if (numberOfSteps <= 0 && defaultState.getLastFocalKeyline().cutoff > 0.0f) {
            float cutoffs = defaultState.getLastFocalKeyline().cutoff;
            steps.add(KeylineStateList.shiftKeylinesAndCreateKeylineState(defaultState, originalStart - cutoffs, carouselSize));
            return steps;
        }
        float cutoffs = 0.0f;
        for (int i = 0; i < numberOfSteps; ++i) {
            KeylineState prevStepState = (KeylineState)steps.get(steps.size() - 1);
            int itemOrigIndex = end - i;
            cutoffs += defaultState.getKeylines().get((int)itemOrigIndex).cutoff;
            int dstIndex = 0;
            if (itemOrigIndex + 1 < defaultState.getKeylines().size()) {
                float originalAdjacentMaskRight = defaultState.getKeylines().get((int)(itemOrigIndex + 1)).mask;
                dstIndex = KeylineStateList.findLastIndexBeforeFirstFocalKeylineWithMask(prevStepState, originalAdjacentMaskRight) + 1;
            }
            int newFirstFocalIndex = defaultState.getFirstFocalKeylineIndex() + i + 1;
            int newLastFocalIndex = defaultState.getLastFocalKeylineIndex() + i + 1;
            KeylineState shifted = KeylineStateList.moveKeylineAndCreateKeylineState(prevStepState, lastNonAnchorKeylineIndex, dstIndex, originalStart - cutoffs, newFirstFocalIndex, newLastFocalIndex, carouselSize);
            if (i == numberOfSteps - 1 && rightOrBottomPaddingForKeylineShift > 0.0f) {
                shifted = KeylineStateList.shiftKeylineStateForPadding(shifted, rightOrBottomPaddingForKeylineShift, carouselSize, false, itemMargins);
            }
            steps.add(shifted);
        }
        return steps;
    }

    private static KeylineState shiftKeylinesAndCreateKeylineState(KeylineState state, float startOffset, float carouselSize) {
        return KeylineStateList.moveKeylineAndCreateKeylineState(state, 0, 0, startOffset, state.getFirstFocalKeylineIndex(), state.getLastFocalKeylineIndex(), carouselSize);
    }

    private static KeylineState moveKeylineAndCreateKeylineState(KeylineState state, int keylineSrcIndex, int keylineDstIndex, float startOffset, int newFirstFocalIndex, int newLastFocalIndex, float carouselSize) {
        ArrayList<KeylineState.Keyline> tmpKeylines = new ArrayList<KeylineState.Keyline>(state.getKeylines());
        KeylineState.Keyline item = (KeylineState.Keyline)tmpKeylines.remove(keylineSrcIndex);
        tmpKeylines.add(keylineDstIndex, item);
        KeylineState.Builder builder = new KeylineState.Builder(state.getItemSize(), carouselSize);
        for (int j = 0; j < tmpKeylines.size(); ++j) {
            KeylineState.Keyline k = (KeylineState.Keyline)tmpKeylines.get(j);
            float offset = startOffset + k.maskedItemSize / 2.0f;
            boolean isFocal = j >= newFirstFocalIndex && j <= newLastFocalIndex;
            builder.addKeyline(offset, k.mask, k.maskedItemSize, isFocal, k.isAnchor, k.cutoff);
            startOffset += k.maskedItemSize;
        }
        return builder.build();
    }

    private static int findFirstIndexAfterLastFocalKeylineWithMask(KeylineState state, float mask) {
        int focalEndIndex;
        for (int i = focalEndIndex = state.getLastFocalKeylineIndex(); i < state.getKeylines().size(); ++i) {
            if (mask != state.getKeylines().get((int)i).mask) continue;
            return i;
        }
        return state.getKeylines().size() - 1;
    }

    private static int findLastIndexBeforeFirstFocalKeylineWithMask(KeylineState state, float mask) {
        int focalStartIndex;
        for (int i = focalStartIndex = state.getFirstFocalKeylineIndex() - 1; i >= 0; --i) {
            if (mask != state.getKeylines().get((int)i).mask) continue;
            return i;
        }
        return 0;
    }

    private static int findFirstNonAnchorKeylineIndex(KeylineState state) {
        for (int i = 0; i < state.getKeylines().size(); ++i) {
            if (state.getKeylines().get((int)i).isAnchor) continue;
            return i;
        }
        return -1;
    }

    private static int findLastNonAnchorKeylineIndex(KeylineState state) {
        for (int i = state.getKeylines().size() - 1; i >= 0; --i) {
            if (state.getKeylines().get((int)i).isAnchor) continue;
            return i;
        }
        return -1;
    }

    Map<Integer, KeylineState> getKeylineStateForPositionMap(int itemCount, int minHorizontalScroll, int maxHorizontalScroll, boolean isRTL) {
        float itemPosition;
        int position;
        int i;
        float itemSize = this.defaultState.getItemSize();
        HashMap<Integer, KeylineState> keylineStates = new HashMap<Integer, KeylineState>();
        int endStepsIndex = 0;
        int startStepsIndex = 0;
        for (i = 0; i < itemCount; ++i) {
            position = isRTL ? itemCount - i - 1 : i;
            itemPosition = (float)position * itemSize * (float)(isRTL ? -1 : 1);
            if (!(itemPosition > (float)maxHorizontalScroll - this.endShiftRange) && i < itemCount - this.endStateSteps.size()) continue;
            keylineStates.put(position, this.endStateSteps.get(MathUtils.clamp((int)endStepsIndex, (int)0, (int)(this.endStateSteps.size() - 1))));
            ++endStepsIndex;
        }
        for (i = itemCount - 1; i >= 0; --i) {
            position = isRTL ? itemCount - i - 1 : i;
            itemPosition = (float)position * itemSize * (float)(isRTL ? -1 : 1);
            if (!(itemPosition < (float)minHorizontalScroll + this.startShiftRange) && i >= this.startStateSteps.size()) continue;
            keylineStates.put(position, this.startStateSteps.get(MathUtils.clamp((int)startStepsIndex, (int)0, (int)(this.startStateSteps.size() - 1))));
            ++startStepsIndex;
        }
        return keylineStates;
    }
}

