/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import androidx.annotation.AttrRes;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import com.google.android.material.R;
import com.google.android.material.color.HarmonizedColorAttributes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

public class HarmonizedColorsOptions {
    @NonNull
    @ColorRes
    private final int[] colorResourceIds;
    @Nullable
    private final HarmonizedColorAttributes colorAttributes;
    @AttrRes
    private final int colorAttributeToHarmonizeWith;

    @NonNull
    public static HarmonizedColorsOptions createMaterialDefaults() {
        return new Builder().setColorAttributes(HarmonizedColorAttributes.createMaterialDefaults()).build();
    }

    private HarmonizedColorsOptions(Builder builder) {
        this.colorResourceIds = builder.colorResourceIds;
        this.colorAttributes = builder.colorAttributes;
        this.colorAttributeToHarmonizeWith = builder.colorAttributeToHarmonizeWith;
    }

    @NonNull
    @ColorRes
    public int[] getColorResourceIds() {
        return this.colorResourceIds;
    }

    @Nullable
    public HarmonizedColorAttributes getColorAttributes() {
        return this.colorAttributes;
    }

    @AttrRes
    public int getColorAttributeToHarmonizeWith() {
        return this.colorAttributeToHarmonizeWith;
    }

    @StyleRes
    int getThemeOverlayResourceId(@StyleRes int defaultThemeOverlay) {
        return this.colorAttributes != null && this.colorAttributes.getThemeOverlay() != 0 ? this.colorAttributes.getThemeOverlay() : defaultThemeOverlay;
    }

    public static class Builder {
        @NonNull
        @ColorRes
        private int[] colorResourceIds = new int[0];
        @Nullable
        private HarmonizedColorAttributes colorAttributes;
        @AttrRes
        private int colorAttributeToHarmonizeWith = R.attr.colorPrimary;

        @NonNull
        @CanIgnoreReturnValue
        public Builder setColorResourceIds(@NonNull @ColorRes int[] colorResourceIds) {
            this.colorResourceIds = colorResourceIds;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setColorAttributes(@Nullable HarmonizedColorAttributes colorAttributes) {
            this.colorAttributes = colorAttributes;
            return this;
        }

        @NonNull
        @CanIgnoreReturnValue
        public Builder setColorAttributeToHarmonizeWith(@AttrRes int colorAttributeToHarmonizeWith) {
            this.colorAttributeToHarmonizeWith = colorAttributeToHarmonizeWith;
            return this;
        }

        @NonNull
        public HarmonizedColorsOptions build() {
            return new HarmonizedColorsOptions(this);
        }
    }
}

