/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.Hct;
import com.google.android.material.color.utilities.TonalPalette;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CorePalette {
    public TonalPalette a1;
    public TonalPalette a2;
    public TonalPalette a3;
    public TonalPalette n1;
    public TonalPalette n2;
    public TonalPalette error;

    public static CorePalette of(int argb) {
        return new CorePalette(argb, false);
    }

    public static CorePalette contentOf(int argb) {
        return new CorePalette(argb, true);
    }

    private CorePalette(int argb, boolean isContent) {
        Hct hct = Hct.fromInt(argb);
        double hue = hct.getHue();
        double chroma = hct.getChroma();
        if (isContent) {
            this.a1 = TonalPalette.fromHueAndChroma(hue, chroma);
            this.a2 = TonalPalette.fromHueAndChroma(hue, chroma / 3.0);
            this.a3 = TonalPalette.fromHueAndChroma(hue + 60.0, chroma / 2.0);
            this.n1 = TonalPalette.fromHueAndChroma(hue, Math.min(chroma / 12.0, 4.0));
            this.n2 = TonalPalette.fromHueAndChroma(hue, Math.min(chroma / 6.0, 8.0));
        } else {
            this.a1 = TonalPalette.fromHueAndChroma(hue, Math.max(48.0, chroma));
            this.a2 = TonalPalette.fromHueAndChroma(hue, 16.0);
            this.a3 = TonalPalette.fromHueAndChroma(hue + 60.0, 24.0);
            this.n1 = TonalPalette.fromHueAndChroma(hue, 4.0);
            this.n2 = TonalPalette.fromHueAndChroma(hue, 8.0);
        }
        this.error = TonalPalette.fromHueAndChroma(25.0, 84.0);
    }
}

