/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color.utilities;

import androidx.annotation.RestrictTo;
import com.google.android.material.color.utilities.QuantizerResult;
import com.google.android.material.color.utilities.QuantizerWsmeans;
import com.google.android.material.color.utilities.QuantizerWu;
import java.util.Map;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class QuantizerCelebi {
    private QuantizerCelebi() {
    }

    public static Map<Integer, Integer> quantize(int[] pixels, int maxColors) {
        QuantizerWu wu = new QuantizerWu();
        QuantizerResult wuResult = wu.quantize(pixels, maxColors);
        Set<Integer> wuClustersAsObjects = wuResult.colorToCount.keySet();
        int index = 0;
        int[] wuClusters = new int[wuClustersAsObjects.size()];
        for (Integer argb : wuClustersAsObjects) {
            wuClusters[index++] = argb;
        }
        return QuantizerWsmeans.quantize(pixels, wuClusters, maxColors);
    }
}

