/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Pair;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.CalendarItemStyle;
import com.google.android.material.datepicker.CalendarStyle;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.DayViewDecorator;
import com.google.android.material.datepicker.MaterialCalendarGridView;
import com.google.android.material.datepicker.Month;
import com.google.android.material.datepicker.UtcDates;
import java.util.Collection;
import java.util.Locale;

class MonthAdapter
extends BaseAdapter {
    static final int MAXIMUM_WEEKS = UtcDates.getUtcCalendar().getMaximum(4);
    private static final int MAXIMUM_GRID_CELLS = UtcDates.getUtcCalendar().getMaximum(5) + UtcDates.getUtcCalendar().getMaximum(7) - 1;
    private static final int NO_DAY_NUMBER = -1;
    final Month month;
    final DateSelector<?> dateSelector;
    private Collection<Long> previouslySelectedDates;
    CalendarStyle calendarStyle;
    final CalendarConstraints calendarConstraints;
    @Nullable
    final DayViewDecorator dayViewDecorator;

    MonthAdapter(Month month, DateSelector<?> dateSelector, CalendarConstraints calendarConstraints, @Nullable DayViewDecorator dayViewDecorator) {
        this.month = month;
        this.dateSelector = dateSelector;
        this.calendarConstraints = calendarConstraints;
        this.dayViewDecorator = dayViewDecorator;
        this.previouslySelectedDates = dateSelector.getSelectedDays();
    }

    public boolean hasStableIds() {
        return true;
    }

    @Nullable
    public Long getItem(int position) {
        if (position < this.firstPositionInMonth() || position > this.lastPositionInMonth()) {
            return null;
        }
        return this.month.getDay(this.positionToDay(position));
    }

    public long getItemId(int position) {
        return position / this.month.daysInWeek;
    }

    public int getCount() {
        return MAXIMUM_GRID_CELLS;
    }

    @NonNull
    public TextView getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        this.initializeStyles(parent.getContext());
        TextView dayTextView = (TextView)convertView;
        if (convertView == null) {
            LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
            dayTextView = (TextView)layoutInflater.inflate(R.layout.mtrl_calendar_day, parent, false);
        }
        int offsetPosition = position - this.firstPositionInMonth();
        int dayNumber = -1;
        if (offsetPosition < 0 || offsetPosition >= this.month.daysInMonth) {
            dayTextView.setVisibility(8);
            dayTextView.setEnabled(false);
        } else {
            dayNumber = offsetPosition + 1;
            dayTextView.setTag((Object)this.month);
            Locale locale = dayTextView.getResources().getConfiguration().locale;
            dayTextView.setText((CharSequence)String.format(locale, "%d", dayNumber));
            dayTextView.setVisibility(0);
            dayTextView.setEnabled(true);
        }
        Long date = this.getItem(position);
        if (date == null) {
            return dayTextView;
        }
        this.updateSelectedState(dayTextView, date, dayNumber);
        return dayTextView;
    }

    public void updateSelectedStates(MaterialCalendarGridView monthGrid) {
        for (Long date : this.previouslySelectedDates) {
            this.updateSelectedStateForDate(monthGrid, date);
        }
        if (this.dateSelector != null) {
            for (Long date : this.dateSelector.getSelectedDays()) {
                this.updateSelectedStateForDate(monthGrid, date);
            }
            this.previouslySelectedDates = this.dateSelector.getSelectedDays();
        }
    }

    private void updateSelectedStateForDate(MaterialCalendarGridView monthGrid, long date) {
        if (Month.create(date).equals(this.month)) {
            int day = this.month.getDayOfMonth(date);
            this.updateSelectedState((TextView)monthGrid.getChildAt(monthGrid.getAdapter().dayToPosition(day) - monthGrid.getFirstVisiblePosition()), date, day);
        }
    }

    private void updateSelectedState(@Nullable TextView dayTextView, long date, int dayNumber) {
        CalendarItemStyle style2;
        if (dayTextView == null) {
            return;
        }
        Context context = dayTextView.getContext();
        String contentDescription = this.getDayContentDescription(context, date);
        dayTextView.setContentDescription((CharSequence)contentDescription);
        boolean valid = this.calendarConstraints.getDateValidator().isValid(date);
        boolean selected = false;
        if (valid) {
            dayTextView.setEnabled(true);
            selected = this.isSelected(date);
            dayTextView.setSelected(selected);
            style2 = selected ? this.calendarStyle.selectedDay : (this.isToday(date) ? this.calendarStyle.todayDay : this.calendarStyle.day);
        } else {
            dayTextView.setEnabled(false);
            style2 = this.calendarStyle.invalidDay;
        }
        if (this.dayViewDecorator != null && dayNumber != -1) {
            int year = this.month.year;
            int month = this.month.month;
            ColorStateList backgroundColorOverride = this.dayViewDecorator.getBackgroundColor(context, year, month, dayNumber, valid, selected);
            ColorStateList textColorOverride = this.dayViewDecorator.getTextColor(context, year, month, dayNumber, valid, selected);
            style2.styleItem(dayTextView, backgroundColorOverride, textColorOverride);
            Drawable drawableLeft = this.dayViewDecorator.getCompoundDrawableLeft(context, year, month, dayNumber, valid, selected);
            Drawable drawableTop = this.dayViewDecorator.getCompoundDrawableTop(context, year, month, dayNumber, valid, selected);
            Drawable drawableRight = this.dayViewDecorator.getCompoundDrawableRight(context, year, month, dayNumber, valid, selected);
            Drawable drawableBottom = this.dayViewDecorator.getCompoundDrawableBottom(context, year, month, dayNumber, valid, selected);
            dayTextView.setCompoundDrawables(drawableLeft, drawableTop, drawableRight, drawableBottom);
            CharSequence decoratorContentDescription = this.dayViewDecorator.getContentDescription(context, year, month, dayNumber, valid, selected, contentDescription);
            dayTextView.setContentDescription(decoratorContentDescription);
        } else {
            style2.styleItem(dayTextView);
        }
    }

    private String getDayContentDescription(Context context, long date) {
        return DateStrings.getDayContentDescription(context, date, this.isToday(date), this.isStartOfRange(date), this.isEndOfRange(date));
    }

    private boolean isToday(long date) {
        return UtcDates.getTodayCalendar().getTimeInMillis() == date;
    }

    @VisibleForTesting
    boolean isStartOfRange(long date) {
        for (Pair<Long, Long> range : this.dateSelector.getSelectedRanges()) {
            if (range.first == null || (Long)range.first != date) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean isEndOfRange(long date) {
        for (Pair<Long, Long> range : this.dateSelector.getSelectedRanges()) {
            if (range.second == null || (Long)range.second != date) continue;
            return true;
        }
        return false;
    }

    private boolean isSelected(long date) {
        for (long selectedDay : this.dateSelector.getSelectedDays()) {
            if (UtcDates.canonicalYearMonthDay(date) != UtcDates.canonicalYearMonthDay(selectedDay)) continue;
            return true;
        }
        return false;
    }

    private void initializeStyles(Context context) {
        if (this.calendarStyle == null) {
            this.calendarStyle = new CalendarStyle(context);
        }
    }

    int firstPositionInMonth() {
        return this.month.daysFromStartOfWeekToFirstOfMonth(this.calendarConstraints.getFirstDayOfWeek());
    }

    int lastPositionInMonth() {
        return this.firstPositionInMonth() + this.month.daysInMonth - 1;
    }

    int positionToDay(int position) {
        return position - this.firstPositionInMonth() + 1;
    }

    int dayToPosition(int day) {
        int offsetFromFirst = day - 1;
        return this.firstPositionInMonth() + offsetFromFirst;
    }

    boolean withinMonth(int position) {
        return position >= this.firstPositionInMonth() && position <= this.lastPositionInMonth();
    }

    boolean isFirstInRow(int position) {
        return position % this.month.daysInWeek == 0;
    }

    boolean isLastInRow(int position) {
        return (position + 1) % this.month.daysInWeek == 0;
    }
}

