/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.animation.TimeInterpolator;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.math.MathUtils;
import androidx.core.text.TextDirectionHeuristicsCompat;
import androidx.core.util.Preconditions;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.StaticLayoutBuilderCompat;
import com.google.android.material.internal.StaticLayoutBuilderConfigurer;
import com.google.android.material.resources.CancelableFontCallback;
import com.google.android.material.resources.TextAppearance;
import com.google.android.material.resources.TypefaceUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CollapsingTextHelper {
    private static final boolean USE_SCALING_TEXTURE = Build.VERSION.SDK_INT < 18;
    private static final String TAG = "CollapsingTextHelper";
    private static final String ELLIPSIS_NORMAL = "\u2026";
    private static final float FADE_MODE_THRESHOLD_FRACTION_RELATIVE = 0.5f;
    private static final boolean DEBUG_DRAW = false;
    @NonNull
    private static final Paint DEBUG_DRAW_PAINT = null;
    private final View view;
    private float expandedFraction;
    private boolean fadeModeEnabled;
    private float fadeModeStartFraction;
    private float fadeModeThresholdFraction;
    private int currentOffsetY;
    @NonNull
    private final Rect expandedBounds;
    @NonNull
    private final Rect collapsedBounds;
    @NonNull
    private final RectF currentBounds;
    private int expandedTextGravity = 16;
    private int collapsedTextGravity = 16;
    private float expandedTextSize = 15.0f;
    private float collapsedTextSize = 15.0f;
    private ColorStateList expandedTextColor;
    private ColorStateList collapsedTextColor;
    private int expandedLineCount;
    private float expandedDrawY;
    private float collapsedDrawY;
    private float expandedDrawX;
    private float collapsedDrawX;
    private float currentDrawX;
    private float currentDrawY;
    private Typeface collapsedTypeface;
    private Typeface collapsedTypefaceBold;
    private Typeface collapsedTypefaceDefault;
    private Typeface expandedTypeface;
    private Typeface expandedTypefaceBold;
    private Typeface expandedTypefaceDefault;
    private Typeface currentTypeface;
    private CancelableFontCallback expandedFontCallback;
    private CancelableFontCallback collapsedFontCallback;
    private TextUtils.TruncateAt titleTextEllipsize = TextUtils.TruncateAt.END;
    @Nullable
    private CharSequence text;
    @Nullable
    private CharSequence textToDraw;
    private boolean isRtl;
    private boolean isRtlTextDirectionHeuristicsEnabled = true;
    private boolean useTexture;
    @Nullable
    private Bitmap expandedTitleTexture;
    private Paint texturePaint;
    private float scale;
    private float currentTextSize;
    private float currentShadowRadius;
    private float currentShadowDx;
    private float currentShadowDy;
    private int currentShadowColor;
    private int[] state;
    private boolean boundsChanged;
    @NonNull
    private final TextPaint textPaint;
    @NonNull
    private final TextPaint tmpPaint;
    private TimeInterpolator positionInterpolator;
    private TimeInterpolator textSizeInterpolator;
    private float collapsedShadowRadius;
    private float collapsedShadowDx;
    private float collapsedShadowDy;
    private ColorStateList collapsedShadowColor;
    private float expandedShadowRadius;
    private float expandedShadowDx;
    private float expandedShadowDy;
    private ColorStateList expandedShadowColor;
    private float collapsedLetterSpacing;
    private float expandedLetterSpacing;
    private float currentLetterSpacing;
    private StaticLayout textLayout;
    private float collapsedTextWidth;
    private float collapsedTextBlend;
    private float expandedTextBlend;
    private CharSequence textToDrawCollapsed;
    private int maxLines = 1;
    private float lineSpacingAdd = 0.0f;
    private float lineSpacingMultiplier = 1.0f;
    private int hyphenationFrequency = StaticLayoutBuilderCompat.DEFAULT_HYPHENATION_FREQUENCY;
    @Nullable
    private StaticLayoutBuilderConfigurer staticLayoutBuilderConfigurer;

    public CollapsingTextHelper(View view) {
        this.view = view;
        this.textPaint = new TextPaint(129);
        this.tmpPaint = new TextPaint((Paint)this.textPaint);
        this.collapsedBounds = new Rect();
        this.expandedBounds = new Rect();
        this.currentBounds = new RectF();
        this.fadeModeThresholdFraction = this.calculateFadeModeThresholdFraction();
        this.maybeUpdateFontWeightAdjustment(view.getContext().getResources().getConfiguration());
    }

    public void setTextSizeInterpolator(TimeInterpolator interpolator) {
        this.textSizeInterpolator = interpolator;
        this.recalculate();
    }

    public void setPositionInterpolator(TimeInterpolator interpolator) {
        this.positionInterpolator = interpolator;
        this.recalculate();
    }

    @Nullable
    public TimeInterpolator getPositionInterpolator() {
        return this.positionInterpolator;
    }

    public void setExpandedTextSize(float textSize) {
        if (this.expandedTextSize != textSize) {
            this.expandedTextSize = textSize;
            this.recalculate();
        }
    }

    public void setCollapsedTextSize(float textSize) {
        if (this.collapsedTextSize != textSize) {
            this.collapsedTextSize = textSize;
            this.recalculate();
        }
    }

    public void setCollapsedTextColor(ColorStateList textColor) {
        if (this.collapsedTextColor != textColor) {
            this.collapsedTextColor = textColor;
            this.recalculate();
        }
    }

    public void setExpandedTextColor(ColorStateList textColor) {
        if (this.expandedTextColor != textColor) {
            this.expandedTextColor = textColor;
            this.recalculate();
        }
    }

    public void setCollapsedAndExpandedTextColor(@Nullable ColorStateList textColor) {
        if (this.collapsedTextColor != textColor || this.expandedTextColor != textColor) {
            this.collapsedTextColor = textColor;
            this.expandedTextColor = textColor;
            this.recalculate();
        }
    }

    public void setExpandedLetterSpacing(float letterSpacing) {
        if (this.expandedLetterSpacing != letterSpacing) {
            this.expandedLetterSpacing = letterSpacing;
            this.recalculate();
        }
    }

    public void setExpandedBounds(int left, int top, int right, int bottom) {
        if (!CollapsingTextHelper.rectEquals(this.expandedBounds, left, top, right, bottom)) {
            this.expandedBounds.set(left, top, right, bottom);
            this.boundsChanged = true;
        }
    }

    public void setExpandedBounds(@NonNull Rect bounds) {
        this.setExpandedBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void setCollapsedBounds(int left, int top, int right, int bottom) {
        if (!CollapsingTextHelper.rectEquals(this.collapsedBounds, left, top, right, bottom)) {
            this.collapsedBounds.set(left, top, right, bottom);
            this.boundsChanged = true;
        }
    }

    public void setCollapsedBounds(@NonNull Rect bounds) {
        this.setCollapsedBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void getCollapsedTextActualBounds(@NonNull RectF bounds, int labelWidth, int textGravity) {
        this.isRtl = this.calculateIsRtl(this.text);
        bounds.left = Math.max(this.getCollapsedTextLeftBound(labelWidth, textGravity), (float)this.collapsedBounds.left);
        bounds.top = this.collapsedBounds.top;
        bounds.right = Math.min(this.getCollapsedTextRightBound(bounds, labelWidth, textGravity), (float)this.collapsedBounds.right);
        bounds.bottom = (float)this.collapsedBounds.top + this.getCollapsedTextHeight();
    }

    private float getCollapsedTextLeftBound(int width, int gravity) {
        if (gravity == 17 || (gravity & 7) == 1) {
            return (float)width / 2.0f - this.collapsedTextWidth / 2.0f;
        }
        if ((gravity & 0x800005) == 0x800005 || (gravity & 5) == 5) {
            return this.isRtl ? (float)this.collapsedBounds.left : (float)this.collapsedBounds.right - this.collapsedTextWidth;
        }
        return this.isRtl ? (float)this.collapsedBounds.right - this.collapsedTextWidth : (float)this.collapsedBounds.left;
    }

    private float getCollapsedTextRightBound(@NonNull RectF bounds, int width, int gravity) {
        if (gravity == 17 || (gravity & 7) == 1) {
            return (float)width / 2.0f + this.collapsedTextWidth / 2.0f;
        }
        if ((gravity & 0x800005) == 0x800005 || (gravity & 5) == 5) {
            return this.isRtl ? bounds.left + this.collapsedTextWidth : (float)this.collapsedBounds.right;
        }
        return this.isRtl ? (float)this.collapsedBounds.right : bounds.left + this.collapsedTextWidth;
    }

    public float getExpandedTextHeight() {
        this.getTextPaintExpanded(this.tmpPaint);
        return -this.tmpPaint.ascent();
    }

    public float getExpandedTextFullHeight() {
        this.getTextPaintExpanded(this.tmpPaint);
        return -this.tmpPaint.ascent() + this.tmpPaint.descent();
    }

    public float getCollapsedTextHeight() {
        this.getTextPaintCollapsed(this.tmpPaint);
        return -this.tmpPaint.ascent();
    }

    public void setCurrentOffsetY(int currentOffsetY) {
        this.currentOffsetY = currentOffsetY;
    }

    public void setFadeModeStartFraction(float fadeModeStartFraction) {
        this.fadeModeStartFraction = fadeModeStartFraction;
        this.fadeModeThresholdFraction = this.calculateFadeModeThresholdFraction();
    }

    private float calculateFadeModeThresholdFraction() {
        return this.fadeModeStartFraction + (1.0f - this.fadeModeStartFraction) * 0.5f;
    }

    public void setFadeModeEnabled(boolean fadeModeEnabled) {
        this.fadeModeEnabled = fadeModeEnabled;
    }

    private void getTextPaintExpanded(@NonNull TextPaint textPaint) {
        textPaint.setTextSize(this.expandedTextSize);
        textPaint.setTypeface(this.expandedTypeface);
        if (Build.VERSION.SDK_INT >= 21) {
            textPaint.setLetterSpacing(this.expandedLetterSpacing);
        }
    }

    private void getTextPaintCollapsed(@NonNull TextPaint textPaint) {
        textPaint.setTextSize(this.collapsedTextSize);
        textPaint.setTypeface(this.collapsedTypeface);
        if (Build.VERSION.SDK_INT >= 21) {
            textPaint.setLetterSpacing(this.collapsedLetterSpacing);
        }
    }

    public void setExpandedTextGravity(int gravity) {
        if (this.expandedTextGravity != gravity) {
            this.expandedTextGravity = gravity;
            this.recalculate();
        }
    }

    public int getExpandedTextGravity() {
        return this.expandedTextGravity;
    }

    public void setCollapsedTextGravity(int gravity) {
        if (this.collapsedTextGravity != gravity) {
            this.collapsedTextGravity = gravity;
            this.recalculate();
        }
    }

    public int getCollapsedTextGravity() {
        return this.collapsedTextGravity;
    }

    public void setCollapsedTextAppearance(int resId) {
        TextAppearance textAppearance = new TextAppearance(this.view.getContext(), resId);
        if (textAppearance.getTextColor() != null) {
            this.collapsedTextColor = textAppearance.getTextColor();
        }
        if (textAppearance.getTextSize() != 0.0f) {
            this.collapsedTextSize = textAppearance.getTextSize();
        }
        if (textAppearance.shadowColor != null) {
            this.collapsedShadowColor = textAppearance.shadowColor;
        }
        this.collapsedShadowDx = textAppearance.shadowDx;
        this.collapsedShadowDy = textAppearance.shadowDy;
        this.collapsedShadowRadius = textAppearance.shadowRadius;
        this.collapsedLetterSpacing = textAppearance.letterSpacing;
        if (this.collapsedFontCallback != null) {
            this.collapsedFontCallback.cancel();
        }
        this.collapsedFontCallback = new CancelableFontCallback(new CancelableFontCallback.ApplyFont(){

            @Override
            public void apply(Typeface font) {
                CollapsingTextHelper.this.setCollapsedTypeface(font);
            }
        }, textAppearance.getFallbackFont());
        textAppearance.getFontAsync(this.view.getContext(), this.collapsedFontCallback);
        this.recalculate();
    }

    public void setExpandedTextAppearance(int resId) {
        TextAppearance textAppearance = new TextAppearance(this.view.getContext(), resId);
        if (textAppearance.getTextColor() != null) {
            this.expandedTextColor = textAppearance.getTextColor();
        }
        if (textAppearance.getTextSize() != 0.0f) {
            this.expandedTextSize = textAppearance.getTextSize();
        }
        if (textAppearance.shadowColor != null) {
            this.expandedShadowColor = textAppearance.shadowColor;
        }
        this.expandedShadowDx = textAppearance.shadowDx;
        this.expandedShadowDy = textAppearance.shadowDy;
        this.expandedShadowRadius = textAppearance.shadowRadius;
        this.expandedLetterSpacing = textAppearance.letterSpacing;
        if (this.expandedFontCallback != null) {
            this.expandedFontCallback.cancel();
        }
        this.expandedFontCallback = new CancelableFontCallback(new CancelableFontCallback.ApplyFont(){

            @Override
            public void apply(Typeface font) {
                CollapsingTextHelper.this.setExpandedTypeface(font);
            }
        }, textAppearance.getFallbackFont());
        textAppearance.getFontAsync(this.view.getContext(), this.expandedFontCallback);
        this.recalculate();
    }

    public void setTitleTextEllipsize(@NonNull TextUtils.TruncateAt ellipsize) {
        this.titleTextEllipsize = ellipsize;
        this.recalculate();
    }

    @NonNull
    public TextUtils.TruncateAt getTitleTextEllipsize() {
        return this.titleTextEllipsize;
    }

    public void setCollapsedTypeface(Typeface typeface) {
        if (this.setCollapsedTypefaceInternal(typeface)) {
            this.recalculate();
        }
    }

    public void setExpandedTypeface(Typeface typeface) {
        if (this.setExpandedTypefaceInternal(typeface)) {
            this.recalculate();
        }
    }

    public void setTypefaces(Typeface typeface) {
        boolean collapsedFontChanged = this.setCollapsedTypefaceInternal(typeface);
        boolean expandedFontChanged = this.setExpandedTypefaceInternal(typeface);
        if (collapsedFontChanged || expandedFontChanged) {
            this.recalculate();
        }
    }

    private boolean setCollapsedTypefaceInternal(Typeface typeface) {
        if (this.collapsedFontCallback != null) {
            this.collapsedFontCallback.cancel();
        }
        if (this.collapsedTypefaceDefault != typeface) {
            this.collapsedTypefaceDefault = typeface;
            this.collapsedTypefaceBold = TypefaceUtils.maybeCopyWithFontWeightAdjustment(this.view.getContext().getResources().getConfiguration(), typeface);
            this.collapsedTypeface = this.collapsedTypefaceBold == null ? this.collapsedTypefaceDefault : this.collapsedTypefaceBold;
            return true;
        }
        return false;
    }

    private boolean setExpandedTypefaceInternal(Typeface typeface) {
        if (this.expandedFontCallback != null) {
            this.expandedFontCallback.cancel();
        }
        if (this.expandedTypefaceDefault != typeface) {
            this.expandedTypefaceDefault = typeface;
            this.expandedTypefaceBold = TypefaceUtils.maybeCopyWithFontWeightAdjustment(this.view.getContext().getResources().getConfiguration(), typeface);
            this.expandedTypeface = this.expandedTypefaceBold == null ? this.expandedTypefaceDefault : this.expandedTypefaceBold;
            return true;
        }
        return false;
    }

    public Typeface getCollapsedTypeface() {
        return this.collapsedTypeface != null ? this.collapsedTypeface : Typeface.DEFAULT;
    }

    public Typeface getExpandedTypeface() {
        return this.expandedTypeface != null ? this.expandedTypeface : Typeface.DEFAULT;
    }

    public void maybeUpdateFontWeightAdjustment(@NonNull Configuration configuration) {
        if (Build.VERSION.SDK_INT >= 31) {
            if (this.collapsedTypefaceDefault != null) {
                this.collapsedTypefaceBold = TypefaceUtils.maybeCopyWithFontWeightAdjustment(configuration, this.collapsedTypefaceDefault);
            }
            if (this.expandedTypefaceDefault != null) {
                this.expandedTypefaceBold = TypefaceUtils.maybeCopyWithFontWeightAdjustment(configuration, this.expandedTypefaceDefault);
            }
            this.collapsedTypeface = this.collapsedTypefaceBold != null ? this.collapsedTypefaceBold : this.collapsedTypefaceDefault;
            this.expandedTypeface = this.expandedTypefaceBold != null ? this.expandedTypefaceBold : this.expandedTypefaceDefault;
            this.recalculate(true);
        }
    }

    public void setExpansionFraction(float fraction) {
        if ((fraction = MathUtils.clamp((float)fraction, (float)0.0f, (float)1.0f)) != this.expandedFraction) {
            this.expandedFraction = fraction;
            this.calculateCurrentOffsets();
        }
    }

    public final boolean setState(int[] state) {
        this.state = state;
        if (this.isStateful()) {
            this.recalculate();
            return true;
        }
        return false;
    }

    public final boolean isStateful() {
        return this.collapsedTextColor != null && this.collapsedTextColor.isStateful() || this.expandedTextColor != null && this.expandedTextColor.isStateful();
    }

    public float getFadeModeThresholdFraction() {
        return this.fadeModeThresholdFraction;
    }

    public float getExpansionFraction() {
        return this.expandedFraction;
    }

    public float getCollapsedTextSize() {
        return this.collapsedTextSize;
    }

    public float getExpandedTextSize() {
        return this.expandedTextSize;
    }

    public void setRtlTextDirectionHeuristicsEnabled(boolean rtlTextDirectionHeuristicsEnabled) {
        this.isRtlTextDirectionHeuristicsEnabled = rtlTextDirectionHeuristicsEnabled;
    }

    public boolean isRtlTextDirectionHeuristicsEnabled() {
        return this.isRtlTextDirectionHeuristicsEnabled;
    }

    private void calculateCurrentOffsets() {
        this.calculateOffsets(this.expandedFraction);
    }

    private void calculateOffsets(float fraction) {
        float textBlendFraction;
        this.interpolateBounds(fraction);
        if (this.fadeModeEnabled) {
            if (fraction < this.fadeModeThresholdFraction) {
                textBlendFraction = 0.0f;
                this.currentDrawX = this.expandedDrawX;
                this.currentDrawY = this.expandedDrawY;
                this.setInterpolatedTextSize(0.0f);
            } else {
                textBlendFraction = 1.0f;
                this.currentDrawX = this.collapsedDrawX;
                this.currentDrawY = this.collapsedDrawY - (float)Math.max(0, this.currentOffsetY);
                this.setInterpolatedTextSize(1.0f);
            }
        } else {
            textBlendFraction = fraction;
            this.currentDrawX = CollapsingTextHelper.lerp(this.expandedDrawX, this.collapsedDrawX, fraction, this.positionInterpolator);
            this.currentDrawY = CollapsingTextHelper.lerp(this.expandedDrawY, this.collapsedDrawY, fraction, this.positionInterpolator);
            this.setInterpolatedTextSize(fraction);
        }
        this.setCollapsedTextBlend(1.0f - CollapsingTextHelper.lerp(0.0f, 1.0f, 1.0f - fraction, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        this.setExpandedTextBlend(CollapsingTextHelper.lerp(1.0f, 0.0f, fraction, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        if (this.collapsedTextColor != this.expandedTextColor) {
            this.textPaint.setColor(CollapsingTextHelper.blendARGB(this.getCurrentExpandedTextColor(), this.getCurrentCollapsedTextColor(), textBlendFraction));
        } else {
            this.textPaint.setColor(this.getCurrentCollapsedTextColor());
        }
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.collapsedLetterSpacing != this.expandedLetterSpacing) {
                this.textPaint.setLetterSpacing(CollapsingTextHelper.lerp(this.expandedLetterSpacing, this.collapsedLetterSpacing, fraction, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
            } else {
                this.textPaint.setLetterSpacing(this.collapsedLetterSpacing);
            }
        }
        this.currentShadowRadius = CollapsingTextHelper.lerp(this.expandedShadowRadius, this.collapsedShadowRadius, fraction, null);
        this.currentShadowDx = CollapsingTextHelper.lerp(this.expandedShadowDx, this.collapsedShadowDx, fraction, null);
        this.currentShadowDy = CollapsingTextHelper.lerp(this.expandedShadowDy, this.collapsedShadowDy, fraction, null);
        this.currentShadowColor = CollapsingTextHelper.blendARGB(this.getCurrentColor(this.expandedShadowColor), this.getCurrentColor(this.collapsedShadowColor), fraction);
        this.textPaint.setShadowLayer(this.currentShadowRadius, this.currentShadowDx, this.currentShadowDy, this.currentShadowColor);
        if (this.fadeModeEnabled) {
            int originalAlpha = this.textPaint.getAlpha();
            int textAlpha = (int)(this.calculateFadeModeTextAlpha(fraction) * (float)originalAlpha);
            this.textPaint.setAlpha(textAlpha);
            if (Build.VERSION.SDK_INT >= 31) {
                this.textPaint.setShadowLayer(this.currentShadowRadius, this.currentShadowDx, this.currentShadowDy, MaterialColors.compositeARGBWithAlpha(this.currentShadowColor, this.textPaint.getAlpha()));
            }
        }
        ViewCompat.postInvalidateOnAnimation((View)this.view);
    }

    private float calculateFadeModeTextAlpha(@FloatRange(from=0.0, to=1.0) float fraction) {
        if (fraction <= this.fadeModeThresholdFraction) {
            return AnimationUtils.lerp(1.0f, 0.0f, this.fadeModeStartFraction, this.fadeModeThresholdFraction, fraction);
        }
        return AnimationUtils.lerp(0.0f, 1.0f, this.fadeModeThresholdFraction, 1.0f, fraction);
    }

    @ColorInt
    private int getCurrentExpandedTextColor() {
        return this.getCurrentColor(this.expandedTextColor);
    }

    @ColorInt
    public int getCurrentCollapsedTextColor() {
        return this.getCurrentColor(this.collapsedTextColor);
    }

    @ColorInt
    private int getCurrentColor(@Nullable ColorStateList colorStateList) {
        if (colorStateList == null) {
            return 0;
        }
        if (this.state != null) {
            return colorStateList.getColorForState(this.state, 0);
        }
        return colorStateList.getDefaultColor();
    }

    private void calculateBaseOffsets(boolean forceRecalculate) {
        this.calculateUsingTextSize(1.0f, forceRecalculate);
        if (this.textToDraw != null && this.textLayout != null) {
            this.textToDrawCollapsed = TextUtils.ellipsize((CharSequence)this.textToDraw, (TextPaint)this.textPaint, (float)this.textLayout.getWidth(), (TextUtils.TruncateAt)this.titleTextEllipsize);
        }
        this.collapsedTextWidth = this.textToDrawCollapsed != null ? this.measureTextWidth(this.textPaint, this.textToDrawCollapsed) : 0.0f;
        int collapsedAbsGravity = GravityCompat.getAbsoluteGravity((int)this.collapsedTextGravity, (int)(this.isRtl ? 1 : 0));
        switch (collapsedAbsGravity & 0x70) {
            case 80: {
                this.collapsedDrawY = (float)this.collapsedBounds.bottom + this.textPaint.ascent();
                break;
            }
            case 48: {
                this.collapsedDrawY = this.collapsedBounds.top;
                break;
            }
            default: {
                float textOffset = (this.textPaint.descent() - this.textPaint.ascent()) / 2.0f;
                this.collapsedDrawY = (float)this.collapsedBounds.centerY() - textOffset;
            }
        }
        switch (collapsedAbsGravity & 0x800007) {
            case 1: {
                this.collapsedDrawX = (float)this.collapsedBounds.centerX() - this.collapsedTextWidth / 2.0f;
                break;
            }
            case 5: {
                this.collapsedDrawX = (float)this.collapsedBounds.right - this.collapsedTextWidth;
                break;
            }
            default: {
                this.collapsedDrawX = this.collapsedBounds.left;
            }
        }
        this.calculateUsingTextSize(0.0f, forceRecalculate);
        float expandedTextHeight = this.textLayout != null ? (float)this.textLayout.getHeight() : 0.0f;
        float expandedTextWidth = 0.0f;
        if (this.textLayout != null && this.maxLines > 1) {
            expandedTextWidth = this.textLayout.getWidth();
        } else if (this.textToDraw != null) {
            expandedTextWidth = this.measureTextWidth(this.textPaint, this.textToDraw);
        }
        this.expandedLineCount = this.textLayout != null ? this.textLayout.getLineCount() : 0;
        int expandedAbsGravity = GravityCompat.getAbsoluteGravity((int)this.expandedTextGravity, (int)(this.isRtl ? 1 : 0));
        switch (expandedAbsGravity & 0x70) {
            case 80: {
                this.expandedDrawY = (float)this.expandedBounds.bottom - expandedTextHeight + this.textPaint.descent();
                break;
            }
            case 48: {
                this.expandedDrawY = this.expandedBounds.top;
                break;
            }
            default: {
                float textOffset = expandedTextHeight / 2.0f;
                this.expandedDrawY = (float)this.expandedBounds.centerY() - textOffset;
            }
        }
        switch (expandedAbsGravity & 0x800007) {
            case 1: {
                this.expandedDrawX = (float)this.expandedBounds.centerX() - expandedTextWidth / 2.0f;
                break;
            }
            case 5: {
                this.expandedDrawX = (float)this.expandedBounds.right - expandedTextWidth;
                break;
            }
            default: {
                this.expandedDrawX = this.expandedBounds.left;
            }
        }
        this.clearTexture();
        this.setInterpolatedTextSize(this.expandedFraction);
    }

    private float measureTextWidth(TextPaint textPaint, CharSequence textToDraw) {
        return textPaint.measureText(textToDraw, 0, textToDraw.length());
    }

    private void interpolateBounds(float fraction) {
        if (this.fadeModeEnabled) {
            this.currentBounds.set(fraction < this.fadeModeThresholdFraction ? this.expandedBounds : this.collapsedBounds);
        } else {
            this.currentBounds.left = CollapsingTextHelper.lerp(this.expandedBounds.left, this.collapsedBounds.left, fraction, this.positionInterpolator);
            this.currentBounds.top = CollapsingTextHelper.lerp(this.expandedDrawY, this.collapsedDrawY, fraction, this.positionInterpolator);
            this.currentBounds.right = CollapsingTextHelper.lerp(this.expandedBounds.right, this.collapsedBounds.right, fraction, this.positionInterpolator);
            this.currentBounds.bottom = CollapsingTextHelper.lerp(this.expandedBounds.bottom, this.collapsedBounds.bottom, fraction, this.positionInterpolator);
        }
    }

    private void setCollapsedTextBlend(float blend) {
        this.collapsedTextBlend = blend;
        ViewCompat.postInvalidateOnAnimation((View)this.view);
    }

    private void setExpandedTextBlend(float blend) {
        this.expandedTextBlend = blend;
        ViewCompat.postInvalidateOnAnimation((View)this.view);
    }

    public void draw(@NonNull Canvas canvas) {
        int saveCount = canvas.save();
        if (this.textToDraw != null && this.currentBounds.width() > 0.0f && this.currentBounds.height() > 0.0f) {
            boolean drawTexture;
            this.textPaint.setTextSize(this.currentTextSize);
            float x = this.currentDrawX;
            float y = this.currentDrawY;
            boolean bl = drawTexture = this.useTexture && this.expandedTitleTexture != null;
            if (this.scale != 1.0f && !this.fadeModeEnabled) {
                canvas.scale(this.scale, this.scale, x, y);
            }
            if (drawTexture) {
                canvas.drawBitmap(this.expandedTitleTexture, x, y, this.texturePaint);
                canvas.restoreToCount(saveCount);
                return;
            }
            if (this.shouldDrawMultiline() && (!this.fadeModeEnabled || this.expandedFraction > this.fadeModeThresholdFraction)) {
                this.drawMultilineTransition(canvas, this.currentDrawX - (float)this.textLayout.getLineStart(0), y);
            } else {
                canvas.translate(x, y);
                this.textLayout.draw(canvas);
            }
            canvas.restoreToCount(saveCount);
        }
    }

    private boolean shouldDrawMultiline() {
        return this.maxLines > 1 && (!this.isRtl || this.fadeModeEnabled) && !this.useTexture;
    }

    private void drawMultilineTransition(@NonNull Canvas canvas, float currentExpandedX, float y) {
        int originalAlpha = this.textPaint.getAlpha();
        canvas.translate(currentExpandedX, y);
        if (!this.fadeModeEnabled) {
            this.textPaint.setAlpha((int)(this.expandedTextBlend * (float)originalAlpha));
            if (Build.VERSION.SDK_INT >= 31) {
                this.textPaint.setShadowLayer(this.currentShadowRadius, this.currentShadowDx, this.currentShadowDy, MaterialColors.compositeARGBWithAlpha(this.currentShadowColor, this.textPaint.getAlpha()));
            }
            this.textLayout.draw(canvas);
        }
        if (!this.fadeModeEnabled) {
            this.textPaint.setAlpha((int)(this.collapsedTextBlend * (float)originalAlpha));
        }
        if (Build.VERSION.SDK_INT >= 31) {
            this.textPaint.setShadowLayer(this.currentShadowRadius, this.currentShadowDx, this.currentShadowDy, MaterialColors.compositeARGBWithAlpha(this.currentShadowColor, this.textPaint.getAlpha()));
        }
        int lineBaseline = this.textLayout.getLineBaseline(0);
        canvas.drawText(this.textToDrawCollapsed, 0, this.textToDrawCollapsed.length(), 0.0f, (float)lineBaseline, (Paint)this.textPaint);
        if (Build.VERSION.SDK_INT >= 31) {
            this.textPaint.setShadowLayer(this.currentShadowRadius, this.currentShadowDx, this.currentShadowDy, this.currentShadowColor);
        }
        if (!this.fadeModeEnabled) {
            String tmp = this.textToDrawCollapsed.toString().trim();
            if (tmp.endsWith(ELLIPSIS_NORMAL)) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            this.textPaint.setAlpha(originalAlpha);
            canvas.drawText(tmp, 0, Math.min(this.textLayout.getLineEnd(0), tmp.length()), 0.0f, (float)lineBaseline, (Paint)this.textPaint);
        }
    }

    private boolean calculateIsRtl(@NonNull CharSequence text) {
        boolean defaultIsRtl = this.isDefaultIsRtl();
        return this.isRtlTextDirectionHeuristicsEnabled ? this.isTextDirectionHeuristicsIsRtl(text, defaultIsRtl) : defaultIsRtl;
    }

    private boolean isDefaultIsRtl() {
        return ViewCompat.getLayoutDirection((View)this.view) == 1;
    }

    private boolean isTextDirectionHeuristicsIsRtl(@NonNull CharSequence text, boolean defaultIsRtl) {
        return (defaultIsRtl ? TextDirectionHeuristicsCompat.FIRSTSTRONG_RTL : TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR).isRtl(text, 0, text.length());
    }

    private void setInterpolatedTextSize(float fraction) {
        this.calculateUsingTextSize(fraction);
        boolean bl = this.useTexture = USE_SCALING_TEXTURE && this.scale != 1.0f;
        if (this.useTexture) {
            this.ensureExpandedTexture();
        }
        ViewCompat.postInvalidateOnAnimation((View)this.view);
    }

    private void calculateUsingTextSize(float fraction) {
        this.calculateUsingTextSize(fraction, false);
    }

    private void calculateUsingTextSize(float fraction, boolean forceRecalculate) {
        boolean updateDrawText;
        float availableWidth;
        Typeface newTypeface;
        float newLetterSpacing;
        float newTextSize;
        if (this.text == null) {
            return;
        }
        float collapsedWidth = this.collapsedBounds.width();
        float expandedWidth = this.expandedBounds.width();
        if (CollapsingTextHelper.isClose(fraction, 1.0f)) {
            newTextSize = this.collapsedTextSize;
            newLetterSpacing = this.collapsedLetterSpacing;
            this.scale = 1.0f;
            newTypeface = this.collapsedTypeface;
            availableWidth = collapsedWidth;
        } else {
            newTextSize = this.expandedTextSize;
            newLetterSpacing = this.expandedLetterSpacing;
            newTypeface = this.expandedTypeface;
            this.scale = CollapsingTextHelper.isClose(fraction, 0.0f) ? 1.0f : CollapsingTextHelper.lerp(this.expandedTextSize, this.collapsedTextSize, fraction, this.textSizeInterpolator) / this.expandedTextSize;
            float textSizeRatio = this.collapsedTextSize / this.expandedTextSize;
            float scaledDownWidth = expandedWidth * textSizeRatio;
            if (forceRecalculate || this.fadeModeEnabled) {
                availableWidth = expandedWidth;
            } else {
                float f = availableWidth = scaledDownWidth > collapsedWidth ? Math.min(collapsedWidth / textSizeRatio, expandedWidth) : expandedWidth;
            }
        }
        if (availableWidth > 0.0f) {
            boolean textSizeChanged = this.currentTextSize != newTextSize;
            boolean letterSpacingChanged = this.currentLetterSpacing != newLetterSpacing;
            boolean typefaceChanged = this.currentTypeface != newTypeface;
            boolean availableWidthChanged = this.textLayout != null && availableWidth != (float)this.textLayout.getWidth();
            updateDrawText = textSizeChanged || letterSpacingChanged || availableWidthChanged || typefaceChanged || this.boundsChanged;
            this.currentTextSize = newTextSize;
            this.currentLetterSpacing = newLetterSpacing;
            this.currentTypeface = newTypeface;
            this.boundsChanged = false;
            this.textPaint.setLinearText(this.scale != 1.0f);
        } else {
            updateDrawText = false;
        }
        if (this.textToDraw == null || updateDrawText) {
            this.textPaint.setTextSize(this.currentTextSize);
            this.textPaint.setTypeface(this.currentTypeface);
            if (Build.VERSION.SDK_INT >= 21) {
                this.textPaint.setLetterSpacing(this.currentLetterSpacing);
            }
            this.isRtl = this.calculateIsRtl(this.text);
            this.textLayout = this.createStaticLayout(this.shouldDrawMultiline() ? this.maxLines : 1, availableWidth, this.isRtl);
            this.textToDraw = this.textLayout.getText();
        }
    }

    private StaticLayout createStaticLayout(int maxLines, float availableWidth, boolean isRtl) {
        StaticLayout textLayout = null;
        try {
            Layout.Alignment textAlignment = maxLines == 1 ? Layout.Alignment.ALIGN_NORMAL : this.getMultilineTextLayoutAlignment();
            textLayout = StaticLayoutBuilderCompat.obtain(this.text, this.textPaint, (int)availableWidth).setEllipsize(this.titleTextEllipsize).setIsRtl(isRtl).setAlignment(textAlignment).setIncludePad(false).setMaxLines(maxLines).setLineSpacing(this.lineSpacingAdd, this.lineSpacingMultiplier).setHyphenationFrequency(this.hyphenationFrequency).setStaticLayoutBuilderConfigurer(this.staticLayoutBuilderConfigurer).build();
        }
        catch (StaticLayoutBuilderCompat.StaticLayoutBuilderCompatException e) {
            Log.e((String)TAG, (String)e.getCause().getMessage(), (Throwable)e);
        }
        return (StaticLayout)Preconditions.checkNotNull(textLayout);
    }

    private Layout.Alignment getMultilineTextLayoutAlignment() {
        int absoluteGravity = GravityCompat.getAbsoluteGravity((int)this.expandedTextGravity, (int)(this.isRtl ? 1 : 0));
        switch (absoluteGravity & 7) {
            case 1: {
                return Layout.Alignment.ALIGN_CENTER;
            }
            case 5: {
                return this.isRtl ? Layout.Alignment.ALIGN_NORMAL : Layout.Alignment.ALIGN_OPPOSITE;
            }
        }
        return this.isRtl ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_NORMAL;
    }

    private void ensureExpandedTexture() {
        if (this.expandedTitleTexture != null || this.expandedBounds.isEmpty() || TextUtils.isEmpty((CharSequence)this.textToDraw)) {
            return;
        }
        this.calculateOffsets(0.0f);
        int width = this.textLayout.getWidth();
        int height = this.textLayout.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        this.expandedTitleTexture = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(this.expandedTitleTexture);
        this.textLayout.draw(c);
        if (this.texturePaint == null) {
            this.texturePaint = new Paint(3);
        }
    }

    public void recalculate() {
        this.recalculate(false);
    }

    public void recalculate(boolean forceRecalculate) {
        if (this.view.getHeight() > 0 && this.view.getWidth() > 0 || forceRecalculate) {
            this.calculateBaseOffsets(forceRecalculate);
            this.calculateCurrentOffsets();
        }
    }

    public void setText(@Nullable CharSequence text) {
        if (text == null || !TextUtils.equals((CharSequence)this.text, (CharSequence)text)) {
            this.text = text;
            this.textToDraw = null;
            this.clearTexture();
            this.recalculate();
        }
    }

    @Nullable
    public CharSequence getText() {
        return this.text;
    }

    private void clearTexture() {
        if (this.expandedTitleTexture != null) {
            this.expandedTitleTexture.recycle();
            this.expandedTitleTexture = null;
        }
    }

    public void setMaxLines(int maxLines) {
        if (maxLines != this.maxLines) {
            this.maxLines = maxLines;
            this.clearTexture();
            this.recalculate();
        }
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public int getLineCount() {
        return this.textLayout != null ? this.textLayout.getLineCount() : 0;
    }

    public int getExpandedLineCount() {
        return this.expandedLineCount;
    }

    @RequiresApi(value=23)
    public void setLineSpacingAdd(float spacingAdd) {
        this.lineSpacingAdd = spacingAdd;
    }

    @RequiresApi(value=23)
    public float getLineSpacingAdd() {
        return this.textLayout.getSpacingAdd();
    }

    @RequiresApi(value=23)
    public void setLineSpacingMultiplier(@FloatRange(from=0.0) float spacingMultiplier) {
        this.lineSpacingMultiplier = spacingMultiplier;
    }

    @RequiresApi(value=23)
    public float getLineSpacingMultiplier() {
        return this.textLayout.getSpacingMultiplier();
    }

    @RequiresApi(value=23)
    public void setHyphenationFrequency(int hyphenationFrequency) {
        this.hyphenationFrequency = hyphenationFrequency;
    }

    @RequiresApi(value=23)
    public int getHyphenationFrequency() {
        return this.hyphenationFrequency;
    }

    @RequiresApi(value=23)
    public void setStaticLayoutBuilderConfigurer(@Nullable StaticLayoutBuilderConfigurer staticLayoutBuilderConfigurer) {
        if (this.staticLayoutBuilderConfigurer != staticLayoutBuilderConfigurer) {
            this.staticLayoutBuilderConfigurer = staticLayoutBuilderConfigurer;
            this.recalculate(true);
        }
    }

    private static boolean isClose(float value, float targetValue) {
        return Math.abs(value - targetValue) < 1.0E-5f;
    }

    public ColorStateList getExpandedTextColor() {
        return this.expandedTextColor;
    }

    public ColorStateList getCollapsedTextColor() {
        return this.collapsedTextColor;
    }

    @ColorInt
    private static int blendARGB(@ColorInt int color1, @ColorInt int color2, @FloatRange(from=0.0, to=1.0) float ratio) {
        float inverseRatio = 1.0f - ratio;
        float a = (float)Color.alpha((int)color1) * inverseRatio + (float)Color.alpha((int)color2) * ratio;
        float r = (float)Color.red((int)color1) * inverseRatio + (float)Color.red((int)color2) * ratio;
        float g = (float)Color.green((int)color1) * inverseRatio + (float)Color.green((int)color2) * ratio;
        float b = (float)Color.blue((int)color1) * inverseRatio + (float)Color.blue((int)color2) * ratio;
        return Color.argb((int)Math.round(a), (int)Math.round(r), (int)Math.round(g), (int)Math.round(b));
    }

    private static float lerp(float startValue, float endValue, float fraction, @Nullable TimeInterpolator interpolator) {
        if (interpolator != null) {
            fraction = interpolator.getInterpolation(fraction);
        }
        return AnimationUtils.lerp(startValue, endValue, fraction);
    }

    private static boolean rectEquals(@NonNull Rect r, int left, int top, int right, int bottom) {
        return r.left == left && r.top == top && r.right == right && r.bottom == bottom;
    }

    static {
        if (DEBUG_DRAW_PAINT != null) {
            DEBUG_DRAW_PAINT.setAntiAlias(true);
            DEBUG_DRAW_PAINT.setColor(-65281);
        }
    }
}

