/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.util.Collection;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MultiViewUpdateListener
implements ValueAnimator.AnimatorUpdateListener {
    private final Listener listener;
    private final View[] views;

    @SuppressLint(value={"LambdaLast"})
    public MultiViewUpdateListener(@NonNull Listener listener, View ... views) {
        this.listener = listener;
        this.views = views;
    }

    @SuppressLint(value={"LambdaLast"})
    public MultiViewUpdateListener(@NonNull Listener listener, @NonNull Collection<View> views) {
        this.listener = listener;
        this.views = views.toArray(new View[0]);
    }

    public void onAnimationUpdate(@NonNull ValueAnimator valueAnimator) {
        for (View view : this.views) {
            this.listener.onAnimationUpdate(valueAnimator, view);
        }
    }

    @NonNull
    public static MultiViewUpdateListener alphaListener(View ... views) {
        return new MultiViewUpdateListener(MultiViewUpdateListener::setAlpha, views);
    }

    @NonNull
    public static MultiViewUpdateListener alphaListener(@NonNull Collection<View> views) {
        return new MultiViewUpdateListener(MultiViewUpdateListener::setAlpha, views);
    }

    private static void setAlpha(@NonNull ValueAnimator animator2, @NonNull View view) {
        view.setAlpha(((Float)animator2.getAnimatedValue()).floatValue());
    }

    @NonNull
    public static MultiViewUpdateListener scaleListener(View ... views) {
        return new MultiViewUpdateListener(MultiViewUpdateListener::setScale, views);
    }

    @NonNull
    public static MultiViewUpdateListener scaleListener(@NonNull Collection<View> views) {
        return new MultiViewUpdateListener(MultiViewUpdateListener::setScale, views);
    }

    private static void setScale(@NonNull ValueAnimator animator2, @NonNull View view) {
        Float scale = (Float)animator2.getAnimatedValue();
        view.setScaleX(scale.floatValue());
        view.setScaleY(scale.floatValue());
    }

    @NonNull
    public static MultiViewUpdateListener translationXListener(View ... views) {
        return new MultiViewUpdateListener(MultiViewUpdateListener::setTranslationX, views);
    }

    @NonNull
    public static MultiViewUpdateListener translationXListener(@NonNull Collection<View> views) {
        return new MultiViewUpdateListener(MultiViewUpdateListener::setTranslationX, views);
    }

    private static void setTranslationX(@NonNull ValueAnimator animator2, @NonNull View view) {
        view.setTranslationX(((Float)animator2.getAnimatedValue()).floatValue());
    }

    @NonNull
    public static MultiViewUpdateListener translationYListener(View ... views) {
        return new MultiViewUpdateListener(MultiViewUpdateListener::setTranslationY, views);
    }

    @NonNull
    public static MultiViewUpdateListener translationYListener(@NonNull Collection<View> views) {
        return new MultiViewUpdateListener(MultiViewUpdateListener::setTranslationY, views);
    }

    private static void setTranslationY(@NonNull ValueAnimator animator2, @NonNull View view) {
        view.setTranslationY(((Float)animator2.getAnimatedValue()).floatValue());
    }

    static interface Listener {
        public void onAnimationUpdate(@NonNull ValueAnimator var1, @NonNull View var2);
    }
}

