/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.animation.TypeEvaluator;
import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RectEvaluator
implements TypeEvaluator<Rect> {
    private final Rect rect;

    public RectEvaluator(@NonNull Rect rect) {
        this.rect = rect;
    }

    public Rect evaluate(float fraction, @NonNull Rect startValue, @NonNull Rect endValue) {
        int left = startValue.left + (int)((float)(endValue.left - startValue.left) * fraction);
        int top = startValue.top + (int)((float)(endValue.top - startValue.top) * fraction);
        int right = startValue.right + (int)((float)(endValue.right - startValue.right) * fraction);
        int bottom = startValue.bottom + (int)((float)(endValue.bottom - startValue.bottom) * fraction);
        this.rect.set(left, top, right, bottom);
        return this.rect;
    }
}

