/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.animation.TimeInterpolator;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ReversableAnimatedValueInterpolator
implements TimeInterpolator {
    private final TimeInterpolator sourceInterpolator;

    public ReversableAnimatedValueInterpolator(@NonNull TimeInterpolator sourceInterpolator) {
        this.sourceInterpolator = sourceInterpolator;
    }

    @NonNull
    public static TimeInterpolator of(boolean useSourceInterpolator, @NonNull TimeInterpolator sourceInterpolator) {
        if (useSourceInterpolator) {
            return sourceInterpolator;
        }
        return new ReversableAnimatedValueInterpolator(sourceInterpolator);
    }

    public float getInterpolation(float input) {
        return 1.0f - this.sourceInterpolator.getInterpolation(input);
    }
}

