/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import com.google.android.material.R;
import com.google.android.material.drawable.DrawableUtils;
import com.google.android.material.internal.ViewOverlayApi14;
import com.google.android.material.internal.ViewOverlayApi18;
import com.google.android.material.internal.ViewOverlayImpl;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ViewUtils {
    @RequiresApi(value=16)
    public static final int EDGE_TO_EDGE_FLAGS = 768;

    private ViewUtils() {
    }

    public static void showKeyboard(@NonNull View view) {
        ViewUtils.showKeyboard(view, true);
    }

    public static void showKeyboard(@NonNull View view, boolean useWindowInsetsController) {
        WindowInsetsControllerCompat windowController;
        if (useWindowInsetsController && (windowController = ViewCompat.getWindowInsetsController((View)view)) != null) {
            windowController.show(WindowInsetsCompat.Type.ime());
            return;
        }
        ViewUtils.getInputMethodManager(view).showSoftInput(view, 1);
    }

    public static void requestFocusAndShowKeyboard(@NonNull View view) {
        ViewUtils.requestFocusAndShowKeyboard(view, true);
    }

    public static void requestFocusAndShowKeyboard(@NonNull View view, boolean useWindowInsetsController) {
        view.requestFocus();
        view.post(() -> ViewUtils.showKeyboard(view, useWindowInsetsController));
    }

    public static void hideKeyboard(@NonNull View view) {
        ViewUtils.hideKeyboard(view, true);
    }

    public static void hideKeyboard(@NonNull View view, boolean useWindowInsetsController) {
        WindowInsetsControllerCompat windowController;
        if (useWindowInsetsController && (windowController = ViewCompat.getWindowInsetsController((View)view)) != null) {
            windowController.hide(WindowInsetsCompat.Type.ime());
            return;
        }
        InputMethodManager imm = ViewUtils.getInputMethodManager(view);
        if (imm != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    @Nullable
    private static InputMethodManager getInputMethodManager(@NonNull View view) {
        return (InputMethodManager)ContextCompat.getSystemService((Context)view.getContext(), InputMethodManager.class);
    }

    public static void setBoundsFromRect(@NonNull View view, @NonNull Rect rect) {
        view.setLeft(rect.left);
        view.setTop(rect.top);
        view.setRight(rect.right);
        view.setBottom(rect.bottom);
    }

    @NonNull
    public static Rect calculateRectFromBounds(@NonNull View view) {
        return ViewUtils.calculateRectFromBounds(view, 0);
    }

    @NonNull
    public static Rect calculateRectFromBounds(@NonNull View view, int offsetY) {
        return new Rect(view.getLeft(), view.getTop() + offsetY, view.getRight(), view.getBottom() + offsetY);
    }

    @NonNull
    public static Rect calculateOffsetRectFromBounds(@NonNull View view, @NonNull View offsetView) {
        int[] offsetViewAbsolutePosition = new int[2];
        offsetView.getLocationOnScreen(offsetViewAbsolutePosition);
        int offsetViewAbsoluteLeft = offsetViewAbsolutePosition[0];
        int offsetViewAbsoluteTop = offsetViewAbsolutePosition[1];
        int[] viewAbsolutePosition = new int[2];
        view.getLocationOnScreen(viewAbsolutePosition);
        int viewAbsoluteLeft = viewAbsolutePosition[0];
        int viewAbsoluteTop = viewAbsolutePosition[1];
        int fromLeft = offsetViewAbsoluteLeft - viewAbsoluteLeft;
        int fromTop = offsetViewAbsoluteTop - viewAbsoluteTop;
        int fromRight = fromLeft + offsetView.getWidth();
        int fromBottom = fromTop + offsetView.getHeight();
        return new Rect(fromLeft, fromTop, fromRight, fromBottom);
    }

    @NonNull
    public static List<View> getChildren(@Nullable View view) {
        ArrayList<View> children = new ArrayList<View>();
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                children.add(viewGroup.getChildAt(i));
            }
        }
        return children;
    }

    public static PorterDuff.Mode parseTintMode(int value, PorterDuff.Mode defaultMode) {
        switch (value) {
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 9: {
                return PorterDuff.Mode.SRC_ATOP;
            }
            case 14: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 15: {
                return PorterDuff.Mode.SCREEN;
            }
            case 16: {
                return PorterDuff.Mode.ADD;
            }
        }
        return defaultMode;
    }

    public static boolean isLayoutRtl(View view) {
        return ViewCompat.getLayoutDirection((View)view) == 1;
    }

    public static float dpToPx(@NonNull Context context, @Dimension(unit=0) int dp) {
        Resources r = context.getResources();
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics());
    }

    public static void doOnApplyWindowInsets(@NonNull View view, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        ViewUtils.doOnApplyWindowInsets(view, attrs, defStyleAttr, defStyleRes, null);
    }

    public static void doOnApplyWindowInsets(@NonNull View view, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes, final @Nullable OnApplyWindowInsetsListener listener) {
        TypedArray a = view.getContext().obtainStyledAttributes(attrs, R.styleable.Insets, defStyleAttr, defStyleRes);
        final boolean paddingBottomSystemWindowInsets = a.getBoolean(R.styleable.Insets_paddingBottomSystemWindowInsets, false);
        final boolean paddingLeftSystemWindowInsets = a.getBoolean(R.styleable.Insets_paddingLeftSystemWindowInsets, false);
        final boolean paddingRightSystemWindowInsets = a.getBoolean(R.styleable.Insets_paddingRightSystemWindowInsets, false);
        a.recycle();
        ViewUtils.doOnApplyWindowInsets(view, new OnApplyWindowInsetsListener(){

            @Override
            @NonNull
            public WindowInsetsCompat onApplyWindowInsets(View view, @NonNull WindowInsetsCompat insets, @NonNull RelativePadding initialPadding) {
                if (paddingBottomSystemWindowInsets) {
                    initialPadding.bottom += insets.getSystemWindowInsetBottom();
                }
                boolean isRtl = ViewUtils.isLayoutRtl(view);
                if (paddingLeftSystemWindowInsets) {
                    if (isRtl) {
                        initialPadding.end += insets.getSystemWindowInsetLeft();
                    } else {
                        initialPadding.start += insets.getSystemWindowInsetLeft();
                    }
                }
                if (paddingRightSystemWindowInsets) {
                    if (isRtl) {
                        initialPadding.start += insets.getSystemWindowInsetRight();
                    } else {
                        initialPadding.end += insets.getSystemWindowInsetRight();
                    }
                }
                initialPadding.applyToView(view);
                return listener != null ? listener.onApplyWindowInsets(view, insets, initialPadding) : insets;
            }
        });
    }

    public static void doOnApplyWindowInsets(@NonNull View view, final @NonNull OnApplyWindowInsetsListener listener) {
        final RelativePadding initialPadding = new RelativePadding(ViewCompat.getPaddingStart((View)view), view.getPaddingTop(), ViewCompat.getPaddingEnd((View)view), view.getPaddingBottom());
        ViewCompat.setOnApplyWindowInsetsListener((View)view, (androidx.core.view.OnApplyWindowInsetsListener)new androidx.core.view.OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat insets) {
                return listener.onApplyWindowInsets(view, insets, new RelativePadding(initialPadding));
            }
        });
        ViewUtils.requestApplyInsetsWhenAttached(view);
    }

    public static void requestApplyInsetsWhenAttached(@NonNull View view) {
        if (ViewCompat.isAttachedToWindow((View)view)) {
            ViewCompat.requestApplyInsets((View)view);
        } else {
            view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(@NonNull View v) {
                    v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewCompat.requestApplyInsets((View)v);
                }

                public void onViewDetachedFromWindow(View v) {
                }
            });
        }
    }

    public static float getParentAbsoluteElevation(@NonNull View view) {
        float absoluteElevation = 0.0f;
        ViewParent viewParent = view.getParent();
        while (viewParent instanceof View) {
            absoluteElevation += ViewCompat.getElevation((View)((View)viewParent));
            viewParent = viewParent.getParent();
        }
        return absoluteElevation;
    }

    @Nullable
    public static ViewOverlayImpl getOverlay(@Nullable View view) {
        if (view == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            return new ViewOverlayApi18(view);
        }
        return ViewOverlayApi14.createFrom(view);
    }

    @Nullable
    public static ViewGroup getContentView(@Nullable View view) {
        if (view == null) {
            return null;
        }
        View rootView = view.getRootView();
        ViewGroup contentView = (ViewGroup)rootView.findViewById(0x1020002);
        if (contentView != null) {
            return contentView;
        }
        if (rootView != view && rootView instanceof ViewGroup) {
            return (ViewGroup)rootView;
        }
        return null;
    }

    @Nullable
    public static ViewOverlayImpl getContentViewOverlay(@NonNull View view) {
        return ViewUtils.getOverlay((View)ViewUtils.getContentView(view));
    }

    public static void addOnGlobalLayoutListener(@Nullable View view, @NonNull ViewTreeObserver.OnGlobalLayoutListener victim) {
        if (view != null) {
            view.getViewTreeObserver().addOnGlobalLayoutListener(victim);
        }
    }

    public static void removeOnGlobalLayoutListener(@Nullable View view, @NonNull ViewTreeObserver.OnGlobalLayoutListener victim) {
        if (view != null) {
            ViewUtils.removeOnGlobalLayoutListener(view.getViewTreeObserver(), victim);
        }
    }

    public static void removeOnGlobalLayoutListener(@NonNull ViewTreeObserver viewTreeObserver, @NonNull ViewTreeObserver.OnGlobalLayoutListener victim) {
        if (Build.VERSION.SDK_INT >= 16) {
            viewTreeObserver.removeOnGlobalLayoutListener(victim);
        } else {
            viewTreeObserver.removeGlobalOnLayoutListener(victim);
        }
    }

    @Nullable
    public static Integer getBackgroundColor(@NonNull View view) {
        ColorStateList backgroundColorStateList = DrawableUtils.getColorStateListOrNull(view.getBackground());
        return backgroundColorStateList != null ? Integer.valueOf(backgroundColorStateList.getDefaultColor()) : null;
    }

    public static class RelativePadding {
        public int start;
        public int top;
        public int end;
        public int bottom;

        public RelativePadding(int start, int top, int end, int bottom) {
            this.start = start;
            this.top = top;
            this.end = end;
            this.bottom = bottom;
        }

        public RelativePadding(@NonNull RelativePadding other) {
            this.start = other.start;
            this.top = other.top;
            this.end = other.end;
            this.bottom = other.bottom;
        }

        public void applyToView(View view) {
            ViewCompat.setPaddingRelative((View)view, (int)this.start, (int)this.top, (int)this.end, (int)this.bottom);
        }
    }

    public static interface OnApplyWindowInsetsListener {
        public WindowInsetsCompat onApplyWindowInsets(View var1, WindowInsetsCompat var2, RelativePadding var3);
    }
}

