/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.motion;

import android.os.Build;
import android.view.View;
import android.window.BackEvent;
import android.window.OnBackAnimationCallback;
import android.window.OnBackInvokedCallback;
import android.window.OnBackInvokedDispatcher;
import androidx.activity.BackEventCompat;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import com.google.android.material.motion.MaterialBackHandler;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MaterialBackOrchestrator {
    @Nullable
    private final BackCallbackDelegate backCallbackDelegate = MaterialBackOrchestrator.createBackCallbackDelegate();
    @NonNull
    private final MaterialBackHandler backHandler;
    @NonNull
    private final View view;

    public <T extends View> MaterialBackOrchestrator(@NonNull T backHandlerView) {
        this((MaterialBackHandler)backHandlerView, backHandlerView);
    }

    public MaterialBackOrchestrator(@NonNull MaterialBackHandler backHandler, @NonNull View view) {
        this.backHandler = backHandler;
        this.view = view;
    }

    public boolean shouldListenForBackCallbacks() {
        return this.backCallbackDelegate != null;
    }

    public void startListeningForBackCallbacksWithPriorityOverlay() {
        this.startListeningForBackCallbacks(true);
    }

    public void startListeningForBackCallbacks() {
        this.startListeningForBackCallbacks(false);
    }

    private void startListeningForBackCallbacks(boolean priorityOverlay) {
        if (this.backCallbackDelegate != null) {
            this.backCallbackDelegate.startListeningForBackCallbacks(this.backHandler, this.view, priorityOverlay);
        }
    }

    public void stopListeningForBackCallbacks() {
        if (this.backCallbackDelegate != null) {
            this.backCallbackDelegate.stopListeningForBackCallbacks(this.view);
        }
    }

    @Nullable
    private static BackCallbackDelegate createBackCallbackDelegate() {
        if (Build.VERSION.SDK_INT >= 34) {
            return new Api34BackCallbackDelegate();
        }
        if (Build.VERSION.SDK_INT >= 33) {
            return new Api33BackCallbackDelegate();
        }
        return null;
    }

    @RequiresApi(value=33)
    private static class Api33BackCallbackDelegate
    implements BackCallbackDelegate {
        @Nullable
        private OnBackInvokedCallback onBackInvokedCallback;

        private Api33BackCallbackDelegate() {
        }

        boolean isListeningForBackCallbacks() {
            return this.onBackInvokedCallback != null;
        }

        @Override
        @DoNotInline
        public void startListeningForBackCallbacks(@NonNull MaterialBackHandler backHandler, @NonNull View view, boolean priorityOverlay) {
            if (this.onBackInvokedCallback != null) {
                return;
            }
            OnBackInvokedDispatcher onBackInvokedDispatcher = view.findOnBackInvokedDispatcher();
            if (onBackInvokedDispatcher == null) {
                return;
            }
            this.onBackInvokedCallback = this.createOnBackInvokedCallback(backHandler);
            int priority = priorityOverlay ? 1000000 : 0;
            onBackInvokedDispatcher.registerOnBackInvokedCallback(priority, this.onBackInvokedCallback);
        }

        @Override
        @DoNotInline
        public void stopListeningForBackCallbacks(@NonNull View view) {
            OnBackInvokedDispatcher onBackInvokedDispatcher = view.findOnBackInvokedDispatcher();
            if (onBackInvokedDispatcher == null) {
                return;
            }
            onBackInvokedDispatcher.unregisterOnBackInvokedCallback(this.onBackInvokedCallback);
            this.onBackInvokedCallback = null;
        }

        OnBackInvokedCallback createOnBackInvokedCallback(@NonNull MaterialBackHandler backHandler) {
            return backHandler::handleBackInvoked;
        }
    }

    @RequiresApi(value=34)
    private static class Api34BackCallbackDelegate
    extends Api33BackCallbackDelegate {
        private Api34BackCallbackDelegate() {
        }

        @Override
        OnBackInvokedCallback createOnBackInvokedCallback(final @NonNull MaterialBackHandler backHandler) {
            return new OnBackAnimationCallback(){

                public void onBackStarted(@NonNull BackEvent backEvent) {
                    if (!this.isListeningForBackCallbacks()) {
                        return;
                    }
                    backHandler.startBackProgress(new BackEventCompat(backEvent));
                }

                public void onBackProgressed(@NonNull BackEvent backEvent) {
                    if (!this.isListeningForBackCallbacks()) {
                        return;
                    }
                    backHandler.updateBackProgress(new BackEventCompat(backEvent));
                }

                public void onBackInvoked() {
                    backHandler.handleBackInvoked();
                }

                public void onBackCancelled() {
                    if (!this.isListeningForBackCallbacks()) {
                        return;
                    }
                    backHandler.cancelBackProgress();
                }
            };
        }
    }

    private static interface BackCallbackDelegate {
        public void startListeningForBackCallbacks(@NonNull MaterialBackHandler var1, @NonNull View var2, boolean var3);

        public void stopListeningForBackCallbacks(@NonNull View var1);
    }
}

