/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.math.MathUtils;
import com.google.android.material.progressindicator.CircularProgressIndicatorSpec;
import com.google.android.material.progressindicator.DrawingDelegate;

final class CircularDrawingDelegate
extends DrawingDelegate<CircularProgressIndicatorSpec> {
    private static final float ROUND_CAP_RAMP_DOWN_THRESHHOLD = 0.01f;
    private float displayedTrackThickness;
    private float displayedCornerRadius;
    private float adjustedRadius;
    private boolean useStrokeCap;
    @FloatRange(from=0.0, to=1.0)
    private float totalTrackLengthFraction;

    CircularDrawingDelegate(@NonNull CircularProgressIndicatorSpec spec) {
        super(spec);
    }

    @Override
    int getPreferredWidth() {
        return this.getSize();
    }

    @Override
    int getPreferredHeight() {
        return this.getSize();
    }

    @Override
    void adjustCanvas(@NonNull Canvas canvas, @NonNull Rect bounds, @FloatRange(from=0.0, to=1.0) float trackThicknessFraction, boolean isShowing, boolean isHiding) {
        float scaleX = (float)bounds.width() / (float)this.getPreferredWidth();
        float scaleY = (float)bounds.height() / (float)this.getPreferredHeight();
        float outerRadiusWithInset = (float)((CircularProgressIndicatorSpec)this.spec).indicatorSize / 2.0f + (float)((CircularProgressIndicatorSpec)this.spec).indicatorInset;
        float scaledOuterRadiusWithInsetX = outerRadiusWithInset * scaleX;
        float scaledOuterRadiusWithInsetY = outerRadiusWithInset * scaleY;
        canvas.translate(scaledOuterRadiusWithInsetX + (float)bounds.left, scaledOuterRadiusWithInsetY + (float)bounds.top);
        canvas.rotate(-90.0f);
        canvas.scale(scaleX, scaleY);
        if (((CircularProgressIndicatorSpec)this.spec).indicatorDirection != 0) {
            canvas.scale(1.0f, -1.0f);
        }
        canvas.clipRect(-outerRadiusWithInset, -outerRadiusWithInset, outerRadiusWithInset, outerRadiusWithInset);
        this.useStrokeCap = ((CircularProgressIndicatorSpec)this.spec).trackThickness / 2 <= ((CircularProgressIndicatorSpec)this.spec).trackCornerRadius;
        this.displayedTrackThickness = (float)((CircularProgressIndicatorSpec)this.spec).trackThickness * trackThicknessFraction;
        this.displayedCornerRadius = (float)Math.min(((CircularProgressIndicatorSpec)this.spec).trackThickness / 2, ((CircularProgressIndicatorSpec)this.spec).trackCornerRadius) * trackThicknessFraction;
        this.adjustedRadius = (float)(((CircularProgressIndicatorSpec)this.spec).indicatorSize - ((CircularProgressIndicatorSpec)this.spec).trackThickness) / 2.0f;
        if (isShowing || isHiding) {
            if (isShowing && ((CircularProgressIndicatorSpec)this.spec).showAnimationBehavior == 2 || isHiding && ((CircularProgressIndicatorSpec)this.spec).hideAnimationBehavior == 1) {
                this.adjustedRadius += (1.0f - trackThicknessFraction) * (float)((CircularProgressIndicatorSpec)this.spec).trackThickness / 2.0f;
            } else if (isShowing && ((CircularProgressIndicatorSpec)this.spec).showAnimationBehavior == 1 || isHiding && ((CircularProgressIndicatorSpec)this.spec).hideAnimationBehavior == 2) {
                this.adjustedRadius -= (1.0f - trackThicknessFraction) * (float)((CircularProgressIndicatorSpec)this.spec).trackThickness / 2.0f;
            }
        }
        this.totalTrackLengthFraction = isHiding && ((CircularProgressIndicatorSpec)this.spec).hideAnimationBehavior == 3 ? trackThicknessFraction : 1.0f;
    }

    @Override
    void fillIndicator(@NonNull Canvas canvas, @NonNull Paint paint, @NonNull DrawingDelegate.ActiveIndicator activeIndicator, @IntRange(from=0L, to=255L) int drawableAlpha) {
        int color2 = MaterialColors.compositeARGBWithAlpha(activeIndicator.color, drawableAlpha);
        this.drawArc(canvas, paint, activeIndicator.startFraction, activeIndicator.endFraction, color2, activeIndicator.gapSize, activeIndicator.gapSize);
    }

    @Override
    void fillTrack(@NonNull Canvas canvas, @NonNull Paint paint, float startFraction, float endFraction, @ColorInt int color2, @IntRange(from=0L, to=255L) int drawableAlpha, int gapSize) {
        color2 = MaterialColors.compositeARGBWithAlpha(color2, drawableAlpha);
        this.drawArc(canvas, paint, startFraction, endFraction, color2, gapSize, gapSize);
    }

    private void drawArc(@NonNull Canvas canvas, @NonNull Paint paint, float startFraction, float endFraction, @ColorInt int paintColor, @Px int startGapSize, @Px int endGapSize) {
        float arcFraction = endFraction >= startFraction ? endFraction - startFraction : 1.0f + endFraction - startFraction;
        startFraction %= 1.0f;
        if (this.totalTrackLengthFraction < 1.0f && startFraction + arcFraction > 1.0f) {
            this.drawArc(canvas, paint, startFraction, 1.0f, paintColor, startGapSize, 0);
            this.drawArc(canvas, paint, 1.0f, startFraction + arcFraction, paintColor, 0, endGapSize);
            return;
        }
        float displayedCornerRadiusInDegree = (float)Math.toDegrees(this.displayedCornerRadius / this.adjustedRadius);
        if (startFraction == 0.0f && arcFraction >= 0.99f) {
            arcFraction += (arcFraction - 0.99f) * (2.0f * displayedCornerRadiusInDegree / 360.0f) / 0.01f;
        }
        startFraction = MathUtils.lerp(1.0f - this.totalTrackLengthFraction, 1.0f, startFraction);
        arcFraction = MathUtils.lerp(0.0f, this.totalTrackLengthFraction, arcFraction);
        float startGapSizeInDegrees = (float)Math.toDegrees((float)startGapSize / this.adjustedRadius);
        float endGapSizeInDegrees = (float)Math.toDegrees((float)endGapSize / this.adjustedRadius);
        float arcDegree = arcFraction * 360.0f - startGapSizeInDegrees - endGapSizeInDegrees;
        float startDegree = startFraction * 360.0f + startGapSizeInDegrees;
        if (arcDegree <= 0.0f) {
            return;
        }
        paint.setAntiAlias(true);
        paint.setColor(paintColor);
        paint.setStrokeWidth(this.displayedTrackThickness);
        if (arcDegree < displayedCornerRadiusInDegree * 2.0f) {
            float shrinkRatio = arcDegree / (displayedCornerRadiusInDegree * 2.0f);
            paint.setStyle(Paint.Style.FILL);
            this.drawRoundedBlock(canvas, paint, startDegree + displayedCornerRadiusInDegree * shrinkRatio, this.displayedCornerRadius * 2.0f, this.displayedTrackThickness, shrinkRatio);
        } else {
            RectF arcBound = new RectF(-this.adjustedRadius, -this.adjustedRadius, this.adjustedRadius, this.adjustedRadius);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeCap(this.useStrokeCap ? Paint.Cap.ROUND : Paint.Cap.BUTT);
            canvas.drawArc(arcBound, startDegree + displayedCornerRadiusInDegree, arcDegree - displayedCornerRadiusInDegree * 2.0f, false, paint);
            if (!this.useStrokeCap && this.displayedCornerRadius > 0.0f) {
                paint.setStyle(Paint.Style.FILL);
                this.drawRoundedBlock(canvas, paint, startDegree + displayedCornerRadiusInDegree, this.displayedCornerRadius * 2.0f, this.displayedTrackThickness);
                this.drawRoundedBlock(canvas, paint, startDegree + arcDegree - displayedCornerRadiusInDegree, this.displayedCornerRadius * 2.0f, this.displayedTrackThickness);
            }
        }
    }

    @Override
    void drawStopIndicator(@NonNull Canvas canvas, @NonNull Paint paint, @ColorInt int color2, @IntRange(from=0L, to=255L) int drawableAlpha) {
    }

    private int getSize() {
        return ((CircularProgressIndicatorSpec)this.spec).indicatorSize + ((CircularProgressIndicatorSpec)this.spec).indicatorInset * 2;
    }

    private void drawRoundedBlock(@NonNull Canvas canvas, @NonNull Paint paint, float positionInDeg, float markWidth, float markHeight) {
        this.drawRoundedBlock(canvas, paint, positionInDeg, markWidth, markHeight, 1.0f);
    }

    private void drawRoundedBlock(@NonNull Canvas canvas, @NonNull Paint paint, float positionInDeg, float markWidth, float markHeight, float scale) {
        markHeight = (int)Math.min(markHeight, this.displayedTrackThickness);
        float markCornerSize = markHeight * this.displayedCornerRadius / this.displayedTrackThickness;
        markCornerSize = Math.min(markWidth / 2.0f, markCornerSize);
        RectF roundedBlock = new RectF(-markHeight / 2.0f, -markWidth / 2.0f, markHeight / 2.0f, markWidth / 2.0f);
        canvas.save();
        canvas.translate((float)((double)this.adjustedRadius * Math.cos(Math.toRadians(positionInDeg))), (float)((double)this.adjustedRadius * Math.sin(Math.toRadians(positionInDeg))));
        canvas.rotate(positionInDeg);
        canvas.scale(scale, scale);
        canvas.drawRoundRect(roundedBlock, markCornerSize, markCornerSize, paint);
        canvas.restore();
    }
}

