/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.core.math.MathUtils;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.CircularDrawingDelegate;
import com.google.android.material.progressindicator.CircularProgressIndicatorSpec;
import com.google.android.material.progressindicator.DrawableWithAnimatedVisibilityChange;
import com.google.android.material.progressindicator.DrawingDelegate;
import com.google.android.material.progressindicator.LinearDrawingDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;

public final class DeterminateDrawable<S extends BaseProgressIndicatorSpec>
extends DrawableWithAnimatedVisibilityChange {
    private static final int MAX_DRAWABLE_LEVEL = 10000;
    private static final float SPRING_FORCE_STIFFNESS = 50.0f;
    static final float GAP_RAMP_DOWN_THRESHOLD = 0.01f;
    private DrawingDelegate<S> drawingDelegate;
    private final SpringForce springForce;
    private final SpringAnimation springAnimation;
    private final DrawingDelegate.ActiveIndicator activeIndicator;
    private boolean skipAnimationOnLevelChange = false;
    private static final FloatPropertyCompat<DeterminateDrawable<?>> INDICATOR_LENGTH_IN_LEVEL = new FloatPropertyCompat<DeterminateDrawable<?>>("indicatorLevel"){

        public float getValue(DeterminateDrawable<?> drawable2) {
            return ((DeterminateDrawable)drawable2).getIndicatorFraction() * 10000.0f;
        }

        public void setValue(DeterminateDrawable<?> drawable2, float value) {
            ((DeterminateDrawable)drawable2).setIndicatorFraction(value / 10000.0f);
        }
    };

    DeterminateDrawable(@NonNull Context context, @NonNull BaseProgressIndicatorSpec baseSpec, @NonNull DrawingDelegate<S> drawingDelegate) {
        super(context, baseSpec);
        this.setDrawingDelegate(drawingDelegate);
        this.activeIndicator = new DrawingDelegate.ActiveIndicator();
        this.springForce = new SpringForce();
        this.springForce.setDampingRatio(1.0f);
        this.springForce.setStiffness(50.0f);
        this.springAnimation = new SpringAnimation((Object)this, INDICATOR_LENGTH_IN_LEVEL);
        this.springAnimation.setSpring(this.springForce);
        this.setGrowFraction(1.0f);
    }

    @NonNull
    public static DeterminateDrawable<LinearProgressIndicatorSpec> createLinearDrawable(@NonNull Context context, @NonNull LinearProgressIndicatorSpec spec) {
        return DeterminateDrawable.createLinearDrawable(context, spec, new LinearDrawingDelegate(spec));
    }

    @NonNull
    static DeterminateDrawable<LinearProgressIndicatorSpec> createLinearDrawable(@NonNull Context context, @NonNull LinearProgressIndicatorSpec spec, @NonNull LinearDrawingDelegate drawingDelegate) {
        return new DeterminateDrawable<LinearProgressIndicatorSpec>(context, spec, drawingDelegate);
    }

    @NonNull
    public static DeterminateDrawable<CircularProgressIndicatorSpec> createCircularDrawable(@NonNull Context context, @NonNull CircularProgressIndicatorSpec spec) {
        return DeterminateDrawable.createCircularDrawable(context, spec, new CircularDrawingDelegate(spec));
    }

    @NonNull
    static DeterminateDrawable<CircularProgressIndicatorSpec> createCircularDrawable(@NonNull Context context, @NonNull CircularProgressIndicatorSpec spec, @NonNull CircularDrawingDelegate drawingDelegate) {
        return new DeterminateDrawable<CircularProgressIndicatorSpec>(context, spec, drawingDelegate);
    }

    public void addSpringAnimationEndListener(@NonNull DynamicAnimation.OnAnimationEndListener listener) {
        this.springAnimation.addEndListener(listener);
    }

    public void removeSpringAnimationEndListener(@NonNull DynamicAnimation.OnAnimationEndListener listener) {
        this.springAnimation.removeEndListener(listener);
    }

    @Override
    boolean setVisibleInternal(boolean visible, boolean restart, boolean animate) {
        boolean changed = super.setVisibleInternal(visible, restart, animate);
        float systemAnimatorDurationScale = this.animatorDurationScaleProvider.getSystemAnimatorDurationScale(this.context.getContentResolver());
        if (systemAnimatorDurationScale == 0.0f) {
            this.skipAnimationOnLevelChange = true;
        } else {
            this.skipAnimationOnLevelChange = false;
            this.springForce.setStiffness(50.0f / systemAnimatorDurationScale);
        }
        return changed;
    }

    public void jumpToCurrentState() {
        this.springAnimation.skipToEnd();
        this.setIndicatorFraction((float)this.getLevel() / 10000.0f);
    }

    protected boolean onLevelChange(int level) {
        if (this.skipAnimationOnLevelChange) {
            this.springAnimation.skipToEnd();
            this.setIndicatorFraction((float)level / 10000.0f);
        } else {
            this.springAnimation.setStartValue(this.getIndicatorFraction() * 10000.0f);
            this.springAnimation.animateToFinalPosition((float)level);
        }
        return true;
    }

    public int getIntrinsicWidth() {
        return this.drawingDelegate.getPreferredWidth();
    }

    public int getIntrinsicHeight() {
        return this.drawingDelegate.getPreferredHeight();
    }

    void setLevelByFraction(float fraction) {
        this.setLevel((int)(10000.0f * fraction));
    }

    public void draw(@NonNull Canvas canvas) {
        Rect clipBounds = new Rect();
        if (this.getBounds().isEmpty() || !this.isVisible() || !canvas.getClipBounds(clipBounds)) {
            return;
        }
        canvas.save();
        this.drawingDelegate.validateSpecAndAdjustCanvas(canvas, this.getBounds(), this.getGrowFraction(), this.isShowing(), this.isHiding());
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
        this.activeIndicator.color = this.baseSpec.indicatorColors[0];
        if (this.baseSpec.indicatorTrackGapSize > 0) {
            int gapSize = this.drawingDelegate instanceof LinearDrawingDelegate ? this.baseSpec.indicatorTrackGapSize : (int)((float)this.baseSpec.indicatorTrackGapSize * MathUtils.clamp((float)this.getIndicatorFraction(), (float)0.0f, (float)0.01f) / 0.01f);
            this.drawingDelegate.fillTrack(canvas, this.paint, this.getIndicatorFraction(), 1.0f, this.baseSpec.trackColor, this.getAlpha(), gapSize);
        } else {
            this.drawingDelegate.fillTrack(canvas, this.paint, 0.0f, 1.0f, this.baseSpec.trackColor, this.getAlpha(), 0);
        }
        this.drawingDelegate.fillIndicator(canvas, this.paint, this.activeIndicator, this.getAlpha());
        this.drawingDelegate.drawStopIndicator(canvas, this.paint, this.baseSpec.indicatorColors[0], this.getAlpha());
        canvas.restore();
    }

    private float getIndicatorFraction() {
        return this.activeIndicator.endFraction;
    }

    private void setIndicatorFraction(float indicatorFraction) {
        this.activeIndicator.endFraction = indicatorFraction;
        this.invalidateSelf();
    }

    @NonNull
    DrawingDelegate<S> getDrawingDelegate() {
        return this.drawingDelegate;
    }

    void setDrawingDelegate(@NonNull DrawingDelegate<S> drawingDelegate) {
        this.drawingDelegate = drawingDelegate;
    }
}

