/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.core.math.MathUtils;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.progressindicator.DrawingDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;

final class LinearDrawingDelegate
extends DrawingDelegate<LinearProgressIndicatorSpec> {
    private float trackLength = 300.0f;
    private float displayedTrackThickness;
    private float displayedCornerRadius;
    private boolean useStrokeCap;
    @FloatRange(from=0.0, to=1.0)
    private float totalTrackLengthFraction;

    LinearDrawingDelegate(@NonNull LinearProgressIndicatorSpec spec) {
        super(spec);
    }

    @Override
    int getPreferredWidth() {
        return -1;
    }

    @Override
    int getPreferredHeight() {
        return ((LinearProgressIndicatorSpec)this.spec).trackThickness;
    }

    @Override
    void adjustCanvas(@NonNull Canvas canvas, @NonNull Rect bounds, @FloatRange(from=0.0, to=1.0) float trackThicknessFraction, boolean isShowing, boolean isHiding) {
        this.trackLength = bounds.width();
        float trackSize = ((LinearProgressIndicatorSpec)this.spec).trackThickness;
        canvas.translate((float)bounds.left + (float)bounds.width() / 2.0f, (float)bounds.top + (float)bounds.height() / 2.0f + Math.max(0.0f, ((float)bounds.height() - trackSize) / 2.0f));
        if (((LinearProgressIndicatorSpec)this.spec).drawHorizontallyInverse) {
            canvas.scale(-1.0f, 1.0f);
        }
        float halfTrackLength = this.trackLength / 2.0f;
        float halfTrackSize = trackSize / 2.0f;
        canvas.clipRect(-halfTrackLength, -halfTrackSize, halfTrackLength, halfTrackSize);
        this.useStrokeCap = ((LinearProgressIndicatorSpec)this.spec).trackThickness / 2 == ((LinearProgressIndicatorSpec)this.spec).trackCornerRadius;
        this.displayedTrackThickness = (float)((LinearProgressIndicatorSpec)this.spec).trackThickness * trackThicknessFraction;
        this.displayedCornerRadius = (float)Math.min(((LinearProgressIndicatorSpec)this.spec).trackThickness / 2, ((LinearProgressIndicatorSpec)this.spec).trackCornerRadius) * trackThicknessFraction;
        if (isShowing || isHiding) {
            if (isShowing && ((LinearProgressIndicatorSpec)this.spec).showAnimationBehavior == 2 || isHiding && ((LinearProgressIndicatorSpec)this.spec).hideAnimationBehavior == 1) {
                canvas.scale(1.0f, -1.0f);
            }
            if (isShowing || isHiding && ((LinearProgressIndicatorSpec)this.spec).hideAnimationBehavior != 3) {
                canvas.translate(0.0f, (float)((LinearProgressIndicatorSpec)this.spec).trackThickness * (1.0f - trackThicknessFraction) / 2.0f);
            }
        }
        this.totalTrackLengthFraction = isHiding && ((LinearProgressIndicatorSpec)this.spec).hideAnimationBehavior == 3 ? trackThicknessFraction : 1.0f;
    }

    @Override
    void fillIndicator(@NonNull Canvas canvas, @NonNull Paint paint, @NonNull DrawingDelegate.ActiveIndicator activeIndicator, int drawableAlpha) {
        int color2 = MaterialColors.compositeARGBWithAlpha(activeIndicator.color, drawableAlpha);
        this.drawLine(canvas, paint, activeIndicator.startFraction, activeIndicator.endFraction, color2, activeIndicator.gapSize, activeIndicator.gapSize);
    }

    @Override
    void fillTrack(@NonNull Canvas canvas, @NonNull Paint paint, float startFraction, float endFraction, int color2, int drawableAlpha, @Px int gapSize) {
        color2 = MaterialColors.compositeARGBWithAlpha(color2, drawableAlpha);
        this.drawLine(canvas, paint, startFraction, endFraction, color2, gapSize, gapSize);
    }

    private void drawLine(@NonNull Canvas canvas, @NonNull Paint paint, float startFraction, float endFraction, @ColorInt int paintColor, @Px int startGapSize, @Px int endGapSize) {
        startFraction = MathUtils.clamp((float)startFraction, (float)0.0f, (float)1.0f);
        endFraction = MathUtils.clamp((float)endFraction, (float)0.0f, (float)1.0f);
        startFraction = com.google.android.material.math.MathUtils.lerp(1.0f - this.totalTrackLengthFraction, 1.0f, startFraction);
        endFraction = com.google.android.material.math.MathUtils.lerp(1.0f - this.totalTrackLengthFraction, 1.0f, endFraction);
        startGapSize = (int)((float)startGapSize * MathUtils.clamp((float)startFraction, (float)0.0f, (float)0.01f) / 0.01f);
        endGapSize = (int)((float)endGapSize * (1.0f - MathUtils.clamp((float)endFraction, (float)0.99f, (float)1.0f)) / 0.01f);
        int startPx = (int)(startFraction * this.trackLength + (float)startGapSize);
        int endPx = (int)(endFraction * this.trackLength - (float)endGapSize);
        float originX = -this.trackLength / 2.0f;
        if (startPx <= endPx) {
            float startBlockCenterX = (float)startPx + this.displayedCornerRadius;
            float endBlockCenterX = (float)endPx - this.displayedCornerRadius;
            float blockWidth = this.displayedCornerRadius * 2.0f;
            paint.setColor(paintColor);
            paint.setAntiAlias(true);
            paint.setStrokeWidth(this.displayedTrackThickness);
            if (startBlockCenterX >= endBlockCenterX) {
                this.drawRoundedBlock(canvas, paint, new PointF(startBlockCenterX + originX, 0.0f), new PointF(endBlockCenterX + originX, 0.0f), blockWidth, this.displayedTrackThickness);
            } else {
                paint.setStyle(Paint.Style.STROKE);
                paint.setStrokeCap(this.useStrokeCap ? Paint.Cap.ROUND : Paint.Cap.BUTT);
                canvas.drawLine(startBlockCenterX + originX, 0.0f, endBlockCenterX + originX, 0.0f, paint);
                if (!this.useStrokeCap && this.displayedCornerRadius > 0.0f) {
                    paint.setStyle(Paint.Style.FILL);
                    if (startBlockCenterX > 0.0f) {
                        this.drawRoundedBlock(canvas, paint, new PointF(startBlockCenterX + originX, 0.0f), blockWidth, this.displayedTrackThickness);
                    }
                    if (endBlockCenterX < this.trackLength) {
                        this.drawRoundedBlock(canvas, paint, new PointF(endBlockCenterX + originX, 0.0f), blockWidth, this.displayedTrackThickness);
                    }
                }
            }
        }
    }

    @Override
    void drawStopIndicator(@NonNull Canvas canvas, @NonNull Paint paint, @ColorInt int color2, @IntRange(from=0L, to=255L) int drawableAlpha) {
        int paintColor = MaterialColors.compositeARGBWithAlpha(color2, drawableAlpha);
        if (((LinearProgressIndicatorSpec)this.spec).trackStopIndicatorSize > 0 && paintColor != 0) {
            paint.setStyle(Paint.Style.FILL);
            paint.setColor(paintColor);
            this.drawRoundedBlock(canvas, paint, new PointF(this.trackLength / 2.0f - this.displayedTrackThickness / 2.0f, 0.0f), ((LinearProgressIndicatorSpec)this.spec).trackStopIndicatorSize, ((LinearProgressIndicatorSpec)this.spec).trackStopIndicatorSize);
        }
    }

    private void drawRoundedBlock(@NonNull Canvas canvas, @NonNull Paint paint, @NonNull PointF center, float markWidth, float markHeight) {
        this.drawRoundedBlock(canvas, paint, center, null, markWidth, markHeight);
    }

    private void drawRoundedBlock(@NonNull Canvas canvas, @NonNull Paint paint, @NonNull PointF drawCenter, @Nullable PointF clipCenter, float markWidth, float markHeight) {
        markHeight = Math.min(markHeight, this.displayedTrackThickness);
        float markCornerSize = markHeight * this.displayedCornerRadius / this.displayedTrackThickness;
        markCornerSize = Math.min(markWidth / 2.0f, markCornerSize);
        RectF roundedBlock = new RectF(-markWidth / 2.0f, -markHeight / 2.0f, markWidth / 2.0f, markHeight / 2.0f);
        paint.setStyle(Paint.Style.FILL);
        canvas.save();
        if (clipCenter != null) {
            canvas.translate(clipCenter.x, clipCenter.y);
            Path clipPath = new Path();
            clipPath.addRoundRect(roundedBlock, markCornerSize, markCornerSize, Path.Direction.CCW);
            canvas.clipPath(clipPath);
            canvas.translate(-clipCenter.x, -clipCenter.y);
        }
        canvas.translate(drawCenter.x, drawCenter.y);
        canvas.drawRoundRect(roundedBlock, markCornerSize, markCornerSize, paint);
        canvas.restore();
    }
}

