/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.resources;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Typeface;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.math.MathUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TypefaceUtils {
    private TypefaceUtils() {
    }

    @Nullable
    public static Typeface maybeCopyWithFontWeightAdjustment(@NonNull Context context, @NonNull Typeface typeface) {
        return TypefaceUtils.maybeCopyWithFontWeightAdjustment(context.getResources().getConfiguration(), typeface);
    }

    @Nullable
    public static Typeface maybeCopyWithFontWeightAdjustment(@NonNull Configuration configuration, @NonNull Typeface typeface) {
        if (Build.VERSION.SDK_INT >= 31 && configuration.fontWeightAdjustment != Integer.MAX_VALUE && configuration.fontWeightAdjustment != 0 && typeface != null) {
            int adjustedWeight = MathUtils.clamp((int)(typeface.getWeight() + configuration.fontWeightAdjustment), (int)1, (int)1000);
            return Typeface.create((Typeface)typeface, (int)adjustedWeight, (boolean)typeface.isItalic());
        }
        return null;
    }
}

