/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.search;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.ActionMenuView;
import androidx.core.view.ViewCompat;
import com.google.android.material.animation.AnimatableView;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.internal.ExpandCollapseAnimationHelper;
import com.google.android.material.internal.MultiViewUpdateListener;
import com.google.android.material.internal.ToolbarUtils;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.search.SearchBar;
import com.google.android.material.shape.MaterialShapeDrawable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class SearchBarAnimationHelper {
    private static final long ON_LOAD_ANIM_CENTER_VIEW_DEFAULT_FADE_DURATION_MS = 250L;
    private static final long ON_LOAD_ANIM_CENTER_VIEW_DEFAULT_FADE_IN_START_DELAY_MS = 500L;
    private static final long ON_LOAD_ANIM_CENTER_VIEW_DEFAULT_FADE_OUT_START_DELAY_MS = 750L;
    private static final long ON_LOAD_ANIM_SECONDARY_DURATION_MS = 250L;
    private static final long ON_LOAD_ANIM_SECONDARY_START_DELAY_MS = 250L;
    private static final long EXPAND_DURATION_MS = 300L;
    private static final long EXPAND_FADE_OUT_CHILDREN_DURATION_MS = 75L;
    private static final long COLLAPSE_DURATION_MS = 250L;
    private static final long COLLAPSE_FADE_IN_CHILDREN_DURATION_MS = 100L;
    private final Set<SearchBar.OnLoadAnimationCallback> onLoadAnimationCallbacks = new LinkedHashSet<SearchBar.OnLoadAnimationCallback>();
    private final Set<AnimatorListenerAdapter> expandAnimationListeners = new LinkedHashSet<AnimatorListenerAdapter>();
    private final Set<AnimatorListenerAdapter> collapseAnimationListeners = new LinkedHashSet<AnimatorListenerAdapter>();
    @Nullable
    private Animator secondaryViewAnimator;
    @Nullable
    private Animator defaultCenterViewAnimator;
    private boolean expanding;
    private boolean collapsing;
    private boolean onLoadAnimationFadeInEnabled = true;
    private Animator runningExpandOrCollapseAnimator = null;

    SearchBarAnimationHelper() {
    }

    void startOnLoadAnimation(SearchBar searchBar) {
        this.dispatchOnLoadAnimation(SearchBar.OnLoadAnimationCallback::onAnimationStart);
        TextView textView = searchBar.getTextView();
        final View centerView = searchBar.getCenterView();
        View secondaryActionMenuItemView = ToolbarUtils.getSecondaryActionMenuItemView(searchBar);
        final Animator secondaryViewAnimator = this.getSecondaryViewAnimator(textView, secondaryActionMenuItemView);
        secondaryViewAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SearchBarAnimationHelper.this.dispatchOnLoadAnimation(SearchBar.OnLoadAnimationCallback::onAnimationEnd);
            }
        });
        this.secondaryViewAnimator = secondaryViewAnimator;
        textView.setAlpha(0.0f);
        if (secondaryActionMenuItemView != null) {
            secondaryActionMenuItemView.setAlpha(0.0f);
        }
        if (centerView instanceof AnimatableView) {
            ((AnimatableView)centerView).startAnimation(() -> ((Animator)secondaryViewAnimator).start());
        } else if (centerView != null) {
            Animator defaultCenterViewAnimator;
            centerView.setAlpha(0.0f);
            centerView.setVisibility(0);
            this.defaultCenterViewAnimator = defaultCenterViewAnimator = this.getDefaultCenterViewAnimator(centerView);
            defaultCenterViewAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    centerView.setVisibility(8);
                    secondaryViewAnimator.start();
                }
            });
            defaultCenterViewAnimator.start();
        } else {
            secondaryViewAnimator.start();
        }
    }

    void stopOnLoadAnimation(SearchBar searchBar) {
        View centerView;
        if (this.secondaryViewAnimator != null) {
            this.secondaryViewAnimator.end();
        }
        if (this.defaultCenterViewAnimator != null) {
            this.defaultCenterViewAnimator.end();
        }
        if ((centerView = searchBar.getCenterView()) instanceof AnimatableView) {
            ((AnimatableView)centerView).stopAnimation();
        }
        if (centerView != null) {
            centerView.setAlpha(0.0f);
        }
    }

    boolean isOnLoadAnimationFadeInEnabled() {
        return this.onLoadAnimationFadeInEnabled;
    }

    void setOnLoadAnimationFadeInEnabled(boolean onLoadAnimationFadeInEnabled) {
        this.onLoadAnimationFadeInEnabled = onLoadAnimationFadeInEnabled;
    }

    void addOnLoadAnimationCallback(SearchBar.OnLoadAnimationCallback onLoadAnimationCallback) {
        this.onLoadAnimationCallbacks.add(onLoadAnimationCallback);
    }

    boolean removeOnLoadAnimationCallback(SearchBar.OnLoadAnimationCallback onLoadAnimationCallback) {
        return this.onLoadAnimationCallbacks.remove(onLoadAnimationCallback);
    }

    private void dispatchOnLoadAnimation(OnLoadAnimationInvocation invocation) {
        for (SearchBar.OnLoadAnimationCallback onLoadAnimationCallback : this.onLoadAnimationCallbacks) {
            invocation.invoke(onLoadAnimationCallback);
        }
    }

    private Animator getDefaultCenterViewAnimator(@Nullable View centerView) {
        ValueAnimator fadeInAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        fadeInAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.alphaListener(centerView));
        fadeInAnimator.setInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        fadeInAnimator.setDuration(this.onLoadAnimationFadeInEnabled ? 250L : 0L);
        fadeInAnimator.setStartDelay(this.onLoadAnimationFadeInEnabled ? 500L : 0L);
        ValueAnimator fadeOutAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        fadeOutAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.alphaListener(centerView));
        fadeOutAnimator.setInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        fadeOutAnimator.setDuration(250L);
        fadeOutAnimator.setStartDelay(750L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playSequentially(new Animator[]{fadeInAnimator, fadeOutAnimator});
        return animatorSet;
    }

    private Animator getSecondaryViewAnimator(TextView textView, @Nullable View secondaryActionMenuItemView) {
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setStartDelay(250L);
        animatorSet.play(this.getTextViewAnimator(textView));
        if (secondaryActionMenuItemView != null) {
            animatorSet.play(this.getSecondaryActionMenuItemAnimator(secondaryActionMenuItemView));
        }
        return animatorSet;
    }

    private Animator getTextViewAnimator(TextView textView) {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.alphaListener(new View[]{textView}));
        animator2.setInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        animator2.setDuration(250L);
        return animator2;
    }

    private Animator getSecondaryActionMenuItemAnimator(@Nullable View secondaryActionMenuItemView) {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.alphaListener(secondaryActionMenuItemView));
        animator2.setInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        animator2.setDuration(250L);
        return animator2;
    }

    void startExpandAnimation(SearchBar searchBar, View expandedView, @Nullable AppBarLayout appBarLayout, boolean skipAnimation) {
        if (this.isCollapsing() && this.runningExpandOrCollapseAnimator != null) {
            this.runningExpandOrCollapseAnimator.cancel();
        }
        this.expanding = true;
        expandedView.setVisibility(4);
        expandedView.post(() -> {
            AnimatorSet fadeAndExpandAnimatorSet = new AnimatorSet();
            Animator fadeOutChildrenAnimator = this.getFadeOutChildrenAnimator(searchBar, expandedView);
            Animator expandAnimator = this.getExpandAnimator(searchBar, expandedView, appBarLayout);
            fadeAndExpandAnimatorSet.playSequentially(new Animator[]{fadeOutChildrenAnimator, expandAnimator});
            fadeAndExpandAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    SearchBarAnimationHelper.this.runningExpandOrCollapseAnimator = null;
                }
            });
            for (AnimatorListenerAdapter listener : this.expandAnimationListeners) {
                fadeAndExpandAnimatorSet.addListener((Animator.AnimatorListener)listener);
            }
            if (skipAnimation) {
                fadeAndExpandAnimatorSet.setDuration(0L);
            }
            fadeAndExpandAnimatorSet.start();
            this.runningExpandOrCollapseAnimator = fadeAndExpandAnimatorSet;
        });
    }

    private Animator getExpandAnimator(final SearchBar searchBar, View expandedView, @Nullable AppBarLayout appBarLayout) {
        return this.getExpandCollapseAnimationHelper(searchBar, expandedView, appBarLayout).setDuration(300L).addListener(new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                searchBar.setVisibility(4);
            }

            public void onAnimationEnd(Animator animation) {
                SearchBarAnimationHelper.this.expanding = false;
            }
        }).getExpandAnimator();
    }

    boolean isExpanding() {
        return this.expanding;
    }

    void addExpandAnimationListener(@NonNull AnimatorListenerAdapter listener) {
        this.expandAnimationListeners.add(listener);
    }

    boolean removeExpandAnimationListener(@NonNull AnimatorListenerAdapter listener) {
        return this.expandAnimationListeners.remove(listener);
    }

    void startCollapseAnimation(SearchBar searchBar, View expandedView, @Nullable AppBarLayout appBarLayout, boolean skipAnimation) {
        if (this.isExpanding() && this.runningExpandOrCollapseAnimator != null) {
            this.runningExpandOrCollapseAnimator.cancel();
        }
        this.collapsing = true;
        AnimatorSet collapseAndFadeAnimatorSet = new AnimatorSet();
        Animator collapseAnimator = this.getCollapseAnimator(searchBar, expandedView, appBarLayout);
        Animator fadeInChildrenAnimator = this.getFadeInChildrenAnimator(searchBar);
        collapseAndFadeAnimatorSet.playSequentially(new Animator[]{collapseAnimator, fadeInChildrenAnimator});
        collapseAndFadeAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SearchBarAnimationHelper.this.runningExpandOrCollapseAnimator = null;
            }
        });
        for (AnimatorListenerAdapter listener : this.collapseAnimationListeners) {
            collapseAndFadeAnimatorSet.addListener((Animator.AnimatorListener)listener);
        }
        if (skipAnimation) {
            collapseAndFadeAnimatorSet.setDuration(0L);
        }
        collapseAndFadeAnimatorSet.start();
        this.runningExpandOrCollapseAnimator = collapseAndFadeAnimatorSet;
    }

    private Animator getCollapseAnimator(final SearchBar searchBar, View expandedView, AppBarLayout appBarLayout) {
        return this.getExpandCollapseAnimationHelper(searchBar, expandedView, appBarLayout).setDuration(250L).addListener(new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                searchBar.stopOnLoadAnimation();
            }

            public void onAnimationEnd(Animator animation) {
                searchBar.setVisibility(0);
                SearchBarAnimationHelper.this.collapsing = false;
            }
        }).getCollapseAnimator();
    }

    boolean isCollapsing() {
        return this.collapsing;
    }

    void addCollapseAnimationListener(@NonNull AnimatorListenerAdapter listener) {
        this.collapseAnimationListeners.add(listener);
    }

    boolean removeCollapseAnimationListener(@NonNull AnimatorListenerAdapter listener) {
        return this.collapseAnimationListeners.remove(listener);
    }

    private ExpandCollapseAnimationHelper getExpandCollapseAnimationHelper(SearchBar searchBar, View expandedView, @Nullable AppBarLayout appBarLayout) {
        return new ExpandCollapseAnimationHelper((View)searchBar, expandedView).setAdditionalUpdateListener(this.getExpandedViewBackgroundUpdateListener(searchBar, expandedView)).setCollapsedViewOffsetY(appBarLayout != null ? appBarLayout.getTop() : 0).addEndAnchoredViews(this.getEndAnchoredViews(expandedView));
    }

    private ValueAnimator.AnimatorUpdateListener getExpandedViewBackgroundUpdateListener(SearchBar searchBar, View expandedView) {
        MaterialShapeDrawable expandedViewBackground = MaterialShapeDrawable.createWithElevationOverlay(expandedView.getContext());
        expandedViewBackground.setCornerSize(searchBar.getCornerSize());
        expandedViewBackground.setElevation(ViewCompat.getElevation((View)searchBar));
        return valueAnimator -> {
            expandedViewBackground.setInterpolation(1.0f - valueAnimator.getAnimatedFraction());
            ViewCompat.setBackground((View)expandedView, (Drawable)expandedViewBackground);
            expandedView.setAlpha(1.0f);
        };
    }

    private Animator getFadeOutChildrenAnimator(SearchBar searchBar, View expandedView) {
        List<View> children = this.getFadeChildren(searchBar);
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        animator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.alphaListener(children));
        animator2.addUpdateListener(animation -> expandedView.setAlpha(0.0f));
        animator2.setDuration(75L);
        animator2.setInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        return animator2;
    }

    private Animator getFadeInChildrenAnimator(SearchBar searchBar) {
        List<View> children = this.getFadeChildren(searchBar);
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)MultiViewUpdateListener.alphaListener(children));
        animator2.setDuration(100L);
        animator2.setInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        return animator2;
    }

    private List<View> getFadeChildren(SearchBar searchBar) {
        List<View> children = ViewUtils.getChildren((View)searchBar);
        if (searchBar.getCenterView() != null) {
            children.remove(searchBar.getCenterView());
        }
        return children;
    }

    private List<View> getEndAnchoredViews(View expandedView) {
        boolean isRtl = ViewUtils.isLayoutRtl(expandedView);
        ArrayList<View> endAnchoredViews = new ArrayList<View>();
        if (expandedView instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)expandedView;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View child = viewGroup.getChildAt(i);
                if ((isRtl || !(child instanceof ActionMenuView)) && (!isRtl || child instanceof ActionMenuView)) continue;
                endAnchoredViews.add(child);
            }
        }
        return endAnchoredViews;
    }

    private static interface OnLoadAnimationInvocation {
        public void invoke(SearchBar.OnLoadAnimationCallback var1);
    }
}

