/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.sidesheet;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.activity.BackEventCompat;
import androidx.annotation.GravityInt;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.math.MathUtils;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityViewCommand;
import androidx.customview.view.AbsSavedState;
import androidx.customview.widget.ViewDragHelper;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.motion.MaterialSideContainerBackHelper;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.sidesheet.LeftSheetDelegate;
import com.google.android.material.sidesheet.RightSheetDelegate;
import com.google.android.material.sidesheet.Sheet;
import com.google.android.material.sidesheet.SheetCallback;
import com.google.android.material.sidesheet.SheetDelegate;
import com.google.android.material.sidesheet.SheetUtils;
import com.google.android.material.sidesheet.SideSheetCallback;
import java.lang.ref.WeakReference;
import java.util.LinkedHashSet;
import java.util.Set;

public class SideSheetBehavior<V extends View>
extends CoordinatorLayout.Behavior<V>
implements Sheet<SideSheetCallback> {
    private static final int DEFAULT_ACCESSIBILITY_PANE_TITLE = R.string.side_sheet_accessibility_pane_title;
    private SheetDelegate sheetDelegate;
    static final int SIGNIFICANT_VEL_THRESHOLD = 500;
    private static final float HIDE_THRESHOLD = 0.5f;
    private static final float HIDE_FRICTION = 0.1f;
    private static final int NO_MAX_SIZE = -1;
    private float maximumVelocity;
    @Nullable
    private MaterialShapeDrawable materialShapeDrawable;
    @Nullable
    private ColorStateList backgroundTint;
    private ShapeAppearanceModel shapeAppearanceModel;
    private final StateSettlingTracker stateSettlingTracker = new StateSettlingTracker();
    private static final int DEF_STYLE_RES = R.style.Widget_Material3_SideSheet;
    private float elevation;
    private boolean draggable = true;
    private int state = 5;
    private int lastStableState = 5;
    @Nullable
    private ViewDragHelper viewDragHelper;
    private boolean ignoreEvents;
    private float hideFriction = 0.1f;
    private int childWidth;
    private int parentWidth;
    private int parentInnerEdge;
    private int innerMargin;
    @Nullable
    private WeakReference<V> viewRef;
    @Nullable
    private WeakReference<View> coplanarSiblingViewRef;
    @IdRes
    private int coplanarSiblingViewId = -1;
    @Nullable
    private VelocityTracker velocityTracker;
    @Nullable
    private MaterialSideContainerBackHelper sideContainerBackHelper;
    private int initialX;
    @NonNull
    private final Set<SideSheetCallback> callbacks = new LinkedHashSet<SideSheetCallback>();
    private final ViewDragHelper.Callback dragCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(@NonNull View child, int pointerId) {
            if (SideSheetBehavior.this.state == 1) {
                return false;
            }
            return SideSheetBehavior.this.viewRef != null && SideSheetBehavior.this.viewRef.get() == child;
        }

        public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
            ViewGroup.MarginLayoutParams layoutParams;
            View coplanarSiblingView = SideSheetBehavior.this.getCoplanarSiblingView();
            if (coplanarSiblingView != null && (layoutParams = (ViewGroup.MarginLayoutParams)coplanarSiblingView.getLayoutParams()) != null) {
                SideSheetBehavior.this.sheetDelegate.updateCoplanarSiblingLayoutParams(layoutParams, changedView.getLeft(), changedView.getRight());
                coplanarSiblingView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            SideSheetBehavior.this.dispatchOnSlide(changedView, left);
        }

        public void onViewDragStateChanged(int state) {
            if (state == 1 && SideSheetBehavior.this.draggable) {
                SideSheetBehavior.this.setStateInternal(1);
            }
        }

        public void onViewReleased(@NonNull View releasedChild, float xVelocity, float yVelocity) {
            int targetState = SideSheetBehavior.this.calculateTargetStateOnViewReleased(releasedChild, xVelocity, yVelocity);
            SideSheetBehavior.this.startSettling(releasedChild, targetState, SideSheetBehavior.this.shouldSkipSmoothAnimation());
        }

        public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
            return child.getTop();
        }

        public int clampViewPositionHorizontal(@NonNull View child, int left, int dx) {
            return MathUtils.clamp((int)left, (int)SideSheetBehavior.this.sheetDelegate.getMinViewPositionHorizontal(), (int)SideSheetBehavior.this.sheetDelegate.getMaxViewPositionHorizontal());
        }

        public int getViewHorizontalDragRange(@NonNull View child) {
            return SideSheetBehavior.this.childWidth + SideSheetBehavior.this.getInnerMargin();
        }
    };

    public SideSheetBehavior() {
    }

    public SideSheetBehavior(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SideSheetBehavior_Layout);
        if (a.hasValue(R.styleable.SideSheetBehavior_Layout_backgroundTint)) {
            this.backgroundTint = MaterialResources.getColorStateList(context, a, R.styleable.SideSheetBehavior_Layout_backgroundTint);
        }
        if (a.hasValue(R.styleable.SideSheetBehavior_Layout_shapeAppearance)) {
            this.shapeAppearanceModel = ShapeAppearanceModel.builder(context, attrs, 0, DEF_STYLE_RES).build();
        }
        if (a.hasValue(R.styleable.SideSheetBehavior_Layout_coplanarSiblingViewId)) {
            this.setCoplanarSiblingViewId(a.getResourceId(R.styleable.SideSheetBehavior_Layout_coplanarSiblingViewId, -1));
        }
        this.createMaterialShapeDrawableIfNeeded(context);
        this.elevation = a.getDimension(R.styleable.SideSheetBehavior_Layout_android_elevation, -1.0f);
        this.setDraggable(a.getBoolean(R.styleable.SideSheetBehavior_Layout_behavior_draggable, true));
        a.recycle();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.maximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    private void setSheetEdge(@NonNull V view, int layoutDirection) {
        CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)view.getLayoutParams();
        int sheetGravity = GravityCompat.getAbsoluteGravity((int)params.gravity, (int)layoutDirection);
        this.setSheetEdge(sheetGravity == 3 ? 1 : 0);
    }

    private void setSheetEdge(int sheetEdge) {
        if (this.sheetDelegate == null || this.sheetDelegate.getSheetEdge() != sheetEdge) {
            if (sheetEdge == 0) {
                this.sheetDelegate = new RightSheetDelegate(this);
                if (this.shapeAppearanceModel != null && !this.hasRightMargin()) {
                    ShapeAppearanceModel.Builder builder = this.shapeAppearanceModel.toBuilder();
                    builder.setTopRightCornerSize(0.0f).setBottomRightCornerSize(0.0f);
                    this.updateMaterialShapeDrawable(builder.build());
                }
                return;
            }
            if (sheetEdge == 1) {
                this.sheetDelegate = new LeftSheetDelegate(this);
                if (this.shapeAppearanceModel != null && !this.hasLeftMargin()) {
                    ShapeAppearanceModel.Builder builder = this.shapeAppearanceModel.toBuilder();
                    builder.setTopLeftCornerSize(0.0f).setBottomLeftCornerSize(0.0f);
                    this.updateMaterialShapeDrawable(builder.build());
                }
                return;
            }
            throw new IllegalArgumentException("Invalid sheet edge position value: " + sheetEdge + ". Must be " + 0 + " or " + 1 + ".");
        }
    }

    @GravityInt
    private int getGravityFromSheetEdge() {
        if (this.sheetDelegate != null) {
            return this.sheetDelegate.getSheetEdge() == 0 ? 5 : 3;
        }
        return 5;
    }

    private boolean hasRightMargin() {
        CoordinatorLayout.LayoutParams layoutParams = this.getViewLayoutParams();
        return layoutParams != null && layoutParams.rightMargin > 0;
    }

    private boolean hasLeftMargin() {
        CoordinatorLayout.LayoutParams layoutParams = this.getViewLayoutParams();
        return layoutParams != null && layoutParams.leftMargin > 0;
    }

    @Nullable
    private CoordinatorLayout.LayoutParams getViewLayoutParams() {
        View view;
        if (this.viewRef != null && (view = (View)this.viewRef.get()) != null && view.getLayoutParams() instanceof CoordinatorLayout.LayoutParams) {
            return (CoordinatorLayout.LayoutParams)view.getLayoutParams();
        }
        return null;
    }

    private void updateMaterialShapeDrawable(@NonNull ShapeAppearanceModel shapeAppearanceModel) {
        if (this.materialShapeDrawable != null) {
            this.materialShapeDrawable.setShapeAppearanceModel(shapeAppearanceModel);
        }
    }

    public void expand() {
        this.setState(3);
    }

    public void hide() {
        this.setState(5);
    }

    @NonNull
    public Parcelable onSaveInstanceState(@NonNull CoordinatorLayout parent, @NonNull V child) {
        return new SavedState(super.onSaveInstanceState(parent, child), this);
    }

    public void onRestoreInstanceState(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull Parcelable state) {
        SavedState ss = (SavedState)state;
        if (ss.getSuperState() != null) {
            super.onRestoreInstanceState(parent, child, ss.getSuperState());
        }
        this.lastStableState = this.state = ss.state == 1 || ss.state == 2 ? 5 : ss.state;
    }

    public void onAttachedToLayoutParams(@NonNull CoordinatorLayout.LayoutParams layoutParams) {
        super.onAttachedToLayoutParams(layoutParams);
        this.viewRef = null;
        this.viewDragHelper = null;
        this.sideContainerBackHelper = null;
    }

    public void onDetachedFromLayoutParams() {
        super.onDetachedFromLayoutParams();
        this.viewRef = null;
        this.viewDragHelper = null;
        this.sideContainerBackHelper = null;
    }

    public boolean onMeasureChild(@NonNull CoordinatorLayout parent, @NonNull V child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = this.getChildMeasureSpec(parentWidthMeasureSpec, parent.getPaddingLeft() + parent.getPaddingRight() + lp.leftMargin + lp.rightMargin + widthUsed, -1, lp.width);
        int childHeightMeasureSpec = this.getChildMeasureSpec(parentHeightMeasureSpec, parent.getPaddingTop() + parent.getPaddingBottom() + lp.topMargin + lp.bottomMargin + heightUsed, -1, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        return true;
    }

    private int getChildMeasureSpec(int parentMeasureSpec, int padding, int maxSize, int childDimension) {
        int result = ViewGroup.getChildMeasureSpec((int)parentMeasureSpec, (int)padding, (int)childDimension);
        if (maxSize == -1) {
            return result;
        }
        int mode = View.MeasureSpec.getMode((int)result);
        int size = View.MeasureSpec.getSize((int)result);
        switch (mode) {
            case 0x40000000: {
                return View.MeasureSpec.makeMeasureSpec((int)Math.min(size, maxSize), (int)0x40000000);
            }
        }
        return View.MeasureSpec.makeMeasureSpec((int)(size == 0 ? maxSize : Math.min(size, maxSize)), (int)Integer.MIN_VALUE);
    }

    public boolean onLayoutChild(@NonNull CoordinatorLayout parent, @NonNull V child, int layoutDirection) {
        if (ViewCompat.getFitsSystemWindows((View)parent) && !ViewCompat.getFitsSystemWindows(child)) {
            child.setFitsSystemWindows(true);
        }
        if (this.viewRef == null) {
            this.viewRef = new WeakReference<V>(child);
            this.sideContainerBackHelper = new MaterialSideContainerBackHelper((View)child);
            if (this.materialShapeDrawable != null) {
                ViewCompat.setBackground(child, (Drawable)this.materialShapeDrawable);
                this.materialShapeDrawable.setElevation(this.elevation == -1.0f ? ViewCompat.getElevation(child) : this.elevation);
            } else if (this.backgroundTint != null) {
                ViewCompat.setBackgroundTintList(child, (ColorStateList)this.backgroundTint);
            }
            this.updateSheetVisibility((View)child);
            this.updateAccessibilityActions();
            if (ViewCompat.getImportantForAccessibility(child) == 0) {
                ViewCompat.setImportantForAccessibility(child, (int)1);
            }
            this.ensureAccessibilityPaneTitleIsSet((View)child);
        }
        this.setSheetEdge(child, layoutDirection);
        if (this.viewDragHelper == null) {
            this.viewDragHelper = ViewDragHelper.create((ViewGroup)parent, (ViewDragHelper.Callback)this.dragCallback);
        }
        int savedOuterEdge = this.sheetDelegate.getOuterEdge(child);
        parent.onLayoutChild(child, layoutDirection);
        this.parentWidth = parent.getWidth();
        this.parentInnerEdge = this.sheetDelegate.getParentInnerEdge(parent);
        this.childWidth = child.getWidth();
        ViewGroup.MarginLayoutParams margins = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        this.innerMargin = margins != null ? this.sheetDelegate.calculateInnerMargin(margins) : 0;
        int currentOffset = this.calculateCurrentOffset(savedOuterEdge, child);
        ViewCompat.offsetLeftAndRight(child, (int)currentOffset);
        this.maybeAssignCoplanarSiblingViewBasedId(parent);
        for (SheetCallback sheetCallback : this.callbacks) {
            if (!(sheetCallback instanceof SideSheetCallback)) continue;
            SideSheetCallback sideSheetCallback = (SideSheetCallback)sheetCallback;
            sideSheetCallback.onLayout((View)child);
        }
        return true;
    }

    private void updateSheetVisibility(@NonNull View sheet) {
        int visibility;
        int n = visibility = this.state == 5 ? 4 : 0;
        if (sheet.getVisibility() != visibility) {
            sheet.setVisibility(visibility);
        }
    }

    private void ensureAccessibilityPaneTitleIsSet(View sheet) {
        if (ViewCompat.getAccessibilityPaneTitle((View)sheet) == null) {
            ViewCompat.setAccessibilityPaneTitle((View)sheet, (CharSequence)sheet.getResources().getString(DEFAULT_ACCESSIBILITY_PANE_TITLE));
        }
    }

    private void maybeAssignCoplanarSiblingViewBasedId(@NonNull CoordinatorLayout parent) {
        View coplanarSiblingView;
        if (this.coplanarSiblingViewRef == null && this.coplanarSiblingViewId != -1 && (coplanarSiblingView = parent.findViewById(this.coplanarSiblingViewId)) != null) {
            this.coplanarSiblingViewRef = new WeakReference<View>(coplanarSiblingView);
        }
    }

    int getChildWidth() {
        return this.childWidth;
    }

    int getParentWidth() {
        return this.parentWidth;
    }

    int getParentInnerEdge() {
        return this.parentInnerEdge;
    }

    int getInnerMargin() {
        return this.innerMargin;
    }

    private int calculateCurrentOffset(int savedOuterEdge, V child) {
        int currentOffset;
        switch (this.state) {
            case 3: {
                currentOffset = 0;
                break;
            }
            case 1: 
            case 2: {
                currentOffset = savedOuterEdge - this.sheetDelegate.getOuterEdge(child);
                break;
            }
            case 5: {
                currentOffset = this.sheetDelegate.getHiddenOffset();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.state);
            }
        }
        return currentOffset;
    }

    public boolean onInterceptTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent event) {
        if (!this.shouldInterceptTouchEvent(child)) {
            this.ignoreEvents = true;
            return false;
        }
        int action = event.getActionMasked();
        if (action == 0) {
            this.resetVelocity();
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        switch (action) {
            case 1: 
            case 3: {
                if (!this.ignoreEvents) break;
                this.ignoreEvents = false;
                return false;
            }
            case 0: {
                this.initialX = (int)event.getX();
                break;
            }
        }
        return !this.ignoreEvents && this.viewDragHelper != null && this.viewDragHelper.shouldInterceptTouchEvent(event);
    }

    private boolean shouldInterceptTouchEvent(@NonNull V child) {
        return (child.isShown() || ViewCompat.getAccessibilityPaneTitle(child) != null) && this.draggable;
    }

    int getSignificantVelocityThreshold() {
        return 500;
    }

    public boolean onTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent event) {
        if (!child.isShown()) {
            return false;
        }
        int action = event.getActionMasked();
        if (this.state == 1 && action == 0) {
            return true;
        }
        if (this.shouldHandleDraggingWithHelper()) {
            this.viewDragHelper.processTouchEvent(event);
        }
        if (action == 0) {
            this.resetVelocity();
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        if (this.shouldHandleDraggingWithHelper() && action == 2 && !this.ignoreEvents && this.isDraggedFarEnough(event)) {
            this.viewDragHelper.captureChildView(child, event.getPointerId(event.getActionIndex()));
        }
        return !this.ignoreEvents;
    }

    private boolean isDraggedFarEnough(@NonNull MotionEvent event) {
        if (!this.shouldHandleDraggingWithHelper()) {
            return false;
        }
        float distanceDragged = this.calculateDragDistance(this.initialX, event.getX());
        return distanceDragged > (float)this.viewDragHelper.getTouchSlop();
    }

    private float calculateDragDistance(float initialPoint, float currentPoint) {
        return Math.abs(initialPoint - currentPoint);
    }

    public int getExpandedOffset() {
        return this.sheetDelegate.getExpandedOffset();
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setHideFriction(float hideFriction) {
        this.hideFriction = hideFriction;
    }

    public float getHideFriction() {
        return this.hideFriction;
    }

    float getHideThreshold() {
        return 0.5f;
    }

    @Override
    public void addCallback(@NonNull SideSheetCallback callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void removeCallback(@NonNull SideSheetCallback callback) {
        this.callbacks.remove(callback);
    }

    @Override
    public void setState(int state) {
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("STATE_" + (state == 1 ? "DRAGGING" : "SETTLING") + " should not be set externally.");
        }
        int finalState = state;
        if (this.viewRef == null || this.viewRef.get() == null) {
            this.setStateInternal(state);
        } else {
            this.runAfterLayout((View)this.viewRef.get(), () -> {
                View child = (View)this.viewRef.get();
                if (child != null) {
                    this.startSettling(child, finalState, false);
                }
            });
        }
    }

    private void runAfterLayout(@NonNull V child, Runnable runnable) {
        if (this.isLayingOut(child)) {
            child.post(runnable);
        } else {
            runnable.run();
        }
    }

    private boolean isLayingOut(@NonNull V child) {
        ViewParent parent = child.getParent();
        return parent != null && parent.isLayoutRequested() && ViewCompat.isAttachedToWindow(child);
    }

    @Override
    public int getState() {
        return this.state;
    }

    void setStateInternal(int state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        if (state == 3 || state == 5) {
            this.lastStableState = state;
        }
        if (this.viewRef == null) {
            return;
        }
        View sheet = (View)this.viewRef.get();
        if (sheet == null) {
            return;
        }
        this.updateSheetVisibility(sheet);
        for (SheetCallback sheetCallback : this.callbacks) {
            sheetCallback.onStateChanged(sheet, state);
        }
        this.updateAccessibilityActions();
    }

    private void resetVelocity() {
        if (this.velocityTracker != null) {
            this.velocityTracker.recycle();
            this.velocityTracker = null;
        }
    }

    boolean shouldHide(@NonNull View child, float velocity) {
        return this.sheetDelegate.shouldHide(child, velocity);
    }

    private boolean shouldHandleDraggingWithHelper() {
        return this.viewDragHelper != null && (this.draggable || this.state == 1);
    }

    private void createMaterialShapeDrawableIfNeeded(@NonNull Context context) {
        if (this.shapeAppearanceModel == null) {
            return;
        }
        this.materialShapeDrawable = new MaterialShapeDrawable(this.shapeAppearanceModel);
        this.materialShapeDrawable.initializeElevationOverlay(context);
        if (this.backgroundTint != null) {
            this.materialShapeDrawable.setFillColor(this.backgroundTint);
        } else {
            TypedValue defaultColor = new TypedValue();
            context.getTheme().resolveAttribute(0x1010031, defaultColor, true);
            this.materialShapeDrawable.setTint(defaultColor.data);
        }
    }

    float getXVelocity() {
        if (this.velocityTracker == null) {
            return 0.0f;
        }
        this.velocityTracker.computeCurrentVelocity(1000, this.maximumVelocity);
        return this.velocityTracker.getXVelocity();
    }

    private void startSettling(View child, int state, boolean isReleasingView) {
        boolean settling = this.isSettling(child, state, isReleasingView);
        if (settling) {
            this.setStateInternal(2);
            this.stateSettlingTracker.continueSettlingToState(state);
        } else {
            this.setStateInternal(state);
        }
    }

    private boolean isSettling(View child, int state, boolean isReleasingView) {
        int left = this.getOuterEdgeOffsetForState(state);
        ViewDragHelper viewDragHelper = this.getViewDragHelper();
        return viewDragHelper != null && (isReleasingView ? viewDragHelper.settleCapturedViewAt(left, child.getTop()) : viewDragHelper.smoothSlideViewTo(child, left, child.getTop()));
    }

    int getOuterEdgeOffsetForState(int state) {
        switch (state) {
            case 3: {
                return this.getExpandedOffset();
            }
            case 5: {
                return this.sheetDelegate.getHiddenOffset();
            }
        }
        throw new IllegalArgumentException("Invalid state to get outer edge offset: " + state);
    }

    @Nullable
    ViewDragHelper getViewDragHelper() {
        return this.viewDragHelper;
    }

    private int calculateTargetStateOnViewReleased(@NonNull View releasedChild, float xVelocity, float yVelocity) {
        int currentLeft;
        int targetState = this.isExpandingOutwards(xVelocity) ? 3 : (this.shouldHide(releasedChild, xVelocity) ? (this.sheetDelegate.isSwipeSignificant(xVelocity, yVelocity) || this.sheetDelegate.isReleasedCloseToInnerEdge(releasedChild) ? 5 : 3) : (xVelocity == 0.0f || !SheetUtils.isSwipeMostlyHorizontal(xVelocity, yVelocity) ? (Math.abs((currentLeft = releasedChild.getLeft()) - this.getExpandedOffset()) < Math.abs(currentLeft - this.sheetDelegate.getHiddenOffset()) ? 3 : 5) : 5));
        return targetState;
    }

    private boolean isExpandingOutwards(float xVelocity) {
        return this.sheetDelegate.isExpandingOutwards(xVelocity);
    }

    private void dispatchOnSlide(@NonNull View child, int outerEdge) {
        if (!this.callbacks.isEmpty()) {
            float slideOffset = this.sheetDelegate.calculateSlideOffset(outerEdge);
            for (SheetCallback sheetCallback : this.callbacks) {
                sheetCallback.onSlide(child, slideOffset);
            }
        }
    }

    public void setCoplanarSiblingViewId(@IdRes int coplanarSiblingViewId) {
        this.coplanarSiblingViewId = coplanarSiblingViewId;
        this.clearCoplanarSiblingView();
        if (this.viewRef != null) {
            View view = (View)this.viewRef.get();
            if (coplanarSiblingViewId != -1 && ViewCompat.isLaidOut((View)view)) {
                view.requestLayout();
            }
        }
    }

    public void setCoplanarSiblingView(@Nullable View coplanarSiblingView) {
        this.coplanarSiblingViewId = -1;
        if (coplanarSiblingView == null) {
            this.clearCoplanarSiblingView();
        } else {
            View view;
            this.coplanarSiblingViewRef = new WeakReference<View>(coplanarSiblingView);
            if (this.viewRef != null && ViewCompat.isLaidOut((View)(view = (View)this.viewRef.get()))) {
                view.requestLayout();
            }
        }
    }

    @Nullable
    public View getCoplanarSiblingView() {
        return this.coplanarSiblingViewRef != null ? (View)this.coplanarSiblingViewRef.get() : null;
    }

    private void clearCoplanarSiblingView() {
        if (this.coplanarSiblingViewRef != null) {
            this.coplanarSiblingViewRef.clear();
        }
        this.coplanarSiblingViewRef = null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean shouldSkipSmoothAnimation() {
        return true;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getLastStableState() {
        return this.lastStableState;
    }

    @Override
    public void startBackProgress(@NonNull BackEventCompat backEvent) {
        if (this.sideContainerBackHelper == null) {
            return;
        }
        this.sideContainerBackHelper.startBackProgress(backEvent);
    }

    @Override
    public void updateBackProgress(@NonNull BackEventCompat backEvent) {
        if (this.sideContainerBackHelper == null) {
            return;
        }
        this.sideContainerBackHelper.updateBackProgress(backEvent, this.getGravityFromSheetEdge());
        this.updateCoplanarSiblingBackProgress();
    }

    private void updateCoplanarSiblingBackProgress() {
        if (this.viewRef == null || this.viewRef.get() == null) {
            return;
        }
        View sheet = (View)this.viewRef.get();
        View coplanarSiblingView = this.getCoplanarSiblingView();
        if (coplanarSiblingView == null) {
            return;
        }
        ViewGroup.MarginLayoutParams coplanarSiblingLayoutParams = (ViewGroup.MarginLayoutParams)coplanarSiblingView.getLayoutParams();
        if (coplanarSiblingLayoutParams == null) {
            return;
        }
        int updatedCoplanarSiblingAdjacentMargin = (int)((float)this.childWidth * sheet.getScaleX() + (float)this.innerMargin);
        this.sheetDelegate.updateCoplanarSiblingAdjacentMargin(coplanarSiblingLayoutParams, updatedCoplanarSiblingAdjacentMargin);
        coplanarSiblingView.requestLayout();
    }

    @Override
    public void handleBackInvoked() {
        if (this.sideContainerBackHelper == null) {
            return;
        }
        BackEventCompat backEvent = this.sideContainerBackHelper.onHandleBackInvoked();
        if (backEvent == null || Build.VERSION.SDK_INT < 34) {
            this.setState(5);
            return;
        }
        this.sideContainerBackHelper.finishBackProgress(backEvent, this.getGravityFromSheetEdge(), (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SideSheetBehavior.this.setStateInternal(5);
                if (SideSheetBehavior.this.viewRef != null && SideSheetBehavior.this.viewRef.get() != null) {
                    ((View)SideSheetBehavior.this.viewRef.get()).requestLayout();
                }
            }
        }, this.getCoplanarFinishAnimatorUpdateListener());
    }

    @Nullable
    private ValueAnimator.AnimatorUpdateListener getCoplanarFinishAnimatorUpdateListener() {
        View coplanarSiblingView = this.getCoplanarSiblingView();
        if (coplanarSiblingView == null) {
            return null;
        }
        ViewGroup.MarginLayoutParams coplanarSiblingLayoutParams = (ViewGroup.MarginLayoutParams)coplanarSiblingView.getLayoutParams();
        if (coplanarSiblingLayoutParams == null) {
            return null;
        }
        int coplanarSiblingAdjacentMargin = this.sheetDelegate.getCoplanarSiblingAdjacentMargin(coplanarSiblingLayoutParams);
        return animation -> {
            this.sheetDelegate.updateCoplanarSiblingAdjacentMargin(coplanarSiblingLayoutParams, AnimationUtils.lerp(coplanarSiblingAdjacentMargin, 0, animation.getAnimatedFraction()));
            coplanarSiblingView.requestLayout();
        };
    }

    @Override
    public void cancelBackProgress() {
        if (this.sideContainerBackHelper == null) {
            return;
        }
        this.sideContainerBackHelper.cancelBackProgress();
    }

    @VisibleForTesting
    @Nullable
    MaterialSideContainerBackHelper getBackHelper() {
        return this.sideContainerBackHelper;
    }

    @NonNull
    public static <V extends View> SideSheetBehavior<V> from(@NonNull V view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof SideSheetBehavior)) {
            throw new IllegalArgumentException("The view is not associated with SideSheetBehavior");
        }
        return (SideSheetBehavior)behavior;
    }

    private void updateAccessibilityActions() {
        if (this.viewRef == null) {
            return;
        }
        View child = (View)this.viewRef.get();
        if (child == null) {
            return;
        }
        ViewCompat.removeAccessibilityAction((View)child, (int)262144);
        ViewCompat.removeAccessibilityAction((View)child, (int)0x100000);
        if (this.state != 5) {
            this.replaceAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_DISMISS, 5);
        }
        if (this.state != 3) {
            this.replaceAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_EXPAND, 3);
        }
    }

    private void replaceAccessibilityActionForState(V child, AccessibilityNodeInfoCompat.AccessibilityActionCompat action, int state) {
        ViewCompat.replaceAccessibilityAction(child, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)action, null, (AccessibilityViewCommand)this.createAccessibilityViewCommandForState(state));
    }

    private AccessibilityViewCommand createAccessibilityViewCommandForState(int state) {
        return (view, arguments) -> {
            this.setState(state);
            return true;
        };
    }

    protected static class SavedState
    extends AbsSavedState {
        final int state;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            @Nullable
            public SavedState createFromParcel(@NonNull Parcel in) {
                return new SavedState(in, null);
            }

            @NonNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(@NonNull Parcel source) {
            this(source, null);
        }

        public SavedState(@NonNull Parcel source, ClassLoader loader) {
            super(source, loader);
            this.state = source.readInt();
        }

        public SavedState(Parcelable superState, @NonNull SideSheetBehavior<?> behavior) {
            super(superState);
            this.state = ((SideSheetBehavior)behavior).state;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.state);
        }
    }

    class StateSettlingTracker {
        private int targetState;
        private boolean isContinueSettlingRunnablePosted;
        private final Runnable continueSettlingRunnable = () -> {
            this.isContinueSettlingRunnablePosted = false;
            if (SideSheetBehavior.this.viewDragHelper != null && SideSheetBehavior.this.viewDragHelper.continueSettling(true)) {
                this.continueSettlingToState(this.targetState);
            } else if (SideSheetBehavior.this.state == 2) {
                SideSheetBehavior.this.setStateInternal(this.targetState);
            }
        };

        StateSettlingTracker() {
        }

        void continueSettlingToState(int targetState) {
            if (SideSheetBehavior.this.viewRef == null || SideSheetBehavior.this.viewRef.get() == null) {
                return;
            }
            this.targetState = targetState;
            if (!this.isContinueSettlingRunnablePosted) {
                ViewCompat.postOnAnimation((View)((View)SideSheetBehavior.this.viewRef.get()), (Runnable)this.continueSettlingRunnable);
                this.isContinueSettlingRunnablePosted = true;
            }
        }
    }
}

