/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.slider;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityManager;
import android.widget.SeekBar;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.math.MathUtils;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.customview.widget.ExploreByTouchHelper;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.drawable.DrawableUtils;
import com.google.android.material.internal.DescendantOffsetUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewOverlayImpl;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.motion.MotionUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.slider.BaseOnChangeListener;
import com.google.android.material.slider.BaseOnSliderTouchListener;
import com.google.android.material.slider.LabelFormatter;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import com.google.android.material.tooltip.TooltipDrawable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

abstract class BaseSlider<S extends BaseSlider<S, L, T>, L extends BaseOnChangeListener<S>, T extends BaseOnSliderTouchListener<S>>
extends View {
    private static final String TAG = BaseSlider.class.getSimpleName();
    private static final String EXCEPTION_ILLEGAL_VALUE = "Slider value(%s) must be greater or equal to valueFrom(%s), and lower or equal to valueTo(%s)";
    private static final String EXCEPTION_ILLEGAL_DISCRETE_VALUE = "Value(%s) must be equal to valueFrom(%s) plus a multiple of stepSize(%s) when using stepSize(%s)";
    private static final String EXCEPTION_ILLEGAL_VALUE_FROM = "valueFrom(%s) must be smaller than valueTo(%s)";
    private static final String EXCEPTION_ILLEGAL_VALUE_TO = "valueTo(%s) must be greater than valueFrom(%s)";
    private static final String EXCEPTION_ILLEGAL_STEP_SIZE = "The stepSize(%s) must be 0, or a factor of the valueFrom(%s)-valueTo(%s) range";
    private static final String EXCEPTION_ILLEGAL_MIN_SEPARATION = "minSeparation(%s) must be greater or equal to 0";
    private static final String EXCEPTION_ILLEGAL_MIN_SEPARATION_STEP_SIZE_UNIT = "minSeparation(%s) cannot be set as a dimension when using stepSize(%s)";
    private static final String EXCEPTION_ILLEGAL_MIN_SEPARATION_STEP_SIZE = "minSeparation(%s) must be greater or equal and a multiple of stepSize(%s) when using stepSize(%s)";
    private static final String WARNING_FLOATING_POINT_ERROR = "Floating point value used for %s(%s). Using floats can have rounding errors which may result in incorrect values. Instead, consider using integers with a custom LabelFormatter to display the value correctly.";
    private static final int TIMEOUT_SEND_ACCESSIBILITY_EVENT = 200;
    private static final int HALO_ALPHA = 63;
    private static final double THRESHOLD = 1.0E-4;
    private static final float THUMB_WIDTH_PRESSED_RATIO = 0.5f;
    static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_Slider;
    static final int UNIT_VALUE = 1;
    static final int UNIT_PX = 0;
    private static final int DEFAULT_LABEL_ANIMATION_ENTER_DURATION = 83;
    private static final int DEFAULT_LABEL_ANIMATION_EXIT_DURATION = 117;
    private static final int LABEL_ANIMATION_ENTER_DURATION_ATTR = R.attr.motionDurationMedium4;
    private static final int LABEL_ANIMATION_EXIT_DURATION_ATTR = R.attr.motionDurationShort3;
    private static final int LABEL_ANIMATION_ENTER_EASING_ATTR = R.attr.motionEasingEmphasizedInterpolator;
    private static final int LABEL_ANIMATION_EXIT_EASING_ATTR = R.attr.motionEasingEmphasizedAccelerateInterpolator;
    @Dimension(unit=0)
    private static final int MIN_TOUCH_TARGET_DP = 48;
    @NonNull
    private final Paint inactiveTrackPaint;
    @NonNull
    private final Paint activeTrackPaint;
    @NonNull
    private final Paint thumbPaint;
    @NonNull
    private final Paint haloPaint;
    @NonNull
    private final Paint inactiveTicksPaint;
    @NonNull
    private final Paint activeTicksPaint;
    @NonNull
    private final Paint stopIndicatorPaint;
    @NonNull
    private final AccessibilityHelper accessibilityHelper;
    private final AccessibilityManager accessibilityManager;
    private AccessibilityEventSender accessibilityEventSender;
    private int labelStyle;
    @NonNull
    private final List<TooltipDrawable> labels = new ArrayList<TooltipDrawable>();
    @NonNull
    private final List<L> changeListeners = new ArrayList<L>();
    @NonNull
    private final List<T> touchListeners = new ArrayList<T>();
    private boolean labelsAreAnimatedIn = false;
    private ValueAnimator labelsInAnimator;
    private ValueAnimator labelsOutAnimator;
    private final int scaledTouchSlop;
    private int minTrackSidePadding;
    private int defaultThumbRadius;
    private int defaultTrackHeight;
    private int defaultTickActiveRadius;
    private int defaultTickInactiveRadius;
    private int minTickSpacing;
    @Px
    private int minTouchTargetSize;
    private int minWidgetHeight;
    private int widgetHeight;
    private int labelBehavior;
    private int trackHeight;
    private int trackSidePadding;
    private int thumbWidth;
    private int thumbHeight;
    private int haloRadius;
    private int thumbTrackGapSize;
    private int defaultThumbWidth = -1;
    private int defaultThumbTrackGapSize = -1;
    private int trackStopIndicatorSize;
    private int trackInsideCornerSize;
    private int labelPadding;
    private float touchDownX;
    private MotionEvent lastEvent;
    private LabelFormatter formatter;
    private boolean thumbIsPressed = false;
    private float valueFrom;
    private float valueTo;
    private ArrayList<Float> values = new ArrayList();
    private int activeThumbIdx = -1;
    private int focusedThumbIdx = -1;
    private float stepSize = 0.0f;
    private float[] ticksCoordinates;
    private boolean tickVisible = true;
    private int tickActiveRadius;
    private int tickInactiveRadius;
    private int trackWidth;
    private boolean forceDrawCompatHalo;
    private boolean isLongPress = false;
    private boolean dirtyConfig;
    @NonNull
    private ColorStateList haloColor;
    @NonNull
    private ColorStateList tickColorActive;
    @NonNull
    private ColorStateList tickColorInactive;
    @NonNull
    private ColorStateList trackColorActive;
    @NonNull
    private ColorStateList trackColorInactive;
    @NonNull
    private final Path trackPath = new Path();
    @NonNull
    private final RectF trackRect = new RectF();
    @NonNull
    private final RectF cornerRect = new RectF();
    @NonNull
    private final MaterialShapeDrawable defaultThumbDrawable = new MaterialShapeDrawable();
    @Nullable
    private Drawable customThumbDrawable;
    @NonNull
    private List<Drawable> customThumbDrawablesForValues = Collections.emptyList();
    private float touchPosition;
    private int separationUnit = 0;
    @NonNull
    private final ViewTreeObserver.OnScrollChangedListener onScrollChangedListener = this::updateLabels;

    public BaseSlider(@NonNull Context context) {
        this(context, null);
    }

    public BaseSlider(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sliderStyle);
    }

    public BaseSlider(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        this.inactiveTrackPaint = new Paint();
        this.activeTrackPaint = new Paint();
        this.thumbPaint = new Paint(1);
        this.thumbPaint.setStyle(Paint.Style.FILL);
        this.thumbPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.haloPaint = new Paint(1);
        this.haloPaint.setStyle(Paint.Style.FILL);
        this.inactiveTicksPaint = new Paint();
        this.inactiveTicksPaint.setStyle(Paint.Style.STROKE);
        this.inactiveTicksPaint.setStrokeCap(Paint.Cap.ROUND);
        this.activeTicksPaint = new Paint();
        this.activeTicksPaint.setStyle(Paint.Style.STROKE);
        this.activeTicksPaint.setStrokeCap(Paint.Cap.ROUND);
        this.stopIndicatorPaint = new Paint();
        this.stopIndicatorPaint.setStyle(Paint.Style.FILL);
        this.stopIndicatorPaint.setStrokeCap(Paint.Cap.ROUND);
        this.loadResources(context.getResources());
        this.processAttributes(context, attrs, defStyleAttr);
        this.setFocusable(true);
        this.setClickable(true);
        this.defaultThumbDrawable.setShadowCompatibilityMode(2);
        this.scaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.accessibilityHelper = new AccessibilityHelper(this);
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)this.accessibilityHelper);
        this.accessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
    }

    private void loadResources(@NonNull Resources resources) {
        this.minWidgetHeight = resources.getDimensionPixelSize(R.dimen.mtrl_slider_widget_height);
        this.trackSidePadding = this.minTrackSidePadding = resources.getDimensionPixelOffset(R.dimen.mtrl_slider_track_side_padding);
        this.defaultThumbRadius = resources.getDimensionPixelSize(R.dimen.mtrl_slider_thumb_radius);
        this.defaultTrackHeight = resources.getDimensionPixelSize(R.dimen.mtrl_slider_track_height);
        this.defaultTickActiveRadius = resources.getDimensionPixelSize(R.dimen.mtrl_slider_tick_radius);
        this.defaultTickInactiveRadius = resources.getDimensionPixelSize(R.dimen.mtrl_slider_tick_radius);
        this.minTickSpacing = resources.getDimensionPixelSize(R.dimen.mtrl_slider_tick_min_spacing);
        this.labelPadding = resources.getDimensionPixelSize(R.dimen.mtrl_slider_label_padding);
    }

    private void processAttributes(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.Slider, defStyleAttr, DEF_STYLE_RES, new int[0]);
        this.labelStyle = a.getResourceId(R.styleable.Slider_labelStyle, R.style.Widget_MaterialComponents_Tooltip);
        this.valueFrom = a.getFloat(R.styleable.Slider_android_valueFrom, 0.0f);
        this.valueTo = a.getFloat(R.styleable.Slider_android_valueTo, 1.0f);
        this.setValues(Float.valueOf(this.valueFrom));
        this.stepSize = a.getFloat(R.styleable.Slider_android_stepSize, 0.0f);
        float defaultMinTouchTargetSize = (float)Math.ceil(ViewUtils.dpToPx(this.getContext(), 48));
        this.minTouchTargetSize = (int)Math.ceil(a.getDimension(R.styleable.Slider_minTouchTargetSize, defaultMinTouchTargetSize));
        boolean hasTrackColor = a.hasValue(R.styleable.Slider_trackColor);
        int trackColorInactiveRes = hasTrackColor ? R.styleable.Slider_trackColor : R.styleable.Slider_trackColorInactive;
        int trackColorActiveRes = hasTrackColor ? R.styleable.Slider_trackColor : R.styleable.Slider_trackColorActive;
        ColorStateList trackColorInactive = MaterialResources.getColorStateList(context, a, trackColorInactiveRes);
        this.setTrackInactiveTintList(trackColorInactive != null ? trackColorInactive : AppCompatResources.getColorStateList((Context)context, (int)R.color.material_slider_inactive_track_color));
        ColorStateList trackColorActive = MaterialResources.getColorStateList(context, a, trackColorActiveRes);
        this.setTrackActiveTintList(trackColorActive != null ? trackColorActive : AppCompatResources.getColorStateList((Context)context, (int)R.color.material_slider_active_track_color));
        ColorStateList thumbColor = MaterialResources.getColorStateList(context, a, R.styleable.Slider_thumbColor);
        this.defaultThumbDrawable.setFillColor(thumbColor);
        if (a.hasValue(R.styleable.Slider_thumbStrokeColor)) {
            this.setThumbStrokeColor(MaterialResources.getColorStateList(context, a, R.styleable.Slider_thumbStrokeColor));
        }
        this.setThumbStrokeWidth(a.getDimension(R.styleable.Slider_thumbStrokeWidth, 0.0f));
        ColorStateList haloColor = MaterialResources.getColorStateList(context, a, R.styleable.Slider_haloColor);
        this.setHaloTintList(haloColor != null ? haloColor : AppCompatResources.getColorStateList((Context)context, (int)R.color.material_slider_halo_color));
        this.tickVisible = a.getBoolean(R.styleable.Slider_tickVisible, true);
        boolean hasTickColor = a.hasValue(R.styleable.Slider_tickColor);
        int tickColorInactiveRes = hasTickColor ? R.styleable.Slider_tickColor : R.styleable.Slider_tickColorInactive;
        int tickColorActiveRes = hasTickColor ? R.styleable.Slider_tickColor : R.styleable.Slider_tickColorActive;
        ColorStateList tickColorInactive = MaterialResources.getColorStateList(context, a, tickColorInactiveRes);
        this.setTickInactiveTintList(tickColorInactive != null ? tickColorInactive : AppCompatResources.getColorStateList((Context)context, (int)R.color.material_slider_inactive_tick_marks_color));
        ColorStateList tickColorActive = MaterialResources.getColorStateList(context, a, tickColorActiveRes);
        this.setTickActiveTintList(tickColorActive != null ? tickColorActive : AppCompatResources.getColorStateList((Context)context, (int)R.color.material_slider_active_tick_marks_color));
        this.setThumbTrackGapSize(a.getDimensionPixelSize(R.styleable.Slider_thumbTrackGapSize, 0));
        this.setTrackStopIndicatorSize(a.getDimensionPixelSize(R.styleable.Slider_trackStopIndicatorSize, 0));
        this.setTrackInsideCornerSize(a.getDimensionPixelSize(R.styleable.Slider_trackInsideCornerSize, 0));
        int radius = a.getDimensionPixelSize(R.styleable.Slider_thumbRadius, 0);
        int thumbWidth = a.getDimensionPixelSize(R.styleable.Slider_thumbWidth, radius * 2);
        int thumbHeight = a.getDimensionPixelSize(R.styleable.Slider_thumbHeight, radius * 2);
        this.setThumbWidth(thumbWidth);
        this.setThumbHeight(thumbHeight);
        this.setHaloRadius(a.getDimensionPixelSize(R.styleable.Slider_haloRadius, 0));
        this.setThumbElevation(a.getDimension(R.styleable.Slider_thumbElevation, 0.0f));
        this.setTrackHeight(a.getDimensionPixelSize(R.styleable.Slider_trackHeight, 0));
        this.setTickActiveRadius(a.getDimensionPixelSize(R.styleable.Slider_tickRadiusActive, this.trackStopIndicatorSize / 2));
        this.setTickInactiveRadius(a.getDimensionPixelSize(R.styleable.Slider_tickRadiusInactive, this.trackStopIndicatorSize / 2));
        this.setLabelBehavior(a.getInt(R.styleable.Slider_labelBehavior, 0));
        if (!a.getBoolean(R.styleable.Slider_android_enabled, true)) {
            this.setEnabled(false);
        }
        a.recycle();
    }

    private boolean maybeIncreaseTrackSidePadding() {
        int increasedSidePaddingByThumb = Math.max(this.thumbWidth / 2 - this.defaultThumbRadius, 0);
        int increasedSidePaddingByTrack = Math.max((this.trackHeight - this.defaultTrackHeight) / 2, 0);
        int increasedSidePaddingByActiveTick = Math.max(this.tickActiveRadius - this.defaultTickActiveRadius, 0);
        int increasedSidePaddingByInactiveTick = Math.max(this.tickInactiveRadius - this.defaultTickInactiveRadius, 0);
        int newTrackSidePadding = this.minTrackSidePadding + Math.max(Math.max(increasedSidePaddingByThumb, increasedSidePaddingByTrack), Math.max(increasedSidePaddingByActiveTick, increasedSidePaddingByInactiveTick));
        if (this.trackSidePadding == newTrackSidePadding) {
            return false;
        }
        this.trackSidePadding = newTrackSidePadding;
        if (ViewCompat.isLaidOut((View)this)) {
            this.updateTrackWidth(this.getWidth());
        }
        return true;
    }

    private void validateValueFrom() {
        if (this.valueFrom >= this.valueTo) {
            throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_VALUE_FROM, Float.valueOf(this.valueFrom), Float.valueOf(this.valueTo)));
        }
    }

    private void validateValueTo() {
        if (this.valueTo <= this.valueFrom) {
            throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_VALUE_TO, Float.valueOf(this.valueTo), Float.valueOf(this.valueFrom)));
        }
    }

    private boolean valueLandsOnTick(float value) {
        double result = new BigDecimal(Float.toString(value)).subtract(new BigDecimal(Float.toString(this.valueFrom)), MathContext.DECIMAL64).doubleValue();
        return this.isMultipleOfStepSize(result);
    }

    private boolean isMultipleOfStepSize(double value) {
        double result = new BigDecimal(Double.toString(value)).divide(new BigDecimal(Float.toString(this.stepSize)), MathContext.DECIMAL64).doubleValue();
        return Math.abs((double)Math.round(result) - result) < 1.0E-4;
    }

    private void validateStepSize() {
        if (this.stepSize > 0.0f && !this.valueLandsOnTick(this.valueTo)) {
            throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_STEP_SIZE, Float.valueOf(this.stepSize), Float.valueOf(this.valueFrom), Float.valueOf(this.valueTo)));
        }
    }

    private void validateValues() {
        for (Float value : this.values) {
            if (value.floatValue() < this.valueFrom || value.floatValue() > this.valueTo) {
                throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_VALUE, value, Float.valueOf(this.valueFrom), Float.valueOf(this.valueTo)));
            }
            if (!(this.stepSize > 0.0f) || this.valueLandsOnTick(value.floatValue())) continue;
            throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_DISCRETE_VALUE, value, Float.valueOf(this.valueFrom), Float.valueOf(this.stepSize), Float.valueOf(this.stepSize)));
        }
    }

    private void validateMinSeparation() {
        float minSeparation = this.getMinSeparation();
        if (minSeparation < 0.0f) {
            throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_MIN_SEPARATION, Float.valueOf(minSeparation)));
        }
        if (this.stepSize > 0.0f && minSeparation > 0.0f) {
            if (this.separationUnit != 1) {
                throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_MIN_SEPARATION_STEP_SIZE_UNIT, Float.valueOf(minSeparation), Float.valueOf(this.stepSize)));
            }
            if (minSeparation < this.stepSize || !this.isMultipleOfStepSize(minSeparation)) {
                throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_MIN_SEPARATION_STEP_SIZE, Float.valueOf(minSeparation), Float.valueOf(this.stepSize), Float.valueOf(this.stepSize)));
            }
        }
    }

    private void warnAboutFloatingPointError() {
        if (this.stepSize == 0.0f) {
            return;
        }
        if ((float)((int)this.stepSize) != this.stepSize) {
            Log.w((String)TAG, (String)String.format(WARNING_FLOATING_POINT_ERROR, "stepSize", Float.valueOf(this.stepSize)));
        }
        if ((float)((int)this.valueFrom) != this.valueFrom) {
            Log.w((String)TAG, (String)String.format(WARNING_FLOATING_POINT_ERROR, "valueFrom", Float.valueOf(this.valueFrom)));
        }
        if ((float)((int)this.valueTo) != this.valueTo) {
            Log.w((String)TAG, (String)String.format(WARNING_FLOATING_POINT_ERROR, "valueTo", Float.valueOf(this.valueTo)));
        }
    }

    private void validateConfigurationIfDirty() {
        if (this.dirtyConfig) {
            this.validateValueFrom();
            this.validateValueTo();
            this.validateStepSize();
            this.validateValues();
            this.validateMinSeparation();
            this.warnAboutFloatingPointError();
            this.dirtyConfig = false;
        }
    }

    public float getValueFrom() {
        return this.valueFrom;
    }

    public void setValueFrom(float valueFrom) {
        this.valueFrom = valueFrom;
        this.dirtyConfig = true;
        this.postInvalidate();
    }

    public float getValueTo() {
        return this.valueTo;
    }

    public void setValueTo(float valueTo) {
        this.valueTo = valueTo;
        this.dirtyConfig = true;
        this.postInvalidate();
    }

    @NonNull
    List<Float> getValues() {
        return new ArrayList<Float>(this.values);
    }

    void setValues(Float ... values) {
        ArrayList<Float> list = new ArrayList<Float>();
        Collections.addAll(list, values);
        this.setValuesInternal(list);
    }

    void setValues(@NonNull List<Float> values) {
        this.setValuesInternal(new ArrayList<Float>(values));
    }

    private void setValuesInternal(@NonNull ArrayList<Float> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("At least one value must be set");
        }
        Collections.sort(values);
        if (this.values.size() == values.size() && this.values.equals(values)) {
            return;
        }
        this.values = values;
        this.dirtyConfig = true;
        this.focusedThumbIdx = 0;
        this.updateHaloHotspot();
        this.createLabelPool();
        this.dispatchOnChangedProgrammatically();
        this.postInvalidate();
    }

    private void createLabelPool() {
        if (this.labels.size() > this.values.size()) {
            List<TooltipDrawable> tooltipDrawables = this.labels.subList(this.values.size(), this.labels.size());
            for (TooltipDrawable label : tooltipDrawables) {
                if (!ViewCompat.isAttachedToWindow((View)this)) continue;
                this.detachLabelFromContentView(label);
            }
            tooltipDrawables.clear();
        }
        while (this.labels.size() < this.values.size()) {
            TooltipDrawable tooltipDrawable = TooltipDrawable.createFromAttributes(this.getContext(), null, 0, this.labelStyle);
            this.labels.add(tooltipDrawable);
            if (!ViewCompat.isAttachedToWindow((View)this)) continue;
            this.attachLabelToContentView(tooltipDrawable);
        }
        boolean strokeWidth = this.labels.size() != 1;
        for (TooltipDrawable label : this.labels) {
            label.setStrokeWidth((float)strokeWidth);
        }
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(float stepSize) {
        if (stepSize < 0.0f) {
            throw new IllegalArgumentException(String.format(EXCEPTION_ILLEGAL_STEP_SIZE, Float.valueOf(stepSize), Float.valueOf(this.valueFrom), Float.valueOf(this.valueTo)));
        }
        if (this.stepSize != stepSize) {
            this.stepSize = stepSize;
            this.dirtyConfig = true;
            this.postInvalidate();
        }
    }

    void setCustomThumbDrawable(@DrawableRes int drawableResId) {
        this.setCustomThumbDrawable(this.getResources().getDrawable(drawableResId));
    }

    void setCustomThumbDrawable(@NonNull Drawable drawable2) {
        this.customThumbDrawable = this.initializeCustomThumbDrawable(drawable2);
        this.customThumbDrawablesForValues.clear();
        this.postInvalidate();
    }

    void setCustomThumbDrawablesForValues(int ... customThumbDrawableResIds) {
        Drawable[] customThumbDrawables = new Drawable[customThumbDrawableResIds.length];
        for (int i = 0; i < customThumbDrawableResIds.length; ++i) {
            customThumbDrawables[i] = this.getResources().getDrawable(customThumbDrawableResIds[i]);
        }
        this.setCustomThumbDrawablesForValues(customThumbDrawables);
    }

    void setCustomThumbDrawablesForValues(Drawable ... customThumbDrawables) {
        this.customThumbDrawable = null;
        this.customThumbDrawablesForValues = new ArrayList<Drawable>();
        for (Drawable originalDrawable : customThumbDrawables) {
            this.customThumbDrawablesForValues.add(this.initializeCustomThumbDrawable(originalDrawable));
        }
        this.postInvalidate();
    }

    private Drawable initializeCustomThumbDrawable(Drawable originalDrawable) {
        Drawable drawable2 = originalDrawable.mutate().getConstantState().newDrawable();
        this.adjustCustomThumbDrawableBounds(drawable2);
        return drawable2;
    }

    private void adjustCustomThumbDrawableBounds(Drawable drawable2) {
        int originalWidth = drawable2.getIntrinsicWidth();
        int originalHeight = drawable2.getIntrinsicHeight();
        if (originalWidth == -1 && originalHeight == -1) {
            drawable2.setBounds(0, 0, this.thumbWidth, this.thumbHeight);
        } else {
            float scaleRatio = (float)Math.max(this.thumbWidth, this.thumbHeight) / (float)Math.max(originalWidth, originalHeight);
            drawable2.setBounds(0, 0, (int)((float)originalWidth * scaleRatio), (int)((float)originalHeight * scaleRatio));
        }
    }

    public int getFocusedThumbIndex() {
        return this.focusedThumbIdx;
    }

    public void setFocusedThumbIndex(int index) {
        if (index < 0 || index >= this.values.size()) {
            throw new IllegalArgumentException("index out of range");
        }
        this.focusedThumbIdx = index;
        this.accessibilityHelper.requestKeyboardFocusForVirtualView(this.focusedThumbIdx);
        this.postInvalidate();
    }

    protected void setActiveThumbIndex(int index) {
        this.activeThumbIdx = index;
    }

    public int getActiveThumbIndex() {
        return this.activeThumbIdx;
    }

    public void addOnChangeListener(@NonNull L listener) {
        this.changeListeners.add(listener);
    }

    public void removeOnChangeListener(@NonNull L listener) {
        this.changeListeners.remove(listener);
    }

    public void clearOnChangeListeners() {
        this.changeListeners.clear();
    }

    public void addOnSliderTouchListener(@NonNull T listener) {
        this.touchListeners.add(listener);
    }

    public void removeOnSliderTouchListener(@NonNull T listener) {
        this.touchListeners.remove(listener);
    }

    public void clearOnSliderTouchListeners() {
        this.touchListeners.clear();
    }

    public boolean hasLabelFormatter() {
        return this.formatter != null;
    }

    public void setLabelFormatter(@Nullable LabelFormatter formatter) {
        this.formatter = formatter;
    }

    public float getThumbElevation() {
        return this.defaultThumbDrawable.getElevation();
    }

    public void setThumbElevation(float elevation) {
        this.defaultThumbDrawable.setElevation(elevation);
    }

    public void setThumbElevationResource(@DimenRes int elevation) {
        this.setThumbElevation(this.getResources().getDimension(elevation));
    }

    @Px
    public int getThumbRadius() {
        return this.thumbWidth / 2;
    }

    public void setThumbRadius(@IntRange(from=0L) @Px int radius) {
        this.setThumbWidth(radius * 2);
        this.setThumbHeight(radius * 2);
    }

    public void setThumbRadiusResource(@DimenRes int radius) {
        this.setThumbRadius(this.getResources().getDimensionPixelSize(radius));
    }

    @Px
    public int getThumbWidth() {
        return this.thumbWidth;
    }

    public void setThumbWidth(@IntRange(from=0L) @Px int width) {
        if (width == this.thumbWidth) {
            return;
        }
        this.thumbWidth = width;
        this.defaultThumbDrawable.setShapeAppearanceModel(ShapeAppearanceModel.builder().setAllCorners(0, (float)this.thumbWidth / 2.0f).build());
        this.defaultThumbDrawable.setBounds(0, 0, this.thumbWidth, this.thumbHeight);
        if (this.customThumbDrawable != null) {
            this.adjustCustomThumbDrawableBounds(this.customThumbDrawable);
        }
        for (Drawable customDrawable : this.customThumbDrawablesForValues) {
            this.adjustCustomThumbDrawableBounds(customDrawable);
        }
        this.updateWidgetLayout();
    }

    public void setThumbWidthResource(@DimenRes int width) {
        this.setThumbWidth(this.getResources().getDimensionPixelSize(width));
    }

    @Px
    public int getThumbHeight() {
        return this.thumbHeight;
    }

    public void setThumbHeight(@IntRange(from=0L) @Px int height) {
        if (height == this.thumbHeight) {
            return;
        }
        this.thumbHeight = height;
        this.defaultThumbDrawable.setBounds(0, 0, this.thumbWidth, this.thumbHeight);
        if (this.customThumbDrawable != null) {
            this.adjustCustomThumbDrawableBounds(this.customThumbDrawable);
        }
        for (Drawable customDrawable : this.customThumbDrawablesForValues) {
            this.adjustCustomThumbDrawableBounds(customDrawable);
        }
        this.updateWidgetLayout();
    }

    public void setThumbHeightResource(@DimenRes int height) {
        this.setThumbHeight(this.getResources().getDimensionPixelSize(height));
    }

    public void setThumbStrokeColor(@Nullable ColorStateList thumbStrokeColor) {
        this.defaultThumbDrawable.setStrokeColor(thumbStrokeColor);
        this.postInvalidate();
    }

    public void setThumbStrokeColorResource(@ColorRes int thumbStrokeColorResourceId) {
        if (thumbStrokeColorResourceId != 0) {
            this.setThumbStrokeColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)thumbStrokeColorResourceId));
        }
    }

    public ColorStateList getThumbStrokeColor() {
        return this.defaultThumbDrawable.getStrokeColor();
    }

    public void setThumbStrokeWidth(float thumbStrokeWidth) {
        this.defaultThumbDrawable.setStrokeWidth(thumbStrokeWidth);
        this.postInvalidate();
    }

    public void setThumbStrokeWidthResource(@DimenRes int thumbStrokeWidthResourceId) {
        if (thumbStrokeWidthResourceId != 0) {
            this.setThumbStrokeWidth(this.getResources().getDimension(thumbStrokeWidthResourceId));
        }
    }

    public float getThumbStrokeWidth() {
        return this.defaultThumbDrawable.getStrokeWidth();
    }

    @Px
    public int getHaloRadius() {
        return this.haloRadius;
    }

    public void setHaloRadius(@IntRange(from=0L) @Px int radius) {
        if (radius == this.haloRadius) {
            return;
        }
        this.haloRadius = radius;
        Drawable background = this.getBackground();
        if (!this.shouldDrawCompatHalo() && background instanceof RippleDrawable) {
            DrawableUtils.setRippleDrawableRadius((RippleDrawable)background, this.haloRadius);
            return;
        }
        this.postInvalidate();
    }

    public void setHaloRadiusResource(@DimenRes int radius) {
        this.setHaloRadius(this.getResources().getDimensionPixelSize(radius));
    }

    public int getLabelBehavior() {
        return this.labelBehavior;
    }

    public void setLabelBehavior(int labelBehavior) {
        if (this.labelBehavior != labelBehavior) {
            this.labelBehavior = labelBehavior;
            this.requestLayout();
        }
    }

    private boolean shouldAlwaysShowLabel() {
        return this.labelBehavior == 3;
    }

    @Px
    public int getTrackSidePadding() {
        return this.trackSidePadding;
    }

    @Px
    public int getTrackWidth() {
        return this.trackWidth;
    }

    @Px
    public int getTrackHeight() {
        return this.trackHeight;
    }

    public void setTrackHeight(@IntRange(from=0L) @Px int trackHeight) {
        if (this.trackHeight != trackHeight) {
            this.trackHeight = trackHeight;
            this.invalidateTrack();
            this.updateWidgetLayout();
        }
    }

    @Px
    public int getTickActiveRadius() {
        return this.tickActiveRadius;
    }

    public void setTickActiveRadius(@IntRange(from=0L) @Px int tickActiveRadius) {
        if (this.tickActiveRadius != tickActiveRadius) {
            this.tickActiveRadius = tickActiveRadius;
            this.activeTicksPaint.setStrokeWidth((float)(tickActiveRadius * 2));
            this.updateWidgetLayout();
        }
    }

    @Px
    public int getTickInactiveRadius() {
        return this.tickInactiveRadius;
    }

    public void setTickInactiveRadius(@IntRange(from=0L) @Px int tickInactiveRadius) {
        if (this.tickInactiveRadius != tickInactiveRadius) {
            this.tickInactiveRadius = tickInactiveRadius;
            this.inactiveTicksPaint.setStrokeWidth((float)(tickInactiveRadius * 2));
            this.updateWidgetLayout();
        }
    }

    private void updateWidgetLayout() {
        boolean sizeChanged = this.maybeIncreaseWidgetHeight();
        boolean sidePaddingChanged = this.maybeIncreaseTrackSidePadding();
        if (sizeChanged) {
            this.requestLayout();
        } else if (sidePaddingChanged) {
            this.postInvalidate();
        }
    }

    private boolean maybeIncreaseWidgetHeight() {
        int minHeightRequiredByThumb;
        int topAndBottomPaddings = this.getPaddingTop() + this.getPaddingBottom();
        int minHeightRequiredByTrack = this.trackHeight + topAndBottomPaddings;
        int newWidgetHeight = Math.max(this.minWidgetHeight, Math.max(minHeightRequiredByTrack, minHeightRequiredByThumb = this.thumbHeight + this.getPaddingTop() + this.getPaddingBottom()));
        if (newWidgetHeight == this.widgetHeight) {
            return false;
        }
        this.widgetHeight = newWidgetHeight;
        return true;
    }

    @NonNull
    public ColorStateList getHaloTintList() {
        return this.haloColor;
    }

    public void setHaloTintList(@NonNull ColorStateList haloColor) {
        if (haloColor.equals(this.haloColor)) {
            return;
        }
        this.haloColor = haloColor;
        Drawable background = this.getBackground();
        if (!this.shouldDrawCompatHalo() && background instanceof RippleDrawable) {
            ((RippleDrawable)background).setColor(haloColor);
            return;
        }
        this.haloPaint.setColor(this.getColorForState(haloColor));
        this.haloPaint.setAlpha(63);
        this.invalidate();
    }

    @NonNull
    public ColorStateList getThumbTintList() {
        return this.defaultThumbDrawable.getFillColor();
    }

    public void setThumbTintList(@NonNull ColorStateList thumbColor) {
        if (thumbColor.equals(this.defaultThumbDrawable.getFillColor())) {
            return;
        }
        this.defaultThumbDrawable.setFillColor(thumbColor);
        this.invalidate();
    }

    @NonNull
    public ColorStateList getTickTintList() {
        if (!this.tickColorInactive.equals(this.tickColorActive)) {
            throw new IllegalStateException("The inactive and active ticks are different colors. Use the getTickColorInactive() and getTickColorActive() methods instead.");
        }
        return this.tickColorActive;
    }

    public void setTickTintList(@NonNull ColorStateList tickColor) {
        this.setTickInactiveTintList(tickColor);
        this.setTickActiveTintList(tickColor);
    }

    @NonNull
    public ColorStateList getTickActiveTintList() {
        return this.tickColorActive;
    }

    public void setTickActiveTintList(@NonNull ColorStateList tickColor) {
        if (tickColor.equals(this.tickColorActive)) {
            return;
        }
        this.tickColorActive = tickColor;
        this.activeTicksPaint.setColor(this.getColorForState(this.tickColorActive));
        this.invalidate();
    }

    @NonNull
    public ColorStateList getTickInactiveTintList() {
        return this.tickColorInactive;
    }

    public void setTickInactiveTintList(@NonNull ColorStateList tickColor) {
        if (tickColor.equals(this.tickColorInactive)) {
            return;
        }
        this.tickColorInactive = tickColor;
        this.inactiveTicksPaint.setColor(this.getColorForState(this.tickColorInactive));
        this.invalidate();
    }

    public boolean isTickVisible() {
        return this.tickVisible;
    }

    public void setTickVisible(boolean tickVisible) {
        if (this.tickVisible != tickVisible) {
            this.tickVisible = tickVisible;
            this.postInvalidate();
        }
    }

    @NonNull
    public ColorStateList getTrackTintList() {
        if (!this.trackColorInactive.equals(this.trackColorActive)) {
            throw new IllegalStateException("The inactive and active parts of the track are different colors. Use the getInactiveTrackColor() and getActiveTrackColor() methods instead.");
        }
        return this.trackColorActive;
    }

    public void setTrackTintList(@NonNull ColorStateList trackColor) {
        this.setTrackInactiveTintList(trackColor);
        this.setTrackActiveTintList(trackColor);
    }

    @NonNull
    public ColorStateList getTrackActiveTintList() {
        return this.trackColorActive;
    }

    public void setTrackActiveTintList(@NonNull ColorStateList trackColor) {
        if (trackColor.equals(this.trackColorActive)) {
            return;
        }
        this.trackColorActive = trackColor;
        this.activeTrackPaint.setColor(this.getColorForState(this.trackColorActive));
        this.stopIndicatorPaint.setColor(this.getColorForState(this.trackColorActive));
        this.invalidate();
    }

    @NonNull
    public ColorStateList getTrackInactiveTintList() {
        return this.trackColorInactive;
    }

    public void setTrackInactiveTintList(@NonNull ColorStateList trackColor) {
        if (trackColor.equals(this.trackColorInactive)) {
            return;
        }
        this.trackColorInactive = trackColor;
        this.inactiveTrackPaint.setColor(this.getColorForState(this.trackColorInactive));
        this.invalidate();
    }

    public int getThumbTrackGapSize() {
        return this.thumbTrackGapSize;
    }

    public void setThumbTrackGapSize(@Px int thumbTrackGapSize) {
        if (this.thumbTrackGapSize == thumbTrackGapSize) {
            return;
        }
        this.thumbTrackGapSize = thumbTrackGapSize;
        this.invalidate();
    }

    public int getTrackStopIndicatorSize() {
        return this.trackStopIndicatorSize;
    }

    public void setTrackStopIndicatorSize(@Px int trackStopIndicatorSize) {
        if (this.trackStopIndicatorSize == trackStopIndicatorSize) {
            return;
        }
        this.trackStopIndicatorSize = trackStopIndicatorSize;
        this.stopIndicatorPaint.setStrokeWidth((float)trackStopIndicatorSize);
        this.invalidate();
    }

    public int getTrackInsideCornerSize() {
        return this.trackInsideCornerSize;
    }

    public void setTrackInsideCornerSize(@Px int cornerSize) {
        if (this.trackInsideCornerSize == cornerSize) {
            return;
        }
        this.trackInsideCornerSize = cornerSize;
        this.invalidate();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility != 0) {
            ViewOverlayImpl contentViewOverlay = ViewUtils.getContentViewOverlay(this);
            if (contentViewOverlay == null) {
                return;
            }
            for (TooltipDrawable label : this.labels) {
                contentViewOverlay.remove(label);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setLayerType(enabled ? 0 : 2, null);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnScrollChangedListener(this.onScrollChangedListener);
        for (TooltipDrawable label : this.labels) {
            this.attachLabelToContentView(label);
        }
    }

    private void attachLabelToContentView(TooltipDrawable label) {
        label.setRelativeToView((View)ViewUtils.getContentView(this));
    }

    protected void onDetachedFromWindow() {
        if (this.accessibilityEventSender != null) {
            this.removeCallbacks(this.accessibilityEventSender);
        }
        this.labelsAreAnimatedIn = false;
        for (TooltipDrawable label : this.labels) {
            this.detachLabelFromContentView(label);
        }
        this.getViewTreeObserver().removeOnScrollChangedListener(this.onScrollChangedListener);
        super.onDetachedFromWindow();
    }

    private void detachLabelFromContentView(TooltipDrawable label) {
        ViewOverlayImpl contentViewOverlay = ViewUtils.getContentViewOverlay(this);
        if (contentViewOverlay != null) {
            contentViewOverlay.remove(label);
            label.detachView((View)ViewUtils.getContentView(this));
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)(this.widgetHeight + (this.labelBehavior == 1 || this.shouldAlwaysShowLabel() ? this.labels.get(0).getIntrinsicHeight() : 0)), (int)0x40000000));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateTrackWidth(w);
        this.updateHaloHotspot();
    }

    private void maybeCalculateTicksCoordinates() {
        if (this.stepSize <= 0.0f) {
            return;
        }
        this.validateConfigurationIfDirty();
        int tickCount = (int)((this.valueTo - this.valueFrom) / this.stepSize + 1.0f);
        tickCount = Math.min(tickCount, this.trackWidth / this.minTickSpacing + 1);
        if (this.ticksCoordinates == null || this.ticksCoordinates.length != tickCount * 2) {
            this.ticksCoordinates = new float[tickCount * 2];
        }
        float interval = (float)this.trackWidth / (float)(tickCount - 1);
        for (int i = 0; i < tickCount * 2; i += 2) {
            this.ticksCoordinates[i] = (float)this.trackSidePadding + (float)i / 2.0f * interval;
            this.ticksCoordinates[i + 1] = this.calculateTrackCenter();
        }
    }

    private void updateTrackWidth(int width) {
        this.trackWidth = Math.max(width - this.trackSidePadding * 2, 0);
        this.maybeCalculateTicksCoordinates();
    }

    private void updateHaloHotspot() {
        Drawable background;
        if (!this.shouldDrawCompatHalo() && this.getMeasuredWidth() > 0 && (background = this.getBackground()) instanceof RippleDrawable) {
            int x = (int)(this.normalizeValue(this.values.get(this.focusedThumbIdx).floatValue()) * (float)this.trackWidth + (float)this.trackSidePadding);
            int y = this.calculateTrackCenter();
            DrawableCompat.setHotspotBounds((Drawable)background, (int)(x - this.haloRadius), (int)(y - this.haloRadius), (int)(x + this.haloRadius), (int)(y + this.haloRadius));
        }
    }

    private int calculateTrackCenter() {
        return this.widgetHeight / 2 + (this.labelBehavior == 1 || this.shouldAlwaysShowLabel() ? this.labels.get(0).getIntrinsicHeight() : 0);
    }

    protected void onDraw(@NonNull Canvas canvas) {
        if (this.dirtyConfig) {
            this.validateConfigurationIfDirty();
            this.maybeCalculateTicksCoordinates();
        }
        super.onDraw(canvas);
        int yCenter = this.calculateTrackCenter();
        float first = this.values.get(0).floatValue();
        float last = this.values.get(this.values.size() - 1).floatValue();
        if (last < this.valueTo || this.values.size() > 1 && first > this.valueFrom) {
            this.drawInactiveTrack(canvas, this.trackWidth, yCenter);
        }
        if (last > this.valueFrom) {
            this.drawActiveTrack(canvas, this.trackWidth, yCenter);
        }
        this.maybeDrawTicks(canvas);
        this.maybeDrawStopIndicator(canvas, yCenter);
        if ((this.thumbIsPressed || this.isFocused()) && this.isEnabled()) {
            this.maybeDrawCompatHalo(canvas, this.trackWidth, yCenter);
        }
        this.updateLabels();
        this.drawThumbs(canvas, this.trackWidth, yCenter);
    }

    private float[] getActiveRange() {
        float[] fArray;
        float min = this.values.get(0).floatValue();
        float max = this.values.get(this.values.size() - 1).floatValue();
        float left = this.normalizeValue(this.values.size() == 1 ? this.valueFrom : min);
        float right = this.normalizeValue(max);
        if (this.isRtl()) {
            float[] fArray2 = new float[2];
            fArray2[0] = right;
            fArray = fArray2;
            fArray2[1] = left;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = left;
            fArray = fArray3;
            fArray3[1] = right;
        }
        return fArray;
    }

    private void drawInactiveTrack(@NonNull Canvas canvas, int width, int yCenter) {
        float left;
        float[] activeRange = this.getActiveRange();
        float right = (float)this.trackSidePadding + activeRange[1] * (float)width;
        if (right < (float)(this.trackSidePadding + width)) {
            if (this.hasGapBetweenThumbAndTrack()) {
                this.trackRect.set(right + (float)this.thumbTrackGapSize, (float)yCenter - (float)this.trackHeight / 2.0f, (float)(this.trackSidePadding + width) + (float)this.trackHeight / 2.0f, (float)yCenter + (float)this.trackHeight / 2.0f);
                this.updateTrack(canvas, this.inactiveTrackPaint, this.trackRect, FullCornerDirection.RIGHT);
            } else {
                this.inactiveTrackPaint.setStyle(Paint.Style.STROKE);
                this.inactiveTrackPaint.setStrokeCap(Paint.Cap.ROUND);
                canvas.drawLine(right, (float)yCenter, (float)(this.trackSidePadding + width), (float)yCenter, this.inactiveTrackPaint);
            }
        }
        if ((left = (float)this.trackSidePadding + activeRange[0] * (float)width) > (float)this.trackSidePadding) {
            if (this.hasGapBetweenThumbAndTrack()) {
                this.trackRect.set((float)this.trackSidePadding - (float)this.trackHeight / 2.0f, (float)yCenter - (float)this.trackHeight / 2.0f, left - (float)this.thumbTrackGapSize, (float)yCenter + (float)this.trackHeight / 2.0f);
                this.updateTrack(canvas, this.inactiveTrackPaint, this.trackRect, FullCornerDirection.LEFT);
            } else {
                this.inactiveTrackPaint.setStyle(Paint.Style.STROKE);
                this.inactiveTrackPaint.setStrokeCap(Paint.Cap.ROUND);
                canvas.drawLine((float)this.trackSidePadding, (float)yCenter, left, (float)yCenter, this.inactiveTrackPaint);
            }
        }
    }

    private float normalizeValue(float value) {
        float normalized = (value - this.valueFrom) / (this.valueTo - this.valueFrom);
        if (this.isRtl()) {
            return 1.0f - normalized;
        }
        return normalized;
    }

    private void drawActiveTrack(@NonNull Canvas canvas, int width, int yCenter) {
        float[] activeRange = this.getActiveRange();
        float right = (float)this.trackSidePadding + activeRange[1] * (float)width;
        float left = (float)this.trackSidePadding + activeRange[0] * (float)width;
        if (this.hasGapBetweenThumbAndTrack()) {
            FullCornerDirection direction = FullCornerDirection.NONE;
            if (this.values.size() == 1) {
                direction = this.isRtl() ? FullCornerDirection.RIGHT : FullCornerDirection.LEFT;
            }
            for (int i = 0; i < this.values.size(); ++i) {
                if (this.values.size() > 1) {
                    if (i > 0) {
                        left = this.valueToX(this.values.get(i - 1).floatValue());
                    }
                    right = this.valueToX(this.values.get(i).floatValue());
                    if (this.isRtl()) {
                        float temp = left;
                        left = right;
                        right = temp;
                    }
                }
                switch (direction) {
                    case NONE: {
                        left += (float)this.thumbTrackGapSize;
                        right -= (float)this.thumbTrackGapSize;
                        break;
                    }
                    case LEFT: {
                        left -= (float)this.trackHeight / 2.0f;
                        right -= (float)this.thumbTrackGapSize;
                        break;
                    }
                    case RIGHT: {
                        left += (float)this.thumbTrackGapSize;
                        right += (float)this.trackHeight / 2.0f;
                        break;
                    }
                }
                if (left >= right) continue;
                this.trackRect.set(left, (float)yCenter - (float)this.trackHeight / 2.0f, right, (float)yCenter + (float)this.trackHeight / 2.0f);
                this.updateTrack(canvas, this.activeTrackPaint, this.trackRect, direction);
            }
        } else {
            this.activeTrackPaint.setStyle(Paint.Style.STROKE);
            this.activeTrackPaint.setStrokeCap(Paint.Cap.ROUND);
            canvas.drawLine(left, (float)yCenter, right, (float)yCenter, this.activeTrackPaint);
        }
    }

    private boolean hasGapBetweenThumbAndTrack() {
        return this.thumbTrackGapSize > 0;
    }

    private void updateTrack(Canvas canvas, Paint paint, RectF bounds, FullCornerDirection direction) {
        float leftCornerSize = (float)this.trackHeight / 2.0f;
        float rightCornerSize = (float)this.trackHeight / 2.0f;
        switch (direction) {
            case BOTH: {
                break;
            }
            case LEFT: {
                rightCornerSize = this.trackInsideCornerSize;
                break;
            }
            case RIGHT: {
                leftCornerSize = this.trackInsideCornerSize;
                break;
            }
            case NONE: {
                leftCornerSize = this.trackInsideCornerSize;
                rightCornerSize = this.trackInsideCornerSize;
            }
        }
        paint.setStyle(Paint.Style.FILL);
        paint.setStrokeCap(Paint.Cap.BUTT);
        paint.setAntiAlias(true);
        this.trackPath.reset();
        if (bounds.width() >= leftCornerSize + rightCornerSize) {
            this.trackPath.addRoundRect(bounds, this.getCornerRadii(leftCornerSize, rightCornerSize), Path.Direction.CW);
            canvas.drawPath(this.trackPath, paint);
        } else {
            float minCornerSize = Math.min(leftCornerSize, rightCornerSize);
            float maxCornerSize = Math.max(leftCornerSize, rightCornerSize);
            canvas.save();
            this.trackPath.addRoundRect(bounds, minCornerSize, minCornerSize, Path.Direction.CW);
            canvas.clipPath(this.trackPath);
            switch (direction) {
                case LEFT: {
                    this.cornerRect.set(bounds.left, bounds.top, bounds.left + 2.0f * maxCornerSize, bounds.bottom);
                    break;
                }
                case RIGHT: {
                    this.cornerRect.set(bounds.right - 2.0f * maxCornerSize, bounds.top, bounds.right, bounds.bottom);
                    break;
                }
                default: {
                    this.cornerRect.set(bounds.centerX() - maxCornerSize, bounds.top, bounds.centerX() + maxCornerSize, bounds.bottom);
                }
            }
            canvas.drawRoundRect(this.cornerRect, maxCornerSize, maxCornerSize, paint);
            canvas.restore();
        }
    }

    private float[] getCornerRadii(float leftSide, float rightSide) {
        return new float[]{leftSide, leftSide, rightSide, rightSide, rightSide, rightSide, leftSide, leftSide};
    }

    private void maybeDrawTicks(@NonNull Canvas canvas) {
        if (!this.tickVisible || this.stepSize <= 0.0f) {
            return;
        }
        float[] activeRange = this.getActiveRange();
        int leftActiveTickIndex = (int)Math.ceil(activeRange[0] * ((float)this.ticksCoordinates.length / 2.0f - 1.0f));
        int rightActiveTickIndex = (int)Math.floor(activeRange[1] * ((float)this.ticksCoordinates.length / 2.0f - 1.0f));
        if (leftActiveTickIndex > 0) {
            canvas.drawPoints(this.ticksCoordinates, 0, leftActiveTickIndex * 2, this.inactiveTicksPaint);
        }
        if (leftActiveTickIndex <= rightActiveTickIndex) {
            canvas.drawPoints(this.ticksCoordinates, leftActiveTickIndex * 2, (rightActiveTickIndex - leftActiveTickIndex + 1) * 2, this.activeTicksPaint);
        }
        if ((rightActiveTickIndex + 1) * 2 < this.ticksCoordinates.length) {
            canvas.drawPoints(this.ticksCoordinates, (rightActiveTickIndex + 1) * 2, this.ticksCoordinates.length - (rightActiveTickIndex + 1) * 2, this.inactiveTicksPaint);
        }
    }

    private void maybeDrawStopIndicator(@NonNull Canvas canvas, int yCenter) {
        if (this.trackStopIndicatorSize <= 0) {
            return;
        }
        if (this.values.size() >= 1 && this.values.get(this.values.size() - 1).floatValue() < this.valueTo) {
            canvas.drawPoint(this.valueToX(this.valueTo), (float)yCenter, this.stopIndicatorPaint);
        }
        if (this.values.size() > 1 && this.values.get(0).floatValue() > this.valueFrom) {
            canvas.drawPoint(this.valueToX(this.valueFrom), (float)yCenter, this.stopIndicatorPaint);
        }
    }

    private void drawThumbs(@NonNull Canvas canvas, int width, int yCenter) {
        for (int i = 0; i < this.values.size(); ++i) {
            float value = this.values.get(i).floatValue();
            if (this.customThumbDrawable != null) {
                this.drawThumbDrawable(canvas, width, yCenter, value, this.customThumbDrawable);
                continue;
            }
            if (i < this.customThumbDrawablesForValues.size()) {
                this.drawThumbDrawable(canvas, width, yCenter, value, this.customThumbDrawablesForValues.get(i));
                continue;
            }
            if (!this.isEnabled()) {
                canvas.drawCircle((float)this.trackSidePadding + this.normalizeValue(value) * (float)width, (float)yCenter, (float)this.getThumbRadius(), this.thumbPaint);
            }
            this.drawThumbDrawable(canvas, width, yCenter, value, this.defaultThumbDrawable);
        }
    }

    private void drawThumbDrawable(@NonNull Canvas canvas, int width, int top, float value, @NonNull Drawable thumbDrawable) {
        canvas.save();
        canvas.translate((float)(this.trackSidePadding + (int)(this.normalizeValue(value) * (float)width)) - (float)thumbDrawable.getBounds().width() / 2.0f, (float)top - (float)thumbDrawable.getBounds().height() / 2.0f);
        thumbDrawable.draw(canvas);
        canvas.restore();
    }

    private void maybeDrawCompatHalo(@NonNull Canvas canvas, int width, int top) {
        if (this.shouldDrawCompatHalo()) {
            int centerX = (int)((float)this.trackSidePadding + this.normalizeValue(this.values.get(this.focusedThumbIdx).floatValue()) * (float)width);
            if (Build.VERSION.SDK_INT < 28) {
                canvas.clipRect((float)(centerX - this.haloRadius), (float)(top - this.haloRadius), (float)(centerX + this.haloRadius), (float)(top + this.haloRadius), Region.Op.UNION);
            }
            canvas.drawCircle((float)centerX, (float)top, (float)this.haloRadius, this.haloPaint);
        }
    }

    private boolean shouldDrawCompatHalo() {
        return this.forceDrawCompatHalo || Build.VERSION.SDK_INT < 21 || !(this.getBackground() instanceof RippleDrawable);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        float x = event.getX();
        this.touchPosition = (x - (float)this.trackSidePadding) / (float)this.trackWidth;
        this.touchPosition = Math.max(0.0f, this.touchPosition);
        this.touchPosition = Math.min(1.0f, this.touchPosition);
        switch (event.getActionMasked()) {
            case 0: {
                this.touchDownX = x;
                if (this.isPotentialVerticalScroll(event)) break;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                if (!this.pickActiveThumb()) break;
                this.requestFocus();
                this.thumbIsPressed = true;
                this.snapTouchPosition();
                this.updateHaloHotspot();
                if (this.hasGapBetweenThumbAndTrack()) {
                    this.defaultThumbWidth = this.thumbWidth;
                    this.defaultThumbTrackGapSize = this.thumbTrackGapSize;
                    int pressedThumbWidth = Math.round((float)this.thumbWidth * 0.5f);
                    int delta = this.thumbWidth - pressedThumbWidth;
                    this.setThumbWidth(pressedThumbWidth);
                    this.setThumbTrackGapSize(this.thumbTrackGapSize - delta / 2);
                }
                this.invalidate();
                this.onStartTrackingTouch();
                break;
            }
            case 2: {
                if (!this.thumbIsPressed) {
                    if (this.isPotentialVerticalScroll(event) && Math.abs(x - this.touchDownX) < (float)this.scaledTouchSlop) {
                        return false;
                    }
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                    this.onStartTrackingTouch();
                }
                if (!this.pickActiveThumb()) break;
                this.thumbIsPressed = true;
                this.snapTouchPosition();
                this.updateHaloHotspot();
                this.invalidate();
                break;
            }
            case 1: 
            case 3: {
                this.thumbIsPressed = false;
                if (this.lastEvent != null && this.lastEvent.getActionMasked() == 0 && Math.abs(this.lastEvent.getX() - event.getX()) <= (float)this.scaledTouchSlop && Math.abs(this.lastEvent.getY() - event.getY()) <= (float)this.scaledTouchSlop && this.pickActiveThumb()) {
                    this.onStartTrackingTouch();
                }
                if (this.activeThumbIdx != -1) {
                    this.snapTouchPosition();
                    this.updateHaloHotspot();
                    if (this.hasGapBetweenThumbAndTrack() && this.defaultThumbWidth != -1 && this.defaultThumbTrackGapSize != -1) {
                        this.setThumbWidth(this.defaultThumbWidth);
                        this.setThumbTrackGapSize(this.defaultThumbTrackGapSize);
                    }
                    this.activeThumbIdx = -1;
                    this.onStopTrackingTouch();
                }
                this.invalidate();
                break;
            }
        }
        this.setPressed(this.thumbIsPressed);
        this.lastEvent = MotionEvent.obtain((MotionEvent)event);
        return true;
    }

    private double snapPosition(float position) {
        if (this.stepSize > 0.0f) {
            int stepCount = (int)((this.valueTo - this.valueFrom) / this.stepSize);
            return (double)Math.round(position * (float)stepCount) / (double)stepCount;
        }
        return position;
    }

    protected boolean pickActiveThumb() {
        if (this.activeThumbIdx != -1) {
            return true;
        }
        float touchValue = this.getValueOfTouchPositionAbsolute();
        float touchX = this.valueToX(touchValue);
        this.activeThumbIdx = 0;
        float activeThumbDiff = Math.abs(this.values.get(this.activeThumbIdx).floatValue() - touchValue);
        for (int i = 1; i < this.values.size(); ++i) {
            boolean movingForward;
            float valueDiff = Math.abs(this.values.get(i).floatValue() - touchValue);
            float valueX = this.valueToX(this.values.get(i).floatValue());
            if (Float.compare(valueDiff, activeThumbDiff) > 0) break;
            boolean bl = this.isRtl() ? valueX - touchX > 0.0f : (movingForward = valueX - touchX < 0.0f);
            if (Float.compare(valueDiff, activeThumbDiff) < 0) {
                activeThumbDiff = valueDiff;
                this.activeThumbIdx = i;
                continue;
            }
            if (Float.compare(valueDiff, activeThumbDiff) != 0) continue;
            if (Math.abs(valueX - touchX) < (float)this.scaledTouchSlop) {
                this.activeThumbIdx = -1;
                return false;
            }
            if (!movingForward) continue;
            activeThumbDiff = valueDiff;
            this.activeThumbIdx = i;
        }
        return this.activeThumbIdx != -1;
    }

    private float getValueOfTouchPositionAbsolute() {
        float position = this.touchPosition;
        if (this.isRtl()) {
            position = 1.0f - position;
        }
        return position * (this.valueTo - this.valueFrom) + this.valueFrom;
    }

    private boolean snapTouchPosition() {
        return this.snapActiveThumbToValue(this.getValueOfTouchPosition());
    }

    private boolean snapActiveThumbToValue(float value) {
        return this.snapThumbToValue(this.activeThumbIdx, value);
    }

    private boolean snapThumbToValue(int idx, float value) {
        this.focusedThumbIdx = idx;
        if ((double)Math.abs(value - this.values.get(idx).floatValue()) < 1.0E-4) {
            return false;
        }
        float newValue = this.getClampedValue(idx, value);
        this.values.set(idx, Float.valueOf(newValue));
        this.dispatchOnChangedFromUser(idx);
        return true;
    }

    private float getClampedValue(int idx, float value) {
        float minSeparation = this.getMinSeparation();
        float f = minSeparation = this.separationUnit == 0 ? this.dimenToValue(minSeparation) : minSeparation;
        if (this.isRtl()) {
            minSeparation = -minSeparation;
        }
        float upperBound = idx + 1 >= this.values.size() ? this.valueTo : this.values.get(idx + 1).floatValue() - minSeparation;
        float lowerBound = idx - 1 < 0 ? this.valueFrom : this.values.get(idx - 1).floatValue() + minSeparation;
        return MathUtils.clamp((float)value, (float)lowerBound, (float)upperBound);
    }

    private float dimenToValue(float dimen2) {
        if (dimen2 == 0.0f) {
            return 0.0f;
        }
        return (dimen2 - (float)this.trackSidePadding) / (float)this.trackWidth * (this.valueFrom - this.valueTo) + this.valueFrom;
    }

    protected void setSeparationUnit(int separationUnit) {
        this.separationUnit = separationUnit;
        this.dirtyConfig = true;
        this.postInvalidate();
    }

    protected float getMinSeparation() {
        return 0.0f;
    }

    private float getValueOfTouchPosition() {
        double position = this.snapPosition(this.touchPosition);
        if (this.isRtl()) {
            position = 1.0 - position;
        }
        return (float)(position * (double)(this.valueTo - this.valueFrom) + (double)this.valueFrom);
    }

    private float valueToX(float value) {
        return this.normalizeValue(value) * (float)this.trackWidth + (float)this.trackSidePadding;
    }

    private static float getAnimatorCurrentValueOrDefault(ValueAnimator animator2, float defaultValue) {
        if (animator2 != null && animator2.isRunning()) {
            float value = ((Float)animator2.getAnimatedValue()).floatValue();
            animator2.cancel();
            return value;
        }
        return defaultValue;
    }

    private ValueAnimator createLabelAnimator(boolean enter) {
        TimeInterpolator interpolator;
        int duration;
        float startFraction = enter ? 0.0f : 1.0f;
        startFraction = BaseSlider.getAnimatorCurrentValueOrDefault(enter ? this.labelsOutAnimator : this.labelsInAnimator, startFraction);
        float endFraction = enter ? 1.0f : 0.0f;
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{startFraction, endFraction});
        if (enter) {
            duration = MotionUtils.resolveThemeDuration(this.getContext(), LABEL_ANIMATION_ENTER_DURATION_ATTR, 83);
            interpolator = MotionUtils.resolveThemeInterpolator(this.getContext(), LABEL_ANIMATION_ENTER_EASING_ATTR, AnimationUtils.DECELERATE_INTERPOLATOR);
        } else {
            duration = MotionUtils.resolveThemeDuration(this.getContext(), LABEL_ANIMATION_EXIT_DURATION_ATTR, 117);
            interpolator = MotionUtils.resolveThemeInterpolator(this.getContext(), LABEL_ANIMATION_EXIT_EASING_ATTR, AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR);
        }
        animator2.setDuration((long)duration);
        animator2.setInterpolator(interpolator);
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float fraction = ((Float)animation.getAnimatedValue()).floatValue();
                for (TooltipDrawable label : BaseSlider.this.labels) {
                    label.setRevealFraction(fraction);
                }
                ViewCompat.postInvalidateOnAnimation((View)BaseSlider.this);
            }
        });
        return animator2;
    }

    private void updateLabels() {
        switch (this.labelBehavior) {
            case 2: {
                this.ensureLabelsRemoved();
                break;
            }
            case 3: {
                if (this.isEnabled() && this.isSliderVisibleOnScreen()) {
                    this.ensureLabelsAdded();
                    break;
                }
                this.ensureLabelsRemoved();
                break;
            }
            case 0: 
            case 1: {
                if (this.activeThumbIdx != -1 && this.isEnabled()) {
                    this.ensureLabelsAdded();
                    break;
                }
                this.ensureLabelsRemoved();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected labelBehavior: " + this.labelBehavior);
            }
        }
    }

    private boolean isSliderVisibleOnScreen() {
        Rect contentViewBounds = new Rect();
        ViewUtils.getContentView(this).getHitRect(contentViewBounds);
        return this.getLocalVisibleRect(contentViewBounds);
    }

    private void ensureLabelsRemoved() {
        if (this.labelsAreAnimatedIn) {
            this.labelsAreAnimatedIn = false;
            this.labelsOutAnimator = this.createLabelAnimator(false);
            this.labelsInAnimator = null;
            this.labelsOutAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    ViewOverlayImpl contentViewOverlay = ViewUtils.getContentViewOverlay(BaseSlider.this);
                    for (TooltipDrawable label : BaseSlider.this.labels) {
                        contentViewOverlay.remove(label);
                    }
                }
            });
            this.labelsOutAnimator.start();
        }
    }

    private void ensureLabelsAdded() {
        if (!this.labelsAreAnimatedIn) {
            this.labelsAreAnimatedIn = true;
            this.labelsInAnimator = this.createLabelAnimator(true);
            this.labelsOutAnimator = null;
            this.labelsInAnimator.start();
        }
        Iterator<TooltipDrawable> labelItr = this.labels.iterator();
        for (int i = 0; i < this.values.size() && labelItr.hasNext(); ++i) {
            if (i == this.focusedThumbIdx) continue;
            this.setValueForLabel(labelItr.next(), this.values.get(i).floatValue());
        }
        if (!labelItr.hasNext()) {
            throw new IllegalStateException(String.format("Not enough labels(%d) to display all the values(%d)", this.labels.size(), this.values.size()));
        }
        this.setValueForLabel(labelItr.next(), this.values.get(this.focusedThumbIdx).floatValue());
    }

    private String formatValue(float value) {
        if (this.hasLabelFormatter()) {
            return this.formatter.getFormattedValue(value);
        }
        return String.format((float)((int)value) == value ? "%.0f" : "%.2f", Float.valueOf(value));
    }

    private void setValueForLabel(TooltipDrawable label, float value) {
        label.setText(this.formatValue(value));
        this.positionLabel(label, value);
        ViewUtils.getContentViewOverlay(this).add(label);
    }

    private void positionLabel(TooltipDrawable label, float value) {
        int left = this.trackSidePadding + (int)(this.normalizeValue(value) * (float)this.trackWidth) - label.getIntrinsicWidth() / 2;
        int top = this.calculateTrackCenter() - (this.labelPadding + this.thumbHeight / 2);
        label.setBounds(left, top - label.getIntrinsicHeight(), left + label.getIntrinsicWidth(), top);
        Rect rect = new Rect(label.getBounds());
        DescendantOffsetUtils.offsetDescendantRect(ViewUtils.getContentView(this), this, rect);
        label.setBounds(rect);
    }

    private void invalidateTrack() {
        this.inactiveTrackPaint.setStrokeWidth((float)this.trackHeight);
        this.activeTrackPaint.setStrokeWidth((float)this.trackHeight);
    }

    private boolean isInVerticalScrollingContainer() {
        ViewParent p = this.getParent();
        while (p instanceof ViewGroup) {
            boolean canScrollVertically;
            ViewGroup parent = (ViewGroup)p;
            boolean bl = canScrollVertically = parent.canScrollVertically(1) || parent.canScrollVertically(-1);
            if (canScrollVertically && parent.shouldDelayChildPressedState()) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    private static boolean isMouseEvent(MotionEvent event) {
        return event.getToolType(0) == 3;
    }

    private boolean isPotentialVerticalScroll(MotionEvent event) {
        return !BaseSlider.isMouseEvent(event) && this.isInVerticalScrollingContainer();
    }

    private void dispatchOnChangedProgrammatically() {
        for (BaseOnChangeListener listener : this.changeListeners) {
            for (Float value : this.values) {
                listener.onValueChange(this, value.floatValue(), false);
            }
        }
    }

    private void dispatchOnChangedFromUser(int idx) {
        for (BaseOnChangeListener listener : this.changeListeners) {
            listener.onValueChange(this, this.values.get(idx).floatValue(), true);
        }
        if (this.accessibilityManager != null && this.accessibilityManager.isEnabled()) {
            this.scheduleAccessibilityEventSender(idx);
        }
    }

    private void onStartTrackingTouch() {
        for (BaseOnSliderTouchListener listener : this.touchListeners) {
            listener.onStartTrackingTouch(this);
        }
    }

    private void onStopTrackingTouch() {
        for (BaseOnSliderTouchListener listener : this.touchListeners) {
            listener.onStopTrackingTouch(this);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.inactiveTrackPaint.setColor(this.getColorForState(this.trackColorInactive));
        this.activeTrackPaint.setColor(this.getColorForState(this.trackColorActive));
        this.inactiveTicksPaint.setColor(this.getColorForState(this.tickColorInactive));
        this.activeTicksPaint.setColor(this.getColorForState(this.tickColorActive));
        this.stopIndicatorPaint.setColor(this.getColorForState(this.trackColorActive));
        for (TooltipDrawable label : this.labels) {
            if (!label.isStateful()) continue;
            label.setState(this.getDrawableState());
        }
        if (this.defaultThumbDrawable.isStateful()) {
            this.defaultThumbDrawable.setState(this.getDrawableState());
        }
        this.haloPaint.setColor(this.getColorForState(this.haloColor));
        this.haloPaint.setAlpha(63);
    }

    @ColorInt
    private int getColorForState(@NonNull ColorStateList colorStateList) {
        return colorStateList.getColorForState(this.getDrawableState(), colorStateList.getDefaultColor());
    }

    @VisibleForTesting
    void forceDrawCompatHalo(boolean force) {
        this.forceDrawCompatHalo = force;
    }

    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        if (!this.isEnabled()) {
            return super.onKeyDown(keyCode, event);
        }
        if (this.values.size() == 1) {
            this.activeThumbIdx = 0;
        }
        if (this.activeThumbIdx == -1) {
            Boolean handled = this.onKeyDownNoActiveThumb(keyCode, event);
            return handled != null ? handled.booleanValue() : super.onKeyDown(keyCode, event);
        }
        this.isLongPress |= event.isLongPress();
        Float increment = this.calculateIncrementForKey(keyCode);
        if (increment != null) {
            if (this.snapActiveThumbToValue(this.values.get(this.activeThumbIdx).floatValue() + increment.floatValue())) {
                this.updateHaloHotspot();
                this.postInvalidate();
            }
            return true;
        }
        switch (keyCode) {
            case 61: {
                if (event.hasNoModifiers()) {
                    return this.moveFocus(1);
                }
                if (event.isShiftPressed()) {
                    return this.moveFocus(-1);
                }
                return false;
            }
            case 23: 
            case 66: {
                this.activeThumbIdx = -1;
                this.postInvalidate();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    @Nullable
    private Boolean onKeyDownNoActiveThumb(int keyCode, @NonNull KeyEvent event) {
        switch (keyCode) {
            case 61: {
                if (event.hasNoModifiers()) {
                    return this.moveFocus(1);
                }
                if (event.isShiftPressed()) {
                    return this.moveFocus(-1);
                }
                return false;
            }
            case 21: {
                this.moveFocusInAbsoluteDirection(-1);
                return true;
            }
            case 69: {
                this.moveFocus(-1);
                return true;
            }
            case 22: {
                this.moveFocusInAbsoluteDirection(1);
                return true;
            }
            case 70: 
            case 81: {
                this.moveFocus(1);
                return true;
            }
            case 23: 
            case 66: {
                this.activeThumbIdx = this.focusedThumbIdx;
                this.postInvalidate();
                return true;
            }
        }
        return null;
    }

    public boolean onKeyUp(int keyCode, @NonNull KeyEvent event) {
        this.isLongPress = false;
        return super.onKeyUp(keyCode, event);
    }

    final boolean isRtl() {
        return ViewCompat.getLayoutDirection((View)this) == 1;
    }

    private boolean moveFocus(int direction) {
        int oldFocusedThumbIdx = this.focusedThumbIdx;
        long newFocusedThumbIdx = (long)oldFocusedThumbIdx + (long)direction;
        this.focusedThumbIdx = (int)MathUtils.clamp((long)newFocusedThumbIdx, (long)0L, (long)(this.values.size() - 1));
        if (this.focusedThumbIdx == oldFocusedThumbIdx) {
            return false;
        }
        if (this.activeThumbIdx != -1) {
            this.activeThumbIdx = this.focusedThumbIdx;
        }
        this.updateHaloHotspot();
        this.postInvalidate();
        return true;
    }

    private boolean moveFocusInAbsoluteDirection(int direction) {
        if (this.isRtl()) {
            direction = direction == Integer.MIN_VALUE ? Integer.MAX_VALUE : -direction;
        }
        return this.moveFocus(direction);
    }

    @Nullable
    private Float calculateIncrementForKey(int keyCode) {
        float increment = this.isLongPress ? this.calculateStepIncrement(20) : this.calculateStepIncrement();
        switch (keyCode) {
            case 21: {
                return Float.valueOf(this.isRtl() ? increment : -increment);
            }
            case 22: {
                return Float.valueOf(this.isRtl() ? -increment : increment);
            }
            case 69: {
                return Float.valueOf(-increment);
            }
            case 70: 
            case 81: {
                return Float.valueOf(increment);
            }
        }
        return null;
    }

    private float calculateStepIncrement() {
        return this.stepSize == 0.0f ? 1.0f : this.stepSize;
    }

    private float calculateStepIncrement(int stepFactor) {
        float increment = this.calculateStepIncrement();
        float numSteps = (this.valueTo - this.valueFrom) / increment;
        if (numSteps <= (float)stepFactor) {
            return increment;
        }
        return (float)Math.round(numSteps / (float)stepFactor) * increment;
    }

    protected void onFocusChanged(boolean gainFocus, int direction, @Nullable Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (!gainFocus) {
            this.activeThumbIdx = -1;
            this.accessibilityHelper.clearKeyboardFocusForVirtualView(this.focusedThumbIdx);
        } else {
            this.focusThumbOnFocusGained(direction);
            this.accessibilityHelper.requestKeyboardFocusForVirtualView(this.focusedThumbIdx);
        }
    }

    private void focusThumbOnFocusGained(int direction) {
        switch (direction) {
            case 1: {
                this.moveFocus(Integer.MAX_VALUE);
                break;
            }
            case 17: {
                this.moveFocusInAbsoluteDirection(Integer.MAX_VALUE);
                break;
            }
            case 2: {
                this.moveFocus(Integer.MIN_VALUE);
                break;
            }
            case 66: {
                this.moveFocusInAbsoluteDirection(Integer.MIN_VALUE);
                break;
            }
        }
    }

    @VisibleForTesting
    final int getAccessibilityFocusedVirtualViewId() {
        return this.accessibilityHelper.getAccessibilityFocusedVirtualViewId();
    }

    @NonNull
    public CharSequence getAccessibilityClassName() {
        return SeekBar.class.getName();
    }

    public boolean dispatchHoverEvent(@NonNull MotionEvent event) {
        return this.accessibilityHelper.dispatchHoverEvent(event) || super.dispatchHoverEvent(event);
    }

    public boolean dispatchKeyEvent(@NonNull KeyEvent event) {
        return super.dispatchKeyEvent(event);
    }

    private void scheduleAccessibilityEventSender(int idx) {
        if (this.accessibilityEventSender == null) {
            this.accessibilityEventSender = new AccessibilityEventSender();
        } else {
            this.removeCallbacks(this.accessibilityEventSender);
        }
        this.accessibilityEventSender.setVirtualViewId(idx);
        this.postDelayed(this.accessibilityEventSender, 200L);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SliderState sliderState = new SliderState(superState);
        sliderState.valueFrom = this.valueFrom;
        sliderState.valueTo = this.valueTo;
        sliderState.values = new ArrayList<Float>(this.values);
        sliderState.stepSize = this.stepSize;
        sliderState.hasFocus = this.hasFocus();
        return sliderState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SliderState sliderState = (SliderState)state;
        super.onRestoreInstanceState(sliderState.getSuperState());
        this.valueFrom = sliderState.valueFrom;
        this.valueTo = sliderState.valueTo;
        this.setValuesInternal(sliderState.values);
        this.stepSize = sliderState.stepSize;
        if (sliderState.hasFocus) {
            this.requestFocus();
        }
    }

    void updateBoundsForVirtualViewId(int virtualViewId, Rect virtualViewBounds) {
        int x = this.trackSidePadding + (int)(this.normalizeValue(this.getValues().get(virtualViewId).floatValue()) * (float)this.trackWidth);
        int y = this.calculateTrackCenter();
        int touchTargetOffsetX = Math.max(this.thumbWidth / 2, this.minTouchTargetSize / 2);
        int touchTargetOffsetY = Math.max(this.thumbHeight / 2, this.minTouchTargetSize / 2);
        virtualViewBounds.set(x - touchTargetOffsetX, y - touchTargetOffsetY, x + touchTargetOffsetX, y + touchTargetOffsetY);
    }

    private static class AccessibilityHelper
    extends ExploreByTouchHelper {
        private final BaseSlider<?, ?, ?> slider;
        final Rect virtualViewBounds = new Rect();

        AccessibilityHelper(BaseSlider<?, ?, ?> slider) {
            super(slider);
            this.slider = slider;
        }

        protected int getVirtualViewAt(float x, float y) {
            for (int i = 0; i < this.slider.getValues().size(); ++i) {
                this.slider.updateBoundsForVirtualViewId(i, this.virtualViewBounds);
                if (!this.virtualViewBounds.contains((int)x, (int)y)) continue;
                return i;
            }
            return -1;
        }

        protected void getVisibleVirtualViews(List<Integer> virtualViewIds) {
            for (int i = 0; i < this.slider.getValues().size(); ++i) {
                virtualViewIds.add(i);
            }
        }

        protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfoCompat info) {
            info.addAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SET_PROGRESS);
            List<Float> values = this.slider.getValues();
            float value = values.get(virtualViewId).floatValue();
            float valueFrom = this.slider.getValueFrom();
            float valueTo = this.slider.getValueTo();
            if (this.slider.isEnabled()) {
                if (value > valueFrom) {
                    info.addAction(8192);
                }
                if (value < valueTo) {
                    info.addAction(4096);
                }
            }
            info.setRangeInfo(AccessibilityNodeInfoCompat.RangeInfoCompat.obtain((int)1, (float)valueFrom, (float)valueTo, (float)value));
            info.setClassName((CharSequence)SeekBar.class.getName());
            StringBuilder contentDescription = new StringBuilder();
            if (this.slider.getContentDescription() != null) {
                contentDescription.append(this.slider.getContentDescription()).append(",");
            }
            String verbalValue = ((BaseSlider)this.slider).formatValue(value);
            String verbalValueType = this.slider.getContext().getString(R.string.material_slider_value);
            if (values.size() > 1) {
                verbalValueType = this.startOrEndDescription(virtualViewId);
            }
            contentDescription.append(String.format(Locale.US, "%s, %s", verbalValueType, verbalValue));
            info.setContentDescription((CharSequence)contentDescription.toString());
            this.slider.updateBoundsForVirtualViewId(virtualViewId, this.virtualViewBounds);
            info.setBoundsInParent(this.virtualViewBounds);
        }

        @NonNull
        private String startOrEndDescription(int virtualViewId) {
            List<Float> values = this.slider.getValues();
            if (virtualViewId == values.size() - 1) {
                return this.slider.getContext().getString(R.string.material_slider_range_end);
            }
            if (virtualViewId == 0) {
                return this.slider.getContext().getString(R.string.material_slider_range_start);
            }
            return "";
        }

        protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            if (!this.slider.isEnabled()) {
                return false;
            }
            switch (action) {
                case 16908349: {
                    if (arguments == null || !arguments.containsKey("android.view.accessibility.action.ARGUMENT_PROGRESS_VALUE")) {
                        return false;
                    }
                    float value = arguments.getFloat("android.view.accessibility.action.ARGUMENT_PROGRESS_VALUE");
                    if (((BaseSlider)this.slider).snapThumbToValue(virtualViewId, value)) {
                        ((BaseSlider)this.slider).updateHaloHotspot();
                        this.slider.postInvalidate();
                        this.invalidateVirtualView(virtualViewId);
                        return true;
                    }
                    return false;
                }
                case 4096: 
                case 8192: {
                    List<Float> values;
                    float clamped;
                    float increment = ((BaseSlider)this.slider).calculateStepIncrement(20);
                    if (action == 8192) {
                        increment = -increment;
                    }
                    if (this.slider.isRtl()) {
                        increment = -increment;
                    }
                    if (((BaseSlider)this.slider).snapThumbToValue(virtualViewId, clamped = MathUtils.clamp((float)((values = this.slider.getValues()).get(virtualViewId).floatValue() + increment), (float)this.slider.getValueFrom(), (float)this.slider.getValueTo()))) {
                        ((BaseSlider)this.slider).updateHaloHotspot();
                        this.slider.postInvalidate();
                        this.invalidateVirtualView(virtualViewId);
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
    }

    static class SliderState
    extends View.BaseSavedState {
        float valueFrom;
        float valueTo;
        ArrayList<Float> values;
        float stepSize;
        boolean hasFocus;
        public static final Parcelable.Creator<SliderState> CREATOR = new Parcelable.Creator<SliderState>(){

            @NonNull
            public SliderState createFromParcel(@NonNull Parcel source) {
                return new SliderState(source);
            }

            @NonNull
            public SliderState[] newArray(int size) {
                return new SliderState[size];
            }
        };

        SliderState(Parcelable superState) {
            super(superState);
        }

        private SliderState(@NonNull Parcel source) {
            super(source);
            this.valueFrom = source.readFloat();
            this.valueTo = source.readFloat();
            this.values = new ArrayList();
            source.readList(this.values, Float.class.getClassLoader());
            this.stepSize = source.readFloat();
            this.hasFocus = source.createBooleanArray()[0];
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeFloat(this.valueFrom);
            dest.writeFloat(this.valueTo);
            dest.writeList(this.values);
            dest.writeFloat(this.stepSize);
            boolean[] booleans = new boolean[]{this.hasFocus};
            dest.writeBooleanArray(booleans);
        }
    }

    private class AccessibilityEventSender
    implements Runnable {
        int virtualViewId = -1;

        private AccessibilityEventSender() {
        }

        void setVirtualViewId(int virtualViewId) {
            this.virtualViewId = virtualViewId;
        }

        @Override
        public void run() {
            BaseSlider.this.accessibilityHelper.sendEventForVirtualView(this.virtualViewId, 4);
        }
    }

    private static enum FullCornerDirection {
        BOTH,
        LEFT,
        RIGHT,
        NONE;

    }
}

