/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DimenRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.view.ViewCompat;
import androidx.core.widget.TextViewCompat;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.animation.AnimatorSetCompat;
import com.google.android.material.motion.MotionUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.textfield.TextInputLayout;
import java.util.ArrayList;
import java.util.List;

final class IndicatorViewController {
    private static final int DEFAULT_CAPTION_TRANSLATION_Y_ANIMATION_DURATION = 217;
    private static final int DEFAULT_CAPTION_FADE_ANIMATION_DURATION = 167;
    private final int captionTranslationYAnimationDuration;
    private final int captionFadeInAnimationDuration;
    private final int captionFadeOutAnimationDuration;
    @NonNull
    private final TimeInterpolator captionTranslationYAnimationInterpolator;
    @NonNull
    private final TimeInterpolator captionFadeInAnimationInterpolator;
    @NonNull
    private final TimeInterpolator captionFadeOutAnimationInterpolator;
    static final int ERROR_INDEX = 0;
    static final int HELPER_INDEX = 1;
    static final int COUNTER_INDEX = 2;
    private static final int CAPTION_STATE_NONE = 0;
    private static final int CAPTION_STATE_ERROR = 1;
    private static final int CAPTION_STATE_HELPER_TEXT = 2;
    private final Context context;
    @NonNull
    private final TextInputLayout textInputView;
    private LinearLayout indicatorArea;
    private int indicatorsAdded;
    private FrameLayout captionArea;
    @Nullable
    private Animator captionAnimator;
    private final float captionTranslationYPx;
    private int captionDisplayed;
    private int captionToShow;
    @Nullable
    private CharSequence errorText;
    private boolean errorEnabled;
    @Nullable
    private TextView errorView;
    @Nullable
    private CharSequence errorViewContentDescription;
    private int errorViewAccessibilityLiveRegion;
    private int errorTextAppearance;
    @Nullable
    private ColorStateList errorViewTextColor;
    private CharSequence helperText;
    private boolean helperTextEnabled;
    @Nullable
    private TextView helperTextView;
    private int helperTextTextAppearance;
    @Nullable
    private ColorStateList helperTextViewTextColor;
    private Typeface typeface;

    public IndicatorViewController(@NonNull TextInputLayout textInputView) {
        this.context = textInputView.getContext();
        this.textInputView = textInputView;
        this.captionTranslationYPx = this.context.getResources().getDimensionPixelSize(R.dimen.design_textinput_caption_translate_y);
        this.captionTranslationYAnimationDuration = MotionUtils.resolveThemeDuration(this.context, R.attr.motionDurationShort4, 217);
        this.captionFadeInAnimationDuration = MotionUtils.resolveThemeDuration(this.context, R.attr.motionDurationMedium4, 167);
        this.captionFadeOutAnimationDuration = MotionUtils.resolveThemeDuration(this.context, R.attr.motionDurationShort4, 167);
        this.captionTranslationYAnimationInterpolator = MotionUtils.resolveThemeInterpolator(this.context, R.attr.motionEasingEmphasizedDecelerateInterpolator, AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR);
        this.captionFadeInAnimationInterpolator = MotionUtils.resolveThemeInterpolator(this.context, R.attr.motionEasingEmphasizedDecelerateInterpolator, AnimationUtils.LINEAR_INTERPOLATOR);
        this.captionFadeOutAnimationInterpolator = MotionUtils.resolveThemeInterpolator(this.context, R.attr.motionEasingLinearInterpolator, AnimationUtils.LINEAR_INTERPOLATOR);
    }

    void showHelper(CharSequence helperText) {
        this.cancelCaptionAnimator();
        this.helperText = helperText;
        this.helperTextView.setText(helperText);
        if (this.captionDisplayed != 2) {
            this.captionToShow = 2;
        }
        this.updateCaptionViewsVisibility(this.captionDisplayed, this.captionToShow, this.shouldAnimateCaptionView(this.helperTextView, helperText));
    }

    void hideHelperText() {
        this.cancelCaptionAnimator();
        if (this.captionDisplayed == 2) {
            this.captionToShow = 0;
        }
        this.updateCaptionViewsVisibility(this.captionDisplayed, this.captionToShow, this.shouldAnimateCaptionView(this.helperTextView, ""));
    }

    void showError(CharSequence errorText) {
        this.cancelCaptionAnimator();
        this.errorText = errorText;
        this.errorView.setText(errorText);
        if (this.captionDisplayed != 1) {
            this.captionToShow = 1;
        }
        this.updateCaptionViewsVisibility(this.captionDisplayed, this.captionToShow, this.shouldAnimateCaptionView(this.errorView, errorText));
    }

    void hideError() {
        this.errorText = null;
        this.cancelCaptionAnimator();
        if (this.captionDisplayed == 1) {
            this.captionToShow = this.helperTextEnabled && !TextUtils.isEmpty((CharSequence)this.helperText) ? 2 : 0;
        }
        this.updateCaptionViewsVisibility(this.captionDisplayed, this.captionToShow, this.shouldAnimateCaptionView(this.errorView, ""));
    }

    private boolean shouldAnimateCaptionView(@Nullable TextView captionView, @NonNull CharSequence captionText) {
        return ViewCompat.isLaidOut((View)this.textInputView) && this.textInputView.isEnabled() && (this.captionToShow != this.captionDisplayed || captionView == null || !TextUtils.equals((CharSequence)captionView.getText(), (CharSequence)captionText));
    }

    private void updateCaptionViewsVisibility(final int captionToHide, final int captionToShow, boolean animate) {
        if (captionToHide == captionToShow) {
            return;
        }
        if (animate) {
            AnimatorSet captionAnimator = new AnimatorSet();
            this.captionAnimator = captionAnimator;
            ArrayList<Animator> captionAnimatorList = new ArrayList<Animator>();
            this.createCaptionAnimators(captionAnimatorList, this.helperTextEnabled, this.helperTextView, 2, captionToHide, captionToShow);
            this.createCaptionAnimators(captionAnimatorList, this.errorEnabled, this.errorView, 1, captionToHide, captionToShow);
            AnimatorSetCompat.playTogether(captionAnimator, captionAnimatorList);
            final TextView captionViewToHide = this.getCaptionViewFromDisplayState(captionToHide);
            final TextView captionViewToShow = this.getCaptionViewFromDisplayState(captionToShow);
            captionAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animator2) {
                    IndicatorViewController.this.captionDisplayed = captionToShow;
                    IndicatorViewController.this.captionAnimator = null;
                    if (captionViewToHide != null) {
                        captionViewToHide.setVisibility(4);
                        if (captionToHide == 1 && IndicatorViewController.this.errorView != null) {
                            IndicatorViewController.this.errorView.setText(null);
                        }
                    }
                    if (captionViewToShow != null) {
                        captionViewToShow.setTranslationY(0.0f);
                        captionViewToShow.setAlpha(1.0f);
                    }
                }

                public void onAnimationStart(Animator animator2) {
                    if (captionViewToShow != null) {
                        captionViewToShow.setVisibility(0);
                        captionViewToShow.setAlpha(0.0f);
                    }
                }
            });
            captionAnimator.start();
        } else {
            this.setCaptionViewVisibilities(captionToHide, captionToShow);
        }
        this.textInputView.updateEditTextBackground();
        this.textInputView.updateLabelState(animate);
        this.textInputView.updateTextInputBoxState();
    }

    private void setCaptionViewVisibilities(int captionToHide, int captionToShow) {
        TextView captionViewDisplayed;
        TextView captionViewToShow;
        if (captionToHide == captionToShow) {
            return;
        }
        if (captionToShow != 0 && (captionViewToShow = this.getCaptionViewFromDisplayState(captionToShow)) != null) {
            captionViewToShow.setVisibility(0);
            captionViewToShow.setAlpha(1.0f);
        }
        if (captionToHide != 0 && (captionViewDisplayed = this.getCaptionViewFromDisplayState(captionToHide)) != null) {
            captionViewDisplayed.setVisibility(4);
            if (captionToHide == 1) {
                captionViewDisplayed.setText(null);
            }
        }
        this.captionDisplayed = captionToShow;
    }

    private void createCaptionAnimators(@NonNull List<Animator> captionAnimatorList, boolean captionEnabled, @Nullable TextView captionView, int captionState, int captionToHide, int captionToShow) {
        boolean shouldShowOrHide;
        if (captionView == null || !captionEnabled) {
            return;
        }
        boolean bl = shouldShowOrHide = captionState == captionToShow || captionState == captionToHide;
        if (shouldShowOrHide) {
            boolean enableShowAnimation;
            ObjectAnimator animator2 = this.createCaptionOpacityAnimator(captionView, captionToShow == captionState);
            boolean bl2 = enableShowAnimation = captionState == captionToShow && captionToHide != 0;
            if (enableShowAnimation) {
                animator2.setStartDelay((long)this.captionFadeOutAnimationDuration);
            }
            captionAnimatorList.add((Animator)animator2);
            if (captionToShow == captionState && captionToHide != 0) {
                ObjectAnimator translationYAnimator = this.createCaptionTranslationYAnimator(captionView);
                translationYAnimator.setStartDelay((long)this.captionFadeOutAnimationDuration);
                captionAnimatorList.add((Animator)translationYAnimator);
            }
        }
    }

    private ObjectAnimator createCaptionOpacityAnimator(TextView captionView, boolean display) {
        float endValue = display ? 1.0f : 0.0f;
        ObjectAnimator opacityAnimator = ObjectAnimator.ofFloat((Object)captionView, (Property)View.ALPHA, (float[])new float[]{endValue});
        opacityAnimator.setDuration(display ? (long)this.captionFadeInAnimationDuration : (long)this.captionFadeOutAnimationDuration);
        opacityAnimator.setInterpolator(display ? this.captionFadeInAnimationInterpolator : this.captionFadeOutAnimationInterpolator);
        return opacityAnimator;
    }

    private ObjectAnimator createCaptionTranslationYAnimator(TextView captionView) {
        ObjectAnimator translationYAnimator = ObjectAnimator.ofFloat((Object)captionView, (Property)View.TRANSLATION_Y, (float[])new float[]{-this.captionTranslationYPx, 0.0f});
        translationYAnimator.setDuration((long)this.captionTranslationYAnimationDuration);
        translationYAnimator.setInterpolator(this.captionTranslationYAnimationInterpolator);
        return translationYAnimator;
    }

    void cancelCaptionAnimator() {
        if (this.captionAnimator != null) {
            this.captionAnimator.cancel();
        }
    }

    boolean isCaptionView(int index) {
        return index == 0 || index == 1;
    }

    @Nullable
    private TextView getCaptionViewFromDisplayState(int captionDisplayState) {
        switch (captionDisplayState) {
            case 1: {
                return this.errorView;
            }
            case 2: {
                return this.helperTextView;
            }
        }
        return null;
    }

    void adjustIndicatorPadding() {
        if (this.canAdjustIndicatorPadding()) {
            EditText editText = this.textInputView.getEditText();
            boolean isFontScaleLarge = MaterialResources.isFontScaleAtLeast1_3(this.context);
            ViewCompat.setPaddingRelative((View)this.indicatorArea, (int)this.getIndicatorPadding(isFontScaleLarge, R.dimen.material_helper_text_font_1_3_padding_horizontal, ViewCompat.getPaddingStart((View)editText)), (int)this.getIndicatorPadding(isFontScaleLarge, R.dimen.material_helper_text_font_1_3_padding_top, this.context.getResources().getDimensionPixelSize(R.dimen.material_helper_text_default_padding_top)), (int)this.getIndicatorPadding(isFontScaleLarge, R.dimen.material_helper_text_font_1_3_padding_horizontal, ViewCompat.getPaddingEnd((View)editText)), (int)0);
        }
    }

    private boolean canAdjustIndicatorPadding() {
        return this.indicatorArea != null && this.textInputView.getEditText() != null;
    }

    private int getIndicatorPadding(boolean isFontScaleLarge, @DimenRes int largeFontPaddingRes, int defaultPadding) {
        return isFontScaleLarge ? this.context.getResources().getDimensionPixelSize(largeFontPaddingRes) : defaultPadding;
    }

    void addIndicator(TextView indicator, int index) {
        if (this.indicatorArea == null && this.captionArea == null) {
            this.indicatorArea = new LinearLayout(this.context);
            this.indicatorArea.setOrientation(0);
            this.textInputView.addView((View)this.indicatorArea, -1, -2);
            this.captionArea = new FrameLayout(this.context);
            LinearLayout.LayoutParams captionAreaLp = new LinearLayout.LayoutParams(0, -2, 1.0f);
            this.indicatorArea.addView((View)this.captionArea, (ViewGroup.LayoutParams)captionAreaLp);
            if (this.textInputView.getEditText() != null) {
                this.adjustIndicatorPadding();
            }
        }
        if (this.isCaptionView(index)) {
            this.captionArea.setVisibility(0);
            this.captionArea.addView((View)indicator);
        } else {
            LinearLayout.LayoutParams indicatorAreaLp = new LinearLayout.LayoutParams(-2, -2);
            this.indicatorArea.addView((View)indicator, (ViewGroup.LayoutParams)indicatorAreaLp);
        }
        this.indicatorArea.setVisibility(0);
        ++this.indicatorsAdded;
    }

    void removeIndicator(TextView indicator, int index) {
        if (this.indicatorArea == null) {
            return;
        }
        if (this.isCaptionView(index) && this.captionArea != null) {
            this.captionArea.removeView((View)indicator);
        } else {
            this.indicatorArea.removeView((View)indicator);
        }
        --this.indicatorsAdded;
        this.setViewGroupGoneIfEmpty((ViewGroup)this.indicatorArea, this.indicatorsAdded);
    }

    private void setViewGroupGoneIfEmpty(@NonNull ViewGroup viewGroup, int indicatorsAdded) {
        if (indicatorsAdded == 0) {
            viewGroup.setVisibility(8);
        }
    }

    void setErrorEnabled(boolean enabled) {
        if (this.errorEnabled == enabled) {
            return;
        }
        this.cancelCaptionAnimator();
        if (enabled) {
            this.errorView = new AppCompatTextView(this.context);
            this.errorView.setId(R.id.textinput_error);
            if (Build.VERSION.SDK_INT >= 17) {
                this.errorView.setTextAlignment(5);
            }
            if (this.typeface != null) {
                this.errorView.setTypeface(this.typeface);
            }
            this.setErrorTextAppearance(this.errorTextAppearance);
            this.setErrorViewTextColor(this.errorViewTextColor);
            this.setErrorContentDescription(this.errorViewContentDescription);
            this.setErrorAccessibilityLiveRegion(this.errorViewAccessibilityLiveRegion);
            this.errorView.setVisibility(4);
            this.addIndicator(this.errorView, 0);
        } else {
            this.hideError();
            this.removeIndicator(this.errorView, 0);
            this.errorView = null;
            this.textInputView.updateEditTextBackground();
            this.textInputView.updateTextInputBoxState();
        }
        this.errorEnabled = enabled;
    }

    boolean isErrorEnabled() {
        return this.errorEnabled;
    }

    boolean isHelperTextEnabled() {
        return this.helperTextEnabled;
    }

    void setHelperTextEnabled(boolean enabled) {
        if (this.helperTextEnabled == enabled) {
            return;
        }
        this.cancelCaptionAnimator();
        if (enabled) {
            this.helperTextView = new AppCompatTextView(this.context);
            this.helperTextView.setId(R.id.textinput_helper_text);
            if (Build.VERSION.SDK_INT >= 17) {
                this.helperTextView.setTextAlignment(5);
            }
            if (this.typeface != null) {
                this.helperTextView.setTypeface(this.typeface);
            }
            this.helperTextView.setVisibility(4);
            ViewCompat.setAccessibilityLiveRegion((View)this.helperTextView, (int)1);
            this.setHelperTextAppearance(this.helperTextTextAppearance);
            this.setHelperTextViewTextColor(this.helperTextViewTextColor);
            this.addIndicator(this.helperTextView, 1);
            if (Build.VERSION.SDK_INT >= 17) {
                this.helperTextView.setAccessibilityDelegate(new View.AccessibilityDelegate(){

                    public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfo accessibilityNodeInfo) {
                        super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfo);
                        EditText editText = IndicatorViewController.this.textInputView.getEditText();
                        if (editText != null) {
                            accessibilityNodeInfo.setLabeledBy((View)editText);
                        }
                    }
                });
            }
        } else {
            this.hideHelperText();
            this.removeIndicator(this.helperTextView, 1);
            this.helperTextView = null;
            this.textInputView.updateEditTextBackground();
            this.textInputView.updateTextInputBoxState();
        }
        this.helperTextEnabled = enabled;
    }

    @Nullable
    View getHelperTextView() {
        return this.helperTextView;
    }

    boolean errorIsDisplayed() {
        return this.isCaptionStateError(this.captionDisplayed);
    }

    boolean errorShouldBeShown() {
        return this.isCaptionStateError(this.captionToShow);
    }

    private boolean isCaptionStateError(int captionState) {
        return captionState == 1 && this.errorView != null && !TextUtils.isEmpty((CharSequence)this.errorText);
    }

    boolean helperTextIsDisplayed() {
        return this.isCaptionStateHelperText(this.captionDisplayed);
    }

    boolean helperTextShouldBeShown() {
        return this.isCaptionStateHelperText(this.captionToShow);
    }

    private boolean isCaptionStateHelperText(int captionState) {
        return captionState == 2 && this.helperTextView != null && !TextUtils.isEmpty((CharSequence)this.helperText);
    }

    @Nullable
    CharSequence getErrorText() {
        return this.errorText;
    }

    CharSequence getHelperText() {
        return this.helperText;
    }

    void setTypefaces(Typeface typeface) {
        if (typeface != this.typeface) {
            this.typeface = typeface;
            this.setTextViewTypeface(this.errorView, typeface);
            this.setTextViewTypeface(this.helperTextView, typeface);
        }
    }

    private void setTextViewTypeface(@Nullable TextView captionView, Typeface typeface) {
        if (captionView != null) {
            captionView.setTypeface(typeface);
        }
    }

    @ColorInt
    int getErrorViewCurrentTextColor() {
        return this.errorView != null ? this.errorView.getCurrentTextColor() : -1;
    }

    @Nullable
    ColorStateList getErrorViewTextColors() {
        return this.errorView != null ? this.errorView.getTextColors() : null;
    }

    void setErrorViewTextColor(@Nullable ColorStateList errorViewTextColor) {
        this.errorViewTextColor = errorViewTextColor;
        if (this.errorView != null && errorViewTextColor != null) {
            this.errorView.setTextColor(errorViewTextColor);
        }
    }

    void setErrorTextAppearance(@StyleRes int resId) {
        this.errorTextAppearance = resId;
        if (this.errorView != null) {
            this.textInputView.setTextAppearanceCompatWithErrorFallback(this.errorView, resId);
        }
    }

    void setErrorContentDescription(@Nullable CharSequence errorContentDescription) {
        this.errorViewContentDescription = errorContentDescription;
        if (this.errorView != null) {
            this.errorView.setContentDescription(errorContentDescription);
        }
    }

    void setErrorAccessibilityLiveRegion(int accessibilityLiveRegion) {
        this.errorViewAccessibilityLiveRegion = accessibilityLiveRegion;
        if (this.errorView != null) {
            ViewCompat.setAccessibilityLiveRegion((View)this.errorView, (int)accessibilityLiveRegion);
        }
    }

    @Nullable
    CharSequence getErrorContentDescription() {
        return this.errorViewContentDescription;
    }

    int getErrorAccessibilityLiveRegion() {
        return this.errorViewAccessibilityLiveRegion;
    }

    @ColorInt
    int getHelperTextViewCurrentTextColor() {
        return this.helperTextView != null ? this.helperTextView.getCurrentTextColor() : -1;
    }

    @Nullable
    ColorStateList getHelperTextViewColors() {
        return this.helperTextView != null ? this.helperTextView.getTextColors() : null;
    }

    void setHelperTextViewTextColor(@Nullable ColorStateList helperTextViewTextColor) {
        this.helperTextViewTextColor = helperTextViewTextColor;
        if (this.helperTextView != null && helperTextViewTextColor != null) {
            this.helperTextView.setTextColor(helperTextViewTextColor);
        }
    }

    void setHelperTextAppearance(@StyleRes int resId) {
        this.helperTextTextAppearance = resId;
        if (this.helperTextView != null) {
            TextViewCompat.setTextAppearance((TextView)this.helperTextView, (int)resId);
        }
    }
}

