/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStructure;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatDrawableManager;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.DrawableUtils;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.text.BidiFormatter;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.TextViewCompat;
import androidx.customview.view.AbsSavedState;
import androidx.transition.Fade;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.CheckableImageButton;
import com.google.android.material.internal.CollapsingTextHelper;
import com.google.android.material.internal.DescendantOffsetUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.motion.MotionUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.CornerTreatment;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.textfield.CutoutDrawable;
import com.google.android.material.textfield.EditTextUtils;
import com.google.android.material.textfield.EndCompoundLayout;
import com.google.android.material.textfield.IndicatorViewController;
import com.google.android.material.textfield.MaterialAutoCompleteTextView;
import com.google.android.material.textfield.StartCompoundLayout;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.LinkedHashSet;

public class TextInputLayout
extends LinearLayout
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final int DEF_STYLE_RES = R.style.Widget_Design_TextInputLayout;
    private static final int LABEL_SCALE_ANIMATION_DURATION = 167;
    private static final int DEFAULT_PLACEHOLDER_FADE_DURATION = 87;
    private static final int PLACEHOLDER_START_DELAY = 67;
    private static final int INVALID_MAX_LENGTH = -1;
    private static final int NO_WIDTH = -1;
    private static final int[][] EDIT_TEXT_BACKGROUND_RIPPLE_STATE = new int[][]{{16842919}, new int[0]};
    private static final String LOG_TAG = "TextInputLayout";
    @NonNull
    private final FrameLayout inputFrame;
    @NonNull
    private final StartCompoundLayout startLayout;
    @NonNull
    private final EndCompoundLayout endLayout;
    EditText editText;
    private CharSequence originalHint;
    private int minEms = -1;
    private int maxEms = -1;
    private int minWidth = -1;
    private int maxWidth = -1;
    private final IndicatorViewController indicatorViewController = new IndicatorViewController(this);
    boolean counterEnabled;
    private int counterMaxLength;
    private boolean counterOverflowed;
    @NonNull
    private LengthCounter lengthCounter = text -> text != null ? text.length() : 0;
    @Nullable
    private TextView counterView;
    private int counterOverflowTextAppearance;
    private int counterTextAppearance;
    private CharSequence placeholderText;
    private boolean placeholderEnabled;
    private TextView placeholderTextView;
    @Nullable
    private ColorStateList placeholderTextColor;
    private int placeholderTextAppearance;
    @Nullable
    private Fade placeholderFadeIn;
    @Nullable
    private Fade placeholderFadeOut;
    @Nullable
    private ColorStateList counterTextColor;
    @Nullable
    private ColorStateList counterOverflowTextColor;
    @Nullable
    private ColorStateList cursorColor;
    @Nullable
    private ColorStateList cursorErrorColor;
    private boolean hintEnabled;
    private CharSequence hint;
    private boolean isProvidingHint;
    @Nullable
    private MaterialShapeDrawable boxBackground;
    private MaterialShapeDrawable outlinedDropDownMenuBackground;
    private StateListDrawable filledDropDownMenuBackground;
    private boolean boxBackgroundApplied;
    @Nullable
    private MaterialShapeDrawable boxUnderlineDefault;
    @Nullable
    private MaterialShapeDrawable boxUnderlineFocused;
    @NonNull
    private ShapeAppearanceModel shapeAppearanceModel;
    private boolean areCornerRadiiRtl;
    private final int boxLabelCutoutPaddingPx;
    private int boxBackgroundMode;
    private int boxCollapsedPaddingTopPx;
    private int boxStrokeWidthPx;
    private int boxStrokeWidthDefaultPx;
    private int boxStrokeWidthFocusedPx;
    @ColorInt
    private int boxStrokeColor;
    @ColorInt
    private int boxBackgroundColor;
    public static final int BOX_BACKGROUND_NONE = 0;
    public static final int BOX_BACKGROUND_FILLED = 1;
    public static final int BOX_BACKGROUND_OUTLINE = 2;
    private final Rect tmpRect = new Rect();
    private final Rect tmpBoundsRect = new Rect();
    private final RectF tmpRectF = new RectF();
    private Typeface typeface;
    @Nullable
    private Drawable startDummyDrawable;
    private int startDummyDrawableWidth;
    public static final int END_ICON_CUSTOM = -1;
    public static final int END_ICON_NONE = 0;
    public static final int END_ICON_PASSWORD_TOGGLE = 1;
    public static final int END_ICON_CLEAR_TEXT = 2;
    public static final int END_ICON_DROPDOWN_MENU = 3;
    private final LinkedHashSet<OnEditTextAttachedListener> editTextAttachedListeners = new LinkedHashSet();
    @Nullable
    private Drawable endDummyDrawable;
    private int endDummyDrawableWidth;
    private Drawable originalEditTextEndDrawable;
    private ColorStateList defaultHintTextColor;
    private ColorStateList focusedTextColor;
    @ColorInt
    private int defaultStrokeColor;
    @ColorInt
    private int hoveredStrokeColor;
    @ColorInt
    private int focusedStrokeColor;
    private ColorStateList strokeErrorColor;
    @ColorInt
    private int defaultFilledBackgroundColor;
    @ColorInt
    private int disabledFilledBackgroundColor;
    @ColorInt
    private int focusedFilledBackgroundColor;
    @ColorInt
    private int hoveredFilledBackgroundColor;
    @ColorInt
    private int disabledColor;
    int originalEditTextMinimumHeight;
    private boolean hintExpanded;
    final CollapsingTextHelper collapsingTextHelper = new CollapsingTextHelper((View)this);
    private boolean expandedHintEnabled;
    private boolean hintAnimationEnabled;
    private ValueAnimator animator;
    private boolean inDrawableStateChanged;
    private boolean restoringSavedState;
    private boolean globalLayoutListenerAdded = false;

    public TextInputLayout(@NonNull Context context) {
        this(context, null);
    }

    public TextInputLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.textInputStyle);
    }

    public TextInputLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        int hintAppearance;
        context = this.getContext();
        this.setOrientation(1);
        this.setWillNotDraw(false);
        this.setAddStatesFromChildren(true);
        this.inputFrame = new FrameLayout(context);
        this.inputFrame.setAddStatesFromChildren(true);
        this.collapsingTextHelper.setTextSizeInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        this.collapsingTextHelper.setPositionInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        this.collapsingTextHelper.setCollapsedTextGravity(0x800033);
        TintTypedArray a = ThemeEnforcement.obtainTintedStyledAttributes(context, attrs, R.styleable.TextInputLayout, defStyleAttr, DEF_STYLE_RES, R.styleable.TextInputLayout_counterTextAppearance, R.styleable.TextInputLayout_counterOverflowTextAppearance, R.styleable.TextInputLayout_errorTextAppearance, R.styleable.TextInputLayout_helperTextTextAppearance, R.styleable.TextInputLayout_hintTextAppearance);
        this.startLayout = new StartCompoundLayout(this, a);
        this.hintEnabled = a.getBoolean(R.styleable.TextInputLayout_hintEnabled, true);
        this.setHint(a.getText(R.styleable.TextInputLayout_android_hint));
        this.hintAnimationEnabled = a.getBoolean(R.styleable.TextInputLayout_hintAnimationEnabled, true);
        this.expandedHintEnabled = a.getBoolean(R.styleable.TextInputLayout_expandedHintEnabled, true);
        if (a.hasValue(R.styleable.TextInputLayout_android_minEms)) {
            this.setMinEms(a.getInt(R.styleable.TextInputLayout_android_minEms, -1));
        } else if (a.hasValue(R.styleable.TextInputLayout_android_minWidth)) {
            this.setMinWidth(a.getDimensionPixelSize(R.styleable.TextInputLayout_android_minWidth, -1));
        }
        if (a.hasValue(R.styleable.TextInputLayout_android_maxEms)) {
            this.setMaxEms(a.getInt(R.styleable.TextInputLayout_android_maxEms, -1));
        } else if (a.hasValue(R.styleable.TextInputLayout_android_maxWidth)) {
            this.setMaxWidth(a.getDimensionPixelSize(R.styleable.TextInputLayout_android_maxWidth, -1));
        }
        this.shapeAppearanceModel = ShapeAppearanceModel.builder(context, attrs, defStyleAttr, DEF_STYLE_RES).build();
        this.boxLabelCutoutPaddingPx = context.getResources().getDimensionPixelOffset(R.dimen.mtrl_textinput_box_label_cutout_padding);
        this.boxCollapsedPaddingTopPx = a.getDimensionPixelOffset(R.styleable.TextInputLayout_boxCollapsedPaddingTop, 0);
        this.boxStrokeWidthDefaultPx = a.getDimensionPixelSize(R.styleable.TextInputLayout_boxStrokeWidth, context.getResources().getDimensionPixelSize(R.dimen.mtrl_textinput_box_stroke_width_default));
        this.boxStrokeWidthFocusedPx = a.getDimensionPixelSize(R.styleable.TextInputLayout_boxStrokeWidthFocused, context.getResources().getDimensionPixelSize(R.dimen.mtrl_textinput_box_stroke_width_focused));
        this.boxStrokeWidthPx = this.boxStrokeWidthDefaultPx;
        float boxCornerRadiusTopStart = a.getDimension(R.styleable.TextInputLayout_boxCornerRadiusTopStart, -1.0f);
        float boxCornerRadiusTopEnd = a.getDimension(R.styleable.TextInputLayout_boxCornerRadiusTopEnd, -1.0f);
        float boxCornerRadiusBottomEnd = a.getDimension(R.styleable.TextInputLayout_boxCornerRadiusBottomEnd, -1.0f);
        float boxCornerRadiusBottomStart = a.getDimension(R.styleable.TextInputLayout_boxCornerRadiusBottomStart, -1.0f);
        ShapeAppearanceModel.Builder shapeBuilder = this.shapeAppearanceModel.toBuilder();
        if (boxCornerRadiusTopStart >= 0.0f) {
            shapeBuilder.setTopLeftCornerSize(boxCornerRadiusTopStart);
        }
        if (boxCornerRadiusTopEnd >= 0.0f) {
            shapeBuilder.setTopRightCornerSize(boxCornerRadiusTopEnd);
        }
        if (boxCornerRadiusBottomEnd >= 0.0f) {
            shapeBuilder.setBottomRightCornerSize(boxCornerRadiusBottomEnd);
        }
        if (boxCornerRadiusBottomStart >= 0.0f) {
            shapeBuilder.setBottomLeftCornerSize(boxCornerRadiusBottomStart);
        }
        this.shapeAppearanceModel = shapeBuilder.build();
        ColorStateList filledBackgroundColorStateList = MaterialResources.getColorStateList(context, a, R.styleable.TextInputLayout_boxBackgroundColor);
        if (filledBackgroundColorStateList != null) {
            this.boxBackgroundColor = this.defaultFilledBackgroundColor = filledBackgroundColorStateList.getDefaultColor();
            if (filledBackgroundColorStateList.isStateful()) {
                this.disabledFilledBackgroundColor = filledBackgroundColorStateList.getColorForState(new int[]{-16842910}, -1);
                this.focusedFilledBackgroundColor = filledBackgroundColorStateList.getColorForState(new int[]{16842908, 16842910}, -1);
                this.hoveredFilledBackgroundColor = filledBackgroundColorStateList.getColorForState(new int[]{16843623, 16842910}, -1);
            } else {
                this.focusedFilledBackgroundColor = this.defaultFilledBackgroundColor;
                ColorStateList mtrlFilledBackgroundColorStateList = AppCompatResources.getColorStateList((Context)context, (int)R.color.mtrl_filled_background_color);
                this.disabledFilledBackgroundColor = mtrlFilledBackgroundColorStateList.getColorForState(new int[]{-16842910}, -1);
                this.hoveredFilledBackgroundColor = mtrlFilledBackgroundColorStateList.getColorForState(new int[]{16843623}, -1);
            }
        } else {
            this.boxBackgroundColor = 0;
            this.defaultFilledBackgroundColor = 0;
            this.disabledFilledBackgroundColor = 0;
            this.focusedFilledBackgroundColor = 0;
            this.hoveredFilledBackgroundColor = 0;
        }
        if (a.hasValue(R.styleable.TextInputLayout_android_textColorHint)) {
            this.defaultHintTextColor = this.focusedTextColor = a.getColorStateList(R.styleable.TextInputLayout_android_textColorHint);
        }
        ColorStateList boxStrokeColorStateList = MaterialResources.getColorStateList(context, a, R.styleable.TextInputLayout_boxStrokeColor);
        this.focusedStrokeColor = a.getColor(R.styleable.TextInputLayout_boxStrokeColor, 0);
        this.defaultStrokeColor = ContextCompat.getColor((Context)context, (int)R.color.mtrl_textinput_default_box_stroke_color);
        this.disabledColor = ContextCompat.getColor((Context)context, (int)R.color.mtrl_textinput_disabled_color);
        this.hoveredStrokeColor = ContextCompat.getColor((Context)context, (int)R.color.mtrl_textinput_hovered_box_stroke_color);
        if (boxStrokeColorStateList != null) {
            this.setBoxStrokeColorStateList(boxStrokeColorStateList);
        }
        if (a.hasValue(R.styleable.TextInputLayout_boxStrokeErrorColor)) {
            this.setBoxStrokeErrorColor(MaterialResources.getColorStateList(context, a, R.styleable.TextInputLayout_boxStrokeErrorColor));
        }
        if ((hintAppearance = a.getResourceId(R.styleable.TextInputLayout_hintTextAppearance, -1)) != -1) {
            this.setHintTextAppearance(a.getResourceId(R.styleable.TextInputLayout_hintTextAppearance, 0));
        }
        this.cursorColor = a.getColorStateList(R.styleable.TextInputLayout_cursorColor);
        this.cursorErrorColor = a.getColorStateList(R.styleable.TextInputLayout_cursorErrorColor);
        int errorTextAppearance = a.getResourceId(R.styleable.TextInputLayout_errorTextAppearance, 0);
        CharSequence errorContentDescription = a.getText(R.styleable.TextInputLayout_errorContentDescription);
        int errorAccessibilityLiveRegion = a.getInt(R.styleable.TextInputLayout_errorAccessibilityLiveRegion, 1);
        boolean errorEnabled = a.getBoolean(R.styleable.TextInputLayout_errorEnabled, false);
        int helperTextTextAppearance = a.getResourceId(R.styleable.TextInputLayout_helperTextTextAppearance, 0);
        boolean helperTextEnabled = a.getBoolean(R.styleable.TextInputLayout_helperTextEnabled, false);
        CharSequence helperText = a.getText(R.styleable.TextInputLayout_helperText);
        int placeholderTextAppearance = a.getResourceId(R.styleable.TextInputLayout_placeholderTextAppearance, 0);
        CharSequence placeholderText = a.getText(R.styleable.TextInputLayout_placeholderText);
        boolean counterEnabled = a.getBoolean(R.styleable.TextInputLayout_counterEnabled, false);
        this.setCounterMaxLength(a.getInt(R.styleable.TextInputLayout_counterMaxLength, -1));
        this.counterTextAppearance = a.getResourceId(R.styleable.TextInputLayout_counterTextAppearance, 0);
        this.counterOverflowTextAppearance = a.getResourceId(R.styleable.TextInputLayout_counterOverflowTextAppearance, 0);
        this.setBoxBackgroundMode(a.getInt(R.styleable.TextInputLayout_boxBackgroundMode, 0));
        this.setErrorContentDescription(errorContentDescription);
        this.setErrorAccessibilityLiveRegion(errorAccessibilityLiveRegion);
        this.setCounterOverflowTextAppearance(this.counterOverflowTextAppearance);
        this.setHelperTextTextAppearance(helperTextTextAppearance);
        this.setErrorTextAppearance(errorTextAppearance);
        this.setCounterTextAppearance(this.counterTextAppearance);
        this.setPlaceholderText(placeholderText);
        this.setPlaceholderTextAppearance(placeholderTextAppearance);
        if (a.hasValue(R.styleable.TextInputLayout_errorTextColor)) {
            this.setErrorTextColor(a.getColorStateList(R.styleable.TextInputLayout_errorTextColor));
        }
        if (a.hasValue(R.styleable.TextInputLayout_helperTextTextColor)) {
            this.setHelperTextColor(a.getColorStateList(R.styleable.TextInputLayout_helperTextTextColor));
        }
        if (a.hasValue(R.styleable.TextInputLayout_hintTextColor)) {
            this.setHintTextColor(a.getColorStateList(R.styleable.TextInputLayout_hintTextColor));
        }
        if (a.hasValue(R.styleable.TextInputLayout_counterTextColor)) {
            this.setCounterTextColor(a.getColorStateList(R.styleable.TextInputLayout_counterTextColor));
        }
        if (a.hasValue(R.styleable.TextInputLayout_counterOverflowTextColor)) {
            this.setCounterOverflowTextColor(a.getColorStateList(R.styleable.TextInputLayout_counterOverflowTextColor));
        }
        if (a.hasValue(R.styleable.TextInputLayout_placeholderTextColor)) {
            this.setPlaceholderTextColor(a.getColorStateList(R.styleable.TextInputLayout_placeholderTextColor));
        }
        this.endLayout = new EndCompoundLayout(this, a);
        boolean enabled = a.getBoolean(R.styleable.TextInputLayout_android_enabled, true);
        a.recycle();
        ViewCompat.setImportantForAccessibility((View)this, (int)2);
        if (Build.VERSION.SDK_INT >= 26) {
            ViewCompat.setImportantForAutofill((View)this, (int)1);
        }
        this.inputFrame.addView((View)this.startLayout);
        this.inputFrame.addView((View)this.endLayout);
        this.addView((View)this.inputFrame);
        this.setEnabled(enabled);
        this.setHelperTextEnabled(helperTextEnabled);
        this.setErrorEnabled(errorEnabled);
        this.setCounterEnabled(counterEnabled);
        this.setHelperText(helperText);
    }

    public void onGlobalLayout() {
        if (Build.VERSION.SDK_INT < 16) {
            this.endLayout.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        } else {
            this.endLayout.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.globalLayoutListenerAdded = false;
        boolean updatedHeight = this.updateEditTextHeightBasedOnIcon();
        boolean updatedIcon = this.updateDummyDrawables();
        if (updatedHeight || updatedIcon) {
            this.editText.post(() -> this.editText.requestLayout());
        }
    }

    public void addView(@NonNull View child, int index, @NonNull ViewGroup.LayoutParams params) {
        if (child instanceof EditText) {
            FrameLayout.LayoutParams flp = new FrameLayout.LayoutParams(params);
            flp.gravity = 0x10 | flp.gravity & 0xFFFFFF8F;
            this.inputFrame.addView(child, (ViewGroup.LayoutParams)flp);
            this.inputFrame.setLayoutParams(params);
            this.updateInputLayoutMargins();
            this.setEditText((EditText)child);
        } else {
            super.addView(child, index, params);
        }
    }

    @NonNull
    MaterialShapeDrawable getBoxBackground() {
        if (this.boxBackgroundMode == 1 || this.boxBackgroundMode == 2) {
            return this.boxBackground;
        }
        throw new IllegalStateException();
    }

    public void setBoxBackgroundMode(int boxBackgroundMode) {
        if (boxBackgroundMode == this.boxBackgroundMode) {
            return;
        }
        this.boxBackgroundMode = boxBackgroundMode;
        if (this.editText != null) {
            this.onApplyBoxBackgroundMode();
        }
    }

    public int getBoxBackgroundMode() {
        return this.boxBackgroundMode;
    }

    private void onApplyBoxBackgroundMode() {
        this.assignBoxBackgroundByMode();
        this.updateEditTextBoxBackgroundIfNeeded();
        this.updateTextInputBoxState();
        this.updateBoxCollapsedPaddingTop();
        this.adjustFilledEditTextPaddingForLargeFont();
        if (this.boxBackgroundMode != 0) {
            this.updateInputLayoutMargins();
        }
        this.setDropDownMenuBackgroundIfNeeded();
    }

    private void assignBoxBackgroundByMode() {
        switch (this.boxBackgroundMode) {
            case 1: {
                this.boxBackground = new MaterialShapeDrawable(this.shapeAppearanceModel);
                this.boxUnderlineDefault = new MaterialShapeDrawable();
                this.boxUnderlineFocused = new MaterialShapeDrawable();
                break;
            }
            case 2: {
                this.boxBackground = this.hintEnabled && !(this.boxBackground instanceof CutoutDrawable) ? CutoutDrawable.create(this.shapeAppearanceModel) : new MaterialShapeDrawable(this.shapeAppearanceModel);
                this.boxUnderlineDefault = null;
                this.boxUnderlineFocused = null;
                break;
            }
            case 0: {
                this.boxBackground = null;
                this.boxUnderlineDefault = null;
                this.boxUnderlineFocused = null;
                break;
            }
            default: {
                throw new IllegalArgumentException(this.boxBackgroundMode + " is illegal; only @BoxBackgroundMode constants are supported.");
            }
        }
    }

    void updateEditTextBoxBackgroundIfNeeded() {
        if (this.editText == null || this.boxBackground == null || !this.boxBackgroundApplied && this.editText.getBackground() != null || this.boxBackgroundMode == 0) {
            return;
        }
        this.updateEditTextBoxBackground();
        this.boxBackgroundApplied = true;
    }

    private void updateEditTextBoxBackground() {
        Drawable editTextBoxBackground = this.getEditTextBoxBackground();
        if (Build.VERSION.SDK_INT < 21 && editTextBoxBackground instanceof LayerDrawable) {
            int paddingLeft = this.editText.getPaddingLeft();
            int paddingTop = this.editText.getPaddingTop();
            int paddingRight = this.editText.getPaddingRight();
            int paddingBottom = this.editText.getPaddingBottom();
            ViewCompat.setBackground((View)this.editText, (Drawable)editTextBoxBackground);
            this.editText.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        } else {
            ViewCompat.setBackground((View)this.editText, (Drawable)editTextBoxBackground);
        }
    }

    @Nullable
    private Drawable getEditTextBoxBackground() {
        if (!(this.editText instanceof AutoCompleteTextView) || EditTextUtils.isEditable(this.editText)) {
            return this.boxBackground;
        }
        int rippleColor = MaterialColors.getColor((View)this.editText, R.attr.colorControlHighlight);
        if (this.boxBackgroundMode == 2) {
            return TextInputLayout.getOutlinedBoxBackgroundWithRipple(this.getContext(), this.boxBackground, rippleColor, EDIT_TEXT_BACKGROUND_RIPPLE_STATE);
        }
        if (this.boxBackgroundMode == 1) {
            return TextInputLayout.getFilledBoxBackgroundWithRipple(this.boxBackground, this.boxBackgroundColor, rippleColor, EDIT_TEXT_BACKGROUND_RIPPLE_STATE);
        }
        return null;
    }

    private static Drawable getOutlinedBoxBackgroundWithRipple(Context context, MaterialShapeDrawable boxBackground, int rippleColor, int[][] states) {
        LayerDrawable editTextBackground;
        int surfaceColor = MaterialColors.getColor(context, R.attr.colorSurface, LOG_TAG);
        MaterialShapeDrawable rippleBackground = new MaterialShapeDrawable(boxBackground.getShapeAppearanceModel());
        int pressedBackgroundColor = MaterialColors.layer(rippleColor, surfaceColor, 0.1f);
        int[] rippleBackgroundColors = new int[]{pressedBackgroundColor, 0};
        rippleBackground.setFillColor(new ColorStateList(states, rippleBackgroundColors));
        if (Build.VERSION.SDK_INT >= 21) {
            rippleBackground.setTint(surfaceColor);
            int[] colors = new int[]{pressedBackgroundColor, surfaceColor};
            ColorStateList rippleColorStateList = new ColorStateList(states, colors);
            MaterialShapeDrawable mask = new MaterialShapeDrawable(boxBackground.getShapeAppearanceModel());
            mask.setTint(-1);
            RippleDrawable rippleDrawable = new RippleDrawable(rippleColorStateList, (Drawable)rippleBackground, (Drawable)mask);
            Drawable[] layers = new Drawable[]{rippleDrawable, boxBackground};
            editTextBackground = new LayerDrawable(layers);
        } else {
            Drawable[] layers = new Drawable[]{rippleBackground, boxBackground};
            editTextBackground = new LayerDrawable(layers);
        }
        return editTextBackground;
    }

    private static Drawable getFilledBoxBackgroundWithRipple(MaterialShapeDrawable boxBackground, int boxBackgroundColor, int rippleColor, int[][] states) {
        RippleDrawable editTextBackground;
        int pressedBackgroundColor = MaterialColors.layer(rippleColor, boxBackgroundColor, 0.1f);
        int[] colors = new int[]{pressedBackgroundColor, boxBackgroundColor};
        if (Build.VERSION.SDK_INT >= 21) {
            ColorStateList rippleColorStateList = new ColorStateList(states, colors);
            editTextBackground = new RippleDrawable(rippleColorStateList, (Drawable)boxBackground, (Drawable)boxBackground);
        } else {
            MaterialShapeDrawable rippleBackground = new MaterialShapeDrawable(boxBackground.getShapeAppearanceModel());
            rippleBackground.setFillColor(new ColorStateList(states, colors));
            Drawable[] layers = new Drawable[]{boxBackground, rippleBackground};
            editTextBackground = new LayerDrawable(layers);
        }
        return editTextBackground;
    }

    private void setDropDownMenuBackgroundIfNeeded() {
        if (!(this.editText instanceof AutoCompleteTextView)) {
            return;
        }
        AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)this.editText;
        if (Build.VERSION.SDK_INT >= 21 && autoCompleteTextView.getDropDownBackground() == null) {
            if (this.boxBackgroundMode == 2) {
                autoCompleteTextView.setDropDownBackgroundDrawable(this.getOrCreateOutlinedDropDownMenuBackground());
            } else if (this.boxBackgroundMode == 1) {
                autoCompleteTextView.setDropDownBackgroundDrawable(this.getOrCreateFilledDropDownMenuBackground());
            }
        }
    }

    private Drawable getOrCreateOutlinedDropDownMenuBackground() {
        if (this.outlinedDropDownMenuBackground == null) {
            this.outlinedDropDownMenuBackground = this.getDropDownMaterialShapeDrawable(true);
        }
        return this.outlinedDropDownMenuBackground;
    }

    private Drawable getOrCreateFilledDropDownMenuBackground() {
        if (this.filledDropDownMenuBackground == null) {
            this.filledDropDownMenuBackground = new StateListDrawable();
            this.filledDropDownMenuBackground.addState(new int[]{0x10100AA}, this.getOrCreateOutlinedDropDownMenuBackground());
            this.filledDropDownMenuBackground.addState(new int[0], (Drawable)this.getDropDownMaterialShapeDrawable(false));
        }
        return this.filledDropDownMenuBackground;
    }

    private MaterialShapeDrawable getDropDownMaterialShapeDrawable(boolean roundedTopCorners) {
        float cornerRadius = this.getResources().getDimensionPixelOffset(R.dimen.mtrl_shape_corner_size_small_component);
        float topCornerRadius = roundedTopCorners ? cornerRadius : 0.0f;
        float elevation = this.editText instanceof MaterialAutoCompleteTextView ? ((MaterialAutoCompleteTextView)this.editText).getPopupElevation() : (float)this.getResources().getDimensionPixelOffset(R.dimen.m3_comp_outlined_autocomplete_menu_container_elevation);
        int verticalPadding = this.getResources().getDimensionPixelOffset(R.dimen.mtrl_exposed_dropdown_menu_popup_vertical_padding);
        ShapeAppearanceModel shapeAppearanceModel = ShapeAppearanceModel.builder().setTopLeftCornerSize(topCornerRadius).setTopRightCornerSize(topCornerRadius).setBottomLeftCornerSize(cornerRadius).setBottomRightCornerSize(cornerRadius).build();
        ColorStateList dropDownBackgroundTint = null;
        if (this.editText instanceof MaterialAutoCompleteTextView) {
            MaterialAutoCompleteTextView materialAutoCompleteTextView = (MaterialAutoCompleteTextView)this.editText;
            dropDownBackgroundTint = materialAutoCompleteTextView.getDropDownBackgroundTintList();
        }
        MaterialShapeDrawable popupDrawable = MaterialShapeDrawable.createWithElevationOverlay(this.getContext(), elevation, dropDownBackgroundTint);
        popupDrawable.setShapeAppearanceModel(shapeAppearanceModel);
        popupDrawable.setPadding(0, verticalPadding, 0, verticalPadding);
        return popupDrawable;
    }

    private void updateBoxCollapsedPaddingTop() {
        if (this.boxBackgroundMode == 1) {
            if (MaterialResources.isFontScaleAtLeast2_0(this.getContext())) {
                this.boxCollapsedPaddingTopPx = this.getResources().getDimensionPixelSize(R.dimen.material_font_2_0_box_collapsed_padding_top);
            } else if (MaterialResources.isFontScaleAtLeast1_3(this.getContext())) {
                this.boxCollapsedPaddingTopPx = this.getResources().getDimensionPixelSize(R.dimen.material_font_1_3_box_collapsed_padding_top);
            }
        }
    }

    private void adjustFilledEditTextPaddingForLargeFont() {
        if (this.editText == null || this.boxBackgroundMode != 1) {
            return;
        }
        if (MaterialResources.isFontScaleAtLeast2_0(this.getContext())) {
            ViewCompat.setPaddingRelative((View)this.editText, (int)ViewCompat.getPaddingStart((View)this.editText), (int)this.getResources().getDimensionPixelSize(R.dimen.material_filled_edittext_font_2_0_padding_top), (int)ViewCompat.getPaddingEnd((View)this.editText), (int)this.getResources().getDimensionPixelSize(R.dimen.material_filled_edittext_font_2_0_padding_bottom));
        } else if (MaterialResources.isFontScaleAtLeast1_3(this.getContext())) {
            ViewCompat.setPaddingRelative((View)this.editText, (int)ViewCompat.getPaddingStart((View)this.editText), (int)this.getResources().getDimensionPixelSize(R.dimen.material_filled_edittext_font_1_3_padding_top), (int)ViewCompat.getPaddingEnd((View)this.editText), (int)this.getResources().getDimensionPixelSize(R.dimen.material_filled_edittext_font_1_3_padding_bottom));
        }
    }

    public void setBoxCollapsedPaddingTop(int boxCollapsedPaddingTop) {
        this.boxCollapsedPaddingTopPx = boxCollapsedPaddingTop;
    }

    public int getBoxCollapsedPaddingTop() {
        return this.boxCollapsedPaddingTopPx;
    }

    public void setBoxStrokeWidthResource(@DimenRes int boxStrokeWidthResId) {
        this.setBoxStrokeWidth(this.getResources().getDimensionPixelSize(boxStrokeWidthResId));
    }

    public void setBoxStrokeWidth(int boxStrokeWidth) {
        this.boxStrokeWidthDefaultPx = boxStrokeWidth;
        this.updateTextInputBoxState();
    }

    public int getBoxStrokeWidth() {
        return this.boxStrokeWidthDefaultPx;
    }

    public void setBoxStrokeWidthFocusedResource(@DimenRes int boxStrokeWidthFocusedResId) {
        this.setBoxStrokeWidthFocused(this.getResources().getDimensionPixelSize(boxStrokeWidthFocusedResId));
    }

    public void setBoxStrokeWidthFocused(int boxStrokeWidthFocused) {
        this.boxStrokeWidthFocusedPx = boxStrokeWidthFocused;
        this.updateTextInputBoxState();
    }

    public int getBoxStrokeWidthFocused() {
        return this.boxStrokeWidthFocusedPx;
    }

    public void setBoxStrokeColor(@ColorInt int boxStrokeColor) {
        if (this.focusedStrokeColor != boxStrokeColor) {
            this.focusedStrokeColor = boxStrokeColor;
            this.updateTextInputBoxState();
        }
    }

    public int getBoxStrokeColor() {
        return this.focusedStrokeColor;
    }

    public void setBoxStrokeColorStateList(@NonNull ColorStateList boxStrokeColorStateList) {
        if (boxStrokeColorStateList.isStateful()) {
            this.defaultStrokeColor = boxStrokeColorStateList.getDefaultColor();
            this.disabledColor = boxStrokeColorStateList.getColorForState(new int[]{-16842910}, -1);
            this.hoveredStrokeColor = boxStrokeColorStateList.getColorForState(new int[]{16843623, 16842910}, -1);
            this.focusedStrokeColor = boxStrokeColorStateList.getColorForState(new int[]{16842908, 16842910}, -1);
        } else if (this.focusedStrokeColor != boxStrokeColorStateList.getDefaultColor()) {
            this.focusedStrokeColor = boxStrokeColorStateList.getDefaultColor();
        }
        this.updateTextInputBoxState();
    }

    public void setBoxStrokeErrorColor(@Nullable ColorStateList strokeErrorColor) {
        if (this.strokeErrorColor != strokeErrorColor) {
            this.strokeErrorColor = strokeErrorColor;
            this.updateTextInputBoxState();
        }
    }

    @Nullable
    public ColorStateList getBoxStrokeErrorColor() {
        return this.strokeErrorColor;
    }

    public void setBoxBackgroundColorResource(@ColorRes int boxBackgroundColorId) {
        this.setBoxBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)boxBackgroundColorId));
    }

    public void setBoxBackgroundColor(@ColorInt int boxBackgroundColor) {
        if (this.boxBackgroundColor != boxBackgroundColor) {
            this.boxBackgroundColor = boxBackgroundColor;
            this.defaultFilledBackgroundColor = boxBackgroundColor;
            this.focusedFilledBackgroundColor = boxBackgroundColor;
            this.hoveredFilledBackgroundColor = boxBackgroundColor;
            this.applyBoxAttributes();
        }
    }

    public void setBoxBackgroundColorStateList(@NonNull ColorStateList boxBackgroundColorStateList) {
        this.boxBackgroundColor = this.defaultFilledBackgroundColor = boxBackgroundColorStateList.getDefaultColor();
        this.disabledFilledBackgroundColor = boxBackgroundColorStateList.getColorForState(new int[]{-16842910}, -1);
        this.focusedFilledBackgroundColor = boxBackgroundColorStateList.getColorForState(new int[]{16842908, 16842910}, -1);
        this.hoveredFilledBackgroundColor = boxBackgroundColorStateList.getColorForState(new int[]{16843623, 16842910}, -1);
        this.applyBoxAttributes();
    }

    public int getBoxBackgroundColor() {
        return this.boxBackgroundColor;
    }

    public void setShapeAppearanceModel(@NonNull ShapeAppearanceModel shapeAppearanceModel) {
        if (this.boxBackground != null && this.boxBackground.getShapeAppearanceModel() != shapeAppearanceModel) {
            this.shapeAppearanceModel = shapeAppearanceModel;
            this.applyBoxAttributes();
        }
    }

    @NonNull
    public ShapeAppearanceModel getShapeAppearanceModel() {
        return this.shapeAppearanceModel;
    }

    public void setBoxCornerFamily(int cornerFamily) {
        this.shapeAppearanceModel = this.shapeAppearanceModel.toBuilder().setTopLeftCorner(cornerFamily, this.shapeAppearanceModel.getTopLeftCornerSize()).setTopRightCorner(cornerFamily, this.shapeAppearanceModel.getTopRightCornerSize()).setBottomLeftCorner(cornerFamily, this.shapeAppearanceModel.getBottomLeftCornerSize()).setBottomRightCorner(cornerFamily, this.shapeAppearanceModel.getBottomRightCornerSize()).build();
        this.applyBoxAttributes();
    }

    public void setBoxCornerRadiiResources(@DimenRes int boxCornerRadiusTopStartId, @DimenRes int boxCornerRadiusTopEndId, @DimenRes int boxCornerRadiusBottomEndId, @DimenRes int boxCornerRadiusBottomStartId) {
        this.setBoxCornerRadii(this.getContext().getResources().getDimension(boxCornerRadiusTopStartId), this.getContext().getResources().getDimension(boxCornerRadiusTopEndId), this.getContext().getResources().getDimension(boxCornerRadiusBottomStartId), this.getContext().getResources().getDimension(boxCornerRadiusBottomEndId));
    }

    public void setBoxCornerRadii(float boxCornerRadiusTopStart, float boxCornerRadiusTopEnd, float boxCornerRadiusBottomStart, float boxCornerRadiusBottomEnd) {
        float boxCornerRadiusBottomRight;
        this.areCornerRadiiRtl = ViewUtils.isLayoutRtl((View)this);
        float boxCornerRadiusTopLeft = this.areCornerRadiiRtl ? boxCornerRadiusTopEnd : boxCornerRadiusTopStart;
        float boxCornerRadiusTopRight = this.areCornerRadiiRtl ? boxCornerRadiusTopStart : boxCornerRadiusTopEnd;
        float boxCornerRadiusBottomLeft = this.areCornerRadiiRtl ? boxCornerRadiusBottomEnd : boxCornerRadiusBottomStart;
        float f = boxCornerRadiusBottomRight = this.areCornerRadiiRtl ? boxCornerRadiusBottomStart : boxCornerRadiusBottomEnd;
        if (this.boxBackground == null || this.boxBackground.getTopLeftCornerResolvedSize() != boxCornerRadiusTopLeft || this.boxBackground.getTopRightCornerResolvedSize() != boxCornerRadiusTopRight || this.boxBackground.getBottomLeftCornerResolvedSize() != boxCornerRadiusBottomLeft || this.boxBackground.getBottomRightCornerResolvedSize() != boxCornerRadiusBottomRight) {
            this.shapeAppearanceModel = this.shapeAppearanceModel.toBuilder().setTopLeftCornerSize(boxCornerRadiusTopLeft).setTopRightCornerSize(boxCornerRadiusTopRight).setBottomLeftCornerSize(boxCornerRadiusBottomLeft).setBottomRightCornerSize(boxCornerRadiusBottomRight).build();
            this.applyBoxAttributes();
        }
    }

    public float getBoxCornerRadiusTopStart() {
        return ViewUtils.isLayoutRtl((View)this) ? this.shapeAppearanceModel.getTopRightCornerSize().getCornerSize(this.tmpRectF) : this.shapeAppearanceModel.getTopLeftCornerSize().getCornerSize(this.tmpRectF);
    }

    public float getBoxCornerRadiusTopEnd() {
        return ViewUtils.isLayoutRtl((View)this) ? this.shapeAppearanceModel.getTopLeftCornerSize().getCornerSize(this.tmpRectF) : this.shapeAppearanceModel.getTopRightCornerSize().getCornerSize(this.tmpRectF);
    }

    public float getBoxCornerRadiusBottomEnd() {
        return ViewUtils.isLayoutRtl((View)this) ? this.shapeAppearanceModel.getBottomLeftCornerSize().getCornerSize(this.tmpRectF) : this.shapeAppearanceModel.getBottomRightCornerSize().getCornerSize(this.tmpRectF);
    }

    public float getBoxCornerRadiusBottomStart() {
        return ViewUtils.isLayoutRtl((View)this) ? this.shapeAppearanceModel.getBottomRightCornerSize().getCornerSize(this.tmpRectF) : this.shapeAppearanceModel.getBottomLeftCornerSize().getCornerSize(this.tmpRectF);
    }

    public void setTypeface(@Nullable Typeface typeface) {
        if (typeface != this.typeface) {
            this.typeface = typeface;
            this.collapsingTextHelper.setTypefaces(typeface);
            this.indicatorViewController.setTypefaces(typeface);
            if (this.counterView != null) {
                this.counterView.setTypeface(typeface);
            }
        }
    }

    @Nullable
    public Typeface getTypeface() {
        return this.typeface;
    }

    public void setLengthCounter(@NonNull LengthCounter lengthCounter) {
        this.lengthCounter = lengthCounter;
    }

    @NonNull
    public LengthCounter getLengthCounter() {
        return this.lengthCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=26)
    public void dispatchProvideAutofillStructure(@NonNull ViewStructure structure, int flags) {
        if (this.editText == null) {
            super.dispatchProvideAutofillStructure(structure, flags);
            return;
        }
        if (this.originalHint != null) {
            boolean wasProvidingHint = this.isProvidingHint;
            this.isProvidingHint = false;
            CharSequence hint = this.editText.getHint();
            this.editText.setHint(this.originalHint);
            try {
                super.dispatchProvideAutofillStructure(structure, flags);
            }
            finally {
                this.editText.setHint(hint);
                this.isProvidingHint = wasProvidingHint;
            }
        } else {
            structure.setAutofillId(this.getAutofillId());
            this.onProvideAutofillStructure(structure, flags);
            this.onProvideAutofillVirtualStructure(structure, flags);
            structure.setChildCount(this.inputFrame.getChildCount());
            for (int i = 0; i < this.inputFrame.getChildCount(); ++i) {
                View child = this.inputFrame.getChildAt(i);
                ViewStructure childStructure = structure.newChild(i);
                child.dispatchProvideAutofillStructure(childStructure, flags);
                if (child != this.editText) continue;
                childStructure.setHint(this.getHint());
            }
        }
    }

    private void setEditText(final EditText editText) {
        if (this.editText != null) {
            throw new IllegalArgumentException("We already have an EditText, can only have one");
        }
        if (this.getEndIconMode() != 3 && !(editText instanceof TextInputEditText)) {
            Log.i((String)LOG_TAG, (String)"EditText added is not a TextInputEditText. Please switch to using that class instead.");
        }
        this.editText = editText;
        if (this.minEms != -1) {
            this.setMinEms(this.minEms);
        } else {
            this.setMinWidth(this.minWidth);
        }
        if (this.maxEms != -1) {
            this.setMaxEms(this.maxEms);
        } else {
            this.setMaxWidth(this.maxWidth);
        }
        this.boxBackgroundApplied = false;
        this.onApplyBoxBackgroundMode();
        this.setTextInputAccessibilityDelegate(new AccessibilityDelegate(this));
        this.collapsingTextHelper.setTypefaces(this.editText.getTypeface());
        this.collapsingTextHelper.setExpandedTextSize(this.editText.getTextSize());
        if (Build.VERSION.SDK_INT >= 21) {
            this.collapsingTextHelper.setExpandedLetterSpacing(this.editText.getLetterSpacing());
        }
        int editTextGravity = this.editText.getGravity();
        this.collapsingTextHelper.setCollapsedTextGravity(0x30 | editTextGravity & 0xFFFFFF8F);
        this.collapsingTextHelper.setExpandedTextGravity(editTextGravity);
        this.originalEditTextMinimumHeight = ViewCompat.getMinimumHeight((View)editText);
        this.editText.addTextChangedListener(new TextWatcher(){
            int previousLineCount;
            {
                this.previousLineCount = editText.getLineCount();
            }

            public void afterTextChanged(@NonNull Editable s) {
                int currentLineCount;
                TextInputLayout.this.updateLabelState(!TextInputLayout.this.restoringSavedState);
                if (TextInputLayout.this.counterEnabled) {
                    TextInputLayout.this.updateCounter(s);
                }
                if (TextInputLayout.this.placeholderEnabled) {
                    TextInputLayout.this.updatePlaceholderText(s);
                }
                if ((currentLineCount = editText.getLineCount()) != this.previousLineCount) {
                    if (currentLineCount < this.previousLineCount && ViewCompat.getMinimumHeight((View)editText) != TextInputLayout.this.originalEditTextMinimumHeight) {
                        editText.setMinimumHeight(TextInputLayout.this.originalEditTextMinimumHeight);
                    }
                    this.previousLineCount = currentLineCount;
                }
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        if (this.defaultHintTextColor == null) {
            this.defaultHintTextColor = this.editText.getHintTextColors();
        }
        if (this.hintEnabled) {
            if (TextUtils.isEmpty((CharSequence)this.hint)) {
                this.originalHint = this.editText.getHint();
                this.setHint(this.originalHint);
                this.editText.setHint(null);
            }
            this.isProvidingHint = true;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            this.updateCursorColor();
        }
        if (this.counterView != null) {
            this.updateCounter(this.editText.getText());
        }
        this.updateEditTextBackground();
        this.indicatorViewController.adjustIndicatorPadding();
        this.startLayout.bringToFront();
        this.endLayout.bringToFront();
        this.dispatchOnEditTextAttached();
        this.endLayout.updateSuffixTextViewPadding();
        if (!this.isEnabled()) {
            editText.setEnabled(false);
        }
        this.updateLabelState(false, true);
    }

    private void updateInputLayoutMargins() {
        if (this.boxBackgroundMode != 1) {
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.inputFrame.getLayoutParams();
            int newTopMargin = this.calculateLabelMarginTop();
            if (newTopMargin != lp.topMargin) {
                lp.topMargin = newTopMargin;
                this.inputFrame.requestLayout();
            }
        }
    }

    public int getBaseline() {
        if (this.editText != null) {
            return this.editText.getBaseline() + this.getPaddingTop() + this.calculateLabelMarginTop();
        }
        return super.getBaseline();
    }

    void updateLabelState(boolean animate) {
        this.updateLabelState(animate, false);
    }

    private void updateLabelState(boolean animate, boolean force) {
        boolean hasFocus;
        boolean isEnabled = this.isEnabled();
        boolean hasText = this.editText != null && !TextUtils.isEmpty((CharSequence)this.editText.getText());
        boolean bl = hasFocus = this.editText != null && this.editText.hasFocus();
        if (this.defaultHintTextColor != null) {
            this.collapsingTextHelper.setCollapsedAndExpandedTextColor(this.defaultHintTextColor);
        }
        if (!isEnabled) {
            int disabledHintColor = this.defaultHintTextColor != null ? this.defaultHintTextColor.getColorForState(new int[]{-16842910}, this.disabledColor) : this.disabledColor;
            this.collapsingTextHelper.setCollapsedAndExpandedTextColor(ColorStateList.valueOf((int)disabledHintColor));
        } else if (this.shouldShowError()) {
            this.collapsingTextHelper.setCollapsedAndExpandedTextColor(this.indicatorViewController.getErrorViewTextColors());
        } else if (this.counterOverflowed && this.counterView != null) {
            this.collapsingTextHelper.setCollapsedAndExpandedTextColor(this.counterView.getTextColors());
        } else if (hasFocus && this.focusedTextColor != null) {
            this.collapsingTextHelper.setCollapsedTextColor(this.focusedTextColor);
        }
        if (hasText || !this.expandedHintEnabled || this.isEnabled() && hasFocus) {
            if (force || this.hintExpanded) {
                this.collapseHint(animate);
            }
        } else if (force || !this.hintExpanded) {
            this.expandHint(animate);
        }
    }

    @Nullable
    public EditText getEditText() {
        return this.editText;
    }

    public void setMinEms(int minEms) {
        this.minEms = minEms;
        if (this.editText != null && minEms != -1) {
            this.editText.setMinEms(minEms);
        }
    }

    public int getMinEms() {
        return this.minEms;
    }

    public void setMaxEms(int maxEms) {
        this.maxEms = maxEms;
        if (this.editText != null && maxEms != -1) {
            this.editText.setMaxEms(maxEms);
        }
    }

    public int getMaxEms() {
        return this.maxEms;
    }

    public void setMinWidth(@Px int minWidth) {
        this.minWidth = minWidth;
        if (this.editText != null && minWidth != -1) {
            this.editText.setMinWidth(minWidth);
        }
    }

    public void setMinWidthResource(@DimenRes int minWidthId) {
        this.setMinWidth(this.getContext().getResources().getDimensionPixelSize(minWidthId));
    }

    @Px
    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMaxWidth(@Px int maxWidth) {
        this.maxWidth = maxWidth;
        if (this.editText != null && maxWidth != -1) {
            this.editText.setMaxWidth(maxWidth);
        }
    }

    public void setMaxWidthResource(@DimenRes int maxWidthId) {
        this.setMaxWidth(this.getContext().getResources().getDimensionPixelSize(maxWidthId));
    }

    @Px
    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setHint(@Nullable CharSequence hint) {
        if (this.hintEnabled) {
            this.setHintInternal(hint);
            this.sendAccessibilityEvent(2048);
        }
    }

    public void setHint(@StringRes int textHintId) {
        this.setHint(textHintId != 0 ? this.getResources().getText(textHintId) : null);
    }

    private void setHintInternal(CharSequence hint) {
        if (!TextUtils.equals((CharSequence)hint, (CharSequence)this.hint)) {
            this.hint = hint;
            this.collapsingTextHelper.setText(hint);
            if (!this.hintExpanded) {
                this.openCutout();
            }
        }
    }

    @Nullable
    public CharSequence getHint() {
        return this.hintEnabled ? this.hint : null;
    }

    public void setHintEnabled(boolean enabled) {
        if (enabled != this.hintEnabled) {
            this.hintEnabled = enabled;
            if (!this.hintEnabled) {
                this.isProvidingHint = false;
                if (!TextUtils.isEmpty((CharSequence)this.hint) && TextUtils.isEmpty((CharSequence)this.editText.getHint())) {
                    this.editText.setHint(this.hint);
                }
                this.setHintInternal(null);
            } else {
                CharSequence editTextHint = this.editText.getHint();
                if (!TextUtils.isEmpty((CharSequence)editTextHint)) {
                    if (TextUtils.isEmpty((CharSequence)this.hint)) {
                        this.setHint(editTextHint);
                    }
                    this.editText.setHint(null);
                }
                this.isProvidingHint = true;
            }
            if (this.editText != null) {
                this.updateInputLayoutMargins();
            }
        }
    }

    public boolean isHintEnabled() {
        return this.hintEnabled;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isProvidingHint() {
        return this.isProvidingHint;
    }

    public void setHintTextAppearance(@StyleRes int resId) {
        this.collapsingTextHelper.setCollapsedTextAppearance(resId);
        this.focusedTextColor = this.collapsingTextHelper.getCollapsedTextColor();
        if (this.editText != null) {
            this.updateLabelState(false);
            this.updateInputLayoutMargins();
        }
    }

    public void setHintTextColor(@Nullable ColorStateList hintTextColor) {
        if (this.focusedTextColor != hintTextColor) {
            if (this.defaultHintTextColor == null) {
                this.collapsingTextHelper.setCollapsedTextColor(hintTextColor);
            }
            this.focusedTextColor = hintTextColor;
            if (this.editText != null) {
                this.updateLabelState(false);
            }
        }
    }

    @Nullable
    public ColorStateList getHintTextColor() {
        return this.focusedTextColor;
    }

    public void setDefaultHintTextColor(@Nullable ColorStateList textColor) {
        this.defaultHintTextColor = textColor;
        this.focusedTextColor = textColor;
        if (this.editText != null) {
            this.updateLabelState(false);
        }
    }

    @Nullable
    public ColorStateList getDefaultHintTextColor() {
        return this.defaultHintTextColor;
    }

    public void setErrorEnabled(boolean enabled) {
        this.indicatorViewController.setErrorEnabled(enabled);
    }

    public void setErrorTextAppearance(@StyleRes int errorTextAppearance) {
        this.indicatorViewController.setErrorTextAppearance(errorTextAppearance);
    }

    public void setErrorTextColor(@Nullable ColorStateList errorTextColor) {
        this.indicatorViewController.setErrorViewTextColor(errorTextColor);
    }

    @ColorInt
    public int getErrorCurrentTextColors() {
        return this.indicatorViewController.getErrorViewCurrentTextColor();
    }

    public void setHelperTextTextAppearance(@StyleRes int helperTextTextAppearance) {
        this.indicatorViewController.setHelperTextAppearance(helperTextTextAppearance);
    }

    public void setHelperTextColor(@Nullable ColorStateList helperTextColor) {
        this.indicatorViewController.setHelperTextViewTextColor(helperTextColor);
    }

    public boolean isErrorEnabled() {
        return this.indicatorViewController.isErrorEnabled();
    }

    public void setHelperTextEnabled(boolean enabled) {
        this.indicatorViewController.setHelperTextEnabled(enabled);
    }

    public void setHelperText(@Nullable CharSequence helperText) {
        if (TextUtils.isEmpty((CharSequence)helperText)) {
            if (this.isHelperTextEnabled()) {
                this.setHelperTextEnabled(false);
            }
        } else {
            if (!this.isHelperTextEnabled()) {
                this.setHelperTextEnabled(true);
            }
            this.indicatorViewController.showHelper(helperText);
        }
    }

    public boolean isHelperTextEnabled() {
        return this.indicatorViewController.isHelperTextEnabled();
    }

    @ColorInt
    public int getHelperTextCurrentTextColor() {
        return this.indicatorViewController.getHelperTextViewCurrentTextColor();
    }

    public void setErrorContentDescription(@Nullable CharSequence errorContentDescription) {
        this.indicatorViewController.setErrorContentDescription(errorContentDescription);
    }

    @Nullable
    public CharSequence getErrorContentDescription() {
        return this.indicatorViewController.getErrorContentDescription();
    }

    public void setErrorAccessibilityLiveRegion(int errorAccessibilityLiveRegion) {
        this.indicatorViewController.setErrorAccessibilityLiveRegion(errorAccessibilityLiveRegion);
    }

    public int getErrorAccessibilityLiveRegion() {
        return this.indicatorViewController.getErrorAccessibilityLiveRegion();
    }

    public void setError(@Nullable CharSequence errorText) {
        if (!this.indicatorViewController.isErrorEnabled()) {
            if (TextUtils.isEmpty((CharSequence)errorText)) {
                return;
            }
            this.setErrorEnabled(true);
        }
        if (!TextUtils.isEmpty((CharSequence)errorText)) {
            this.indicatorViewController.showError(errorText);
        } else {
            this.indicatorViewController.hideError();
        }
    }

    public void setErrorIconDrawable(@DrawableRes int resId) {
        this.endLayout.setErrorIconDrawable(resId);
    }

    public void setErrorIconDrawable(@Nullable Drawable errorIconDrawable) {
        this.endLayout.setErrorIconDrawable(errorIconDrawable);
    }

    @Nullable
    public Drawable getErrorIconDrawable() {
        return this.endLayout.getErrorIconDrawable();
    }

    public void setErrorIconTintList(@Nullable ColorStateList errorIconTintList) {
        this.endLayout.setErrorIconTintList(errorIconTintList);
    }

    public void setErrorIconTintMode(@Nullable PorterDuff.Mode errorIconTintMode) {
        this.endLayout.setErrorIconTintMode(errorIconTintMode);
    }

    public void setCounterEnabled(boolean enabled) {
        if (this.counterEnabled != enabled) {
            if (enabled) {
                this.counterView = new AppCompatTextView(this.getContext());
                this.counterView.setId(R.id.textinput_counter);
                if (this.typeface != null) {
                    this.counterView.setTypeface(this.typeface);
                }
                this.counterView.setMaxLines(1);
                this.indicatorViewController.addIndicator(this.counterView, 2);
                MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)this.counterView.getLayoutParams()), (int)this.getResources().getDimensionPixelOffset(R.dimen.mtrl_textinput_counter_margin_start));
                this.updateCounterTextAppearanceAndColor();
                this.updateCounter();
            } else {
                this.indicatorViewController.removeIndicator(this.counterView, 2);
                this.counterView = null;
            }
            this.counterEnabled = enabled;
        }
    }

    public void setCounterTextAppearance(int counterTextAppearance) {
        if (this.counterTextAppearance != counterTextAppearance) {
            this.counterTextAppearance = counterTextAppearance;
            this.updateCounterTextAppearanceAndColor();
        }
    }

    public void setCounterTextColor(@Nullable ColorStateList counterTextColor) {
        if (this.counterTextColor != counterTextColor) {
            this.counterTextColor = counterTextColor;
            this.updateCounterTextAppearanceAndColor();
        }
    }

    @Nullable
    public ColorStateList getCounterTextColor() {
        return this.counterTextColor;
    }

    public void setCounterOverflowTextAppearance(int counterOverflowTextAppearance) {
        if (this.counterOverflowTextAppearance != counterOverflowTextAppearance) {
            this.counterOverflowTextAppearance = counterOverflowTextAppearance;
            this.updateCounterTextAppearanceAndColor();
        }
    }

    public void setCounterOverflowTextColor(@Nullable ColorStateList counterOverflowTextColor) {
        if (this.counterOverflowTextColor != counterOverflowTextColor) {
            this.counterOverflowTextColor = counterOverflowTextColor;
            this.updateCounterTextAppearanceAndColor();
        }
    }

    @Nullable
    public ColorStateList getCounterOverflowTextColor() {
        return this.counterOverflowTextColor;
    }

    public boolean isCounterEnabled() {
        return this.counterEnabled;
    }

    public void setCounterMaxLength(int maxLength) {
        if (this.counterMaxLength != maxLength) {
            this.counterMaxLength = maxLength > 0 ? maxLength : -1;
            if (this.counterEnabled) {
                this.updateCounter();
            }
        }
    }

    private void updateCounter() {
        if (this.counterView != null) {
            this.updateCounter(this.editText == null ? null : this.editText.getText());
        }
    }

    void updateCounter(@Nullable Editable text) {
        int length = this.lengthCounter.countLength(text);
        boolean wasCounterOverflowed = this.counterOverflowed;
        if (this.counterMaxLength == -1) {
            this.counterView.setText((CharSequence)String.valueOf(length));
            this.counterView.setContentDescription(null);
            this.counterOverflowed = false;
        } else {
            this.counterOverflowed = length > this.counterMaxLength;
            TextInputLayout.updateCounterContentDescription(this.getContext(), this.counterView, length, this.counterMaxLength, this.counterOverflowed);
            if (wasCounterOverflowed != this.counterOverflowed) {
                this.updateCounterTextAppearanceAndColor();
            }
            BidiFormatter bidiFormatter = BidiFormatter.getInstance();
            this.counterView.setText((CharSequence)bidiFormatter.unicodeWrap(this.getContext().getString(R.string.character_counter_pattern, new Object[]{length, this.counterMaxLength})));
        }
        if (this.editText != null && wasCounterOverflowed != this.counterOverflowed) {
            this.updateLabelState(false);
            this.updateTextInputBoxState();
            this.updateEditTextBackground();
        }
    }

    private static void updateCounterContentDescription(@NonNull Context context, @NonNull TextView counterView, int length, int counterMaxLength, boolean counterOverflowed) {
        counterView.setContentDescription((CharSequence)context.getString(counterOverflowed ? R.string.character_counter_overflowed_content_description : R.string.character_counter_content_description, new Object[]{length, counterMaxLength}));
    }

    public void setPlaceholderText(@Nullable CharSequence placeholderText) {
        if (this.placeholderTextView == null) {
            this.placeholderTextView = new AppCompatTextView(this.getContext());
            this.placeholderTextView.setId(R.id.textinput_placeholder);
            ViewCompat.setImportantForAccessibility((View)this.placeholderTextView, (int)2);
            this.placeholderFadeIn = this.createPlaceholderFadeTransition();
            this.placeholderFadeIn.setStartDelay(67L);
            this.placeholderFadeOut = this.createPlaceholderFadeTransition();
            this.setPlaceholderTextAppearance(this.placeholderTextAppearance);
            this.setPlaceholderTextColor(this.placeholderTextColor);
        }
        if (TextUtils.isEmpty((CharSequence)placeholderText)) {
            this.setPlaceholderTextEnabled(false);
        } else {
            if (!this.placeholderEnabled) {
                this.setPlaceholderTextEnabled(true);
            }
            this.placeholderText = placeholderText;
        }
        this.updatePlaceholderText();
    }

    @Nullable
    public CharSequence getPlaceholderText() {
        return this.placeholderEnabled ? this.placeholderText : null;
    }

    private void setPlaceholderTextEnabled(boolean placeholderEnabled) {
        if (this.placeholderEnabled == placeholderEnabled) {
            return;
        }
        if (placeholderEnabled) {
            this.addPlaceholderTextView();
        } else {
            this.removePlaceholderTextView();
            this.placeholderTextView = null;
        }
        this.placeholderEnabled = placeholderEnabled;
    }

    private Fade createPlaceholderFadeTransition() {
        Fade placeholderFadeTransition = new Fade();
        placeholderFadeTransition.setDuration((long)MotionUtils.resolveThemeDuration(this.getContext(), R.attr.motionDurationShort2, 87));
        placeholderFadeTransition.setInterpolator(MotionUtils.resolveThemeInterpolator(this.getContext(), R.attr.motionEasingLinearInterpolator, AnimationUtils.LINEAR_INTERPOLATOR));
        return placeholderFadeTransition;
    }

    private void updatePlaceholderText() {
        this.updatePlaceholderText(this.editText == null ? null : this.editText.getText());
    }

    private void updatePlaceholderText(@Nullable Editable text) {
        int length = this.lengthCounter.countLength(text);
        if (length == 0 && !this.hintExpanded) {
            this.showPlaceholderText();
        } else {
            this.hidePlaceholderText();
        }
    }

    private void showPlaceholderText() {
        if (this.placeholderTextView != null && this.placeholderEnabled && !TextUtils.isEmpty((CharSequence)this.placeholderText)) {
            this.placeholderTextView.setText(this.placeholderText);
            TransitionManager.beginDelayedTransition((ViewGroup)this.inputFrame, (Transition)this.placeholderFadeIn);
            this.placeholderTextView.setVisibility(0);
            this.placeholderTextView.bringToFront();
            if (Build.VERSION.SDK_INT >= 16) {
                this.announceForAccessibility(this.placeholderText);
            }
        }
    }

    private void hidePlaceholderText() {
        if (this.placeholderTextView != null && this.placeholderEnabled) {
            this.placeholderTextView.setText(null);
            TransitionManager.beginDelayedTransition((ViewGroup)this.inputFrame, (Transition)this.placeholderFadeOut);
            this.placeholderTextView.setVisibility(4);
        }
    }

    private void addPlaceholderTextView() {
        if (this.placeholderTextView != null) {
            this.inputFrame.addView((View)this.placeholderTextView);
            this.placeholderTextView.setVisibility(0);
        }
    }

    private void removePlaceholderTextView() {
        if (this.placeholderTextView != null) {
            this.placeholderTextView.setVisibility(8);
        }
    }

    public void setPlaceholderTextColor(@Nullable ColorStateList placeholderTextColor) {
        if (this.placeholderTextColor != placeholderTextColor) {
            this.placeholderTextColor = placeholderTextColor;
            if (this.placeholderTextView != null && placeholderTextColor != null) {
                this.placeholderTextView.setTextColor(placeholderTextColor);
            }
        }
    }

    @Nullable
    public ColorStateList getPlaceholderTextColor() {
        return this.placeholderTextColor;
    }

    public void setPlaceholderTextAppearance(@StyleRes int placeholderTextAppearance) {
        this.placeholderTextAppearance = placeholderTextAppearance;
        if (this.placeholderTextView != null) {
            TextViewCompat.setTextAppearance((TextView)this.placeholderTextView, (int)placeholderTextAppearance);
        }
    }

    @StyleRes
    public int getPlaceholderTextAppearance() {
        return this.placeholderTextAppearance;
    }

    @RequiresApi(value=29)
    public void setCursorColor(@Nullable ColorStateList cursorColor) {
        if (this.cursorColor != cursorColor) {
            this.cursorColor = cursorColor;
            this.updateCursorColor();
        }
    }

    @Nullable
    @RequiresApi(value=29)
    public ColorStateList getCursorColor() {
        return this.cursorColor;
    }

    @RequiresApi(value=29)
    public void setCursorErrorColor(@Nullable ColorStateList cursorErrorColor) {
        if (this.cursorErrorColor != cursorErrorColor) {
            this.cursorErrorColor = cursorErrorColor;
            if (this.isOnError()) {
                this.updateCursorColor();
            }
        }
    }

    @Nullable
    @RequiresApi(value=29)
    public ColorStateList getCursorErrorColor() {
        return this.cursorErrorColor;
    }

    public void setPrefixText(@Nullable CharSequence prefixText) {
        this.startLayout.setPrefixText(prefixText);
    }

    @Nullable
    public CharSequence getPrefixText() {
        return this.startLayout.getPrefixText();
    }

    @NonNull
    public TextView getPrefixTextView() {
        return this.startLayout.getPrefixTextView();
    }

    public void setPrefixTextColor(@NonNull ColorStateList prefixTextColor) {
        this.startLayout.setPrefixTextColor(prefixTextColor);
    }

    @Nullable
    public ColorStateList getPrefixTextColor() {
        return this.startLayout.getPrefixTextColor();
    }

    public void setPrefixTextAppearance(@StyleRes int prefixTextAppearance) {
        this.startLayout.setPrefixTextAppearance(prefixTextAppearance);
    }

    public void setSuffixText(@Nullable CharSequence suffixText) {
        this.endLayout.setSuffixText(suffixText);
    }

    @Nullable
    public CharSequence getSuffixText() {
        return this.endLayout.getSuffixText();
    }

    @NonNull
    public TextView getSuffixTextView() {
        return this.endLayout.getSuffixTextView();
    }

    public void setSuffixTextColor(@NonNull ColorStateList suffixTextColor) {
        this.endLayout.setSuffixTextColor(suffixTextColor);
    }

    @Nullable
    public ColorStateList getSuffixTextColor() {
        return this.endLayout.getSuffixTextColor();
    }

    public void setSuffixTextAppearance(@StyleRes int suffixTextAppearance) {
        this.endLayout.setSuffixTextAppearance(suffixTextAppearance);
    }

    public void setEnabled(boolean enabled) {
        TextInputLayout.recursiveSetEnabled((ViewGroup)this, enabled);
        super.setEnabled(enabled);
    }

    private static void recursiveSetEnabled(@NonNull ViewGroup vg, boolean enabled) {
        int count = vg.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = vg.getChildAt(i);
            child.setEnabled(enabled);
            if (!(child instanceof ViewGroup)) continue;
            TextInputLayout.recursiveSetEnabled((ViewGroup)child, enabled);
        }
    }

    public int getCounterMaxLength() {
        return this.counterMaxLength;
    }

    @Nullable
    CharSequence getCounterOverflowDescription() {
        if (this.counterEnabled && this.counterOverflowed && this.counterView != null) {
            return this.counterView.getContentDescription();
        }
        return null;
    }

    private void updateCounterTextAppearanceAndColor() {
        if (this.counterView != null) {
            this.setTextAppearanceCompatWithErrorFallback(this.counterView, this.counterOverflowed ? this.counterOverflowTextAppearance : this.counterTextAppearance);
            if (!this.counterOverflowed && this.counterTextColor != null) {
                this.counterView.setTextColor(this.counterTextColor);
            }
            if (this.counterOverflowed && this.counterOverflowTextColor != null) {
                this.counterView.setTextColor(this.counterOverflowTextColor);
            }
        }
    }

    void setTextAppearanceCompatWithErrorFallback(@NonNull TextView textView, @StyleRes int textAppearance) {
        boolean useDefaultColor = false;
        try {
            TextViewCompat.setTextAppearance((TextView)textView, (int)textAppearance);
            if (Build.VERSION.SDK_INT >= 23 && textView.getTextColors().getDefaultColor() == -65281) {
                useDefaultColor = true;
            }
        }
        catch (Exception e) {
            useDefaultColor = true;
        }
        if (useDefaultColor) {
            TextViewCompat.setTextAppearance((TextView)textView, (int)R.style.TextAppearance_AppCompat_Caption);
            textView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.design_error));
        }
    }

    private int calculateLabelMarginTop() {
        if (!this.hintEnabled) {
            return 0;
        }
        switch (this.boxBackgroundMode) {
            case 2: {
                return (int)(this.collapsingTextHelper.getCollapsedTextHeight() / 2.0f);
            }
            case 0: {
                return (int)this.collapsingTextHelper.getCollapsedTextHeight();
            }
        }
        return 0;
    }

    @NonNull
    private Rect calculateCollapsedTextBounds(@NonNull Rect rect) {
        if (this.editText == null) {
            throw new IllegalStateException();
        }
        Rect bounds = this.tmpBoundsRect;
        boolean isRtl = ViewUtils.isLayoutRtl((View)this);
        bounds.bottom = rect.bottom;
        switch (this.boxBackgroundMode) {
            case 2: {
                bounds.left = rect.left + this.editText.getPaddingLeft();
                bounds.top = rect.top - this.calculateLabelMarginTop();
                bounds.right = rect.right - this.editText.getPaddingRight();
                return bounds;
            }
            case 1: {
                bounds.left = this.getLabelLeftBoundAlignedWithPrefixAndSuffix(rect.left, isRtl);
                bounds.top = rect.top + this.boxCollapsedPaddingTopPx;
                bounds.right = this.getLabelRightBoundAlignedWithPrefixAndSuffix(rect.right, isRtl);
                return bounds;
            }
        }
        bounds.left = this.getLabelLeftBoundAlignedWithPrefixAndSuffix(rect.left, isRtl);
        bounds.top = this.getPaddingTop();
        bounds.right = this.getLabelRightBoundAlignedWithPrefixAndSuffix(rect.right, isRtl);
        return bounds;
    }

    private int getLabelLeftBoundAlignedWithPrefixAndSuffix(int rectLeft, boolean isRtl) {
        if (!isRtl && this.getPrefixText() != null) {
            return rectLeft + this.startLayout.getPrefixTextStartOffset();
        }
        if (isRtl && this.getSuffixText() != null) {
            return rectLeft + this.endLayout.getSuffixTextEndOffset();
        }
        return rectLeft + this.editText.getCompoundPaddingLeft();
    }

    private int getLabelRightBoundAlignedWithPrefixAndSuffix(int rectRight, boolean isRtl) {
        if (!isRtl && this.getSuffixText() != null) {
            return rectRight - this.endLayout.getSuffixTextEndOffset();
        }
        if (isRtl && this.getPrefixText() != null) {
            return rectRight - this.startLayout.getPrefixTextStartOffset();
        }
        return rectRight - this.editText.getCompoundPaddingRight();
    }

    @NonNull
    private Rect calculateExpandedTextBounds(@NonNull Rect rect) {
        if (this.editText == null) {
            throw new IllegalStateException();
        }
        Rect bounds = this.tmpBoundsRect;
        float labelHeight = this.collapsingTextHelper.getExpandedTextHeight();
        bounds.left = rect.left + this.editText.getCompoundPaddingLeft();
        bounds.top = this.calculateExpandedLabelTop(rect, labelHeight);
        bounds.right = rect.right - this.editText.getCompoundPaddingRight();
        bounds.bottom = this.calculateExpandedLabelBottom(rect, bounds, labelHeight);
        return bounds;
    }

    private int calculateExpandedLabelTop(@NonNull Rect rect, float labelHeight) {
        if (this.isSingleLineFilledTextField()) {
            return (int)((float)rect.centerY() - labelHeight / 2.0f);
        }
        return rect.top + this.editText.getCompoundPaddingTop();
    }

    private int calculateExpandedLabelBottom(@NonNull Rect rect, @NonNull Rect bounds, float labelHeight) {
        if (this.isSingleLineFilledTextField()) {
            return (int)((float)bounds.top + labelHeight);
        }
        return rect.bottom - this.editText.getCompoundPaddingBottom();
    }

    private boolean isSingleLineFilledTextField() {
        return this.boxBackgroundMode == 1 && (Build.VERSION.SDK_INT < 16 || this.editText.getMinLines() <= 1);
    }

    private int calculateBoxBackgroundColor() {
        int backgroundColor = this.boxBackgroundColor;
        if (this.boxBackgroundMode == 1) {
            int surfaceLayerColor = MaterialColors.getColor((View)this, R.attr.colorSurface, 0);
            backgroundColor = MaterialColors.layer(surfaceLayerColor, this.boxBackgroundColor);
        }
        return backgroundColor;
    }

    private void applyBoxAttributes() {
        if (this.boxBackground == null) {
            return;
        }
        if (this.boxBackground.getShapeAppearanceModel() != this.shapeAppearanceModel) {
            this.boxBackground.setShapeAppearanceModel(this.shapeAppearanceModel);
        }
        if (this.canDrawOutlineStroke()) {
            this.boxBackground.setStroke((float)this.boxStrokeWidthPx, this.boxStrokeColor);
        }
        this.boxBackgroundColor = this.calculateBoxBackgroundColor();
        this.boxBackground.setFillColor(ColorStateList.valueOf((int)this.boxBackgroundColor));
        this.applyBoxUnderlineAttributes();
        this.updateEditTextBoxBackgroundIfNeeded();
    }

    private void applyBoxUnderlineAttributes() {
        if (this.boxUnderlineDefault == null || this.boxUnderlineFocused == null) {
            return;
        }
        if (this.canDrawStroke()) {
            this.boxUnderlineDefault.setFillColor(this.editText.isFocused() ? ColorStateList.valueOf((int)this.defaultStrokeColor) : ColorStateList.valueOf((int)this.boxStrokeColor));
            this.boxUnderlineFocused.setFillColor(ColorStateList.valueOf((int)this.boxStrokeColor));
        }
        this.invalidate();
    }

    private boolean canDrawOutlineStroke() {
        return this.boxBackgroundMode == 2 && this.canDrawStroke();
    }

    private boolean canDrawStroke() {
        return this.boxStrokeWidthPx > -1 && this.boxStrokeColor != 0;
    }

    void updateEditTextBackground() {
        if (this.editText == null || this.boxBackgroundMode != 0) {
            return;
        }
        Drawable editTextBackground = this.editText.getBackground();
        if (editTextBackground == null) {
            return;
        }
        if (DrawableUtils.canSafelyMutateDrawable((Drawable)editTextBackground)) {
            editTextBackground = editTextBackground.mutate();
        }
        if (this.shouldShowError()) {
            editTextBackground.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter((int)this.getErrorCurrentTextColors(), (PorterDuff.Mode)PorterDuff.Mode.SRC_IN));
        } else if (this.counterOverflowed && this.counterView != null) {
            editTextBackground.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter((int)this.counterView.getCurrentTextColor(), (PorterDuff.Mode)PorterDuff.Mode.SRC_IN));
        } else {
            DrawableCompat.clearColorFilter((Drawable)editTextBackground);
            this.editText.refreshDrawableState();
        }
    }

    boolean shouldShowError() {
        return this.indicatorViewController.errorShouldBeShown();
    }

    @Nullable
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        if (this.shouldShowError()) {
            ss.error = this.getError();
        }
        ss.isEndIconChecked = this.endLayout.isEndIconChecked();
        return ss;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setError(ss.error);
        if (ss.isEndIconChecked) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    TextInputLayout.this.endLayout.checkEndIcon();
                }
            });
        }
        this.requestLayout();
    }

    protected void dispatchRestoreInstanceState(@NonNull SparseArray<Parcelable> container) {
        this.restoringSavedState = true;
        super.dispatchRestoreInstanceState(container);
        this.restoringSavedState = false;
    }

    @Nullable
    public CharSequence getError() {
        return this.indicatorViewController.isErrorEnabled() ? this.indicatorViewController.getErrorText() : null;
    }

    @Nullable
    public CharSequence getHelperText() {
        return this.indicatorViewController.isHelperTextEnabled() ? this.indicatorViewController.getHelperText() : null;
    }

    public boolean isHintAnimationEnabled() {
        return this.hintAnimationEnabled;
    }

    public void setHintAnimationEnabled(boolean enabled) {
        this.hintAnimationEnabled = enabled;
    }

    public boolean isExpandedHintEnabled() {
        return this.expandedHintEnabled;
    }

    public void setExpandedHintEnabled(boolean enabled) {
        if (this.expandedHintEnabled != enabled) {
            this.expandedHintEnabled = enabled;
            this.updateLabelState(false);
        }
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        boolean isLayoutDirectionRtl;
        super.onRtlPropertiesChanged(layoutDirection);
        boolean bl = isLayoutDirectionRtl = layoutDirection == 1;
        if (isLayoutDirectionRtl != this.areCornerRadiiRtl) {
            float boxCornerRadiusTopLeft = this.shapeAppearanceModel.getTopLeftCornerSize().getCornerSize(this.tmpRectF);
            float boxCornerRadiusTopRight = this.shapeAppearanceModel.getTopRightCornerSize().getCornerSize(this.tmpRectF);
            float boxCornerRadiusBottomLeft = this.shapeAppearanceModel.getBottomLeftCornerSize().getCornerSize(this.tmpRectF);
            float boxCornerRadiusBottomRight = this.shapeAppearanceModel.getBottomRightCornerSize().getCornerSize(this.tmpRectF);
            CornerTreatment topLeftTreatment = this.shapeAppearanceModel.getTopLeftCorner();
            CornerTreatment topRightTreatment = this.shapeAppearanceModel.getTopRightCorner();
            CornerTreatment bottomLeftTreatment = this.shapeAppearanceModel.getBottomLeftCorner();
            CornerTreatment bottomRightTreatment = this.shapeAppearanceModel.getBottomRightCorner();
            ShapeAppearanceModel newShapeAppearanceModel = ShapeAppearanceModel.builder().setTopLeftCorner(topRightTreatment).setTopRightCorner(topLeftTreatment).setBottomLeftCorner(bottomRightTreatment).setBottomRightCorner(bottomLeftTreatment).setTopLeftCornerSize(boxCornerRadiusTopRight).setTopRightCornerSize(boxCornerRadiusTopLeft).setBottomLeftCornerSize(boxCornerRadiusBottomRight).setBottomRightCornerSize(boxCornerRadiusBottomLeft).build();
            this.areCornerRadiiRtl = isLayoutDirectionRtl;
            this.setShapeAppearanceModel(newShapeAppearanceModel);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.globalLayoutListenerAdded) {
            this.endLayout.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            this.globalLayoutListenerAdded = true;
        }
        this.updatePlaceholderMeasurementsBasedOnEditText();
        this.endLayout.updateSuffixTextViewPadding();
    }

    private boolean updateEditTextHeightBasedOnIcon() {
        if (this.editText == null) {
            return false;
        }
        int maxIconHeight = Math.max(this.endLayout.getMeasuredHeight(), this.startLayout.getMeasuredHeight());
        if (this.editText.getMeasuredHeight() < maxIconHeight) {
            this.editText.setMinimumHeight(maxIconHeight);
            return true;
        }
        return false;
    }

    private void updatePlaceholderMeasurementsBasedOnEditText() {
        if (this.placeholderTextView != null && this.editText != null) {
            int editTextGravity = this.editText.getGravity();
            this.placeholderTextView.setGravity(editTextGravity);
            this.placeholderTextView.setPadding(this.editText.getCompoundPaddingLeft(), this.editText.getCompoundPaddingTop(), this.editText.getCompoundPaddingRight(), this.editText.getCompoundPaddingBottom());
        }
    }

    public void setStartIconDrawable(@DrawableRes int resId) {
        this.setStartIconDrawable(resId != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)resId) : null);
    }

    public void setStartIconDrawable(@Nullable Drawable startIconDrawable) {
        this.startLayout.setStartIconDrawable(startIconDrawable);
    }

    @Nullable
    public Drawable getStartIconDrawable() {
        return this.startLayout.getStartIconDrawable();
    }

    public void setStartIconMinSize(@IntRange(from=0L) int iconSize) {
        this.startLayout.setStartIconMinSize(iconSize);
    }

    public int getStartIconMinSize() {
        return this.startLayout.getStartIconMinSize();
    }

    public void setStartIconOnClickListener(@Nullable View.OnClickListener startIconOnClickListener) {
        this.startLayout.setStartIconOnClickListener(startIconOnClickListener);
    }

    public void setStartIconOnLongClickListener(@Nullable View.OnLongClickListener startIconOnLongClickListener) {
        this.startLayout.setStartIconOnLongClickListener(startIconOnLongClickListener);
    }

    public void setStartIconVisible(boolean visible) {
        this.startLayout.setStartIconVisible(visible);
    }

    public boolean isStartIconVisible() {
        return this.startLayout.isStartIconVisible();
    }

    public void refreshStartIconDrawableState() {
        this.startLayout.refreshStartIconDrawableState();
    }

    public void setStartIconCheckable(boolean startIconCheckable) {
        this.startLayout.setStartIconCheckable(startIconCheckable);
    }

    public boolean isStartIconCheckable() {
        return this.startLayout.isStartIconCheckable();
    }

    public void setStartIconContentDescription(@StringRes int resId) {
        this.setStartIconContentDescription(resId != 0 ? this.getResources().getText(resId) : null);
    }

    public void setStartIconContentDescription(@Nullable CharSequence startIconContentDescription) {
        this.startLayout.setStartIconContentDescription(startIconContentDescription);
    }

    @Nullable
    public CharSequence getStartIconContentDescription() {
        return this.startLayout.getStartIconContentDescription();
    }

    public void setStartIconTintList(@Nullable ColorStateList startIconTintList) {
        this.startLayout.setStartIconTintList(startIconTintList);
    }

    public void setStartIconTintMode(@Nullable PorterDuff.Mode startIconTintMode) {
        this.startLayout.setStartIconTintMode(startIconTintMode);
    }

    public void setEndIconMode(int endIconMode) {
        this.endLayout.setEndIconMode(endIconMode);
    }

    public int getEndIconMode() {
        return this.endLayout.getEndIconMode();
    }

    public void setEndIconOnClickListener(@Nullable View.OnClickListener endIconOnClickListener) {
        this.endLayout.setEndIconOnClickListener(endIconOnClickListener);
    }

    public void setErrorIconOnClickListener(@Nullable View.OnClickListener errorIconOnClickListener) {
        this.endLayout.setErrorIconOnClickListener(errorIconOnClickListener);
    }

    public void setEndIconOnLongClickListener(@Nullable View.OnLongClickListener endIconOnLongClickListener) {
        this.endLayout.setEndIconOnLongClickListener(endIconOnLongClickListener);
    }

    public void setErrorIconOnLongClickListener(@Nullable View.OnLongClickListener errorIconOnLongClickListener) {
        this.endLayout.setErrorIconOnLongClickListener(errorIconOnLongClickListener);
    }

    public void refreshErrorIconDrawableState() {
        this.endLayout.refreshErrorIconDrawableState();
    }

    public void setEndIconVisible(boolean visible) {
        this.endLayout.setEndIconVisible(visible);
    }

    public boolean isEndIconVisible() {
        return this.endLayout.isEndIconVisible();
    }

    public void setEndIconActivated(boolean endIconActivated) {
        this.endLayout.setEndIconActivated(endIconActivated);
    }

    public void refreshEndIconDrawableState() {
        this.endLayout.refreshEndIconDrawableState();
    }

    public void setEndIconCheckable(boolean endIconCheckable) {
        this.endLayout.setEndIconCheckable(endIconCheckable);
    }

    public boolean isEndIconCheckable() {
        return this.endLayout.isEndIconCheckable();
    }

    public void setEndIconDrawable(@DrawableRes int resId) {
        this.endLayout.setEndIconDrawable(resId);
    }

    public void setEndIconDrawable(@Nullable Drawable endIconDrawable) {
        this.endLayout.setEndIconDrawable(endIconDrawable);
    }

    @Nullable
    public Drawable getEndIconDrawable() {
        return this.endLayout.getEndIconDrawable();
    }

    public void setEndIconMinSize(@IntRange(from=0L) int iconSize) {
        this.endLayout.setEndIconMinSize(iconSize);
    }

    public int getEndIconMinSize() {
        return this.endLayout.getEndIconMinSize();
    }

    public void setStartIconScaleType(@NonNull ImageView.ScaleType scaleType) {
        this.startLayout.setStartIconScaleType(scaleType);
    }

    @NonNull
    public ImageView.ScaleType getStartIconScaleType() {
        return this.startLayout.getStartIconScaleType();
    }

    public void setEndIconScaleType(@NonNull ImageView.ScaleType scaleType) {
        this.endLayout.setEndIconScaleType(scaleType);
    }

    @NonNull
    public ImageView.ScaleType getEndIconScaleType() {
        return this.endLayout.getEndIconScaleType();
    }

    public void setEndIconContentDescription(@StringRes int resId) {
        this.endLayout.setEndIconContentDescription(resId);
    }

    public void setEndIconContentDescription(@Nullable CharSequence endIconContentDescription) {
        this.endLayout.setEndIconContentDescription(endIconContentDescription);
    }

    @Nullable
    public CharSequence getEndIconContentDescription() {
        return this.endLayout.getEndIconContentDescription();
    }

    public void setEndIconTintList(@Nullable ColorStateList endIconTintList) {
        this.endLayout.setEndIconTintList(endIconTintList);
    }

    public void setEndIconTintMode(@Nullable PorterDuff.Mode endIconTintMode) {
        this.endLayout.setEndIconTintMode(endIconTintMode);
    }

    public void addOnEndIconChangedListener(@NonNull OnEndIconChangedListener listener) {
        this.endLayout.addOnEndIconChangedListener(listener);
    }

    public void removeOnEndIconChangedListener(@NonNull OnEndIconChangedListener listener) {
        this.endLayout.removeOnEndIconChangedListener(listener);
    }

    public void clearOnEndIconChangedListeners() {
        this.endLayout.clearOnEndIconChangedListeners();
    }

    public void addOnEditTextAttachedListener(@NonNull OnEditTextAttachedListener listener) {
        this.editTextAttachedListeners.add(listener);
        if (this.editText != null) {
            listener.onEditTextAttached(this);
        }
    }

    public void removeOnEditTextAttachedListener(@NonNull OnEditTextAttachedListener listener) {
        this.editTextAttachedListeners.remove(listener);
    }

    public void clearOnEditTextAttachedListeners() {
        this.editTextAttachedListeners.clear();
    }

    @Deprecated
    public void setPasswordVisibilityToggleDrawable(@DrawableRes int resId) {
        this.endLayout.setPasswordVisibilityToggleDrawable(resId);
    }

    @Deprecated
    public void setPasswordVisibilityToggleDrawable(@Nullable Drawable icon) {
        this.endLayout.setPasswordVisibilityToggleDrawable(icon);
    }

    @Deprecated
    public void setPasswordVisibilityToggleContentDescription(@StringRes int resId) {
        this.endLayout.setPasswordVisibilityToggleContentDescription(resId);
    }

    @Deprecated
    public void setPasswordVisibilityToggleContentDescription(@Nullable CharSequence description) {
        this.endLayout.setPasswordVisibilityToggleContentDescription(description);
    }

    @Deprecated
    @Nullable
    public Drawable getPasswordVisibilityToggleDrawable() {
        return this.endLayout.getPasswordVisibilityToggleDrawable();
    }

    @Deprecated
    @Nullable
    public CharSequence getPasswordVisibilityToggleContentDescription() {
        return this.endLayout.getPasswordVisibilityToggleContentDescription();
    }

    @Deprecated
    public boolean isPasswordVisibilityToggleEnabled() {
        return this.endLayout.isPasswordVisibilityToggleEnabled();
    }

    @Deprecated
    public void setPasswordVisibilityToggleEnabled(boolean enabled) {
        this.endLayout.setPasswordVisibilityToggleEnabled(enabled);
    }

    @Deprecated
    public void setPasswordVisibilityToggleTintList(@Nullable ColorStateList tintList) {
        this.endLayout.setPasswordVisibilityToggleTintList(tintList);
    }

    @Deprecated
    public void setPasswordVisibilityToggleTintMode(@Nullable PorterDuff.Mode mode) {
        this.endLayout.setPasswordVisibilityToggleTintMode(mode);
    }

    @Deprecated
    public void passwordVisibilityToggleRequested(boolean shouldSkipAnimations) {
        this.endLayout.togglePasswordVisibilityToggle(shouldSkipAnimations);
    }

    public void setTextInputAccessibilityDelegate(@Nullable AccessibilityDelegate delegate) {
        if (this.editText != null) {
            ViewCompat.setAccessibilityDelegate((View)this.editText, (AccessibilityDelegateCompat)delegate);
        }
    }

    @NonNull
    CheckableImageButton getEndIconView() {
        return this.endLayout.getEndIconView();
    }

    private void dispatchOnEditTextAttached() {
        for (OnEditTextAttachedListener listener : this.editTextAttachedListeners) {
            listener.onEditTextAttached(this);
        }
    }

    boolean updateDummyDrawables() {
        int right;
        if (this.editText == null) {
            return false;
        }
        boolean updatedIcon = false;
        if (this.shouldUpdateStartDummyDrawable()) {
            Drawable[] compounds;
            right = this.startLayout.getMeasuredWidth() - this.editText.getPaddingLeft();
            if (this.startDummyDrawable == null || this.startDummyDrawableWidth != right) {
                this.startDummyDrawable = new ColorDrawable();
                this.startDummyDrawableWidth = right;
                this.startDummyDrawable.setBounds(0, 0, this.startDummyDrawableWidth, 1);
            }
            if ((compounds = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText))[0] != this.startDummyDrawable) {
                TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)this.startDummyDrawable, (Drawable)compounds[1], (Drawable)compounds[2], (Drawable)compounds[3]);
                updatedIcon = true;
            }
        } else if (this.startDummyDrawable != null) {
            Drawable[] compounds = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText);
            TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, null, (Drawable)compounds[1], (Drawable)compounds[2], (Drawable)compounds[3]);
            this.startDummyDrawable = null;
            updatedIcon = true;
        }
        if (this.shouldUpdateEndDummyDrawable()) {
            right = this.endLayout.getSuffixTextView().getMeasuredWidth() - this.editText.getPaddingRight();
            CheckableImageButton iconView = this.endLayout.getCurrentEndIconView();
            if (iconView != null) {
                right = right + iconView.getMeasuredWidth() + MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)iconView.getLayoutParams()));
            }
            Drawable[] compounds = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText);
            if (this.endDummyDrawable != null && this.endDummyDrawableWidth != right) {
                this.endDummyDrawableWidth = right;
                this.endDummyDrawable.setBounds(0, 0, this.endDummyDrawableWidth, 1);
                TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)compounds[0], (Drawable)compounds[1], (Drawable)this.endDummyDrawable, (Drawable)compounds[3]);
                updatedIcon = true;
            } else {
                if (this.endDummyDrawable == null) {
                    this.endDummyDrawable = new ColorDrawable();
                    this.endDummyDrawableWidth = right;
                    this.endDummyDrawable.setBounds(0, 0, this.endDummyDrawableWidth, 1);
                }
                if (compounds[2] != this.endDummyDrawable) {
                    this.originalEditTextEndDrawable = compounds[2];
                    TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)compounds[0], (Drawable)compounds[1], (Drawable)this.endDummyDrawable, (Drawable)compounds[3]);
                    updatedIcon = true;
                }
            }
        } else if (this.endDummyDrawable != null) {
            Drawable[] compounds = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText);
            if (compounds[2] == this.endDummyDrawable) {
                TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)compounds[0], (Drawable)compounds[1], (Drawable)this.originalEditTextEndDrawable, (Drawable)compounds[3]);
                updatedIcon = true;
            }
            this.endDummyDrawable = null;
        }
        return updatedIcon;
    }

    private boolean shouldUpdateStartDummyDrawable() {
        return (this.getStartIconDrawable() != null || this.getPrefixText() != null && this.getPrefixTextView().getVisibility() == 0) && this.startLayout.getMeasuredWidth() > 0;
    }

    private boolean shouldUpdateEndDummyDrawable() {
        return (this.endLayout.isErrorIconVisible() || this.endLayout.hasEndIcon() && this.isEndIconVisible() || this.endLayout.getSuffixText() != null) && this.endLayout.getMeasuredWidth() > 0;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.editText != null) {
            Rect rect = this.tmpRect;
            DescendantOffsetUtils.getDescendantRect((ViewGroup)this, (View)this.editText, rect);
            this.updateBoxUnderlineBounds(rect);
            if (this.hintEnabled) {
                this.collapsingTextHelper.setExpandedTextSize(this.editText.getTextSize());
                int editTextGravity = this.editText.getGravity();
                this.collapsingTextHelper.setCollapsedTextGravity(0x30 | editTextGravity & 0xFFFFFF8F);
                this.collapsingTextHelper.setExpandedTextGravity(editTextGravity);
                this.collapsingTextHelper.setCollapsedBounds(this.calculateCollapsedTextBounds(rect));
                this.collapsingTextHelper.setExpandedBounds(this.calculateExpandedTextBounds(rect));
                this.collapsingTextHelper.recalculate();
                if (this.cutoutEnabled() && !this.hintExpanded) {
                    this.openCutout();
                }
            }
        }
    }

    private void updateBoxUnderlineBounds(@NonNull Rect bounds) {
        int top;
        if (this.boxUnderlineDefault != null) {
            top = bounds.bottom - this.boxStrokeWidthDefaultPx;
            this.boxUnderlineDefault.setBounds(bounds.left, top, bounds.right, bounds.bottom);
        }
        if (this.boxUnderlineFocused != null) {
            top = bounds.bottom - this.boxStrokeWidthFocusedPx;
            this.boxUnderlineFocused.setBounds(bounds.left, top, bounds.right, bounds.bottom);
        }
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        this.drawHint(canvas);
        this.drawBoxUnderline(canvas);
    }

    protected void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.collapsingTextHelper.maybeUpdateFontWeightAdjustment(newConfig);
    }

    private void drawHint(@NonNull Canvas canvas) {
        if (this.hintEnabled) {
            this.collapsingTextHelper.draw(canvas);
        }
    }

    private void drawBoxUnderline(Canvas canvas) {
        if (this.boxUnderlineFocused != null && this.boxUnderlineDefault != null) {
            this.boxUnderlineDefault.draw(canvas);
            if (this.editText.isFocused()) {
                Rect focusedUnderlineBounds = this.boxUnderlineFocused.getBounds();
                Rect defaultUnderlineBounds = this.boxUnderlineDefault.getBounds();
                float hintExpansionFraction = this.collapsingTextHelper.getExpansionFraction();
                int midpointX = defaultUnderlineBounds.centerX();
                focusedUnderlineBounds.left = AnimationUtils.lerp(midpointX, defaultUnderlineBounds.left, hintExpansionFraction);
                focusedUnderlineBounds.right = AnimationUtils.lerp(midpointX, defaultUnderlineBounds.right, hintExpansionFraction);
                this.boxUnderlineFocused.draw(canvas);
            }
        }
    }

    private void collapseHint(boolean animate) {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.cancel();
        }
        if (animate && this.hintAnimationEnabled) {
            this.animateToExpansionFraction(1.0f);
        } else {
            this.collapsingTextHelper.setExpansionFraction(1.0f);
        }
        this.hintExpanded = false;
        if (this.cutoutEnabled()) {
            this.openCutout();
        }
        this.updatePlaceholderText();
        this.startLayout.onHintStateChanged(false);
        this.endLayout.onHintStateChanged(false);
    }

    private boolean cutoutEnabled() {
        return this.hintEnabled && !TextUtils.isEmpty((CharSequence)this.hint) && this.boxBackground instanceof CutoutDrawable;
    }

    private void openCutout() {
        if (!this.cutoutEnabled()) {
            return;
        }
        RectF cutoutBounds = this.tmpRectF;
        this.collapsingTextHelper.getCollapsedTextActualBounds(cutoutBounds, this.editText.getWidth(), this.editText.getGravity());
        if (cutoutBounds.width() <= 0.0f || cutoutBounds.height() <= 0.0f) {
            return;
        }
        this.applyCutoutPadding(cutoutBounds);
        cutoutBounds.offset((float)(-this.getPaddingLeft()), (float)(-this.getPaddingTop()) - cutoutBounds.height() / 2.0f + (float)this.boxStrokeWidthPx);
        ((CutoutDrawable)this.boxBackground).setCutout(cutoutBounds);
    }

    private void recalculateCutout() {
        if (this.cutoutEnabled() && !this.hintExpanded) {
            this.closeCutout();
            this.openCutout();
        }
    }

    private void closeCutout() {
        if (this.cutoutEnabled()) {
            ((CutoutDrawable)this.boxBackground).removeCutout();
        }
    }

    private void applyCutoutPadding(@NonNull RectF cutoutBounds) {
        cutoutBounds.left -= (float)this.boxLabelCutoutPaddingPx;
        cutoutBounds.right += (float)this.boxLabelCutoutPaddingPx;
    }

    @VisibleForTesting
    boolean cutoutIsOpen() {
        return this.cutoutEnabled() && ((CutoutDrawable)this.boxBackground).hasCutout();
    }

    protected void drawableStateChanged() {
        if (this.inDrawableStateChanged) {
            return;
        }
        this.inDrawableStateChanged = true;
        super.drawableStateChanged();
        int[] state = this.getDrawableState();
        boolean changed = false;
        if (this.collapsingTextHelper != null) {
            changed |= this.collapsingTextHelper.setState(state);
        }
        if (this.editText != null) {
            this.updateLabelState(ViewCompat.isLaidOut((View)this) && this.isEnabled());
        }
        this.updateEditTextBackground();
        this.updateTextInputBoxState();
        if (changed) {
            this.invalidate();
        }
        this.inDrawableStateChanged = false;
    }

    void updateTextInputBoxState() {
        boolean isHovered;
        if (this.boxBackground == null || this.boxBackgroundMode == 0) {
            return;
        }
        boolean hasFocus = this.isFocused() || this.editText != null && this.editText.hasFocus();
        boolean bl = isHovered = this.isHovered() || this.editText != null && this.editText.isHovered();
        if (!this.isEnabled()) {
            this.boxStrokeColor = this.disabledColor;
        } else if (this.shouldShowError()) {
            if (this.strokeErrorColor != null) {
                this.updateStrokeErrorColor(hasFocus, isHovered);
            } else {
                this.boxStrokeColor = this.getErrorCurrentTextColors();
            }
        } else if (this.counterOverflowed && this.counterView != null) {
            if (this.strokeErrorColor != null) {
                this.updateStrokeErrorColor(hasFocus, isHovered);
            } else {
                this.boxStrokeColor = this.counterView.getCurrentTextColor();
            }
        } else {
            this.boxStrokeColor = hasFocus ? this.focusedStrokeColor : (isHovered ? this.hoveredStrokeColor : this.defaultStrokeColor);
        }
        if (Build.VERSION.SDK_INT >= 29) {
            this.updateCursorColor();
        }
        this.endLayout.onTextInputBoxStateUpdated();
        this.refreshStartIconDrawableState();
        if (this.boxBackgroundMode == 2) {
            int originalBoxStrokeWidthPx = this.boxStrokeWidthPx;
            this.boxStrokeWidthPx = hasFocus && this.isEnabled() ? this.boxStrokeWidthFocusedPx : this.boxStrokeWidthDefaultPx;
            if (this.boxStrokeWidthPx != originalBoxStrokeWidthPx) {
                this.recalculateCutout();
            }
        }
        if (this.boxBackgroundMode == 1) {
            this.boxBackgroundColor = !this.isEnabled() ? this.disabledFilledBackgroundColor : (isHovered && !hasFocus ? this.hoveredFilledBackgroundColor : (hasFocus ? this.focusedFilledBackgroundColor : this.defaultFilledBackgroundColor));
        }
        this.applyBoxAttributes();
    }

    private boolean isOnError() {
        return this.shouldShowError() || this.counterView != null && this.counterOverflowed;
    }

    private void updateStrokeErrorColor(boolean hasFocus, boolean isHovered) {
        int defaultStrokeErrorColor = this.strokeErrorColor.getDefaultColor();
        int hoveredStrokeErrorColor = this.strokeErrorColor.getColorForState(new int[]{16843623, 16842910}, defaultStrokeErrorColor);
        int focusedStrokeErrorColor = this.strokeErrorColor.getColorForState(new int[]{16843518, 16842910}, defaultStrokeErrorColor);
        this.boxStrokeColor = hasFocus ? focusedStrokeErrorColor : (isHovered ? hoveredStrokeErrorColor : defaultStrokeErrorColor);
    }

    @RequiresApi(value=29)
    private void updateCursorColor() {
        ColorStateList color2;
        ColorStateList colorStateList = color2 = this.cursorColor != null ? this.cursorColor : MaterialColors.getColorStateListOrNull(this.getContext(), R.attr.colorControlActivated);
        if (this.editText == null || this.editText.getTextCursorDrawable() == null) {
            return;
        }
        Drawable cursorDrawable = DrawableCompat.wrap((Drawable)this.editText.getTextCursorDrawable()).mutate();
        if (this.isOnError() && this.cursorErrorColor != null) {
            color2 = this.cursorErrorColor;
        }
        DrawableCompat.setTintList((Drawable)cursorDrawable, (ColorStateList)color2);
    }

    private void expandHint(boolean animate) {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.cancel();
        }
        if (animate && this.hintAnimationEnabled) {
            this.animateToExpansionFraction(0.0f);
        } else {
            this.collapsingTextHelper.setExpansionFraction(0.0f);
        }
        if (this.cutoutEnabled() && ((CutoutDrawable)this.boxBackground).hasCutout()) {
            this.closeCutout();
        }
        this.hintExpanded = true;
        this.hidePlaceholderText();
        this.startLayout.onHintStateChanged(true);
        this.endLayout.onHintStateChanged(true);
    }

    @VisibleForTesting
    void animateToExpansionFraction(float target) {
        if (this.collapsingTextHelper.getExpansionFraction() == target) {
            return;
        }
        if (this.animator == null) {
            this.animator = new ValueAnimator();
            this.animator.setInterpolator(MotionUtils.resolveThemeInterpolator(this.getContext(), R.attr.motionEasingEmphasizedInterpolator, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
            this.animator.setDuration((long)MotionUtils.resolveThemeDuration(this.getContext(), R.attr.motionDurationMedium4, 167));
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(@NonNull ValueAnimator animator2) {
                    TextInputLayout.this.collapsingTextHelper.setExpansionFraction(((Float)animator2.getAnimatedValue()).floatValue());
                }
            });
        }
        this.animator.setFloatValues(new float[]{this.collapsingTextHelper.getExpansionFraction(), target});
        this.animator.start();
    }

    final boolean isHintExpanded() {
        return this.hintExpanded;
    }

    @VisibleForTesting
    final boolean isHelperTextDisplayed() {
        return this.indicatorViewController.helperTextIsDisplayed();
    }

    @VisibleForTesting
    final int getHintCurrentCollapsedTextColor() {
        return this.collapsingTextHelper.getCurrentCollapsedTextColor();
    }

    @VisibleForTesting
    final float getHintCollapsedTextHeight() {
        return this.collapsingTextHelper.getCollapsedTextHeight();
    }

    public static class AccessibilityDelegate
    extends AccessibilityDelegateCompat {
        private final TextInputLayout layout;

        public AccessibilityDelegate(@NonNull TextInputLayout layout2) {
            this.layout = layout2;
        }

        public void onInitializeAccessibilityNodeInfo(@NonNull View host, @NonNull AccessibilityNodeInfoCompat info) {
            View helperTextView;
            super.onInitializeAccessibilityNodeInfo(host, info);
            EditText editText = this.layout.getEditText();
            Editable inputText = editText != null ? editText.getText() : null;
            CharSequence hintText = this.layout.getHint();
            CharSequence errorText = this.layout.getError();
            CharSequence placeholderText = this.layout.getPlaceholderText();
            int maxCharLimit = this.layout.getCounterMaxLength();
            CharSequence counterOverflowDesc = this.layout.getCounterOverflowDescription();
            boolean showingText = !TextUtils.isEmpty((CharSequence)inputText);
            boolean hasHint = !TextUtils.isEmpty((CharSequence)hintText);
            boolean isHintCollapsed = !this.layout.isHintExpanded();
            boolean showingError = !TextUtils.isEmpty((CharSequence)errorText);
            boolean contentInvalid = showingError || !TextUtils.isEmpty((CharSequence)counterOverflowDesc);
            String hint = hasHint ? hintText.toString() : "";
            this.layout.startLayout.setupAccessibilityNodeInfo(info);
            if (showingText) {
                info.setText((CharSequence)inputText);
            } else if (!TextUtils.isEmpty((CharSequence)hint)) {
                info.setText((CharSequence)hint);
                if (isHintCollapsed && placeholderText != null) {
                    info.setText((CharSequence)(hint + ", " + placeholderText));
                }
            } else if (placeholderText != null) {
                info.setText(placeholderText);
            }
            if (!TextUtils.isEmpty((CharSequence)hint)) {
                if (Build.VERSION.SDK_INT >= 26) {
                    info.setHintText((CharSequence)hint);
                } else {
                    String text = showingText ? inputText + ", " + hint : hint;
                    info.setText((CharSequence)text);
                }
                info.setShowingHintText(!showingText);
            }
            info.setMaxTextLength(inputText != null && inputText.length() == maxCharLimit ? maxCharLimit : -1);
            if (contentInvalid) {
                info.setError(showingError ? errorText : counterOverflowDesc);
            }
            if (Build.VERSION.SDK_INT >= 17 && (helperTextView = this.layout.indicatorViewController.getHelperTextView()) != null) {
                info.setLabelFor(helperTextView);
            }
            this.layout.endLayout.getEndIconDelegate().onInitializeAccessibilityNodeInfo(host, info);
        }

        public void onPopulateAccessibilityEvent(@NonNull View host, @NonNull AccessibilityEvent event) {
            super.onPopulateAccessibilityEvent(host, event);
            this.layout.endLayout.getEndIconDelegate().onPopulateAccessibilityEvent(host, event);
        }
    }

    static class SavedState
    extends AbsSavedState {
        @Nullable
        CharSequence error;
        boolean isEndIconChecked;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            @Nullable
            public SavedState createFromParcel(@NonNull Parcel in) {
                return new SavedState(in, null);
            }

            @NonNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        SavedState(@NonNull Parcel source, ClassLoader loader) {
            super(source, loader);
            this.error = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            this.isEndIconChecked = source.readInt() == 1;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            TextUtils.writeToParcel((CharSequence)this.error, (Parcel)dest, (int)flags);
            dest.writeInt(this.isEndIconChecked ? 1 : 0);
        }

        @NonNull
        public String toString() {
            return "TextInputLayout.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " error=" + this.error + "}";
        }
    }

    public static interface OnEndIconChangedListener {
        public void onEndIconChanged(@NonNull TextInputLayout var1, int var2);
    }

    public static interface OnEditTextAttachedListener {
        public void onEditTextAttached(@NonNull TextInputLayout var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface EndIconMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BoxBackgroundMode {
    }

    public static interface LengthCounter {
        public int countLength(@Nullable Editable var1);
    }
}

