/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.core.util.Preconditions;
import androidx.core.view.ViewCompat;
import androidx.transition.ArcMotion;
import androidx.transition.PathMotion;
import androidx.transition.Transition;
import androidx.transition.TransitionValues;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.canvas.CanvasCompat;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.Shapeable;
import com.google.android.material.transition.FadeModeEvaluator;
import com.google.android.material.transition.FadeModeEvaluators;
import com.google.android.material.transition.FadeModeResult;
import com.google.android.material.transition.FitModeEvaluator;
import com.google.android.material.transition.FitModeEvaluators;
import com.google.android.material.transition.FitModeResult;
import com.google.android.material.transition.MaskEvaluator;
import com.google.android.material.transition.MaterialArcMotion;
import com.google.android.material.transition.TransitionListenerAdapter;
import com.google.android.material.transition.TransitionUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class MaterialContainerTransform
extends Transition {
    public static final int TRANSITION_DIRECTION_AUTO = 0;
    public static final int TRANSITION_DIRECTION_ENTER = 1;
    public static final int TRANSITION_DIRECTION_RETURN = 2;
    public static final int FADE_MODE_IN = 0;
    public static final int FADE_MODE_OUT = 1;
    public static final int FADE_MODE_CROSS = 2;
    public static final int FADE_MODE_THROUGH = 3;
    public static final int FIT_MODE_AUTO = 0;
    public static final int FIT_MODE_WIDTH = 1;
    public static final int FIT_MODE_HEIGHT = 2;
    private static final String TAG = MaterialContainerTransform.class.getSimpleName();
    private static final String PROP_BOUNDS = "materialContainerTransition:bounds";
    private static final String PROP_SHAPE_APPEARANCE = "materialContainerTransition:shapeAppearance";
    private static final String[] TRANSITION_PROPS = new String[]{"materialContainerTransition:bounds", "materialContainerTransition:shapeAppearance"};
    private static final ProgressThresholdsGroup DEFAULT_ENTER_THRESHOLDS = new ProgressThresholdsGroup(new ProgressThresholds(0.0f, 0.25f), new ProgressThresholds(0.0f, 1.0f), new ProgressThresholds(0.0f, 1.0f), new ProgressThresholds(0.0f, 0.75f));
    private static final ProgressThresholdsGroup DEFAULT_RETURN_THRESHOLDS = new ProgressThresholdsGroup(new ProgressThresholds(0.6f, 0.9f), new ProgressThresholds(0.0f, 1.0f), new ProgressThresholds(0.0f, 0.9f), new ProgressThresholds(0.3f, 0.9f));
    private static final ProgressThresholdsGroup DEFAULT_ENTER_THRESHOLDS_ARC = new ProgressThresholdsGroup(new ProgressThresholds(0.1f, 0.4f), new ProgressThresholds(0.1f, 1.0f), new ProgressThresholds(0.1f, 1.0f), new ProgressThresholds(0.1f, 0.9f));
    private static final ProgressThresholdsGroup DEFAULT_RETURN_THRESHOLDS_ARC = new ProgressThresholdsGroup(new ProgressThresholds(0.6f, 0.9f), new ProgressThresholds(0.0f, 0.9f), new ProgressThresholds(0.0f, 0.9f), new ProgressThresholds(0.2f, 0.9f));
    private static final float ELEVATION_NOT_SET = -1.0f;
    private boolean drawDebugEnabled = false;
    private boolean holdAtEndEnabled = false;
    private boolean pathMotionCustom = false;
    private boolean appliedThemeValues = false;
    @IdRes
    private int drawingViewId = 0x1020002;
    @IdRes
    private int startViewId = -1;
    @IdRes
    private int endViewId = -1;
    @ColorInt
    private int containerColor = 0;
    @ColorInt
    private int startContainerColor = 0;
    @ColorInt
    private int endContainerColor = 0;
    @ColorInt
    private int scrimColor = 0x52000000;
    private int transitionDirection = 0;
    private int fadeMode = 0;
    private int fitMode = 0;
    @Nullable
    private View startView;
    @Nullable
    private View endView;
    @Nullable
    private ShapeAppearanceModel startShapeAppearanceModel;
    @Nullable
    private ShapeAppearanceModel endShapeAppearanceModel;
    @Nullable
    private ProgressThresholds fadeProgressThresholds;
    @Nullable
    private ProgressThresholds scaleProgressThresholds;
    @Nullable
    private ProgressThresholds scaleMaskProgressThresholds;
    @Nullable
    private ProgressThresholds shapeMaskProgressThresholds;
    private boolean elevationShadowEnabled = Build.VERSION.SDK_INT >= 28;
    private float startElevation = -1.0f;
    private float endElevation = -1.0f;

    public MaterialContainerTransform() {
    }

    public MaterialContainerTransform(@NonNull Context context, boolean entering) {
        this.maybeApplyThemeValues(context, entering);
        this.appliedThemeValues = true;
    }

    @IdRes
    public int getStartViewId() {
        return this.startViewId;
    }

    public void setStartViewId(@IdRes int startViewId) {
        this.startViewId = startViewId;
    }

    @IdRes
    public int getEndViewId() {
        return this.endViewId;
    }

    public void setEndViewId(@IdRes int endViewId) {
        this.endViewId = endViewId;
    }

    @Nullable
    public View getStartView() {
        return this.startView;
    }

    public void setStartView(@Nullable View startView) {
        this.startView = startView;
    }

    @Nullable
    public View getEndView() {
        return this.endView;
    }

    public void setEndView(@Nullable View endView) {
        this.endView = endView;
    }

    @Nullable
    public ShapeAppearanceModel getStartShapeAppearanceModel() {
        return this.startShapeAppearanceModel;
    }

    public void setStartShapeAppearanceModel(@Nullable ShapeAppearanceModel startShapeAppearanceModel) {
        this.startShapeAppearanceModel = startShapeAppearanceModel;
    }

    @Nullable
    public ShapeAppearanceModel getEndShapeAppearanceModel() {
        return this.endShapeAppearanceModel;
    }

    public void setEndShapeAppearanceModel(@Nullable ShapeAppearanceModel endShapeAppearanceModel) {
        this.endShapeAppearanceModel = endShapeAppearanceModel;
    }

    public boolean isElevationShadowEnabled() {
        return this.elevationShadowEnabled;
    }

    public void setElevationShadowEnabled(boolean elevationShadowEnabled) {
        this.elevationShadowEnabled = elevationShadowEnabled;
    }

    public float getStartElevation() {
        return this.startElevation;
    }

    public void setStartElevation(float startElevation) {
        this.startElevation = startElevation;
    }

    public float getEndElevation() {
        return this.endElevation;
    }

    public void setEndElevation(float endElevation) {
        this.endElevation = endElevation;
    }

    @IdRes
    public int getDrawingViewId() {
        return this.drawingViewId;
    }

    public void setDrawingViewId(@IdRes int drawingViewId) {
        this.drawingViewId = drawingViewId;
    }

    @ColorInt
    public int getContainerColor() {
        return this.containerColor;
    }

    public void setContainerColor(@ColorInt int containerColor) {
        this.containerColor = containerColor;
    }

    @ColorInt
    public int getStartContainerColor() {
        return this.startContainerColor;
    }

    public void setStartContainerColor(@ColorInt int containerColor) {
        this.startContainerColor = containerColor;
    }

    @ColorInt
    public int getEndContainerColor() {
        return this.endContainerColor;
    }

    public void setEndContainerColor(@ColorInt int containerColor) {
        this.endContainerColor = containerColor;
    }

    public void setAllContainerColors(@ColorInt int containerColor) {
        this.containerColor = containerColor;
        this.startContainerColor = containerColor;
        this.endContainerColor = containerColor;
    }

    @ColorInt
    public int getScrimColor() {
        return this.scrimColor;
    }

    public void setScrimColor(@ColorInt int scrimColor) {
        this.scrimColor = scrimColor;
    }

    public int getTransitionDirection() {
        return this.transitionDirection;
    }

    public void setTransitionDirection(int transitionDirection) {
        this.transitionDirection = transitionDirection;
    }

    public int getFadeMode() {
        return this.fadeMode;
    }

    public void setFadeMode(int fadeMode) {
        this.fadeMode = fadeMode;
    }

    public int getFitMode() {
        return this.fitMode;
    }

    public void setFitMode(int fitMode) {
        this.fitMode = fitMode;
    }

    @Nullable
    public ProgressThresholds getFadeProgressThresholds() {
        return this.fadeProgressThresholds;
    }

    public void setFadeProgressThresholds(@Nullable ProgressThresholds fadeProgressThresholds) {
        this.fadeProgressThresholds = fadeProgressThresholds;
    }

    @Nullable
    public ProgressThresholds getScaleProgressThresholds() {
        return this.scaleProgressThresholds;
    }

    public void setScaleProgressThresholds(@Nullable ProgressThresholds scaleProgressThresholds) {
        this.scaleProgressThresholds = scaleProgressThresholds;
    }

    @Nullable
    public ProgressThresholds getScaleMaskProgressThresholds() {
        return this.scaleMaskProgressThresholds;
    }

    public void setScaleMaskProgressThresholds(@Nullable ProgressThresholds scaleMaskProgressThresholds) {
        this.scaleMaskProgressThresholds = scaleMaskProgressThresholds;
    }

    @Nullable
    public ProgressThresholds getShapeMaskProgressThresholds() {
        return this.shapeMaskProgressThresholds;
    }

    public void setShapeMaskProgressThresholds(@Nullable ProgressThresholds shapeMaskProgressThresholds) {
        this.shapeMaskProgressThresholds = shapeMaskProgressThresholds;
    }

    public boolean isHoldAtEndEnabled() {
        return this.holdAtEndEnabled;
    }

    public void setHoldAtEndEnabled(boolean holdAtEndEnabled) {
        this.holdAtEndEnabled = holdAtEndEnabled;
    }

    public boolean isDrawDebugEnabled() {
        return this.drawDebugEnabled;
    }

    public void setDrawDebugEnabled(boolean drawDebugEnabled) {
        this.drawDebugEnabled = drawDebugEnabled;
    }

    public void setPathMotion(@Nullable PathMotion pathMotion) {
        super.setPathMotion(pathMotion);
        this.pathMotionCustom = true;
    }

    @Nullable
    public String[] getTransitionProperties() {
        return TRANSITION_PROPS;
    }

    public void captureStartValues(@NonNull TransitionValues transitionValues) {
        MaterialContainerTransform.captureValues(transitionValues, this.startView, this.startViewId, this.startShapeAppearanceModel);
    }

    public void captureEndValues(@NonNull TransitionValues transitionValues) {
        MaterialContainerTransform.captureValues(transitionValues, this.endView, this.endViewId, this.endShapeAppearanceModel);
    }

    private static void captureValues(@NonNull TransitionValues transitionValues, @Nullable View viewOverride, @IdRes int viewIdOverride, @Nullable ShapeAppearanceModel shapeAppearanceModelOverride) {
        if (viewIdOverride != -1) {
            transitionValues.view = TransitionUtils.findDescendantOrAncestorById(transitionValues.view, viewIdOverride);
        } else if (viewOverride != null) {
            transitionValues.view = viewOverride;
        } else if (transitionValues.view.getTag(R.id.mtrl_motion_snapshot_view) instanceof View) {
            View snapshotView = (View)transitionValues.view.getTag(R.id.mtrl_motion_snapshot_view);
            transitionValues.view.setTag(R.id.mtrl_motion_snapshot_view, null);
            transitionValues.view = snapshotView;
        }
        View view = transitionValues.view;
        if (ViewCompat.isLaidOut((View)view) || view.getWidth() != 0 || view.getHeight() != 0) {
            RectF bounds = view.getParent() == null ? TransitionUtils.getRelativeBounds(view) : TransitionUtils.getLocationOnScreen(view);
            transitionValues.values.put(PROP_BOUNDS, bounds);
            transitionValues.values.put(PROP_SHAPE_APPEARANCE, MaterialContainerTransform.captureShapeAppearance(view, bounds, shapeAppearanceModelOverride));
        }
    }

    private static ShapeAppearanceModel captureShapeAppearance(@NonNull View view, @NonNull RectF bounds, @Nullable ShapeAppearanceModel shapeAppearanceModelOverride) {
        ShapeAppearanceModel shapeAppearanceModel = MaterialContainerTransform.getShapeAppearance(view, shapeAppearanceModelOverride);
        return TransitionUtils.convertToRelativeCornerSizes(shapeAppearanceModel, bounds);
    }

    private static ShapeAppearanceModel getShapeAppearance(@NonNull View view, @Nullable ShapeAppearanceModel shapeAppearanceModelOverride) {
        if (shapeAppearanceModelOverride != null) {
            return shapeAppearanceModelOverride;
        }
        if (view.getTag(R.id.mtrl_motion_snapshot_view) instanceof ShapeAppearanceModel) {
            return (ShapeAppearanceModel)view.getTag(R.id.mtrl_motion_snapshot_view);
        }
        Context context = view.getContext();
        int transitionShapeAppearanceResId = MaterialContainerTransform.getTransitionShapeAppearanceResId(context);
        if (transitionShapeAppearanceResId != -1) {
            return ShapeAppearanceModel.builder(context, transitionShapeAppearanceResId, 0).build();
        }
        if (view instanceof Shapeable) {
            return ((Shapeable)view).getShapeAppearanceModel();
        }
        return ShapeAppearanceModel.builder().build();
    }

    @StyleRes
    private static int getTransitionShapeAppearanceResId(Context context) {
        TypedArray a = context.obtainStyledAttributes(new int[]{R.attr.transitionShapeAppearance});
        int transitionShapeAppearanceResId = a.getResourceId(0, -1);
        a.recycle();
        return transitionShapeAppearanceResId;
    }

    @Nullable
    public Animator createAnimator(@NonNull ViewGroup sceneRoot, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        View boundingView;
        View drawingView;
        View drawingBaseView;
        if (startValues == null || endValues == null) {
            return null;
        }
        RectF startBounds = (RectF)startValues.values.get(PROP_BOUNDS);
        ShapeAppearanceModel startShapeAppearanceModel = (ShapeAppearanceModel)startValues.values.get(PROP_SHAPE_APPEARANCE);
        if (startBounds == null || startShapeAppearanceModel == null) {
            Log.w((String)TAG, (String)"Skipping due to null start bounds. Ensure start view is laid out and measured.");
            return null;
        }
        RectF endBounds = (RectF)endValues.values.get(PROP_BOUNDS);
        ShapeAppearanceModel endShapeAppearanceModel = (ShapeAppearanceModel)endValues.values.get(PROP_SHAPE_APPEARANCE);
        if (endBounds == null || endShapeAppearanceModel == null) {
            Log.w((String)TAG, (String)"Skipping due to null end bounds. Ensure end view is laid out and measured.");
            return null;
        }
        final View startView = startValues.view;
        final View endView = endValues.view;
        View view = drawingBaseView = endView.getParent() != null ? endView : startView;
        if (this.drawingViewId == drawingBaseView.getId()) {
            drawingView = (View)drawingBaseView.getParent();
            boundingView = drawingBaseView;
        } else {
            drawingView = TransitionUtils.findAncestorById(drawingBaseView, this.drawingViewId);
            boundingView = null;
        }
        RectF drawingViewBounds = TransitionUtils.getLocationOnScreen(drawingView);
        float offsetX = -drawingViewBounds.left;
        float offsetY = -drawingViewBounds.top;
        RectF drawableBounds = MaterialContainerTransform.calculateDrawableBounds(drawingView, boundingView, offsetX, offsetY);
        startBounds.offset(offsetX, offsetY);
        endBounds.offset(offsetX, offsetY);
        boolean entering = this.isEntering(startBounds, endBounds);
        if (!this.appliedThemeValues) {
            this.maybeApplyThemeValues(drawingBaseView.getContext(), entering);
        }
        final TransitionDrawable transitionDrawable = new TransitionDrawable(this.getPathMotion(), startView, startBounds, startShapeAppearanceModel, MaterialContainerTransform.getElevationOrDefault(this.startElevation, startView), endView, endBounds, endShapeAppearanceModel, MaterialContainerTransform.getElevationOrDefault(this.endElevation, endView), this.containerColor, this.startContainerColor, this.endContainerColor, this.scrimColor, entering, this.elevationShadowEnabled, FadeModeEvaluators.get(this.fadeMode, entering), FitModeEvaluators.get(this.fitMode, entering, startBounds, endBounds), this.buildThresholdsGroup(entering), this.drawDebugEnabled);
        transitionDrawable.setBounds(Math.round(drawableBounds.left), Math.round(drawableBounds.top), Math.round(drawableBounds.right), Math.round(drawableBounds.bottom));
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                transitionDrawable.setProgress(animation.getAnimatedFraction());
            }
        });
        this.addListener(new TransitionListenerAdapter(){

            @Override
            public void onTransitionStart(@NonNull Transition transition) {
                ViewUtils.getOverlay(drawingView).add(transitionDrawable);
                startView.setAlpha(0.0f);
                endView.setAlpha(0.0f);
            }

            @Override
            public void onTransitionEnd(@NonNull Transition transition) {
                MaterialContainerTransform.this.removeListener(this);
                if (MaterialContainerTransform.this.holdAtEndEnabled) {
                    return;
                }
                startView.setAlpha(1.0f);
                endView.setAlpha(1.0f);
                ViewUtils.getOverlay(drawingView).remove(transitionDrawable);
            }
        });
        return animator2;
    }

    private void maybeApplyThemeValues(Context context, boolean entering) {
        TransitionUtils.maybeApplyThemeInterpolator(this, context, R.attr.motionEasingEmphasizedInterpolator, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        TransitionUtils.maybeApplyThemeDuration(this, context, entering ? R.attr.motionDurationLong2 : R.attr.motionDurationMedium4);
        if (!this.pathMotionCustom) {
            TransitionUtils.maybeApplyThemePath(this, context, R.attr.motionPath);
        }
    }

    private static float getElevationOrDefault(float elevation, View view) {
        return elevation != -1.0f ? elevation : ViewCompat.getElevation((View)view);
    }

    private static RectF calculateDrawableBounds(View drawingView, @Nullable View boundingView, float offsetX, float offsetY) {
        if (boundingView != null) {
            RectF drawableBounds = TransitionUtils.getLocationOnScreen(boundingView);
            drawableBounds.offset(offsetX, offsetY);
            return drawableBounds;
        }
        return new RectF(0.0f, 0.0f, (float)drawingView.getWidth(), (float)drawingView.getHeight());
    }

    private boolean isEntering(@NonNull RectF startBounds, @NonNull RectF endBounds) {
        switch (this.transitionDirection) {
            case 0: {
                return TransitionUtils.calculateArea(endBounds) > TransitionUtils.calculateArea(startBounds);
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid transition direction: " + this.transitionDirection);
    }

    private ProgressThresholdsGroup buildThresholdsGroup(boolean entering) {
        PathMotion pathMotion = this.getPathMotion();
        if (pathMotion instanceof ArcMotion || pathMotion instanceof MaterialArcMotion) {
            return this.getThresholdsOrDefault(entering, DEFAULT_ENTER_THRESHOLDS_ARC, DEFAULT_RETURN_THRESHOLDS_ARC);
        }
        return this.getThresholdsOrDefault(entering, DEFAULT_ENTER_THRESHOLDS, DEFAULT_RETURN_THRESHOLDS);
    }

    private ProgressThresholdsGroup getThresholdsOrDefault(boolean entering, ProgressThresholdsGroup defaultEnterThresholds, ProgressThresholdsGroup defaultReturnThresholds) {
        ProgressThresholdsGroup defaultThresholds = entering ? defaultEnterThresholds : defaultReturnThresholds;
        return new ProgressThresholdsGroup(TransitionUtils.defaultIfNull(this.fadeProgressThresholds, defaultThresholds.fade), TransitionUtils.defaultIfNull(this.scaleProgressThresholds, defaultThresholds.scale), TransitionUtils.defaultIfNull(this.scaleMaskProgressThresholds, defaultThresholds.scaleMask), TransitionUtils.defaultIfNull(this.shapeMaskProgressThresholds, defaultThresholds.shapeMask));
    }

    private static class ProgressThresholdsGroup {
        @NonNull
        private final ProgressThresholds fade;
        @NonNull
        private final ProgressThresholds scale;
        @NonNull
        private final ProgressThresholds scaleMask;
        @NonNull
        private final ProgressThresholds shapeMask;

        private ProgressThresholdsGroup(@NonNull ProgressThresholds fade, @NonNull ProgressThresholds scale, @NonNull ProgressThresholds scaleMask, @NonNull ProgressThresholds shapeMask) {
            this.fade = fade;
            this.scale = scale;
            this.scaleMask = scaleMask;
            this.shapeMask = shapeMask;
        }
    }

    public static class ProgressThresholds {
        @FloatRange(from=0.0, to=1.0)
        private final float start;
        @FloatRange(from=0.0, to=1.0)
        private final float end;

        public ProgressThresholds(@FloatRange(from=0.0, to=1.0) float start, @FloatRange(from=0.0, to=1.0) float end) {
            this.start = start;
            this.end = end;
        }

        @FloatRange(from=0.0, to=1.0)
        public float getStart() {
            return this.start;
        }

        @FloatRange(from=0.0, to=1.0)
        public float getEnd() {
            return this.end;
        }
    }

    private static final class TransitionDrawable
    extends Drawable {
        private static final int SHADOW_COLOR = 0x2D000000;
        private static final int COMPAT_SHADOW_COLOR = -7829368;
        private static final float SHADOW_DX_MULTIPLIER_ADJUSTMENT = 0.3f;
        private static final float SHADOW_DY_MULTIPLIER_ADJUSTMENT = 1.5f;
        private final View startView;
        private final RectF startBounds;
        private final ShapeAppearanceModel startShapeAppearanceModel;
        private final float startElevation;
        private final View endView;
        private final RectF endBounds;
        private final ShapeAppearanceModel endShapeAppearanceModel;
        private final float endElevation;
        private final Paint containerPaint = new Paint();
        private final Paint startContainerPaint = new Paint();
        private final Paint endContainerPaint = new Paint();
        private final Paint shadowPaint = new Paint();
        private final Paint scrimPaint = new Paint();
        private final MaskEvaluator maskEvaluator = new MaskEvaluator();
        private final PathMeasure motionPathMeasure;
        private final float motionPathLength;
        private final float[] motionPathPosition = new float[2];
        private final boolean entering;
        private final float displayWidth;
        private final float displayHeight;
        private final boolean elevationShadowEnabled;
        private final MaterialShapeDrawable compatShadowDrawable = new MaterialShapeDrawable();
        private final RectF currentStartBounds;
        private final RectF currentStartBoundsMasked;
        private final RectF currentEndBounds;
        private final RectF currentEndBoundsMasked;
        private final ProgressThresholdsGroup progressThresholds;
        private final FadeModeEvaluator fadeModeEvaluator;
        private final FitModeEvaluator fitModeEvaluator;
        private final boolean drawDebugEnabled;
        private final Paint debugPaint = new Paint();
        private final Path debugPath = new Path();
        private FadeModeResult fadeModeResult;
        private FitModeResult fitModeResult;
        private RectF currentMaskBounds;
        private float currentElevation;
        private float currentElevationDy;
        private float progress;

        private TransitionDrawable(PathMotion pathMotion, View startView, RectF startBounds, ShapeAppearanceModel startShapeAppearanceModel, float startElevation, View endView, RectF endBounds, ShapeAppearanceModel endShapeAppearanceModel, float endElevation, @ColorInt int containerColor, @ColorInt int startContainerColor, @ColorInt int endContainerColor, int scrimColor, boolean entering, boolean elevationShadowEnabled, FadeModeEvaluator fadeModeEvaluator, FitModeEvaluator fitModeEvaluator, ProgressThresholdsGroup progressThresholds, boolean drawDebugEnabled) {
            this.startView = startView;
            this.startBounds = startBounds;
            this.startShapeAppearanceModel = startShapeAppearanceModel;
            this.startElevation = startElevation;
            this.endView = endView;
            this.endBounds = endBounds;
            this.endShapeAppearanceModel = endShapeAppearanceModel;
            this.endElevation = endElevation;
            this.entering = entering;
            this.elevationShadowEnabled = elevationShadowEnabled;
            this.fadeModeEvaluator = fadeModeEvaluator;
            this.fitModeEvaluator = fitModeEvaluator;
            this.progressThresholds = progressThresholds;
            this.drawDebugEnabled = drawDebugEnabled;
            WindowManager windowManager = (WindowManager)startView.getContext().getSystemService("window");
            DisplayMetrics displayMetrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            this.displayWidth = displayMetrics.widthPixels;
            this.displayHeight = displayMetrics.heightPixels;
            this.containerPaint.setColor(containerColor);
            this.startContainerPaint.setColor(startContainerColor);
            this.endContainerPaint.setColor(endContainerColor);
            this.compatShadowDrawable.setFillColor(ColorStateList.valueOf((int)0));
            this.compatShadowDrawable.setShadowCompatibilityMode(2);
            this.compatShadowDrawable.setShadowBitmapDrawingEnable(false);
            this.compatShadowDrawable.setShadowColor(-7829368);
            this.currentStartBounds = new RectF(startBounds);
            this.currentStartBoundsMasked = new RectF(this.currentStartBounds);
            this.currentEndBounds = new RectF(this.currentStartBounds);
            this.currentEndBoundsMasked = new RectF(this.currentEndBounds);
            PointF startPoint = TransitionDrawable.getMotionPathPoint(startBounds);
            PointF endPoint = TransitionDrawable.getMotionPathPoint(endBounds);
            Path motionPath = pathMotion.getPath(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
            this.motionPathMeasure = new PathMeasure(motionPath, false);
            this.motionPathLength = this.motionPathMeasure.getLength();
            this.motionPathPosition[0] = startBounds.centerX();
            this.motionPathPosition[1] = startBounds.top;
            this.scrimPaint.setStyle(Paint.Style.FILL);
            this.scrimPaint.setShader(TransitionUtils.createColorShader(scrimColor));
            this.debugPaint.setStyle(Paint.Style.STROKE);
            this.debugPaint.setStrokeWidth(10.0f);
            this.updateProgress(0.0f);
        }

        public void draw(@NonNull Canvas canvas) {
            int debugCanvasSave;
            if (this.scrimPaint.getAlpha() > 0) {
                canvas.drawRect(this.getBounds(), this.scrimPaint);
            }
            int n = debugCanvasSave = this.drawDebugEnabled ? canvas.save() : -1;
            if (this.elevationShadowEnabled && this.currentElevation > 0.0f) {
                this.drawElevationShadow(canvas);
            }
            this.maskEvaluator.clip(canvas);
            this.maybeDrawContainerColor(canvas, this.containerPaint);
            if (this.fadeModeResult.endOnTop) {
                this.drawStartView(canvas);
                this.drawEndView(canvas);
            } else {
                this.drawEndView(canvas);
                this.drawStartView(canvas);
            }
            if (this.drawDebugEnabled) {
                canvas.restoreToCount(debugCanvasSave);
                this.drawDebugCumulativePath(canvas, this.currentStartBounds, this.debugPath, -65281);
                this.drawDebugRect(canvas, this.currentStartBoundsMasked, -256);
                this.drawDebugRect(canvas, this.currentStartBounds, -16711936);
                this.drawDebugRect(canvas, this.currentEndBoundsMasked, -16711681);
                this.drawDebugRect(canvas, this.currentEndBounds, -16776961);
            }
        }

        private void drawElevationShadow(Canvas canvas) {
            canvas.save();
            canvas.clipPath(this.maskEvaluator.getPath(), Region.Op.DIFFERENCE);
            if (Build.VERSION.SDK_INT > 28) {
                this.drawElevationShadowWithPaintShadowLayer(canvas);
            } else {
                this.drawElevationShadowWithMaterialShapeDrawable(canvas);
            }
            canvas.restore();
        }

        private void drawElevationShadowWithPaintShadowLayer(Canvas canvas) {
            ShapeAppearanceModel currentShapeAppearanceModel = this.maskEvaluator.getCurrentShapeAppearanceModel();
            if (currentShapeAppearanceModel.isRoundRect(this.currentMaskBounds)) {
                float radius = currentShapeAppearanceModel.getTopLeftCornerSize().getCornerSize(this.currentMaskBounds);
                canvas.drawRoundRect(this.currentMaskBounds, radius, radius, this.shadowPaint);
            } else {
                canvas.drawPath(this.maskEvaluator.getPath(), this.shadowPaint);
            }
        }

        private void drawElevationShadowWithMaterialShapeDrawable(Canvas canvas) {
            this.compatShadowDrawable.setBounds((int)this.currentMaskBounds.left, (int)this.currentMaskBounds.top, (int)this.currentMaskBounds.right, (int)this.currentMaskBounds.bottom);
            this.compatShadowDrawable.setElevation(this.currentElevation);
            this.compatShadowDrawable.setShadowVerticalOffset((int)this.currentElevationDy);
            this.compatShadowDrawable.setShapeAppearanceModel(this.maskEvaluator.getCurrentShapeAppearanceModel());
            this.compatShadowDrawable.draw(canvas);
        }

        private void drawStartView(Canvas canvas) {
            this.maybeDrawContainerColor(canvas, this.startContainerPaint);
            TransitionUtils.transform(canvas, this.getBounds(), this.currentStartBounds.left, this.currentStartBounds.top, this.fitModeResult.startScale, this.fadeModeResult.startAlpha, new CanvasCompat.CanvasOperation(){

                @Override
                public void run(Canvas canvas) {
                    startView.draw(canvas);
                }
            });
        }

        private void drawEndView(Canvas canvas) {
            this.maybeDrawContainerColor(canvas, this.endContainerPaint);
            TransitionUtils.transform(canvas, this.getBounds(), this.currentEndBounds.left, this.currentEndBounds.top, this.fitModeResult.endScale, this.fadeModeResult.endAlpha, new CanvasCompat.CanvasOperation(){

                @Override
                public void run(Canvas canvas) {
                    endView.draw(canvas);
                }
            });
        }

        private void maybeDrawContainerColor(Canvas canvas, Paint containerPaint) {
            if (containerPaint.getColor() != 0 && containerPaint.getAlpha() > 0) {
                canvas.drawRect(this.getBounds(), containerPaint);
            }
        }

        public void setAlpha(int alpha) {
            throw new UnsupportedOperationException("Setting alpha on is not supported");
        }

        public void setColorFilter(@Nullable ColorFilter colorFilter) {
            throw new UnsupportedOperationException("Setting a color filter is not supported");
        }

        public int getOpacity() {
            return -3;
        }

        private void setProgress(float progress) {
            if (this.progress != progress) {
                this.updateProgress(progress);
            }
        }

        private void updateProgress(float progress) {
            this.progress = progress;
            this.scrimPaint.setAlpha((int)(this.entering ? TransitionUtils.lerp(0.0f, 255.0f, progress) : TransitionUtils.lerp(255.0f, 0.0f, progress)));
            this.motionPathMeasure.getPosTan(this.motionPathLength * progress, this.motionPathPosition, null);
            float motionPathX = this.motionPathPosition[0];
            float motionPathY = this.motionPathPosition[1];
            if (progress > 1.0f || progress < 0.0f) {
                float trajectoryMultiplier;
                float trajectoryProgress;
                if (progress > 1.0f) {
                    trajectoryProgress = 0.99f;
                    trajectoryMultiplier = (progress - 1.0f) / (1.0f - trajectoryProgress);
                } else {
                    trajectoryProgress = 0.01f;
                    trajectoryMultiplier = progress / trajectoryProgress * -1.0f;
                }
                this.motionPathMeasure.getPosTan(this.motionPathLength * trajectoryProgress, this.motionPathPosition, null);
                float trajectoryMotionPathX = this.motionPathPosition[0];
                float trajectoryMotionPathY = this.motionPathPosition[1];
                motionPathX += (motionPathX - trajectoryMotionPathX) * trajectoryMultiplier;
                motionPathY += (motionPathY - trajectoryMotionPathY) * trajectoryMultiplier;
            }
            float scaleStartFraction = ((Float)Preconditions.checkNotNull((Object)Float.valueOf(this.progressThresholds.scale.start))).floatValue();
            float scaleEndFraction = ((Float)Preconditions.checkNotNull((Object)Float.valueOf(this.progressThresholds.scale.end))).floatValue();
            this.fitModeResult = this.fitModeEvaluator.evaluate(progress, scaleStartFraction, scaleEndFraction, this.startBounds.width(), this.startBounds.height(), this.endBounds.width(), this.endBounds.height());
            this.currentStartBounds.set(motionPathX - this.fitModeResult.currentStartWidth / 2.0f, motionPathY, motionPathX + this.fitModeResult.currentStartWidth / 2.0f, motionPathY + this.fitModeResult.currentStartHeight);
            this.currentEndBounds.set(motionPathX - this.fitModeResult.currentEndWidth / 2.0f, motionPathY, motionPathX + this.fitModeResult.currentEndWidth / 2.0f, motionPathY + this.fitModeResult.currentEndHeight);
            this.currentStartBoundsMasked.set(this.currentStartBounds);
            this.currentEndBoundsMasked.set(this.currentEndBounds);
            float maskStartFraction = ((Float)Preconditions.checkNotNull((Object)Float.valueOf(this.progressThresholds.scaleMask.start))).floatValue();
            float maskEndFraction = ((Float)Preconditions.checkNotNull((Object)Float.valueOf(this.progressThresholds.scaleMask.end))).floatValue();
            boolean shouldMaskStartBounds = this.fitModeEvaluator.shouldMaskStartBounds(this.fitModeResult);
            RectF maskBounds = shouldMaskStartBounds ? this.currentStartBoundsMasked : this.currentEndBoundsMasked;
            float maskProgress = TransitionUtils.lerp(0.0f, 1.0f, maskStartFraction, maskEndFraction, progress);
            float maskMultiplier = shouldMaskStartBounds ? maskProgress : 1.0f - maskProgress;
            this.fitModeEvaluator.applyMask(maskBounds, maskMultiplier, this.fitModeResult);
            this.currentMaskBounds = new RectF(Math.min(this.currentStartBoundsMasked.left, this.currentEndBoundsMasked.left), Math.min(this.currentStartBoundsMasked.top, this.currentEndBoundsMasked.top), Math.max(this.currentStartBoundsMasked.right, this.currentEndBoundsMasked.right), Math.max(this.currentStartBoundsMasked.bottom, this.currentEndBoundsMasked.bottom));
            this.maskEvaluator.evaluate(progress, this.startShapeAppearanceModel, this.endShapeAppearanceModel, this.currentStartBounds, this.currentStartBoundsMasked, this.currentEndBoundsMasked, this.progressThresholds.shapeMask);
            this.currentElevation = TransitionUtils.lerp(this.startElevation, this.endElevation, progress);
            float dxMultiplier = TransitionDrawable.calculateElevationDxMultiplier(this.currentMaskBounds, this.displayWidth);
            float dyMultiplier = TransitionDrawable.calculateElevationDyMultiplier(this.currentMaskBounds, this.displayHeight);
            float currentElevationDx = (int)(this.currentElevation * dxMultiplier);
            this.currentElevationDy = (int)(this.currentElevation * dyMultiplier);
            this.shadowPaint.setShadowLayer(this.currentElevation, currentElevationDx, this.currentElevationDy, 0x2D000000);
            float fadeStartFraction = ((Float)Preconditions.checkNotNull((Object)Float.valueOf(this.progressThresholds.fade.start))).floatValue();
            float fadeEndFraction = ((Float)Preconditions.checkNotNull((Object)Float.valueOf(this.progressThresholds.fade.end))).floatValue();
            this.fadeModeResult = this.fadeModeEvaluator.evaluate(progress, fadeStartFraction, fadeEndFraction, 0.35f);
            if (this.startContainerPaint.getColor() != 0) {
                this.startContainerPaint.setAlpha(this.fadeModeResult.startAlpha);
            }
            if (this.endContainerPaint.getColor() != 0) {
                this.endContainerPaint.setAlpha(this.fadeModeResult.endAlpha);
            }
            this.invalidateSelf();
        }

        private static PointF getMotionPathPoint(RectF bounds) {
            return new PointF(bounds.centerX(), bounds.top);
        }

        private static float calculateElevationDxMultiplier(RectF bounds, float displayWidth) {
            return (bounds.centerX() / (displayWidth / 2.0f) - 1.0f) * 0.3f;
        }

        private static float calculateElevationDyMultiplier(RectF bounds, float displayHeight) {
            return bounds.centerY() / displayHeight * 1.5f;
        }

        private void drawDebugCumulativePath(Canvas canvas, RectF bounds, Path path, @ColorInt int color2) {
            PointF point = TransitionDrawable.getMotionPathPoint(bounds);
            if (this.progress == 0.0f) {
                path.reset();
                path.moveTo(point.x, point.y);
            } else {
                path.lineTo(point.x, point.y);
                this.debugPaint.setColor(color2);
                canvas.drawPath(path, this.debugPaint);
            }
        }

        private void drawDebugRect(Canvas canvas, RectF bounds, @ColorInt int color2) {
            this.debugPaint.setColor(color2);
            canvas.drawRect(bounds, this.debugPaint);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface FitMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface FadeMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface TransitionDirection {
    }
}

