/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.helper.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.constraintlayout.motion.widget.MotionHelper;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.motion.widget.MotionScene;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.R;
import java.util.ArrayList;

public class Carousel
extends MotionHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = "Carousel";
    private Adapter mAdapter = null;
    private final ArrayList<View> mList = new ArrayList();
    private int mPreviousIndex = 0;
    private int mIndex = 0;
    private MotionLayout mMotionLayout;
    private int mFirstViewReference = -1;
    private boolean mInfiniteCarousel = false;
    private int mBackwardTransition = -1;
    private int mForwardTransition = -1;
    private int mPreviousState = -1;
    private int mNextState = -1;
    private float mDampening = 0.9f;
    private int mStartIndex = 0;
    private int mEmptyViewBehavior = 4;
    public static final int TOUCH_UP_IMMEDIATE_STOP = 1;
    public static final int TOUCH_UP_CARRY_ON = 2;
    private int mTouchUpMode = 1;
    private float mVelocityThreshold = 2.0f;
    private int mTargetIndex = -1;
    private int mAnimateTargetDelay = 200;
    int mLastStartId = -1;
    Runnable mUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            Carousel.this.mMotionLayout.setProgress(0.0f);
            Carousel.this.updateItems();
            Carousel.this.mAdapter.onNewItem(Carousel.this.mIndex);
            float velocity = Carousel.this.mMotionLayout.getVelocity();
            if (Carousel.this.mTouchUpMode == 2 && velocity > Carousel.this.mVelocityThreshold && Carousel.this.mIndex < Carousel.this.mAdapter.count() - 1) {
                final float v = velocity * Carousel.this.mDampening;
                if (Carousel.this.mIndex == 0 && Carousel.this.mPreviousIndex > Carousel.this.mIndex) {
                    return;
                }
                if (Carousel.this.mIndex == Carousel.this.mAdapter.count() - 1 && Carousel.this.mPreviousIndex < Carousel.this.mIndex) {
                    return;
                }
                Carousel.this.mMotionLayout.post(new Runnable(){

                    @Override
                    public void run() {
                        Carousel.this.mMotionLayout.touchAnimateTo(5, 1.0f, v);
                    }
                });
            }
        }
    };

    public Carousel(Context context) {
        super(context);
    }

    public Carousel(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public Carousel(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Carousel);
            int n = a.getIndexCount();
            for (int i = 0; i < n; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.Carousel_carousel_firstView) {
                    this.mFirstViewReference = a.getResourceId(attr, this.mFirstViewReference);
                    continue;
                }
                if (attr == R.styleable.Carousel_carousel_backwardTransition) {
                    this.mBackwardTransition = a.getResourceId(attr, this.mBackwardTransition);
                    continue;
                }
                if (attr == R.styleable.Carousel_carousel_forwardTransition) {
                    this.mForwardTransition = a.getResourceId(attr, this.mForwardTransition);
                    continue;
                }
                if (attr == R.styleable.Carousel_carousel_emptyViewsBehavior) {
                    this.mEmptyViewBehavior = a.getInt(attr, this.mEmptyViewBehavior);
                    continue;
                }
                if (attr == R.styleable.Carousel_carousel_previousState) {
                    this.mPreviousState = a.getResourceId(attr, this.mPreviousState);
                    continue;
                }
                if (attr == R.styleable.Carousel_carousel_nextState) {
                    this.mNextState = a.getResourceId(attr, this.mNextState);
                    continue;
                }
                if (attr == R.styleable.Carousel_carousel_touchUp_dampeningFactor) {
                    this.mDampening = a.getFloat(attr, this.mDampening);
                    continue;
                }
                if (attr == R.styleable.Carousel_carousel_touchUpMode) {
                    this.mTouchUpMode = a.getInt(attr, this.mTouchUpMode);
                    continue;
                }
                if (attr == R.styleable.Carousel_carousel_touchUp_velocityThreshold) {
                    this.mVelocityThreshold = a.getFloat(attr, this.mVelocityThreshold);
                    continue;
                }
                if (attr != R.styleable.Carousel_carousel_infinite) continue;
                this.mInfiniteCarousel = a.getBoolean(attr, this.mInfiniteCarousel);
            }
            a.recycle();
        }
    }

    public void setAdapter(Adapter adapter) {
        this.mAdapter = adapter;
    }

    public void setInfinite(boolean infiniteCarousel) {
        this.mInfiniteCarousel = infiniteCarousel;
    }

    public boolean isInfinite() {
        return this.mInfiniteCarousel;
    }

    public int getCount() {
        if (this.mAdapter != null) {
            return this.mAdapter.count();
        }
        return 0;
    }

    public int getCurrentIndex() {
        return this.mIndex;
    }

    public void transitionToIndex(int index, int delay) {
        this.mTargetIndex = Math.max(0, Math.min(this.getCount() - 1, index));
        this.mAnimateTargetDelay = Math.max(0, delay);
        this.mMotionLayout.setTransitionDuration(this.mAnimateTargetDelay);
        if (index < this.mIndex) {
            this.mMotionLayout.transitionToState(this.mPreviousState, this.mAnimateTargetDelay);
        } else {
            this.mMotionLayout.transitionToState(this.mNextState, this.mAnimateTargetDelay);
        }
    }

    public void jumpToIndex(int index) {
        this.mIndex = Math.max(0, Math.min(this.getCount() - 1, index));
        this.refresh();
    }

    public void refresh() {
        int count = this.mList.size();
        for (int i = 0; i < count; ++i) {
            View view = this.mList.get(i);
            if (this.mAdapter.count() == 0) {
                this.updateViewVisibility(view, this.mEmptyViewBehavior);
                continue;
            }
            this.updateViewVisibility(view, 0);
        }
        this.mMotionLayout.rebuildScene();
        this.updateItems();
    }

    @Override
    public void onTransitionChange(MotionLayout motionLayout, int startId, int endId, float progress) {
        this.mLastStartId = startId;
    }

    @Override
    public void onTransitionCompleted(MotionLayout motionLayout, int currentId) {
        this.mPreviousIndex = this.mIndex++;
        if (currentId != this.mNextState && currentId == this.mPreviousState) {
            --this.mIndex;
        }
        if (this.mInfiniteCarousel) {
            if (this.mIndex >= this.mAdapter.count()) {
                this.mIndex = 0;
            }
            if (this.mIndex < 0) {
                this.mIndex = this.mAdapter.count() - 1;
            }
        } else {
            if (this.mIndex >= this.mAdapter.count()) {
                this.mIndex = this.mAdapter.count() - 1;
            }
            if (this.mIndex < 0) {
                this.mIndex = 0;
            }
        }
        if (this.mPreviousIndex != this.mIndex) {
            this.mMotionLayout.post(this.mUpdateRunnable);
        }
    }

    private void enableAllTransitions(boolean enable) {
        ArrayList<MotionScene.Transition> transitions = this.mMotionLayout.getDefinedTransitions();
        for (MotionScene.Transition transition : transitions) {
            transition.setEnabled(enable);
        }
    }

    private boolean enableTransition(int transitionID, boolean enable) {
        if (transitionID == -1) {
            return false;
        }
        if (this.mMotionLayout == null) {
            return false;
        }
        MotionScene.Transition transition = this.mMotionLayout.getTransition(transitionID);
        if (transition == null) {
            return false;
        }
        if (enable == transition.isEnabled()) {
            return false;
        }
        transition.setEnabled(enable);
        return true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mList.clear();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MotionLayout container = null;
        if (!(this.getParent() instanceof MotionLayout)) {
            return;
        }
        container = (MotionLayout)this.getParent();
        this.mList.clear();
        for (int i = 0; i < this.mCount; ++i) {
            int id2 = this.mIds[i];
            View view = container.getViewById(id2);
            if (this.mFirstViewReference == id2) {
                this.mStartIndex = i;
            }
            this.mList.add(view);
        }
        this.mMotionLayout = container;
        if (this.mTouchUpMode == 2) {
            MotionScene.Transition backward;
            MotionScene.Transition forward = this.mMotionLayout.getTransition(this.mForwardTransition);
            if (forward != null) {
                forward.setOnTouchUp(5);
            }
            if ((backward = this.mMotionLayout.getTransition(this.mBackwardTransition)) != null) {
                backward.setOnTouchUp(5);
            }
        }
        this.updateItems();
    }

    private boolean updateViewVisibility(View view, int visibility) {
        if (this.mMotionLayout == null) {
            return false;
        }
        boolean needsMotionSceneRebuild = false;
        int[] constraintSets = this.mMotionLayout.getConstraintSetIds();
        for (int i = 0; i < constraintSets.length; ++i) {
            needsMotionSceneRebuild |= this.updateViewVisibility(constraintSets[i], view, visibility);
        }
        return needsMotionSceneRebuild;
    }

    private boolean updateViewVisibility(int constraintSetId, View view, int visibility) {
        ConstraintSet constraintSet = this.mMotionLayout.getConstraintSet(constraintSetId);
        if (constraintSet == null) {
            return false;
        }
        ConstraintSet.Constraint constraint = constraintSet.getConstraint(view.getId());
        if (constraint == null) {
            return false;
        }
        constraint.propertySet.mVisibilityMode = 1;
        view.setVisibility(visibility);
        return true;
    }

    private void updateItems() {
        if (this.mAdapter == null) {
            return;
        }
        if (this.mMotionLayout == null) {
            return;
        }
        if (this.mAdapter.count() == 0) {
            return;
        }
        int viewCount = this.mList.size();
        for (int i = 0; i < viewCount; ++i) {
            View view = this.mList.get(i);
            int index = this.mIndex + i - this.mStartIndex;
            if (this.mInfiniteCarousel) {
                if (index < 0) {
                    if (this.mEmptyViewBehavior != 4) {
                        this.updateViewVisibility(view, this.mEmptyViewBehavior);
                    } else {
                        this.updateViewVisibility(view, 0);
                    }
                    if (index % this.mAdapter.count() == 0) {
                        this.mAdapter.populate(view, 0);
                        continue;
                    }
                    this.mAdapter.populate(view, this.mAdapter.count() + index % this.mAdapter.count());
                    continue;
                }
                if (index >= this.mAdapter.count()) {
                    if (index == this.mAdapter.count()) {
                        index = 0;
                    } else if (index > this.mAdapter.count()) {
                        index %= this.mAdapter.count();
                    }
                    if (this.mEmptyViewBehavior != 4) {
                        this.updateViewVisibility(view, this.mEmptyViewBehavior);
                    } else {
                        this.updateViewVisibility(view, 0);
                    }
                    this.mAdapter.populate(view, index);
                    continue;
                }
                this.updateViewVisibility(view, 0);
                this.mAdapter.populate(view, index);
                continue;
            }
            if (index < 0) {
                this.updateViewVisibility(view, this.mEmptyViewBehavior);
                continue;
            }
            if (index >= this.mAdapter.count()) {
                this.updateViewVisibility(view, this.mEmptyViewBehavior);
                continue;
            }
            this.updateViewVisibility(view, 0);
            this.mAdapter.populate(view, index);
        }
        if (this.mTargetIndex != -1 && this.mTargetIndex != this.mIndex) {
            this.mMotionLayout.post(() -> {
                this.mMotionLayout.setTransitionDuration(this.mAnimateTargetDelay);
                if (this.mTargetIndex < this.mIndex) {
                    this.mMotionLayout.transitionToState(this.mPreviousState, this.mAnimateTargetDelay);
                } else {
                    this.mMotionLayout.transitionToState(this.mNextState, this.mAnimateTargetDelay);
                }
            });
        } else if (this.mTargetIndex == this.mIndex) {
            this.mTargetIndex = -1;
        }
        if (this.mBackwardTransition == -1 || this.mForwardTransition == -1) {
            Log.w((String)TAG, (String)"No backward or forward transitions defined for Carousel!");
            return;
        }
        if (this.mInfiniteCarousel) {
            return;
        }
        int count = this.mAdapter.count();
        if (this.mIndex == 0) {
            this.enableTransition(this.mBackwardTransition, false);
        } else {
            this.enableTransition(this.mBackwardTransition, true);
            this.mMotionLayout.setTransition(this.mBackwardTransition);
        }
        if (this.mIndex == count - 1) {
            this.enableTransition(this.mForwardTransition, false);
        } else {
            this.enableTransition(this.mForwardTransition, true);
            this.mMotionLayout.setTransition(this.mForwardTransition);
        }
    }

    public static interface Adapter {
        public int count();

        public void populate(View var1, int var2);

        public void onNewItem(int var1);
    }
}

