/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.helper.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.R;
import androidx.constraintlayout.widget.VirtualLayout;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Grid
extends VirtualLayout {
    private static final String TAG = "Grid";
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 0;
    private static final boolean DEBUG_BOXES = false;
    private final int mMaxRows = 50;
    private final int mMaxColumns = 50;
    private View[] mBoxViews;
    ConstraintLayout mContainer;
    private int mRows;
    private int mRowsSet;
    private int mColumns;
    private int mColumnsSet;
    private String mStrSpans;
    private String mStrSkips;
    private String mStrRowWeights;
    private String mStrColumnWeights;
    private float mHorizontalGaps;
    private float mVerticalGaps;
    private int mOrientation;
    private int mNextAvailableIndex = 0;
    private boolean mValidateInputs;
    private boolean mUseRtl;
    private boolean[][] mPositionMatrix;
    Set<Integer> mSpanIds = new HashSet<Integer>();
    private int[] mBoxViewIds;

    public Grid(Context context) {
        super(context);
    }

    public Grid(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public Grid(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init(AttributeSet attrs) {
        super.init(attrs);
        this.mUseViewMeasure = true;
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.Grid);
            int n = a.getIndexCount();
            for (int i = 0; i < n; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.Grid_grid_rows) {
                    this.mRowsSet = a.getInteger(attr, 0);
                    continue;
                }
                if (attr == R.styleable.Grid_grid_columns) {
                    this.mColumnsSet = a.getInteger(attr, 0);
                    continue;
                }
                if (attr == R.styleable.Grid_grid_spans) {
                    this.mStrSpans = a.getString(attr);
                    continue;
                }
                if (attr == R.styleable.Grid_grid_skips) {
                    this.mStrSkips = a.getString(attr);
                    continue;
                }
                if (attr == R.styleable.Grid_grid_rowWeights) {
                    this.mStrRowWeights = a.getString(attr);
                    continue;
                }
                if (attr == R.styleable.Grid_grid_columnWeights) {
                    this.mStrColumnWeights = a.getString(attr);
                    continue;
                }
                if (attr == R.styleable.Grid_grid_orientation) {
                    this.mOrientation = a.getInt(attr, 0);
                    continue;
                }
                if (attr == R.styleable.Grid_grid_horizontalGaps) {
                    this.mHorizontalGaps = a.getDimension(attr, 0.0f);
                    continue;
                }
                if (attr == R.styleable.Grid_grid_verticalGaps) {
                    this.mVerticalGaps = a.getDimension(attr, 0.0f);
                    continue;
                }
                if (attr == R.styleable.Grid_grid_validateInputs) {
                    this.mValidateInputs = a.getBoolean(attr, false);
                    continue;
                }
                if (attr != R.styleable.Grid_grid_useRtl) continue;
                this.mUseRtl = a.getBoolean(attr, false);
            }
            this.updateActualRowsAndColumns();
            this.initVariables();
            a.recycle();
        }
    }

    private void updateActualRowsAndColumns() {
        if (this.mRowsSet == 0 || this.mColumnsSet == 0) {
            if (this.mColumnsSet > 0) {
                this.mColumns = this.mColumnsSet;
                this.mRows = (this.mCount + this.mColumns - 1) / this.mColumnsSet;
            } else if (this.mRowsSet > 0) {
                this.mRows = this.mRowsSet;
                this.mColumns = (this.mCount + this.mRowsSet - 1) / this.mRowsSet;
            } else {
                this.mRows = (int)(1.5 + Math.sqrt(this.mCount));
                this.mColumns = (this.mCount + this.mRows - 1) / this.mRows;
            }
        } else {
            this.mRows = this.mRowsSet;
            this.mColumns = this.mColumnsSet;
        }
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mContainer = (ConstraintLayout)this.getParent();
        this.generateGrid(false);
    }

    private boolean generateGrid(boolean isUpdate) {
        int[][] mSpans;
        int[][] mSkips;
        if (this.mContainer == null || this.mRows < 1 || this.mColumns < 1) {
            return false;
        }
        if (isUpdate) {
            for (int i = 0; i < this.mPositionMatrix.length; ++i) {
                for (int j = 0; j < this.mPositionMatrix[0].length; ++j) {
                    this.mPositionMatrix[i][j] = true;
                }
            }
            this.mSpanIds.clear();
        }
        this.mNextAvailableIndex = 0;
        boolean isSuccess = true;
        this.buildBoxes();
        if (this.mStrSkips != null && !this.mStrSkips.trim().isEmpty() && (mSkips = this.parseSpans(this.mStrSkips)) != null) {
            isSuccess &= this.handleSkips(mSkips);
        }
        if (this.mStrSpans != null && !this.mStrSpans.trim().isEmpty() && (mSpans = this.parseSpans(this.mStrSpans)) != null) {
            isSuccess &= this.handleSpans(this.mIds, mSpans);
        }
        return (isSuccess &= this.arrangeWidgets()) || !this.mValidateInputs;
    }

    private void initVariables() {
        for (boolean[] row : this.mPositionMatrix = new boolean[this.mRows][this.mColumns]) {
            Arrays.fill(row, true);
        }
    }

    private float[] parseWeights(int size, String str) {
        if (str == null || str.trim().isEmpty()) {
            return null;
        }
        String[] values = str.split(",");
        if (values.length != size) {
            return null;
        }
        float[] arr = new float[size];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Float.parseFloat(values[i].trim());
        }
        return arr;
    }

    private ConstraintLayout.LayoutParams params(View v) {
        return (ConstraintLayout.LayoutParams)v.getLayoutParams();
    }

    private void connectView(View view, int row, int column, int rowSpan, int columnSpan) {
        ConstraintLayout.LayoutParams params = this.params(view);
        params.leftToLeft = this.mBoxViewIds[column];
        params.topToTop = this.mBoxViewIds[row];
        params.rightToRight = this.mBoxViewIds[column + columnSpan - 1];
        params.bottomToBottom = this.mBoxViewIds[row + rowSpan - 1];
        view.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private boolean arrangeWidgets() {
        View[] views = this.getViews(this.mContainer);
        for (int i = 0; i < this.mCount; ++i) {
            if (this.mSpanIds.contains(this.mIds[i])) continue;
            int position = this.getNextPosition();
            int row = this.getRowByIndex(position);
            int col = this.getColByIndex(position);
            if (position == -1) {
                return false;
            }
            this.connectView(views[i], row, col, 1, 1);
        }
        return true;
    }

    private int getRowByIndex(int index) {
        if (this.mOrientation == 1) {
            return index % this.mRows;
        }
        return index / this.mColumns;
    }

    private int getColByIndex(int index) {
        if (this.mOrientation == 1) {
            return index / this.mRows;
        }
        return index % this.mColumns;
    }

    private int getNextPosition() {
        int position = 0;
        boolean positionFound = false;
        while (!positionFound) {
            int col;
            if (this.mNextAvailableIndex >= this.mRows * this.mColumns) {
                return -1;
            }
            position = this.mNextAvailableIndex;
            int row = this.getRowByIndex(this.mNextAvailableIndex);
            if (this.mPositionMatrix[row][col = this.getColByIndex(this.mNextAvailableIndex)]) {
                this.mPositionMatrix[row][col] = false;
                positionFound = true;
            }
            ++this.mNextAvailableIndex;
        }
        return position;
    }

    private boolean isSpansValid(CharSequence str) {
        return true;
    }

    private boolean isWeightsValid(String str) {
        return true;
    }

    private int[][] parseSpans(String str) {
        if (!this.isSpansValid(str)) {
            return null;
        }
        String[] spans = str.split(",");
        int[][] spanMatrix = new int[spans.length][3];
        for (int i = 0; i < spans.length; ++i) {
            String[] indexAndSpan = spans[i].trim().split(":");
            String[] rowAndCol = indexAndSpan[1].split("x");
            spanMatrix[i][0] = Integer.parseInt(indexAndSpan[0]);
            spanMatrix[i][1] = Integer.parseInt(rowAndCol[0]);
            spanMatrix[i][2] = Integer.parseInt(rowAndCol[1]);
        }
        return spanMatrix;
    }

    private boolean handleSpans(int[] mId, int[][] spansMatrix) {
        View[] views = this.getViews(this.mContainer);
        for (int i = 0; i < spansMatrix.length; ++i) {
            int col;
            int row = this.getRowByIndex(spansMatrix[i][0]);
            if (!this.invalidatePositions(row, col = this.getColByIndex(spansMatrix[i][0]), spansMatrix[i][1], spansMatrix[i][2])) {
                return false;
            }
            this.connectView(views[i], row, col, spansMatrix[i][1], spansMatrix[i][2]);
            this.mSpanIds.add(mId[i]);
        }
        return true;
    }

    private boolean handleSkips(int[][] skipsMatrix) {
        for (int i = 0; i < skipsMatrix.length; ++i) {
            int col;
            int row = this.getRowByIndex(skipsMatrix[i][0]);
            if (this.invalidatePositions(row, col = this.getColByIndex(skipsMatrix[i][0]), skipsMatrix[i][1], skipsMatrix[i][2])) continue;
            return false;
        }
        return true;
    }

    private boolean invalidatePositions(int startRow, int startColumn, int rowSpan, int columnSpan) {
        for (int i = startRow; i < startRow + rowSpan; ++i) {
            for (int j = startColumn; j < startColumn + columnSpan; ++j) {
                if (i >= this.mPositionMatrix.length || j >= this.mPositionMatrix[0].length || !this.mPositionMatrix[i][j]) {
                    return false;
                }
                this.mPositionMatrix[i][j] = false;
            }
        }
        return true;
    }

    @Override
    public void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isInEditMode()) {
            return;
        }
        Paint paint = new Paint();
        paint.setColor(-65536);
        paint.setStyle(Paint.Style.STROKE);
        int myTop = this.getTop();
        int myLeft = this.getLeft();
        int myBottom = this.getBottom();
        int myRight = this.getRight();
        for (View box : this.mBoxViews) {
            int l = box.getLeft() - myLeft;
            int t = box.getTop() - myTop;
            int r = box.getRight() - myLeft;
            int b = box.getBottom() - myTop;
            canvas.drawRect((float)l, 0.0f, (float)r, (float)(myBottom - myTop), paint);
            canvas.drawRect(0.0f, (float)t, (float)(myRight - myLeft), (float)b, paint);
        }
    }

    private void setBoxViewHorizontalChains() {
        int i;
        int gridId = this.getId();
        int maxVal = Math.max(this.mRows, this.mColumns);
        float[] columnWeights = this.parseWeights(this.mColumns, this.mStrColumnWeights);
        ConstraintLayout.LayoutParams params = this.params(this.mBoxViews[0]);
        if (this.mColumns == 1) {
            this.clearHParams(this.mBoxViews[0]);
            params.leftToLeft = gridId;
            params.rightToRight = gridId;
            this.mBoxViews[0].setLayoutParams((ViewGroup.LayoutParams)params);
            return;
        }
        for (i = 0; i < this.mColumns; ++i) {
            params = this.params(this.mBoxViews[i]);
            this.clearHParams(this.mBoxViews[i]);
            if (columnWeights != null) {
                params.horizontalWeight = columnWeights[i];
            }
            if (i > 0) {
                params.leftToRight = this.mBoxViewIds[i - 1];
            } else {
                params.leftToLeft = gridId;
            }
            if (i < this.mColumns - 1) {
                params.rightToLeft = this.mBoxViewIds[i + 1];
            } else {
                params.rightToRight = gridId;
            }
            if (i > 0) {
                params.leftMargin = (int)this.mHorizontalGaps;
            }
            this.mBoxViews[i].setLayoutParams((ViewGroup.LayoutParams)params);
        }
        for (i = this.mColumns; i < maxVal; ++i) {
            params = this.params(this.mBoxViews[i]);
            this.clearHParams(this.mBoxViews[i]);
            params.leftToLeft = gridId;
            params.rightToRight = gridId;
            this.mBoxViews[i].setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void setBoxViewVerticalChains() {
        ConstraintLayout.LayoutParams params;
        int i;
        int gridId = this.getId();
        int maxVal = Math.max(this.mRows, this.mColumns);
        float[] rowWeights = this.parseWeights(this.mRows, this.mStrRowWeights);
        if (this.mRows == 1) {
            ConstraintLayout.LayoutParams params2 = this.params(this.mBoxViews[0]);
            this.clearVParams(this.mBoxViews[0]);
            params2.topToTop = gridId;
            params2.bottomToBottom = gridId;
            this.mBoxViews[0].setLayoutParams((ViewGroup.LayoutParams)params2);
            return;
        }
        for (i = 0; i < this.mRows; ++i) {
            params = this.params(this.mBoxViews[i]);
            this.clearVParams(this.mBoxViews[i]);
            if (rowWeights != null) {
                params.verticalWeight = rowWeights[i];
            }
            if (i > 0) {
                params.topToBottom = this.mBoxViewIds[i - 1];
            } else {
                params.topToTop = gridId;
            }
            if (i < this.mRows - 1) {
                params.bottomToTop = this.mBoxViewIds[i + 1];
            } else {
                params.bottomToBottom = gridId;
            }
            if (i > 0) {
                params.topMargin = (int)this.mHorizontalGaps;
            }
            this.mBoxViews[i].setLayoutParams((ViewGroup.LayoutParams)params);
        }
        for (i = this.mRows; i < maxVal; ++i) {
            params = this.params(this.mBoxViews[i]);
            this.clearVParams(this.mBoxViews[i]);
            params.topToTop = gridId;
            params.bottomToBottom = gridId;
            this.mBoxViews[i].setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private View makeNewView() {
        View v = new View(this.getContext());
        v.setId(View.generateViewId());
        v.setVisibility(4);
        ConstraintLayout.LayoutParams params = new ConstraintLayout.LayoutParams(0, 0);
        this.mContainer.addView(v, (ViewGroup.LayoutParams)params);
        return v;
    }

    private void clearVParams(View view) {
        ConstraintLayout.LayoutParams params = this.params(view);
        params.verticalWeight = -1.0f;
        params.topToBottom = -1;
        params.topToTop = -1;
        params.bottomToTop = -1;
        params.bottomToBottom = -1;
        params.topMargin = -1;
        view.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void clearHParams(View view) {
        ConstraintLayout.LayoutParams params = this.params(view);
        params.horizontalWeight = -1.0f;
        params.leftToRight = -1;
        params.leftToLeft = -1;
        params.rightToLeft = -1;
        params.rightToRight = -1;
        params.leftMargin = -1;
        view.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void buildBoxes() {
        int i;
        int boxCount = Math.max(this.mRows, this.mColumns);
        if (this.mBoxViews == null) {
            this.mBoxViews = new View[boxCount];
            for (i = 0; i < this.mBoxViews.length; ++i) {
                this.mBoxViews[i] = this.makeNewView();
            }
        } else if (boxCount != this.mBoxViews.length) {
            View[] temp = new View[boxCount];
            for (int i2 = 0; i2 < boxCount; ++i2) {
                temp[i2] = i2 < this.mBoxViews.length ? this.mBoxViews[i2] : this.makeNewView();
            }
            for (int j = boxCount; j < this.mBoxViews.length; ++j) {
                View view = this.mBoxViews[j];
                this.mContainer.removeView(view);
            }
            this.mBoxViews = temp;
        }
        this.mBoxViewIds = new int[boxCount];
        for (i = 0; i < this.mBoxViews.length; ++i) {
            this.mBoxViewIds[i] = this.mBoxViews[i].getId();
        }
        this.setBoxViewVerticalChains();
        this.setBoxViewHorizontalChains();
    }

    public int getRows() {
        return this.mRowsSet;
    }

    public void setRows(int rows) {
        if (rows > 50) {
            return;
        }
        if (this.mRowsSet == rows) {
            return;
        }
        this.mRowsSet = rows;
        this.updateActualRowsAndColumns();
        this.initVariables();
        this.generateGrid(false);
        this.invalidate();
    }

    public int getColumns() {
        return this.mColumnsSet;
    }

    public void setColumns(int columns) {
        if (columns > 50) {
            return;
        }
        if (this.mColumnsSet == columns) {
            return;
        }
        this.mColumnsSet = columns;
        this.updateActualRowsAndColumns();
        this.initVariables();
        this.generateGrid(false);
        this.invalidate();
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            return;
        }
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
        this.generateGrid(true);
        this.invalidate();
    }

    public String getSpans() {
        return this.mStrSpans;
    }

    public void setSpans(CharSequence spans) {
        if (!this.isSpansValid(spans)) {
            return;
        }
        if (this.mStrSpans != null && this.mStrSpans.contentEquals(spans)) {
            return;
        }
        this.mStrSpans = spans.toString();
        this.generateGrid(true);
        this.invalidate();
    }

    public String getSkips() {
        return this.mStrSkips;
    }

    public void setSkips(String skips) {
        if (!this.isSpansValid(skips)) {
            return;
        }
        if (this.mStrSkips != null && this.mStrSkips.equals(skips)) {
            return;
        }
        this.mStrSkips = skips;
        this.generateGrid(true);
        this.invalidate();
    }

    public String getRowWeights() {
        return this.mStrRowWeights;
    }

    public void setRowWeights(String rowWeights) {
        if (!this.isWeightsValid(rowWeights)) {
            return;
        }
        if (this.mStrRowWeights != null && this.mStrRowWeights.equals(rowWeights)) {
            return;
        }
        this.mStrRowWeights = rowWeights;
        this.generateGrid(true);
        this.invalidate();
    }

    public String getColumnWeights() {
        return this.mStrColumnWeights;
    }

    public void setColumnWeights(String columnWeights) {
        if (!this.isWeightsValid(columnWeights)) {
            return;
        }
        if (this.mStrColumnWeights != null && this.mStrColumnWeights.equals(columnWeights)) {
            return;
        }
        this.mStrColumnWeights = columnWeights;
        this.generateGrid(true);
        this.invalidate();
    }

    public float getHorizontalGaps() {
        return this.mHorizontalGaps;
    }

    public void setHorizontalGaps(float horizontalGaps) {
        if (horizontalGaps < 0.0f) {
            return;
        }
        if (this.mHorizontalGaps == horizontalGaps) {
            return;
        }
        this.mHorizontalGaps = horizontalGaps;
        this.generateGrid(true);
        this.invalidate();
    }

    public float getVerticalGaps() {
        return this.mVerticalGaps;
    }

    public void setVerticalGaps(float verticalGaps) {
        if (verticalGaps < 0.0f) {
            return;
        }
        if (this.mVerticalGaps == verticalGaps) {
            return;
        }
        this.mVerticalGaps = verticalGaps;
        this.generateGrid(true);
        this.invalidate();
    }
}

