/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.utils;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.widget.ConstraintAttribute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CustomSupport {
    private static final String TAG = "CustomSupport";
    private static final boolean DEBUG = false;

    public static void setInterpolatedValue(ConstraintAttribute att, View view, float[] value) {
        Class<?> viewClass = view.getClass();
        String methodName = "set" + att.getName();
        try {
            switch (att.getType()) {
                case INT_TYPE: {
                    Method method = viewClass.getMethod(methodName, Integer.TYPE);
                    method.invoke((Object)view, (int)value[0]);
                    break;
                }
                case FLOAT_TYPE: {
                    Method method = viewClass.getMethod(methodName, Float.TYPE);
                    method.invoke((Object)view, Float.valueOf(value[0]));
                    break;
                }
                case COLOR_DRAWABLE_TYPE: {
                    Method method = viewClass.getMethod(methodName, Drawable.class);
                    int r = CustomSupport.clamp((int)((float)Math.pow(value[0], 0.45454545454545453) * 255.0f));
                    int g = CustomSupport.clamp((int)((float)Math.pow(value[1], 0.45454545454545453) * 255.0f));
                    int b = CustomSupport.clamp((int)((float)Math.pow(value[2], 0.45454545454545453) * 255.0f));
                    int a = CustomSupport.clamp((int)(value[3] * 255.0f));
                    int color = a << 24 | r << 16 | g << 8 | b;
                    ColorDrawable drawable = new ColorDrawable();
                    drawable.setColor(color);
                    method.invoke((Object)view, drawable);
                    break;
                }
                case COLOR_TYPE: {
                    Method method = viewClass.getMethod(methodName, Integer.TYPE);
                    int r = CustomSupport.clamp((int)((float)Math.pow(value[0], 0.45454545454545453) * 255.0f));
                    int g = CustomSupport.clamp((int)((float)Math.pow(value[1], 0.45454545454545453) * 255.0f));
                    int b = CustomSupport.clamp((int)((float)Math.pow(value[2], 0.45454545454545453) * 255.0f));
                    int a = CustomSupport.clamp((int)(value[3] * 255.0f));
                    int color = a << 24 | r << 16 | g << 8 | b;
                    method.invoke((Object)view, color);
                    break;
                }
                case STRING_TYPE: {
                    throw new RuntimeException("unable to interpolate strings " + att.getName());
                }
                case BOOLEAN_TYPE: {
                    Method method = viewClass.getMethod(methodName, Boolean.TYPE);
                    method.invoke((Object)view, value[0] > 0.5f);
                    break;
                }
                case DIMENSION_TYPE: {
                    Method method = viewClass.getMethod(methodName, Float.TYPE);
                    method.invoke((Object)view, Float.valueOf(value[0]));
                    break;
                }
            }
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)("No method " + methodName + " on View \"" + Debug.getName(view) + "\""), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)("Cannot access method " + methodName + " on View \"" + Debug.getName(view) + "\""), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)("Cannot invoke method " + methodName + " on View \"" + Debug.getName(view) + "\""), (Throwable)e);
        }
    }

    private static int clamp(int c) {
        int n = 255;
        c &= ~(c >> 31);
        c -= n;
        c &= c >> 31;
        return c += n;
    }
}

