/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.util.TypedValue;
import androidx.constraintlayout.motion.utils.ViewSpline;
import androidx.constraintlayout.motion.utils.ViewTimeCycle;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.R;
import java.util.HashMap;
import java.util.HashSet;

public class KeyTimeCycle
extends Key {
    public static final String WAVE_PERIOD = "wavePeriod";
    public static final String WAVE_OFFSET = "waveOffset";
    public static final String WAVE_SHAPE = "waveShape";
    public static final int SHAPE_SIN_WAVE = 0;
    public static final int SHAPE_SQUARE_WAVE = 1;
    public static final int SHAPE_TRIANGLE_WAVE = 2;
    public static final int SHAPE_SAW_WAVE = 3;
    public static final int SHAPE_REVERSE_SAW_WAVE = 4;
    public static final int SHAPE_COS_WAVE = 5;
    public static final int SHAPE_BOUNCE = 6;
    public static final int KEY_TYPE = 3;
    static final String NAME = "KeyTimeCycle";
    private static final String TAG = "KeyTimeCycle";
    private String mTransitionEasing;
    private int mCurveFit = -1;
    private float mAlpha = Float.NaN;
    private float mElevation = Float.NaN;
    private float mRotation = Float.NaN;
    private float mRotationX = Float.NaN;
    private float mRotationY = Float.NaN;
    private float mTransitionPathRotate = Float.NaN;
    private float mScaleX = Float.NaN;
    private float mScaleY = Float.NaN;
    private float mTranslationX = Float.NaN;
    private float mTranslationY = Float.NaN;
    private float mTranslationZ = Float.NaN;
    private float mProgress = Float.NaN;
    private int mWaveShape = 0;
    private String mCustomWaveShape = null;
    private float mWavePeriod = Float.NaN;
    private float mWaveOffset = 0.0f;

    public KeyTimeCycle() {
        this.mType = 3;
        this.mCustomConstraints = new HashMap();
    }

    @Override
    public void load(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.KeyTimeCycle);
        Loader.read(this, a);
    }

    @Override
    public void getAttributeNames(HashSet<String> attributes) {
        if (!Float.isNaN(this.mAlpha)) {
            attributes.add("alpha");
        }
        if (!Float.isNaN(this.mElevation)) {
            attributes.add("elevation");
        }
        if (!Float.isNaN(this.mRotation)) {
            attributes.add("rotation");
        }
        if (!Float.isNaN(this.mRotationX)) {
            attributes.add("rotationX");
        }
        if (!Float.isNaN(this.mRotationY)) {
            attributes.add("rotationY");
        }
        if (!Float.isNaN(this.mTranslationX)) {
            attributes.add("translationX");
        }
        if (!Float.isNaN(this.mTranslationY)) {
            attributes.add("translationY");
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            attributes.add("translationZ");
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            attributes.add("transitionPathRotate");
        }
        if (!Float.isNaN(this.mScaleX)) {
            attributes.add("scaleX");
        }
        if (!Float.isNaN(this.mScaleY)) {
            attributes.add("scaleY");
        }
        if (!Float.isNaN(this.mProgress)) {
            attributes.add("progress");
        }
        if (this.mCustomConstraints.size() > 0) {
            for (String s : this.mCustomConstraints.keySet()) {
                attributes.add("CUSTOM," + s);
            }
        }
    }

    @Override
    public void setInterpolation(HashMap<String, Integer> interpolation) {
        if (this.mCurveFit == -1) {
            return;
        }
        if (!Float.isNaN(this.mAlpha)) {
            interpolation.put("alpha", this.mCurveFit);
        }
        if (!Float.isNaN(this.mElevation)) {
            interpolation.put("elevation", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotation)) {
            interpolation.put("rotation", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotationX)) {
            interpolation.put("rotationX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotationY)) {
            interpolation.put("rotationY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationX)) {
            interpolation.put("translationX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationY)) {
            interpolation.put("translationY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            interpolation.put("translationZ", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            interpolation.put("transitionPathRotate", this.mCurveFit);
        }
        if (!Float.isNaN(this.mScaleX)) {
            interpolation.put("scaleX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mScaleX)) {
            interpolation.put("scaleY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mProgress)) {
            interpolation.put("progress", this.mCurveFit);
        }
        if (this.mCustomConstraints.size() > 0) {
            for (String s : this.mCustomConstraints.keySet()) {
                interpolation.put("CUSTOM," + s, this.mCurveFit);
            }
        }
    }

    @Override
    public void addValues(HashMap<String, ViewSpline> splines) {
        throw new IllegalArgumentException(" KeyTimeCycles do not support SplineSet");
    }

    public void addTimeValues(HashMap<String, ViewTimeCycle> splines) {
        block28: for (String s : splines.keySet()) {
            ViewTimeCycle splineSet = splines.get(s);
            if (splineSet == null) continue;
            if (s.startsWith("CUSTOM")) {
                String cKey = s.substring("CUSTOM".length() + 1);
                ConstraintAttribute cValue = (ConstraintAttribute)this.mCustomConstraints.get(cKey);
                if (cValue == null) continue;
                ((ViewTimeCycle.CustomSet)splineSet).setPoint(this.mFramePosition, cValue, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                continue;
            }
            switch (s) {
                case "alpha": {
                    if (Float.isNaN(this.mAlpha)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mAlpha, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "elevation": {
                    if (Float.isNaN(this.mElevation)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mElevation, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "rotation": {
                    if (Float.isNaN(this.mRotation)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mRotation, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "rotationX": {
                    if (Float.isNaN(this.mRotationX)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mRotationX, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "rotationY": {
                    if (Float.isNaN(this.mRotationY)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mRotationY, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "transitionPathRotate": {
                    if (Float.isNaN(this.mTransitionPathRotate)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mTransitionPathRotate, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "scaleX": {
                    if (Float.isNaN(this.mScaleX)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mScaleX, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "scaleY": {
                    if (Float.isNaN(this.mScaleY)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mScaleY, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "translationX": {
                    if (Float.isNaN(this.mTranslationX)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationX, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "translationY": {
                    if (Float.isNaN(this.mTranslationY)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationY, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "translationZ": {
                    if (Float.isNaN(this.mTranslationZ)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationZ, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
                case "progress": {
                    if (Float.isNaN(this.mProgress)) continue block28;
                    splineSet.setPoint(this.mFramePosition, this.mProgress, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block28;
                }
            }
            Log.e((String)"KeyTimeCycles", (String)("UNKNOWN addValues \"" + s + "\""));
        }
    }

    @Override
    public void setValue(String tag, Object value) {
        switch (tag) {
            case "alpha": {
                this.mAlpha = this.toFloat(value);
                break;
            }
            case "curveFit": {
                this.mCurveFit = this.toInt(value);
                break;
            }
            case "elevation": {
                this.mElevation = this.toFloat(value);
                break;
            }
            case "motionProgress": {
                this.mProgress = this.toFloat(value);
                break;
            }
            case "rotation": {
                this.mRotation = this.toFloat(value);
                break;
            }
            case "rotationX": {
                this.mRotationX = this.toFloat(value);
                break;
            }
            case "rotationY": {
                this.mRotationY = this.toFloat(value);
                break;
            }
            case "scaleX": {
                this.mScaleX = this.toFloat(value);
                break;
            }
            case "scaleY": {
                this.mScaleY = this.toFloat(value);
                break;
            }
            case "transitionEasing": {
                this.mTransitionEasing = value.toString();
                break;
            }
            case "transitionPathRotate": {
                this.mTransitionPathRotate = this.toFloat(value);
                break;
            }
            case "translationX": {
                this.mTranslationX = this.toFloat(value);
                break;
            }
            case "translationY": {
                this.mTranslationY = this.toFloat(value);
                break;
            }
            case "translationZ": {
                this.mTranslationZ = this.toFloat(value);
                break;
            }
            case "wavePeriod": {
                this.mWavePeriod = this.toFloat(value);
                break;
            }
            case "waveOffset": {
                this.mWaveOffset = this.toFloat(value);
                break;
            }
            case "waveShape": {
                if (value instanceof Integer) {
                    this.mWaveShape = this.toInt(value);
                    break;
                }
                this.mWaveShape = 7;
                this.mCustomWaveShape = value.toString();
            }
        }
    }

    @Override
    public Key copy(Key src) {
        super.copy(src);
        KeyTimeCycle k = (KeyTimeCycle)src;
        this.mTransitionEasing = k.mTransitionEasing;
        this.mCurveFit = k.mCurveFit;
        this.mWaveShape = k.mWaveShape;
        this.mWavePeriod = k.mWavePeriod;
        this.mWaveOffset = k.mWaveOffset;
        this.mProgress = k.mProgress;
        this.mAlpha = k.mAlpha;
        this.mElevation = k.mElevation;
        this.mRotation = k.mRotation;
        this.mTransitionPathRotate = k.mTransitionPathRotate;
        this.mRotationX = k.mRotationX;
        this.mRotationY = k.mRotationY;
        this.mScaleX = k.mScaleX;
        this.mScaleY = k.mScaleY;
        this.mTranslationX = k.mTranslationX;
        this.mTranslationY = k.mTranslationY;
        this.mTranslationZ = k.mTranslationZ;
        this.mCustomWaveShape = k.mCustomWaveShape;
        return this;
    }

    @Override
    public Key clone() {
        return new KeyTimeCycle().copy(this);
    }

    private static class Loader {
        private static final int ANDROID_ALPHA = 1;
        private static final int ANDROID_ELEVATION = 2;
        private static final int ANDROID_ROTATION = 4;
        private static final int ANDROID_ROTATION_X = 5;
        private static final int ANDROID_ROTATION_Y = 6;
        private static final int TRANSITION_PATH_ROTATE = 8;
        private static final int ANDROID_SCALE_X = 7;
        private static final int TRANSITION_EASING = 9;
        private static final int TARGET_ID = 10;
        private static final int FRAME_POSITION = 12;
        private static final int CURVE_FIT = 13;
        private static final int ANDROID_SCALE_Y = 14;
        private static final int ANDROID_TRANSLATION_X = 15;
        private static final int ANDROID_TRANSLATION_Y = 16;
        private static final int ANDROID_TRANSLATION_Z = 17;
        private static final int PROGRESS = 18;
        private static final int WAVE_SHAPE = 19;
        private static final int WAVE_PERIOD = 20;
        private static final int WAVE_OFFSET = 21;
        private static SparseIntArray sAttrMap = new SparseIntArray();

        private Loader() {
        }

        public static void read(KeyTimeCycle c, TypedArray a) {
            int n = a.getIndexCount();
            block21: for (int i = 0; i < n; ++i) {
                int attr = a.getIndex(i);
                switch (sAttrMap.get(attr)) {
                    case 10: {
                        if (MotionLayout.IS_IN_EDIT_MODE) {
                            c.mTargetId = a.getResourceId(attr, c.mTargetId);
                            if (c.mTargetId != -1) continue block21;
                            c.mTargetString = a.getString(attr);
                            continue block21;
                        }
                        if (a.peekValue((int)attr).type == 3) {
                            c.mTargetString = a.getString(attr);
                            continue block21;
                        }
                        c.mTargetId = a.getResourceId(attr, c.mTargetId);
                        continue block21;
                    }
                    case 12: {
                        c.mFramePosition = a.getInt(attr, c.mFramePosition);
                        continue block21;
                    }
                    case 1: {
                        c.mAlpha = a.getFloat(attr, c.mAlpha);
                        continue block21;
                    }
                    case 2: {
                        c.mElevation = a.getDimension(attr, c.mElevation);
                        continue block21;
                    }
                    case 4: {
                        c.mRotation = a.getFloat(attr, c.mRotation);
                        continue block21;
                    }
                    case 13: {
                        c.mCurveFit = a.getInteger(attr, c.mCurveFit);
                        continue block21;
                    }
                    case 19: {
                        if (a.peekValue((int)attr).type == 3) {
                            c.mCustomWaveShape = a.getString(attr);
                            c.mWaveShape = 7;
                            continue block21;
                        }
                        c.mWaveShape = a.getInt(attr, c.mWaveShape);
                        continue block21;
                    }
                    case 20: {
                        c.mWavePeriod = a.getFloat(attr, c.mWavePeriod);
                        continue block21;
                    }
                    case 21: {
                        TypedValue type = a.peekValue(attr);
                        if (type.type == 5) {
                            c.mWaveOffset = a.getDimension(attr, c.mWaveOffset);
                            continue block21;
                        }
                        c.mWaveOffset = a.getFloat(attr, c.mWaveOffset);
                        continue block21;
                    }
                    case 7: {
                        c.mScaleX = a.getFloat(attr, c.mScaleX);
                        continue block21;
                    }
                    case 5: {
                        c.mRotationX = a.getFloat(attr, c.mRotationX);
                        continue block21;
                    }
                    case 6: {
                        c.mRotationY = a.getFloat(attr, c.mRotationY);
                        continue block21;
                    }
                    case 9: {
                        c.mTransitionEasing = a.getString(attr);
                        continue block21;
                    }
                    case 14: {
                        c.mScaleY = a.getFloat(attr, c.mScaleY);
                        continue block21;
                    }
                    case 8: {
                        c.mTransitionPathRotate = a.getFloat(attr, c.mTransitionPathRotate);
                        continue block21;
                    }
                    case 15: {
                        c.mTranslationX = a.getDimension(attr, c.mTranslationX);
                        continue block21;
                    }
                    case 16: {
                        c.mTranslationY = a.getDimension(attr, c.mTranslationY);
                        continue block21;
                    }
                    case 17: {
                        if (Build.VERSION.SDK_INT < 21) continue block21;
                        c.mTranslationZ = a.getDimension(attr, c.mTranslationZ);
                        continue block21;
                    }
                    case 18: {
                        c.mProgress = a.getFloat(attr, c.mProgress);
                        continue block21;
                    }
                    default: {
                        Log.e((String)"KeyTimeCycle", (String)("unused attribute 0x" + Integer.toHexString(attr) + "   " + sAttrMap.get(attr)));
                    }
                }
            }
        }

        static {
            sAttrMap.append(R.styleable.KeyTimeCycle_android_alpha, 1);
            sAttrMap.append(R.styleable.KeyTimeCycle_android_elevation, 2);
            sAttrMap.append(R.styleable.KeyTimeCycle_android_rotation, 4);
            sAttrMap.append(R.styleable.KeyTimeCycle_android_rotationX, 5);
            sAttrMap.append(R.styleable.KeyTimeCycle_android_rotationY, 6);
            sAttrMap.append(R.styleable.KeyTimeCycle_android_scaleX, 7);
            sAttrMap.append(R.styleable.KeyTimeCycle_transitionPathRotate, 8);
            sAttrMap.append(R.styleable.KeyTimeCycle_transitionEasing, 9);
            sAttrMap.append(R.styleable.KeyTimeCycle_motionTarget, 10);
            sAttrMap.append(R.styleable.KeyTimeCycle_framePosition, 12);
            sAttrMap.append(R.styleable.KeyTimeCycle_curveFit, 13);
            sAttrMap.append(R.styleable.KeyTimeCycle_android_scaleY, 14);
            sAttrMap.append(R.styleable.KeyTimeCycle_android_translationX, 15);
            sAttrMap.append(R.styleable.KeyTimeCycle_android_translationY, 16);
            sAttrMap.append(R.styleable.KeyTimeCycle_android_translationZ, 17);
            sAttrMap.append(R.styleable.KeyTimeCycle_motionProgress, 18);
            sAttrMap.append(R.styleable.KeyTimeCycle_wavePeriod, 20);
            sAttrMap.append(R.styleable.KeyTimeCycle_waveOffset, 21);
            sAttrMap.append(R.styleable.KeyTimeCycle_waveShape, 19);
        }
    }
}

