/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.motion.utils.ViewSpline;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.ConstraintSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

class MotionConstrainedPoint
implements Comparable<MotionConstrainedPoint> {
    public static final String TAG = "MotionPaths";
    public static final boolean DEBUG = false;
    static final int PERPENDICULAR = 1;
    static final int CARTESIAN = 2;
    static String[] sNames = new String[]{"position", "x", "y", "width", "height", "pathRotate"};
    public float rotationY = 0.0f;
    int mVisibilityMode = 0;
    int mVisibility;
    LinkedHashMap<String, ConstraintAttribute> mAttributes = new LinkedHashMap();
    int mMode = 0;
    double[] mTempValue = new double[18];
    double[] mTempDelta = new double[18];
    private float mAlpha = 1.0f;
    private boolean mApplyElevation = false;
    private float mElevation = 0.0f;
    private float mRotation = 0.0f;
    private float mRotationX = 0.0f;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private float mPivotX = Float.NaN;
    private float mPivotY = Float.NaN;
    private float mTranslationX = 0.0f;
    private float mTranslationY = 0.0f;
    private float mTranslationZ = 0.0f;
    private Easing mKeyFrameEasing;
    private int mDrawPath = 0;
    private float mPosition;
    private float mX;
    private float mY;
    private float mWidth;
    private float mHeight;
    private float mPathRotate = Float.NaN;
    private float mProgress = Float.NaN;
    private int mAnimateRelativeTo = -1;

    MotionConstrainedPoint() {
    }

    private boolean diff(float a, float b) {
        if (Float.isNaN(a) || Float.isNaN(b)) {
            return Float.isNaN(a) != Float.isNaN(b);
        }
        return Math.abs(a - b) > 1.0E-6f;
    }

    void different(MotionConstrainedPoint points, HashSet<String> keySet) {
        if (this.diff(this.mAlpha, points.mAlpha)) {
            keySet.add("alpha");
        }
        if (this.diff(this.mElevation, points.mElevation)) {
            keySet.add("elevation");
        }
        if (this.mVisibility != points.mVisibility && this.mVisibilityMode == 0 && (this.mVisibility == 0 || points.mVisibility == 0)) {
            keySet.add("alpha");
        }
        if (this.diff(this.mRotation, points.mRotation)) {
            keySet.add("rotation");
        }
        if (!Float.isNaN(this.mPathRotate) || !Float.isNaN(points.mPathRotate)) {
            keySet.add("transitionPathRotate");
        }
        if (!Float.isNaN(this.mProgress) || !Float.isNaN(points.mProgress)) {
            keySet.add("progress");
        }
        if (this.diff(this.mRotationX, points.mRotationX)) {
            keySet.add("rotationX");
        }
        if (this.diff(this.rotationY, points.rotationY)) {
            keySet.add("rotationY");
        }
        if (this.diff(this.mPivotX, points.mPivotX)) {
            keySet.add("transformPivotX");
        }
        if (this.diff(this.mPivotY, points.mPivotY)) {
            keySet.add("transformPivotY");
        }
        if (this.diff(this.mScaleX, points.mScaleX)) {
            keySet.add("scaleX");
        }
        if (this.diff(this.mScaleY, points.mScaleY)) {
            keySet.add("scaleY");
        }
        if (this.diff(this.mTranslationX, points.mTranslationX)) {
            keySet.add("translationX");
        }
        if (this.diff(this.mTranslationY, points.mTranslationY)) {
            keySet.add("translationY");
        }
        if (this.diff(this.mTranslationZ, points.mTranslationZ)) {
            keySet.add("translationZ");
        }
    }

    void different(MotionConstrainedPoint points, boolean[] mask, String[] custom) {
        int c = 0;
        int n = c++;
        mask[n] = mask[n] | this.diff(this.mPosition, points.mPosition);
        int n2 = c++;
        mask[n2] = mask[n2] | this.diff(this.mX, points.mX);
        int n3 = c++;
        mask[n3] = mask[n3] | this.diff(this.mY, points.mY);
        int n4 = c++;
        mask[n4] = mask[n4] | this.diff(this.mWidth, points.mWidth);
        int n5 = c++;
        mask[n5] = mask[n5] | this.diff(this.mHeight, points.mHeight);
    }

    void fillStandard(double[] data, int[] toUse) {
        float[] set = new float[]{this.mPosition, this.mX, this.mY, this.mWidth, this.mHeight, this.mAlpha, this.mElevation, this.mRotation, this.mRotationX, this.rotationY, this.mScaleX, this.mScaleY, this.mPivotX, this.mPivotY, this.mTranslationX, this.mTranslationY, this.mTranslationZ, this.mPathRotate};
        int c = 0;
        for (int i = 0; i < toUse.length; ++i) {
            if (toUse[i] >= set.length) continue;
            data[c++] = set[toUse[i]];
        }
    }

    boolean hasCustomData(String name) {
        return this.mAttributes.containsKey(name);
    }

    int getCustomDataCount(String name) {
        return this.mAttributes.get(name).numberOfInterpolatedValues();
    }

    int getCustomData(String name, double[] value, int offset) {
        ConstraintAttribute a = this.mAttributes.get(name);
        if (a.numberOfInterpolatedValues() == 1) {
            value[offset] = a.getValueToInterpolate();
            return 1;
        }
        int n = a.numberOfInterpolatedValues();
        float[] f = new float[n];
        a.getValuesToInterpolate(f);
        for (int i = 0; i < n; ++i) {
            value[offset++] = f[i];
        }
        return n;
    }

    void setBounds(float x, float y, float w, float h) {
        this.mX = x;
        this.mY = y;
        this.mWidth = w;
        this.mHeight = h;
    }

    @Override
    public int compareTo(MotionConstrainedPoint o) {
        return Float.compare(this.mPosition, o.mPosition);
    }

    public void applyParameters(View view) {
        this.mVisibility = view.getVisibility();
        this.mAlpha = view.getVisibility() != 0 ? 0.0f : view.getAlpha();
        this.mApplyElevation = false;
        if (Build.VERSION.SDK_INT >= 21) {
            this.mElevation = view.getElevation();
        }
        this.mRotation = view.getRotation();
        this.mRotationX = view.getRotationX();
        this.rotationY = view.getRotationY();
        this.mScaleX = view.getScaleX();
        this.mScaleY = view.getScaleY();
        this.mPivotX = view.getPivotX();
        this.mPivotY = view.getPivotY();
        this.mTranslationX = view.getTranslationX();
        this.mTranslationY = view.getTranslationY();
        if (Build.VERSION.SDK_INT >= 21) {
            this.mTranslationZ = view.getTranslationZ();
        }
    }

    public void applyParameters(ConstraintSet.Constraint c) {
        this.mVisibilityMode = c.propertySet.mVisibilityMode;
        this.mVisibility = c.propertySet.visibility;
        this.mAlpha = c.propertySet.visibility != 0 && this.mVisibilityMode == 0 ? 0.0f : c.propertySet.alpha;
        this.mApplyElevation = c.transform.applyElevation;
        this.mElevation = c.transform.elevation;
        this.mRotation = c.transform.rotation;
        this.mRotationX = c.transform.rotationX;
        this.rotationY = c.transform.rotationY;
        this.mScaleX = c.transform.scaleX;
        this.mScaleY = c.transform.scaleY;
        this.mPivotX = c.transform.transformPivotX;
        this.mPivotY = c.transform.transformPivotY;
        this.mTranslationX = c.transform.translationX;
        this.mTranslationY = c.transform.translationY;
        this.mTranslationZ = c.transform.translationZ;
        this.mKeyFrameEasing = Easing.getInterpolator((String)c.motion.mTransitionEasing);
        this.mPathRotate = c.motion.mPathRotate;
        this.mDrawPath = c.motion.mDrawPath;
        this.mAnimateRelativeTo = c.motion.mAnimateRelativeTo;
        this.mProgress = c.propertySet.mProgress;
        Set<String> at = c.mCustomConstraints.keySet();
        for (String s : at) {
            ConstraintAttribute attr = c.mCustomConstraints.get(s);
            if (!attr.isContinuous()) continue;
            this.mAttributes.put(s, attr);
        }
    }

    public void addValues(HashMap<String, ViewSpline> splines, int mFramePosition) {
        block32: for (String s : splines.keySet()) {
            ViewSpline viewSpline = splines.get(s);
            if (viewSpline == null) continue;
            switch (s) {
                case "alpha": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.mAlpha) ? 1.0f : this.mAlpha);
                    continue block32;
                }
                case "elevation": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.mElevation) ? 0.0f : this.mElevation);
                    continue block32;
                }
                case "rotation": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.mRotation) ? 0.0f : this.mRotation);
                    continue block32;
                }
                case "rotationX": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.mRotationX) ? 0.0f : this.mRotationX);
                    continue block32;
                }
                case "rotationY": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.rotationY) ? 0.0f : this.rotationY);
                    continue block32;
                }
                case "transformPivotX": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.mPivotX) ? 0.0f : this.mPivotX);
                    continue block32;
                }
                case "transformPivotY": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.mPivotY) ? 0.0f : this.mPivotY);
                    continue block32;
                }
                case "transitionPathRotate": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.mPathRotate) ? 0.0f : this.mPathRotate);
                    continue block32;
                }
                case "progress": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.mProgress) ? 0.0f : this.mProgress);
                    continue block32;
                }
                case "scaleX": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.mScaleX) ? 1.0f : this.mScaleX);
                    continue block32;
                }
                case "scaleY": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.mScaleY) ? 1.0f : this.mScaleY);
                    continue block32;
                }
                case "translationX": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.mTranslationX) ? 0.0f : this.mTranslationX);
                    continue block32;
                }
                case "translationY": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.mTranslationY) ? 0.0f : this.mTranslationY);
                    continue block32;
                }
                case "translationZ": {
                    viewSpline.setPoint(mFramePosition, Float.isNaN(this.mTranslationZ) ? 0.0f : this.mTranslationZ);
                    continue block32;
                }
            }
            if (s.startsWith("CUSTOM")) {
                String customName = s.split(",")[1];
                if (!this.mAttributes.containsKey(customName)) continue;
                ConstraintAttribute custom = this.mAttributes.get(customName);
                if (viewSpline instanceof ViewSpline.CustomSet) {
                    ((ViewSpline.CustomSet)viewSpline).setPoint(mFramePosition, custom);
                    continue;
                }
                Log.e((String)TAG, (String)(s + " ViewSpline not a CustomSet frame = " + mFramePosition + ", value" + custom.getValueToInterpolate() + (Object)((Object)viewSpline)));
                continue;
            }
            Log.e((String)TAG, (String)("UNKNOWN spline " + s));
        }
    }

    public void setState(View view) {
        this.setBounds(view.getX(), view.getY(), view.getWidth(), view.getHeight());
        this.applyParameters(view);
    }

    public void setState(Rect rect, View view, int rotation, float prevous) {
        this.setBounds(rect.left, rect.top, rect.width(), rect.height());
        this.applyParameters(view);
        this.mPivotX = Float.NaN;
        this.mPivotY = Float.NaN;
        switch (rotation) {
            case 2: {
                this.mRotation = prevous + 90.0f;
                break;
            }
            case 1: {
                this.mRotation = prevous - 90.0f;
            }
        }
    }

    public void setState(Rect cw, ConstraintSet constraintSet, int rotation, int viewId) {
        this.setBounds(cw.left, cw.top, cw.width(), cw.height());
        this.applyParameters(constraintSet.getParameters(viewId));
        switch (rotation) {
            case 1: 
            case 3: {
                this.mRotation -= 90.0f;
                break;
            }
            case 2: 
            case 4: {
                this.mRotation += 90.0f;
                if (!(this.mRotation > 180.0f)) break;
                this.mRotation -= 360.0f;
            }
        }
    }
}

