/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.utils.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.constraintlayout.utils.widget.ImageFilterView;
import androidx.constraintlayout.widget.R;

public class ImageFilterButton
extends AppCompatImageButton {
    private ImageFilterView.ImageMatrix mImageMatrix = new ImageFilterView.ImageMatrix();
    private float mCrossfade = 0.0f;
    private float mRoundPercent = 0.0f;
    private float mRound = Float.NaN;
    private Path mPath;
    ViewOutlineProvider mViewOutlineProvider;
    RectF mRect;
    Drawable[] mLayers = new Drawable[2];
    LayerDrawable mLayer;
    private boolean mOverlay = true;
    private Drawable mAltDrawable = null;
    private Drawable mDrawable = null;
    private float mPanX = Float.NaN;
    private float mPanY = Float.NaN;
    private float mZoom = Float.NaN;
    private float mRotate = Float.NaN;

    public ImageFilterButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public ImageFilterButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ImageFilterButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setPadding(0, 0, 0, 0);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ImageFilterView);
            int count = a.getIndexCount();
            this.mAltDrawable = a.getDrawable(R.styleable.ImageFilterView_altSrc);
            for (int i = 0; i < count; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.ImageFilterView_crossfade) {
                    this.mCrossfade = a.getFloat(attr, 0.0f);
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_warmth) {
                    this.setWarmth(a.getFloat(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_saturation) {
                    this.setSaturation(a.getFloat(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_contrast) {
                    this.setContrast(a.getFloat(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_round) {
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRound(a.getDimension(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_roundPercent) {
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRoundPercent(a.getFloat(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_overlay) {
                    this.setOverlay(a.getBoolean(attr, this.mOverlay));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_imagePanX) {
                    this.setImagePanX(a.getFloat(attr, this.mPanX));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_imagePanY) {
                    this.setImagePanY(a.getFloat(attr, this.mPanY));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_imageRotate) {
                    this.setImageRotate(a.getFloat(attr, this.mRotate));
                    continue;
                }
                if (attr != R.styleable.ImageFilterView_imageZoom) continue;
                this.setImageZoom(a.getFloat(attr, this.mZoom));
            }
            a.recycle();
            this.mDrawable = this.getDrawable();
            if (this.mAltDrawable != null && this.mDrawable != null) {
                this.mLayers[0] = this.mDrawable = this.getDrawable().mutate();
                this.mLayers[1] = this.mAltDrawable.mutate();
                this.mLayer = new LayerDrawable(this.mLayers);
                this.mLayer.getDrawable(1).setAlpha((int)(255.0f * this.mCrossfade));
                if (!this.mOverlay) {
                    this.mLayer.getDrawable(0).setAlpha((int)(255.0f * (1.0f - this.mCrossfade)));
                }
                super.setImageDrawable((Drawable)this.mLayer);
            } else {
                this.mDrawable = this.getDrawable();
                if (this.mDrawable != null) {
                    this.mLayers[0] = this.mDrawable = this.mDrawable.mutate();
                }
            }
        }
    }

    public float getImagePanX() {
        return this.mPanX;
    }

    public float getImagePanY() {
        return this.mPanY;
    }

    public float getImageZoom() {
        return this.mZoom;
    }

    public float getImageRotate() {
        return this.mRotate;
    }

    public void setImagePanX(float pan) {
        this.mPanX = pan;
        this.updateViewMatrix();
    }

    public void setImagePanY(float pan) {
        this.mPanY = pan;
        this.updateViewMatrix();
    }

    public void setImageZoom(float zoom) {
        this.mZoom = zoom;
        this.updateViewMatrix();
    }

    public void setImageRotate(float rotation) {
        this.mRotate = rotation;
        this.updateViewMatrix();
    }

    public void setImageDrawable(Drawable drawable) {
        if (this.mAltDrawable != null && drawable != null) {
            this.mLayers[0] = this.mDrawable = drawable.mutate();
            this.mLayers[1] = this.mAltDrawable;
            this.mLayer = new LayerDrawable(this.mLayers);
            super.setImageDrawable((Drawable)this.mLayer);
            this.setCrossfade(this.mCrossfade);
        } else {
            super.setImageDrawable(drawable);
        }
    }

    public void setImageResource(int resId) {
        if (this.mAltDrawable != null) {
            this.mLayers[0] = this.mDrawable = AppCompatResources.getDrawable((Context)this.getContext(), (int)resId).mutate();
            this.mLayers[1] = this.mAltDrawable;
            this.mLayer = new LayerDrawable(this.mLayers);
            super.setImageDrawable((Drawable)this.mLayer);
            this.setCrossfade(this.mCrossfade);
        } else {
            super.setImageResource(resId);
        }
    }

    public void setAltImageResource(int resId) {
        this.mAltDrawable = AppCompatResources.getDrawable((Context)this.getContext(), (int)resId).mutate();
        this.mLayers[0] = this.mDrawable;
        this.mLayers[1] = this.mAltDrawable;
        this.mLayer = new LayerDrawable(this.mLayers);
        super.setImageDrawable((Drawable)this.mLayer);
        this.setCrossfade(this.mCrossfade);
    }

    private void updateViewMatrix() {
        if (Float.isNaN(this.mPanX) && Float.isNaN(this.mPanY) && Float.isNaN(this.mZoom) && Float.isNaN(this.mRotate)) {
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
            return;
        }
        this.setMatrix();
    }

    private void setMatrix() {
        if (Float.isNaN(this.mPanX) && Float.isNaN(this.mPanY) && Float.isNaN(this.mZoom) && Float.isNaN(this.mRotate)) {
            return;
        }
        float panX = Float.isNaN(this.mPanX) ? 0.0f : this.mPanX;
        float panY = Float.isNaN(this.mPanY) ? 0.0f : this.mPanY;
        float zoom = Float.isNaN(this.mZoom) ? 1.0f : this.mZoom;
        float rota = Float.isNaN(this.mRotate) ? 0.0f : this.mRotate;
        Matrix imageMatrix = new Matrix();
        imageMatrix.reset();
        float iw = this.getDrawable().getIntrinsicWidth();
        float ih = this.getDrawable().getIntrinsicHeight();
        float sw = this.getWidth();
        float sh = this.getHeight();
        float scale = zoom * (iw * sh < ih * sw ? sw / iw : sh / ih);
        imageMatrix.postScale(scale, scale);
        float tx = 0.5f * (panX * (sw - scale * iw) + sw - scale * iw);
        float ty = 0.5f * (panY * (sh - scale * ih) + sh - scale * ih);
        imageMatrix.postTranslate(tx, ty);
        imageMatrix.postRotate(rota, sw / 2.0f, sh / 2.0f);
        this.setImageMatrix(imageMatrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    private void setOverlay(boolean overlay) {
        this.mOverlay = overlay;
    }

    public void setSaturation(float saturation) {
        this.mImageMatrix.mSaturation = saturation;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public float getSaturation() {
        return this.mImageMatrix.mSaturation;
    }

    public void setContrast(float contrast) {
        this.mImageMatrix.mContrast = contrast;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public float getContrast() {
        return this.mImageMatrix.mContrast;
    }

    public void setWarmth(float warmth) {
        this.mImageMatrix.mWarmth = warmth;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public float getWarmth() {
        return this.mImageMatrix.mWarmth;
    }

    public void setCrossfade(float crossfade) {
        this.mCrossfade = crossfade;
        if (this.mLayers != null) {
            if (!this.mOverlay) {
                this.mLayer.getDrawable(0).setAlpha((int)(255.0f * (1.0f - this.mCrossfade)));
            }
            this.mLayer.getDrawable(1).setAlpha((int)(255.0f * this.mCrossfade));
            super.setImageDrawable((Drawable)this.mLayer);
        }
    }

    public float getCrossfade() {
        return this.mCrossfade;
    }

    public void setBrightness(float brightness) {
        this.mImageMatrix.mBrightness = brightness;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    @RequiresApi(value=21)
    public void setRoundPercent(float round) {
        boolean change = this.mRoundPercent != round;
        this.mRoundPercent = round;
        if (this.mRoundPercent != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int w = ImageFilterButton.this.getWidth();
                            int h = ImageFilterButton.this.getHeight();
                            float r = (float)Math.min(w, h) * ImageFilterButton.this.mRoundPercent / 2.0f;
                            outline.setRoundRect(0, 0, w, h, r);
                        }
                    };
                    this.setOutlineProvider(this.mViewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int w = this.getWidth();
            int h = this.getHeight();
            float r = (float)Math.min(w, h) * this.mRoundPercent / 2.0f;
            this.mRect.set(0.0f, 0.0f, (float)w, (float)h);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, r, r, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (change && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    @RequiresApi(value=21)
    public void setRound(float round) {
        if (Float.isNaN(round)) {
            this.mRound = round;
            float tmp = this.mRoundPercent;
            this.mRoundPercent = -1.0f;
            this.setRoundPercent(tmp);
            return;
        }
        boolean change = this.mRound != round;
        this.mRound = round;
        if (this.mRound != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int w = ImageFilterButton.this.getWidth();
                            int h = ImageFilterButton.this.getHeight();
                            outline.setRoundRect(0, 0, w, h, ImageFilterButton.this.mRound);
                        }
                    };
                    this.setOutlineProvider(this.mViewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int w = this.getWidth();
            int h = this.getHeight();
            this.mRect.set(0.0f, 0.0f, (float)w, (float)h);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, this.mRound, this.mRound, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (change && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public float getRoundPercent() {
        return this.mRoundPercent;
    }

    public float getRound() {
        return this.mRound;
    }

    public void draw(@NonNull Canvas canvas) {
        boolean clip = false;
        if (Build.VERSION.SDK_INT < 21 && this.mRound != 0.0f && this.mPath != null) {
            clip = true;
            canvas.save();
            canvas.clipPath(this.mPath);
        }
        super.draw(canvas);
        if (clip) {
            canvas.restore();
        }
    }

    public void layout(int l, int t, int r, int b) {
        super.layout(l, t, r, b);
        this.setMatrix();
    }
}

