/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.utils.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.R;

public class ImageFilterView
extends AppCompatImageView {
    private ImageMatrix mImageMatrix = new ImageMatrix();
    private boolean mOverlay = true;
    private Drawable mAltDrawable = null;
    private Drawable mDrawable = null;
    private float mCrossfade = 0.0f;
    private float mRoundPercent = 0.0f;
    private float mRound = Float.NaN;
    private Path mPath;
    ViewOutlineProvider mViewOutlineProvider;
    RectF mRect;
    Drawable[] mLayers = new Drawable[2];
    LayerDrawable mLayer;
    float mPanX = Float.NaN;
    float mPanY = Float.NaN;
    float mZoom = Float.NaN;
    float mRotate = Float.NaN;

    public float getImagePanX() {
        return this.mPanX;
    }

    public float getImagePanY() {
        return this.mPanY;
    }

    public float getImageZoom() {
        return this.mZoom;
    }

    public float getImageRotate() {
        return this.mRotate;
    }

    public void setImagePanX(float pan) {
        this.mPanX = pan;
        this.updateViewMatrix();
    }

    public void setImagePanY(float pan) {
        this.mPanY = pan;
        this.updateViewMatrix();
    }

    public void setImageZoom(float zoom) {
        this.mZoom = zoom;
        this.updateViewMatrix();
    }

    public void setImageRotate(float rotation) {
        this.mRotate = rotation;
        this.updateViewMatrix();
    }

    public void setImageDrawable(Drawable drawable) {
        if (this.mAltDrawable != null && drawable != null) {
            this.mLayers[0] = this.mDrawable = drawable.mutate();
            this.mLayers[1] = this.mAltDrawable;
            this.mLayer = new LayerDrawable(this.mLayers);
            super.setImageDrawable((Drawable)this.mLayer);
            this.setCrossfade(this.mCrossfade);
        } else {
            super.setImageDrawable(drawable);
        }
    }

    public void setImageResource(int resId) {
        if (this.mAltDrawable != null) {
            this.mLayers[0] = this.mDrawable = AppCompatResources.getDrawable((Context)this.getContext(), (int)resId).mutate();
            this.mLayers[1] = this.mAltDrawable;
            this.mLayer = new LayerDrawable(this.mLayers);
            super.setImageDrawable((Drawable)this.mLayer);
            this.setCrossfade(this.mCrossfade);
        } else {
            super.setImageResource(resId);
        }
    }

    public void setAltImageResource(int resId) {
        this.mAltDrawable = AppCompatResources.getDrawable((Context)this.getContext(), (int)resId);
        this.setAltImageDrawable(this.mAltDrawable);
    }

    public void setAltImageDrawable(Drawable altDrawable) {
        this.mAltDrawable = altDrawable.mutate();
        this.mLayers[0] = this.mDrawable;
        this.mLayers[1] = this.mAltDrawable;
        this.mLayer = new LayerDrawable(this.mLayers);
        super.setImageDrawable((Drawable)this.mLayer);
        this.setCrossfade(this.mCrossfade);
    }

    private void updateViewMatrix() {
        if (Float.isNaN(this.mPanX) && Float.isNaN(this.mPanY) && Float.isNaN(this.mZoom) && Float.isNaN(this.mRotate)) {
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
            return;
        }
        this.setMatrix();
    }

    private void setMatrix() {
        if (Float.isNaN(this.mPanX) && Float.isNaN(this.mPanY) && Float.isNaN(this.mZoom) && Float.isNaN(this.mRotate)) {
            return;
        }
        float panX = Float.isNaN(this.mPanX) ? 0.0f : this.mPanX;
        float panY = Float.isNaN(this.mPanY) ? 0.0f : this.mPanY;
        float zoom = Float.isNaN(this.mZoom) ? 1.0f : this.mZoom;
        float rota = Float.isNaN(this.mRotate) ? 0.0f : this.mRotate;
        Matrix imageMatrix = new Matrix();
        imageMatrix.reset();
        float iw = this.getDrawable().getIntrinsicWidth();
        float ih = this.getDrawable().getIntrinsicHeight();
        float sw = this.getWidth();
        float sh = this.getHeight();
        float scale = zoom * (iw * sh < ih * sw ? sw / iw : sh / ih);
        imageMatrix.postScale(scale, scale);
        float tx = 0.5f * (panX * (sw - scale * iw) + sw - scale * iw);
        float ty = 0.5f * (panY * (sh - scale * ih) + sh - scale * ih);
        imageMatrix.postTranslate(tx, ty);
        imageMatrix.postRotate(rota, sw / 2.0f, sh / 2.0f);
        this.setImageMatrix(imageMatrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    public ImageFilterView(Context context) {
        super(context);
        this.init(context, null);
    }

    public ImageFilterView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ImageFilterView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ImageFilterView);
            int count = a.getIndexCount();
            this.mAltDrawable = a.getDrawable(R.styleable.ImageFilterView_altSrc);
            for (int i = 0; i < count; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.ImageFilterView_crossfade) {
                    this.mCrossfade = a.getFloat(attr, 0.0f);
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_warmth) {
                    this.setWarmth(a.getFloat(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_saturation) {
                    this.setSaturation(a.getFloat(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_contrast) {
                    this.setContrast(a.getFloat(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_brightness) {
                    this.setBrightness(a.getFloat(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_round) {
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRound(a.getDimension(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_roundPercent) {
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRoundPercent(a.getFloat(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_overlay) {
                    this.setOverlay(a.getBoolean(attr, this.mOverlay));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_imagePanX) {
                    this.setImagePanX(a.getFloat(attr, this.mPanX));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_imagePanY) {
                    this.setImagePanY(a.getFloat(attr, this.mPanY));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_imageRotate) {
                    this.setImageRotate(a.getFloat(attr, this.mRotate));
                    continue;
                }
                if (attr != R.styleable.ImageFilterView_imageZoom) continue;
                this.setImageZoom(a.getFloat(attr, this.mZoom));
            }
            a.recycle();
            this.mDrawable = this.getDrawable();
            if (this.mAltDrawable != null && this.mDrawable != null) {
                this.mLayers[0] = this.mDrawable = this.getDrawable().mutate();
                this.mLayers[1] = this.mAltDrawable.mutate();
                this.mLayer = new LayerDrawable(this.mLayers);
                this.mLayer.getDrawable(1).setAlpha((int)(255.0f * this.mCrossfade));
                if (!this.mOverlay) {
                    this.mLayer.getDrawable(0).setAlpha((int)(255.0f * (1.0f - this.mCrossfade)));
                }
                super.setImageDrawable((Drawable)this.mLayer);
            } else {
                this.mDrawable = this.getDrawable();
                if (this.mDrawable != null) {
                    this.mLayers[0] = this.mDrawable = this.mDrawable.mutate();
                }
            }
        }
    }

    private void setOverlay(boolean overlay) {
        this.mOverlay = overlay;
    }

    public void setSaturation(float saturation) {
        this.mImageMatrix.mSaturation = saturation;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public float getSaturation() {
        return this.mImageMatrix.mSaturation;
    }

    public void setContrast(float contrast) {
        this.mImageMatrix.mContrast = contrast;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public float getContrast() {
        return this.mImageMatrix.mContrast;
    }

    public void setWarmth(float warmth) {
        this.mImageMatrix.mWarmth = warmth;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public float getWarmth() {
        return this.mImageMatrix.mWarmth;
    }

    public void setCrossfade(float crossfade) {
        this.mCrossfade = crossfade;
        if (this.mLayers != null) {
            if (!this.mOverlay) {
                this.mLayer.getDrawable(0).setAlpha((int)(255.0f * (1.0f - this.mCrossfade)));
            }
            this.mLayer.getDrawable(1).setAlpha((int)(255.0f * this.mCrossfade));
            super.setImageDrawable((Drawable)this.mLayer);
        }
    }

    public float getCrossfade() {
        return this.mCrossfade;
    }

    public void setBrightness(float brightness) {
        this.mImageMatrix.mBrightness = brightness;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public float getBrightness() {
        return this.mImageMatrix.mBrightness;
    }

    @RequiresApi(value=21)
    public void setRoundPercent(float round) {
        boolean change = this.mRoundPercent != round;
        this.mRoundPercent = round;
        if (this.mRoundPercent != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int w = ImageFilterView.this.getWidth();
                            int h = ImageFilterView.this.getHeight();
                            float r = (float)Math.min(w, h) * ImageFilterView.this.mRoundPercent / 2.0f;
                            outline.setRoundRect(0, 0, w, h, r);
                        }
                    };
                    this.setOutlineProvider(this.mViewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int w = this.getWidth();
            int h = this.getHeight();
            float r = (float)Math.min(w, h) * this.mRoundPercent / 2.0f;
            this.mRect.set(0.0f, 0.0f, (float)w, (float)h);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, r, r, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (change && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    @RequiresApi(value=21)
    public void setRound(float round) {
        if (Float.isNaN(round)) {
            this.mRound = round;
            float tmp = this.mRoundPercent;
            this.mRoundPercent = -1.0f;
            this.setRoundPercent(tmp);
            return;
        }
        boolean change = this.mRound != round;
        this.mRound = round;
        if (this.mRound != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int w = ImageFilterView.this.getWidth();
                            int h = ImageFilterView.this.getHeight();
                            outline.setRoundRect(0, 0, w, h, ImageFilterView.this.mRound);
                        }
                    };
                    this.setOutlineProvider(this.mViewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int w = this.getWidth();
            int h = this.getHeight();
            this.mRect.set(0.0f, 0.0f, (float)w, (float)h);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, this.mRound, this.mRound, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (change && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public float getRoundPercent() {
        return this.mRoundPercent;
    }

    public float getRound() {
        return this.mRound;
    }

    public void draw(@NonNull Canvas canvas) {
        boolean clip = false;
        if (Build.VERSION.SDK_INT < 21 && this.mRoundPercent != 0.0f && this.mPath != null) {
            clip = true;
            canvas.save();
            canvas.clipPath(this.mPath);
        }
        super.draw(canvas);
        if (clip) {
            canvas.restore();
        }
    }

    public void layout(int l, int t, int r, int b) {
        super.layout(l, t, r, b);
        this.setMatrix();
    }

    static class ImageMatrix {
        float[] mMatrix = new float[20];
        ColorMatrix mColorMatrix = new ColorMatrix();
        ColorMatrix mTmpColorMatrix = new ColorMatrix();
        float mBrightness = 1.0f;
        float mSaturation = 1.0f;
        float mContrast = 1.0f;
        float mWarmth = 1.0f;

        ImageMatrix() {
        }

        private void saturation(float saturationStrength) {
            float Rf = 0.2999f;
            float Gf = 0.587f;
            float Bf = 0.114f;
            float s = saturationStrength;
            float ms = 1.0f - s;
            float Rt = Rf * ms;
            float Gt = Gf * ms;
            float Bt = Bf * ms;
            this.mMatrix[0] = Rt + s;
            this.mMatrix[1] = Gt;
            this.mMatrix[2] = Bt;
            this.mMatrix[3] = 0.0f;
            this.mMatrix[4] = 0.0f;
            this.mMatrix[5] = Rt;
            this.mMatrix[6] = Gt + s;
            this.mMatrix[7] = Bt;
            this.mMatrix[8] = 0.0f;
            this.mMatrix[9] = 0.0f;
            this.mMatrix[10] = Rt;
            this.mMatrix[11] = Gt;
            this.mMatrix[12] = Bt + s;
            this.mMatrix[13] = 0.0f;
            this.mMatrix[14] = 0.0f;
            this.mMatrix[15] = 0.0f;
            this.mMatrix[16] = 0.0f;
            this.mMatrix[17] = 0.0f;
            this.mMatrix[18] = 1.0f;
            this.mMatrix[19] = 0.0f;
        }

        private void warmth(float warmth) {
            float colorG;
            float colorR;
            float colorG2;
            float colorR2;
            float kelvin;
            float centiKelvin;
            float baseTemperature = 5000.0f;
            if (warmth <= 0.0f) {
                warmth = 0.01f;
            }
            if ((centiKelvin = (kelvin = baseTemperature / warmth) / 100.0f) > 66.0f) {
                float tmp = centiKelvin - 60.0f;
                colorR2 = 329.69873f * (float)Math.pow(tmp, -0.13320475816726685);
                colorG2 = 288.12216f * (float)Math.pow(tmp, 0.07551485300064087);
            } else {
                colorG2 = 99.4708f * (float)Math.log(centiKelvin) - 161.11957f;
                colorR2 = 255.0f;
            }
            float colorB = centiKelvin < 66.0f ? (centiKelvin > 19.0f ? 138.51773f * (float)Math.log(centiKelvin - 10.0f) - 305.0448f : 0.0f) : 255.0f;
            float tmpColor_r = Math.min(255.0f, Math.max(colorR2, 0.0f));
            float tmpColor_g = Math.min(255.0f, Math.max(colorG2, 0.0f));
            float tmpColor_b = Math.min(255.0f, Math.max(colorB, 0.0f));
            float color_r = tmpColor_r;
            float color_g = tmpColor_g;
            float color_b = tmpColor_b;
            kelvin = baseTemperature;
            float centiKelvin2 = kelvin / 100.0f;
            if (centiKelvin2 > 66.0f) {
                float tmp = centiKelvin2 - 60.0f;
                colorR = 329.69873f * (float)Math.pow(tmp, -0.13320475816726685);
                colorG = 288.12216f * (float)Math.pow(tmp, 0.07551485300064087);
            } else {
                colorG = 99.4708f * (float)Math.log(centiKelvin2) - 161.11957f;
                colorR = 255.0f;
            }
            float colorB2 = centiKelvin2 < 66.0f ? (centiKelvin2 > 19.0f ? 138.51773f * (float)Math.log(centiKelvin2 - 10.0f) - 305.0448f : 0.0f) : 255.0f;
            tmpColor_r = Math.min(255.0f, Math.max(colorR, 0.0f));
            tmpColor_g = Math.min(255.0f, Math.max(colorG, 0.0f));
            tmpColor_b = Math.min(255.0f, Math.max(colorB2, 0.0f));
            color_g /= tmpColor_g;
            color_b /= tmpColor_b;
            this.mMatrix[0] = color_r /= tmpColor_r;
            this.mMatrix[1] = 0.0f;
            this.mMatrix[2] = 0.0f;
            this.mMatrix[3] = 0.0f;
            this.mMatrix[4] = 0.0f;
            this.mMatrix[5] = 0.0f;
            this.mMatrix[6] = color_g;
            this.mMatrix[7] = 0.0f;
            this.mMatrix[8] = 0.0f;
            this.mMatrix[9] = 0.0f;
            this.mMatrix[10] = 0.0f;
            this.mMatrix[11] = 0.0f;
            this.mMatrix[12] = color_b;
            this.mMatrix[13] = 0.0f;
            this.mMatrix[14] = 0.0f;
            this.mMatrix[15] = 0.0f;
            this.mMatrix[16] = 0.0f;
            this.mMatrix[17] = 0.0f;
            this.mMatrix[18] = 1.0f;
            this.mMatrix[19] = 0.0f;
        }

        private void brightness(float brightness) {
            this.mMatrix[0] = brightness;
            this.mMatrix[1] = 0.0f;
            this.mMatrix[2] = 0.0f;
            this.mMatrix[3] = 0.0f;
            this.mMatrix[4] = 0.0f;
            this.mMatrix[5] = 0.0f;
            this.mMatrix[6] = brightness;
            this.mMatrix[7] = 0.0f;
            this.mMatrix[8] = 0.0f;
            this.mMatrix[9] = 0.0f;
            this.mMatrix[10] = 0.0f;
            this.mMatrix[11] = 0.0f;
            this.mMatrix[12] = brightness;
            this.mMatrix[13] = 0.0f;
            this.mMatrix[14] = 0.0f;
            this.mMatrix[15] = 0.0f;
            this.mMatrix[16] = 0.0f;
            this.mMatrix[17] = 0.0f;
            this.mMatrix[18] = 1.0f;
            this.mMatrix[19] = 0.0f;
        }

        void updateMatrix(ImageView view) {
            this.mColorMatrix.reset();
            boolean filter = false;
            if (this.mSaturation != 1.0f) {
                this.saturation(this.mSaturation);
                this.mColorMatrix.set(this.mMatrix);
                filter = true;
            }
            if (this.mContrast != 1.0f) {
                this.mTmpColorMatrix.setScale(this.mContrast, this.mContrast, this.mContrast, 1.0f);
                this.mColorMatrix.postConcat(this.mTmpColorMatrix);
                filter = true;
            }
            if (this.mWarmth != 1.0f) {
                this.warmth(this.mWarmth);
                this.mTmpColorMatrix.set(this.mMatrix);
                this.mColorMatrix.postConcat(this.mTmpColorMatrix);
                filter = true;
            }
            if (this.mBrightness != 1.0f) {
                this.brightness(this.mBrightness);
                this.mTmpColorMatrix.set(this.mMatrix);
                this.mColorMatrix.postConcat(this.mTmpColorMatrix);
                filter = true;
            }
            if (filter) {
                view.setColorFilter((ColorFilter)new ColorMatrixColorFilter(this.mColorMatrix));
            } else {
                view.clearColorFilter();
            }
        }
    }
}

