/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.utils.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Layout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.R;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.FloatLayout;
import androidx.constraintlayout.widget.R;
import java.util.Objects;

public class MotionLabel
extends View
implements FloatLayout {
    static final String TAG = "MotionLabel";
    TextPaint mPaint = new TextPaint();
    Path mPath = new Path();
    private int mTextFillColor = 65535;
    private int mTextOutlineColor = 65535;
    private boolean mUseOutline = false;
    private float mRoundPercent = 0.0f;
    private float mRound = Float.NaN;
    ViewOutlineProvider mViewOutlineProvider;
    RectF mRect;
    private float mTextSize = 48.0f;
    private float mBaseTextSize = Float.NaN;
    private int mStyleIndex;
    private int mTypefaceIndex;
    private float mTextOutlineThickness = 0.0f;
    private String mText = "Hello World";
    boolean mNotBuilt = true;
    private Rect mTextBounds = new Rect();
    private int mPaddingLeft = 1;
    private int mPaddingRight = 1;
    private int mPaddingTop = 1;
    private int mPaddingBottom = 1;
    private String mFontFamily;
    private Layout mLayout;
    private static final int SANS = 1;
    private static final int SERIF = 2;
    private static final int MONOSPACE = 3;
    private int mGravity = 0x800033;
    private int mAutoSizeTextType = 0;
    private boolean mAutoSize = false;
    private float mDeltaLeft;
    private float mFloatWidth;
    private float mFloatHeight;
    private Drawable mTextBackground;
    Matrix mOutlinePositionMatrix;
    private Bitmap mTextBackgroundBitmap;
    private BitmapShader mTextShader;
    private Matrix mTextShaderMatrix;
    private float mTextureHeight = Float.NaN;
    private float mTextureWidth = Float.NaN;
    private float mTextPanX = 0.0f;
    private float mTextPanY = 0.0f;
    Paint mPaintCache = new Paint();
    private int mTextureEffect = 0;
    Rect mTempRect;
    Paint mTempPaint;
    float mPaintTextSize;
    float mBackgroundPanX = Float.NaN;
    float mBackgroundPanY = Float.NaN;
    float mZoom = Float.NaN;
    float mRotate = Float.NaN;

    public MotionLabel(Context context) {
        super(context);
        this.init(context, null);
    }

    public MotionLabel(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MotionLabel(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setUpTheme(context);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.MotionLabel);
            int count = a.getIndexCount();
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.MotionLabel_android_text) {
                    this.setText(a.getText(attr2));
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_android_fontFamily) {
                    this.mFontFamily = a.getString(attr2);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_scaleFromTextSize) {
                    this.mBaseTextSize = a.getDimensionPixelSize(attr2, (int)this.mBaseTextSize);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_android_textSize) {
                    this.mTextSize = a.getDimensionPixelSize(attr2, (int)this.mTextSize);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_android_textStyle) {
                    this.mStyleIndex = a.getInt(attr2, this.mStyleIndex);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_android_typeface) {
                    this.mTypefaceIndex = a.getInt(attr2, this.mTypefaceIndex);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_android_textColor) {
                    this.mTextFillColor = a.getColor(attr2, this.mTextFillColor);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_borderRound) {
                    this.mRound = a.getDimension(attr2, this.mRound);
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRound(this.mRound);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_borderRoundPercent) {
                    this.mRoundPercent = a.getFloat(attr2, this.mRoundPercent);
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRoundPercent(this.mRoundPercent);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_android_gravity) {
                    this.setGravity(a.getInt(attr2, -1));
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_android_autoSizeTextType) {
                    this.mAutoSizeTextType = a.getInt(attr2, 0);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_textOutlineColor) {
                    this.mTextOutlineColor = a.getInt(attr2, this.mTextOutlineColor);
                    this.mUseOutline = true;
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_textOutlineThickness) {
                    this.mTextOutlineThickness = a.getDimension(attr2, this.mTextOutlineThickness);
                    this.mUseOutline = true;
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_textBackground) {
                    this.mTextBackground = a.getDrawable(attr2);
                    this.mUseOutline = true;
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_textBackgroundPanX) {
                    this.mBackgroundPanX = a.getFloat(attr2, this.mBackgroundPanX);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_textBackgroundPanY) {
                    this.mBackgroundPanY = a.getFloat(attr2, this.mBackgroundPanY);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_textPanX) {
                    this.mTextPanX = a.getFloat(attr2, this.mTextPanX);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_textPanY) {
                    this.mTextPanY = a.getFloat(attr2, this.mTextPanY);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_textBackgroundRotate) {
                    this.mRotate = a.getFloat(attr2, this.mRotate);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_textBackgroundZoom) {
                    this.mZoom = a.getFloat(attr2, this.mZoom);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_textureHeight) {
                    this.mTextureHeight = a.getDimension(attr2, this.mTextureHeight);
                    continue;
                }
                if (attr2 == R.styleable.MotionLabel_textureWidth) {
                    this.mTextureWidth = a.getDimension(attr2, this.mTextureWidth);
                    continue;
                }
                if (attr2 != R.styleable.MotionLabel_textureEffect) continue;
                this.mTextureEffect = a.getInt(attr2, this.mTextureEffect);
            }
            a.recycle();
        }
        this.setupTexture();
        this.setupPath();
    }

    Bitmap blur(Bitmap bitmapOriginal, int factor) {
        int w = bitmapOriginal.getWidth();
        int h = bitmapOriginal.getHeight();
        Bitmap ret = Bitmap.createScaledBitmap((Bitmap)bitmapOriginal, (int)(w /= 2), (int)(h /= 2), (boolean)true);
        for (int i = 0; i < factor && w >= 32 && h >= 32; ++i) {
            ret = Bitmap.createScaledBitmap((Bitmap)ret, (int)(w /= 2), (int)(h /= 2), (boolean)true);
        }
        return ret;
    }

    private void setupTexture() {
        if (this.mTextBackground != null) {
            this.mTextShaderMatrix = new Matrix();
            int iw = this.mTextBackground.getIntrinsicWidth();
            int ih = this.mTextBackground.getIntrinsicHeight();
            if (iw <= 0) {
                int w = this.getWidth();
                if (w == 0) {
                    w = Float.isNaN(this.mTextureWidth) ? 128 : (int)this.mTextureWidth;
                }
                iw = w;
            }
            if (ih <= 0) {
                int h = this.getHeight();
                if (h == 0) {
                    h = Float.isNaN(this.mTextureHeight) ? 128 : (int)this.mTextureHeight;
                }
                ih = h;
            }
            if (this.mTextureEffect != 0) {
                iw /= 2;
                ih /= 2;
            }
            this.mTextBackgroundBitmap = Bitmap.createBitmap((int)iw, (int)ih, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(this.mTextBackgroundBitmap);
            this.mTextBackground.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            this.mTextBackground.setFilterBitmap(true);
            this.mTextBackground.draw(canvas);
            if (this.mTextureEffect != 0) {
                this.mTextBackgroundBitmap = this.blur(this.mTextBackgroundBitmap, 4);
            }
            this.mTextShader = new BitmapShader(this.mTextBackgroundBitmap, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
        }
    }

    private void adjustTexture(float l, float t, float r, float b) {
        if (this.mTextShaderMatrix == null) {
            return;
        }
        this.mFloatWidth = r - l;
        this.mFloatHeight = b - t;
        this.updateShaderMatrix();
    }

    @SuppressLint(value={"RtlHardcoded"})
    public void setGravity(int gravity) {
        if ((gravity & 0x800007) == 0) {
            gravity |= 0x800003;
        }
        if ((gravity & 0x70) == 0) {
            gravity |= 0x30;
        }
        boolean newLayout = false;
        if ((gravity & 0x800007) != (this.mGravity & 0x800007)) {
            newLayout = true;
        }
        if (gravity != this.mGravity) {
            this.invalidate();
        }
        this.mGravity = gravity;
        switch (this.mGravity & 0x70) {
            case 48: {
                this.mTextPanY = -1.0f;
                break;
            }
            case 80: {
                this.mTextPanY = 1.0f;
                break;
            }
            default: {
                this.mTextPanY = 0.0f;
            }
        }
        switch (this.mGravity & 0x800007) {
            case 3: 
            case 0x800003: {
                this.mTextPanX = -1.0f;
                break;
            }
            case 5: 
            case 0x800005: {
                this.mTextPanX = 1.0f;
                break;
            }
            default: {
                this.mTextPanX = 0.0f;
            }
        }
    }

    private float getHorizontalOffset() {
        float scale = Float.isNaN(this.mBaseTextSize) ? 1.0f : this.mTextSize / this.mBaseTextSize;
        float textWidth = scale * this.mPaint.measureText(this.mText, 0, this.mText.length());
        float boxWidth = (Float.isNaN(this.mFloatWidth) ? (float)this.getMeasuredWidth() : this.mFloatWidth) - (float)this.getPaddingLeft() - (float)this.getPaddingRight();
        return (boxWidth - textWidth) * (1.0f + this.mTextPanX) / 2.0f;
    }

    private float getVerticalOffset() {
        float scale = Float.isNaN(this.mBaseTextSize) ? 1.0f : this.mTextSize / this.mBaseTextSize;
        Paint.FontMetrics fm = this.mPaint.getFontMetrics();
        float boxHeight = (Float.isNaN(this.mFloatHeight) ? (float)this.getMeasuredHeight() : this.mFloatHeight) - (float)this.getPaddingTop() - (float)this.getPaddingBottom();
        float textHeight = scale * (fm.descent - fm.ascent);
        return (boxHeight - textHeight) * (1.0f - this.mTextPanY) / 2.0f - scale * fm.ascent;
    }

    private void setUpTheme(Context context) {
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(R.attr.colorPrimary, typedValue, true);
        this.mTextFillColor = typedValue.data;
        this.mPaint.setColor(this.mTextFillColor);
    }

    public void setText(CharSequence text) {
        this.mText = text.toString();
        this.invalidate();
    }

    void setupPath() {
        this.mPaddingLeft = this.getPaddingLeft();
        this.mPaddingRight = this.getPaddingRight();
        this.mPaddingTop = this.getPaddingTop();
        this.mPaddingBottom = this.getPaddingBottom();
        this.setTypefaceFromAttrs(this.mFontFamily, this.mTypefaceIndex, this.mStyleIndex);
        this.mPaint.setColor(this.mTextFillColor);
        this.mPaint.setStrokeWidth(this.mTextOutlineThickness);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mPaint.setFlags(128);
        this.setTextSize(this.mTextSize);
        this.mPaint.setAntiAlias(true);
    }

    void buildShape(float scale) {
        if (!this.mUseOutline && scale == 1.0f) {
            return;
        }
        this.mPath.reset();
        String str = this.mText;
        int len = str.length();
        this.mPaint.getTextBounds(str, 0, len, this.mTextBounds);
        this.mPaint.getTextPath(str, 0, len, 0.0f, 0.0f, this.mPath);
        if (scale != 1.0f) {
            Log.v((String)TAG, (String)(Debug.getLoc() + " scale " + scale));
            Matrix matrix = new Matrix();
            matrix.postScale(scale, scale);
            this.mPath.transform(matrix);
        }
        --this.mTextBounds.right;
        ++this.mTextBounds.left;
        ++this.mTextBounds.bottom;
        --this.mTextBounds.top;
        RectF rect = new RectF();
        rect.bottom = this.getHeight();
        rect.right = this.getWidth();
        this.mNotBuilt = false;
    }

    public void layout(int l, int t, int r, int b) {
        super.layout(l, t, r, b);
        boolean normalScale = Float.isNaN(this.mBaseTextSize);
        float scaleText = normalScale ? 1.0f : this.mTextSize / this.mBaseTextSize;
        this.mFloatWidth = r - l;
        this.mFloatHeight = b - t;
        if (this.mAutoSize) {
            if (this.mTempRect == null) {
                this.mTempPaint = new Paint();
                this.mTempRect = new Rect();
                this.mTempPaint.set((Paint)this.mPaint);
                this.mPaintTextSize = this.mTempPaint.getTextSize();
            }
            this.mTempPaint.getTextBounds(this.mText, 0, this.mText.length(), this.mTempRect);
            int tw = this.mTempRect.width();
            int th = (int)(1.3f * (float)this.mTempRect.height());
            float vw = this.mFloatWidth - (float)this.mPaddingRight - (float)this.mPaddingLeft;
            float vh = this.mFloatHeight - (float)this.mPaddingBottom - (float)this.mPaddingTop;
            if (normalScale) {
                if ((float)tw * vh > (float)th * vw) {
                    this.mPaint.setTextSize(this.mPaintTextSize * vw / (float)tw);
                } else {
                    this.mPaint.setTextSize(this.mPaintTextSize * vh / (float)th);
                }
            } else {
                float f = scaleText = (float)tw * vh > (float)th * vw ? vw / (float)tw : vh / (float)th;
            }
        }
        if (this.mUseOutline || !normalScale) {
            this.adjustTexture(l, t, r, b);
            this.buildShape(scaleText);
        }
    }

    @Override
    public void layout(float l, float t, float r, float b) {
        this.mDeltaLeft = l - (float)((int)(0.5f + l));
        int w = (int)(0.5f + r) - (int)(0.5f + l);
        int h = (int)(0.5f + b) - (int)(0.5f + t);
        this.mFloatWidth = r - l;
        this.mFloatHeight = b - t;
        this.adjustTexture(l, t, r, b);
        if (this.getMeasuredHeight() != h || this.getMeasuredWidth() != w) {
            int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)w, (int)0x40000000);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)h, (int)0x40000000);
            this.measure(widthMeasureSpec, heightMeasureSpec);
            super.layout((int)(0.5f + l), (int)(0.5f + t), (int)(0.5f + r), (int)(0.5f + b));
        } else {
            super.layout((int)(0.5f + l), (int)(0.5f + t), (int)(0.5f + r), (int)(0.5f + b));
        }
        if (this.mAutoSize) {
            if (this.mTempRect == null) {
                this.mTempPaint = new Paint();
                this.mTempRect = new Rect();
                this.mTempPaint.set((Paint)this.mPaint);
                this.mPaintTextSize = this.mTempPaint.getTextSize();
            }
            this.mFloatWidth = r - l;
            this.mFloatHeight = b - t;
            this.mTempPaint.getTextBounds(this.mText, 0, this.mText.length(), this.mTempRect);
            int tw = this.mTempRect.width();
            float th = 1.3f * (float)this.mTempRect.height();
            float vw = r - l - (float)this.mPaddingRight - (float)this.mPaddingLeft;
            float vh = b - t - (float)this.mPaddingBottom - (float)this.mPaddingTop;
            if ((float)tw * vh > th * vw) {
                this.mPaint.setTextSize(this.mPaintTextSize * vw / (float)tw);
            } else {
                this.mPaint.setTextSize(this.mPaintTextSize * vh / th);
            }
            if (this.mUseOutline || !Float.isNaN(this.mBaseTextSize)) {
                this.buildShape(Float.isNaN(this.mBaseTextSize) ? 1.0f : this.mTextSize / this.mBaseTextSize);
            }
        }
    }

    protected void onDraw(@NonNull Canvas canvas) {
        float scale = Float.isNaN(this.mBaseTextSize) ? 1.0f : this.mTextSize / this.mBaseTextSize;
        super.onDraw(canvas);
        if (!this.mUseOutline && scale == 1.0f) {
            float x = (float)this.mPaddingLeft + this.getHorizontalOffset();
            float y = (float)this.mPaddingTop + this.getVerticalOffset();
            canvas.drawText(this.mText, this.mDeltaLeft + x, y, (Paint)this.mPaint);
            return;
        }
        if (this.mNotBuilt) {
            this.buildShape(scale);
        }
        if (this.mOutlinePositionMatrix == null) {
            this.mOutlinePositionMatrix = new Matrix();
        }
        if (this.mUseOutline) {
            this.mPaintCache.set((Paint)this.mPaint);
            this.mOutlinePositionMatrix.reset();
            float x = (float)this.mPaddingLeft + this.getHorizontalOffset();
            float y = (float)this.mPaddingTop + this.getVerticalOffset();
            this.mOutlinePositionMatrix.postTranslate(x, y);
            this.mOutlinePositionMatrix.preScale(scale, scale);
            this.mPath.transform(this.mOutlinePositionMatrix);
            if (this.mTextShader != null) {
                this.mPaint.setFilterBitmap(true);
                this.mPaint.setShader((Shader)this.mTextShader);
            } else {
                this.mPaint.setColor(this.mTextFillColor);
            }
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setStrokeWidth(this.mTextOutlineThickness);
            canvas.drawPath(this.mPath, (Paint)this.mPaint);
            if (this.mTextShader != null) {
                this.mPaint.setShader(null);
            }
            this.mPaint.setColor(this.mTextOutlineColor);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(this.mTextOutlineThickness);
            canvas.drawPath(this.mPath, (Paint)this.mPaint);
            this.mOutlinePositionMatrix.reset();
            this.mOutlinePositionMatrix.postTranslate(-x, -y);
            this.mPath.transform(this.mOutlinePositionMatrix);
            this.mPaint.set(this.mPaintCache);
        } else {
            float x = (float)this.mPaddingLeft + this.getHorizontalOffset();
            float y = (float)this.mPaddingTop + this.getVerticalOffset();
            this.mOutlinePositionMatrix.reset();
            this.mOutlinePositionMatrix.preTranslate(x, y);
            this.mPath.transform(this.mOutlinePositionMatrix);
            this.mPaint.setColor(this.mTextFillColor);
            this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            this.mPaint.setStrokeWidth(this.mTextOutlineThickness);
            canvas.drawPath(this.mPath, (Paint)this.mPaint);
            this.mOutlinePositionMatrix.reset();
            this.mOutlinePositionMatrix.preTranslate(-x, -y);
            this.mPath.transform(this.mOutlinePositionMatrix);
        }
    }

    public void setTextOutlineThickness(float width) {
        this.mTextOutlineThickness = width;
        this.mUseOutline = true;
        if (Float.isNaN(this.mTextOutlineThickness)) {
            this.mTextOutlineThickness = 1.0f;
            this.mUseOutline = false;
        }
        this.invalidate();
    }

    public void setTextFillColor(int color) {
        this.mTextFillColor = color;
        this.invalidate();
    }

    public void setTextOutlineColor(int color) {
        this.mTextOutlineColor = color;
        this.mUseOutline = true;
        this.invalidate();
    }

    private void setTypefaceFromAttrs(String familyName, int typefaceIndex, int styleIndex) {
        Typeface tf = null;
        if (familyName != null && (tf = Typeface.create((String)familyName, (int)styleIndex)) != null) {
            this.setTypeface(tf);
            return;
        }
        switch (typefaceIndex) {
            case 1: {
                tf = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                tf = Typeface.SERIF;
                break;
            }
            case 3: {
                tf = Typeface.MONOSPACE;
            }
        }
        if (styleIndex > 0) {
            tf = tf == null ? Typeface.defaultFromStyle((int)styleIndex) : Typeface.create((Typeface)tf, (int)styleIndex);
            this.setTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = styleIndex & ~typefaceStyle;
            this.mPaint.setFakeBoldText((need & 1) != 0);
            this.mPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mPaint.setFakeBoldText(false);
            this.mPaint.setTextSkewX(0.0f);
            this.setTypeface(tf);
        }
    }

    public void setTypeface(Typeface tf) {
        if (!Objects.equals(this.mPaint.getTypeface(), tf)) {
            this.mPaint.setTypeface(tf);
            if (this.mLayout != null) {
                this.mLayout = null;
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public Typeface getTypeface() {
        return this.mPaint.getTypeface();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthSize;
        int height = heightSize;
        this.mAutoSize = false;
        this.mPaddingLeft = this.getPaddingLeft();
        this.mPaddingRight = this.getPaddingRight();
        this.mPaddingTop = this.getPaddingTop();
        this.mPaddingBottom = this.getPaddingBottom();
        if (widthMode != 0x40000000 || heightMode != 0x40000000) {
            this.mPaint.getTextBounds(this.mText, 0, this.mText.length(), this.mTextBounds);
            if (widthMode != 0x40000000) {
                width = (int)((float)this.mTextBounds.width() + 0.99999f);
            }
            width += this.mPaddingLeft + this.mPaddingRight;
            if (heightMode != 0x40000000) {
                int desired = (int)((float)this.mPaint.getFontMetricsInt(null) + 0.99999f);
                height = heightMode == Integer.MIN_VALUE ? Math.min(height, desired) : desired;
                height += this.mPaddingTop + this.mPaddingBottom;
            }
        } else if (this.mAutoSizeTextType != 0) {
            this.mAutoSize = true;
        }
        this.setMeasuredDimension(width, height);
    }

    @RequiresApi(value=21)
    public void setRoundPercent(float round) {
        boolean change = this.mRoundPercent != round;
        this.mRoundPercent = round;
        if (this.mRoundPercent != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int w = MotionLabel.this.getWidth();
                            int h = MotionLabel.this.getHeight();
                            float r = (float)Math.min(w, h) * MotionLabel.this.mRoundPercent / 2.0f;
                            outline.setRoundRect(0, 0, w, h, r);
                        }
                    };
                    this.setOutlineProvider(this.mViewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int w = this.getWidth();
            int h = this.getHeight();
            float r = (float)Math.min(w, h) * this.mRoundPercent / 2.0f;
            this.mRect.set(0.0f, 0.0f, (float)w, (float)h);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, r, r, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (change && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    @RequiresApi(value=21)
    public void setRound(float round) {
        if (Float.isNaN(round)) {
            this.mRound = round;
            float tmp = this.mRoundPercent;
            this.mRoundPercent = -1.0f;
            this.setRoundPercent(tmp);
            return;
        }
        boolean change = this.mRound != round;
        this.mRound = round;
        if (this.mRound != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int w = MotionLabel.this.getWidth();
                            int h = MotionLabel.this.getHeight();
                            outline.setRoundRect(0, 0, w, h, MotionLabel.this.mRound);
                        }
                    };
                    this.setOutlineProvider(this.mViewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int w = this.getWidth();
            int h = this.getHeight();
            this.mRect.set(0.0f, 0.0f, (float)w, (float)h);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, this.mRound, this.mRound, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (change && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public float getRoundPercent() {
        return this.mRoundPercent;
    }

    public float getRound() {
        return this.mRound;
    }

    public void setTextSize(float size) {
        this.mTextSize = size;
        this.mPaint.setTextSize(Float.isNaN(this.mBaseTextSize) ? size : this.mBaseTextSize);
        this.buildShape(Float.isNaN(this.mBaseTextSize) ? 1.0f : this.mTextSize / this.mBaseTextSize);
        this.requestLayout();
        this.invalidate();
    }

    public int getTextOutlineColor() {
        return this.mTextOutlineColor;
    }

    public float getTextBackgroundPanX() {
        return this.mBackgroundPanX;
    }

    public float getTextBackgroundPanY() {
        return this.mBackgroundPanY;
    }

    public float getTextBackgroundZoom() {
        return this.mZoom;
    }

    public float getTextBackgroundRotate() {
        return this.mRotate;
    }

    public void setTextBackgroundPanX(float pan) {
        this.mBackgroundPanX = pan;
        this.updateShaderMatrix();
        this.invalidate();
    }

    public void setTextBackgroundPanY(float pan) {
        this.mBackgroundPanY = pan;
        this.updateShaderMatrix();
        this.invalidate();
    }

    public void setTextBackgroundZoom(float zoom) {
        this.mZoom = zoom;
        this.updateShaderMatrix();
        this.invalidate();
    }

    public void setTextBackgroundRotate(float rotation) {
        this.mRotate = rotation;
        this.updateShaderMatrix();
        this.invalidate();
    }

    private void updateShaderMatrix() {
        float panX = Float.isNaN(this.mBackgroundPanX) ? 0.0f : this.mBackgroundPanX;
        float panY = Float.isNaN(this.mBackgroundPanY) ? 0.0f : this.mBackgroundPanY;
        float zoom = Float.isNaN(this.mZoom) ? 1.0f : this.mZoom;
        float rota = Float.isNaN(this.mRotate) ? 0.0f : this.mRotate;
        this.mTextShaderMatrix.reset();
        float iw = this.mTextBackgroundBitmap.getWidth();
        float ih = this.mTextBackgroundBitmap.getHeight();
        float sw = Float.isNaN(this.mTextureWidth) ? this.mFloatWidth : this.mTextureWidth;
        float sh = Float.isNaN(this.mTextureHeight) ? this.mFloatHeight : this.mTextureHeight;
        float scale = zoom * (iw * sh < ih * sw ? sw / iw : sh / ih);
        this.mTextShaderMatrix.postScale(scale, scale);
        float gapx = sw - scale * iw;
        float gapy = sh - scale * ih;
        if (!Float.isNaN(this.mTextureHeight)) {
            gapy = this.mTextureHeight / 2.0f;
        }
        if (!Float.isNaN(this.mTextureWidth)) {
            gapx = this.mTextureWidth / 2.0f;
        }
        float tx = 0.5f * (panX * gapx + sw - scale * iw);
        float ty = 0.5f * (panY * gapy + sh - scale * ih);
        this.mTextShaderMatrix.postTranslate(tx, ty);
        this.mTextShaderMatrix.postRotate(rota, sw / 2.0f, sh / 2.0f);
        this.mTextShader.setLocalMatrix(this.mTextShaderMatrix);
    }

    public float getTextPanX() {
        return this.mTextPanX;
    }

    public void setTextPanX(float textPanX) {
        this.mTextPanX = textPanX;
        this.invalidate();
    }

    public float getTextPanY() {
        return this.mTextPanY;
    }

    public void setTextPanY(float textPanY) {
        this.mTextPanY = textPanY;
        this.invalidate();
    }

    public float getTextureHeight() {
        return this.mTextureHeight;
    }

    public void setTextureHeight(float mTextureHeight) {
        this.mTextureHeight = mTextureHeight;
        this.updateShaderMatrix();
        this.invalidate();
    }

    public float getTextureWidth() {
        return this.mTextureWidth;
    }

    public void setTextureWidth(float mTextureWidth) {
        this.mTextureWidth = mTextureWidth;
        this.updateShaderMatrix();
        this.invalidate();
    }

    public float getScaleFromTextSize() {
        return this.mBaseTextSize;
    }

    public void setScaleFromTextSize(float size) {
        this.mBaseTextSize = size;
    }
}

