/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.utils.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.utils.widget.MockView;
import androidx.constraintlayout.widget.R;

public class MotionTelltales
extends MockView {
    private static final String TAG = "MotionTelltales";
    private Paint mPaintTelltales = new Paint();
    MotionLayout mMotionLayout;
    float[] mVelocity = new float[2];
    Matrix mInvertMatrix = new Matrix();
    int mVelocityMode = 0;
    int mTailColor = -65281;
    float mTailScale = 0.25f;

    public MotionTelltales(Context context) {
        super(context);
        this.init(context, null);
    }

    public MotionTelltales(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MotionTelltales(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MotionTelltales);
            int count = a.getIndexCount();
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.MotionTelltales_telltales_tailColor) {
                    this.mTailColor = a.getColor(attr2, this.mTailColor);
                    continue;
                }
                if (attr2 == R.styleable.MotionTelltales_telltales_velocityMode) {
                    this.mVelocityMode = a.getInt(attr2, this.mVelocityMode);
                    continue;
                }
                if (attr2 != R.styleable.MotionTelltales_telltales_tailScale) continue;
                this.mTailScale = a.getFloat(attr2, this.mTailScale);
            }
            a.recycle();
        }
        this.mPaintTelltales.setColor(this.mTailColor);
        this.mPaintTelltales.setStrokeWidth(5.0f);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    public void setText(CharSequence text) {
        this.mText = text.toString();
        this.requestLayout();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.postInvalidate();
    }

    @Override
    public void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        Matrix matrix = this.getMatrix();
        matrix.invert(this.mInvertMatrix);
        if (this.mMotionLayout == null) {
            ViewParent vp = this.getParent();
            if (vp instanceof MotionLayout) {
                this.mMotionLayout = (MotionLayout)vp;
            }
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        float[] f = new float[]{0.1f, 0.25f, 0.5f, 0.75f, 0.9f};
        for (int y = 0; y < f.length; ++y) {
            float py = f[y];
            for (int x = 0; x < f.length; ++x) {
                float px = f[x];
                this.mMotionLayout.getViewVelocity(this, px, py, this.mVelocity, this.mVelocityMode);
                this.mInvertMatrix.mapVectors(this.mVelocity);
                float sx = (float)width * px;
                float sy = (float)height * py;
                float ex = sx - this.mVelocity[0] * this.mTailScale;
                float ey = sy - this.mVelocity[1] * this.mTailScale;
                this.mInvertMatrix.mapVectors(this.mVelocity);
                canvas.drawLine(sx, sy, ex, ey, this.mPaintTelltales);
            }
        }
    }
}

