/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import android.view.View;
import androidx.constraintlayout.widget.R;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

public class ConstraintAttribute {
    private static final String TAG = "TransitionLayout";
    private static final boolean DEBUG = false;
    private boolean mMethod = false;
    String mName;
    private AttributeType mType;
    private int mIntegerValue;
    private float mFloatValue;
    private String mStringValue;
    boolean mBooleanValue;
    private int mColorValue;

    public String getName() {
        return this.mName;
    }

    public boolean isMethod() {
        return this.mMethod;
    }

    public int getIntegerValue() {
        return this.mIntegerValue;
    }

    public float getFloatValue() {
        return this.mFloatValue;
    }

    public String getStringValue() {
        return this.mStringValue;
    }

    public boolean isBooleanValue() {
        return this.mBooleanValue;
    }

    public int getColorValue() {
        return this.mColorValue;
    }

    public AttributeType getType() {
        return this.mType;
    }

    public boolean isContinuous() {
        switch (this.mType.ordinal()) {
            case 4: 
            case 5: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    public void setFloatValue(float value) {
        this.mFloatValue = value;
    }

    public void setColorValue(int value) {
        this.mColorValue = value;
    }

    public void setIntValue(int value) {
        this.mIntegerValue = value;
    }

    public void setStringValue(String value) {
        this.mStringValue = value;
    }

    public int numberOfInterpolatedValues() {
        switch (this.mType.ordinal()) {
            case 2: 
            case 3: {
                return 4;
            }
        }
        return 1;
    }

    public float getValueToInterpolate() {
        switch (this.mType.ordinal()) {
            case 0: {
                return this.mIntegerValue;
            }
            case 1: 
            case 6: {
                return this.mFloatValue;
            }
            case 2: 
            case 3: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 4: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 5: {
                return this.mBooleanValue ? 1.0f : 0.0f;
            }
            case 7: {
                return Float.NaN;
            }
        }
        return Float.NaN;
    }

    public void getValuesToInterpolate(float[] ret) {
        switch (this.mType.ordinal()) {
            case 0: {
                ret[0] = this.mIntegerValue;
                break;
            }
            case 1: {
                ret[0] = this.mFloatValue;
                break;
            }
            case 2: 
            case 3: {
                int a = 0xFF & this.mColorValue >> 24;
                int r = 0xFF & this.mColorValue >> 16;
                int g = 0xFF & this.mColorValue >> 8;
                int b = 0xFF & this.mColorValue;
                float f_r = (float)Math.pow((float)r / 255.0f, 2.2);
                float f_g = (float)Math.pow((float)g / 255.0f, 2.2);
                float f_b = (float)Math.pow((float)b / 255.0f, 2.2);
                ret[0] = f_r;
                ret[1] = f_g;
                ret[2] = f_b;
                ret[3] = (float)a / 255.0f;
                break;
            }
            case 4: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 5: {
                ret[0] = this.mBooleanValue ? 1.0f : 0.0f;
                break;
            }
            case 6: {
                ret[0] = this.mFloatValue;
                break;
            }
        }
    }

    public void setValue(float[] value) {
        switch (this.mType.ordinal()) {
            case 0: 
            case 7: {
                this.mIntegerValue = (int)value[0];
                break;
            }
            case 1: {
                this.mFloatValue = value[0];
                break;
            }
            case 2: 
            case 3: {
                this.mColorValue = Color.HSVToColor((float[])value);
                this.mColorValue = this.mColorValue & 0xFFFFFF | ConstraintAttribute.clamp((int)(255.0f * value[3])) << 24;
                break;
            }
            case 4: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 5: {
                this.mBooleanValue = (double)value[0] > 0.5;
                break;
            }
            case 6: {
                this.mFloatValue = value[0];
                break;
            }
        }
    }

    public boolean diff(ConstraintAttribute constraintAttribute) {
        if (constraintAttribute == null || this.mType != constraintAttribute.mType) {
            return false;
        }
        switch (this.mType.ordinal()) {
            case 0: 
            case 7: {
                return this.mIntegerValue == constraintAttribute.mIntegerValue;
            }
            case 1: {
                return this.mFloatValue == constraintAttribute.mFloatValue;
            }
            case 2: 
            case 3: {
                return this.mColorValue == constraintAttribute.mColorValue;
            }
            case 4: {
                return this.mIntegerValue == constraintAttribute.mIntegerValue;
            }
            case 5: {
                return this.mBooleanValue == constraintAttribute.mBooleanValue;
            }
            case 6: {
                return this.mFloatValue == constraintAttribute.mFloatValue;
            }
        }
        return false;
    }

    public ConstraintAttribute(String name, AttributeType attributeType) {
        this.mName = name;
        this.mType = attributeType;
    }

    public ConstraintAttribute(String name, AttributeType attributeType, Object value, boolean method) {
        this.mName = name;
        this.mType = attributeType;
        this.mMethod = method;
        this.setValue(value);
    }

    public ConstraintAttribute(ConstraintAttribute source, Object value) {
        this.mName = source.mName;
        this.mType = source.mType;
        this.setValue(value);
    }

    public void setValue(Object value) {
        switch (this.mType.ordinal()) {
            case 0: 
            case 7: {
                this.mIntegerValue = (Integer)value;
                break;
            }
            case 1: {
                this.mFloatValue = ((Float)value).floatValue();
                break;
            }
            case 2: 
            case 3: {
                this.mColorValue = (Integer)value;
                break;
            }
            case 4: {
                this.mStringValue = (String)value;
                break;
            }
            case 5: {
                this.mBooleanValue = (Boolean)value;
                break;
            }
            case 6: {
                this.mFloatValue = ((Float)value).floatValue();
            }
        }
    }

    public static HashMap<String, ConstraintAttribute> extractAttributes(HashMap<String, ConstraintAttribute> base, View view) {
        HashMap<String, ConstraintAttribute> ret = new HashMap<String, ConstraintAttribute>();
        Class<?> viewClass = view.getClass();
        for (String name : base.keySet()) {
            ConstraintAttribute constraintAttribute = base.get(name);
            try {
                Object val;
                if (name.equals("BackgroundColor")) {
                    ColorDrawable viewColor = (ColorDrawable)view.getBackground();
                    val = viewColor.getColor();
                    ret.put(name, new ConstraintAttribute(constraintAttribute, val));
                    continue;
                }
                Method method = viewClass.getMethod("getMap" + name, new Class[0]);
                val = method.invoke((Object)view, new Object[0]);
                ret.put(name, new ConstraintAttribute(constraintAttribute, val));
            }
            catch (NoSuchMethodException e) {
                Log.e((String)TAG, (String)(viewClass.getName() + " must have a method " + name), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)(" Custom Attribute \"" + name + "\" not found on " + viewClass.getName()), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.e((String)TAG, (String)(" Custom Attribute \"" + name + "\" not found on " + viewClass.getName()), (Throwable)e);
            }
        }
        return ret;
    }

    public static void setAttributes(View view, HashMap<String, ConstraintAttribute> map) {
        Class<?> viewClass = view.getClass();
        for (String name : map.keySet()) {
            ConstraintAttribute constraintAttribute = map.get(name);
            String methodName = name;
            if (!constraintAttribute.mMethod) {
                methodName = "set" + methodName;
            }
            try {
                switch (constraintAttribute.mType.ordinal()) {
                    case 0: {
                        Method method = viewClass.getMethod(methodName, Integer.TYPE);
                        method.invoke((Object)view, constraintAttribute.mIntegerValue);
                        break;
                    }
                    case 1: {
                        Method method = viewClass.getMethod(methodName, Float.TYPE);
                        method.invoke((Object)view, Float.valueOf(constraintAttribute.mFloatValue));
                        break;
                    }
                    case 3: {
                        Method method = viewClass.getMethod(methodName, Drawable.class);
                        ColorDrawable drawable = new ColorDrawable();
                        drawable.setColor(constraintAttribute.mColorValue);
                        method.invoke((Object)view, drawable);
                        break;
                    }
                    case 2: {
                        Method method = viewClass.getMethod(methodName, Integer.TYPE);
                        method.invoke((Object)view, constraintAttribute.mColorValue);
                        break;
                    }
                    case 4: {
                        Method method = viewClass.getMethod(methodName, CharSequence.class);
                        method.invoke((Object)view, constraintAttribute.mStringValue);
                        break;
                    }
                    case 5: {
                        Method method = viewClass.getMethod(methodName, Boolean.TYPE);
                        method.invoke((Object)view, constraintAttribute.mBooleanValue);
                        break;
                    }
                    case 6: {
                        Method method = viewClass.getMethod(methodName, Float.TYPE);
                        method.invoke((Object)view, Float.valueOf(constraintAttribute.mFloatValue));
                        break;
                    }
                    case 7: {
                        Method method = viewClass.getMethod(methodName, Integer.TYPE);
                        method.invoke((Object)view, constraintAttribute.mIntegerValue);
                    }
                }
            }
            catch (NoSuchMethodException e) {
                Log.e((String)TAG, (String)(viewClass.getName() + " must have a method " + methodName), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)(" Custom Attribute \"" + name + "\" not found on " + viewClass.getName()), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.e((String)TAG, (String)(" Custom Attribute \"" + name + "\" not found on " + viewClass.getName()), (Throwable)e);
            }
        }
    }

    public void applyCustom(View view) {
        String name;
        Class<?> viewClass = view.getClass();
        String methodName = name = this.mName;
        if (!this.mMethod) {
            methodName = "set" + methodName;
        }
        try {
            switch (this.mType.ordinal()) {
                case 0: 
                case 7: {
                    Method method = viewClass.getMethod(methodName, Integer.TYPE);
                    method.invoke((Object)view, this.mIntegerValue);
                    break;
                }
                case 1: {
                    Method method = viewClass.getMethod(methodName, Float.TYPE);
                    method.invoke((Object)view, Float.valueOf(this.mFloatValue));
                    break;
                }
                case 3: {
                    Method method = viewClass.getMethod(methodName, Drawable.class);
                    ColorDrawable drawable = new ColorDrawable();
                    drawable.setColor(this.mColorValue);
                    method.invoke((Object)view, drawable);
                    break;
                }
                case 2: {
                    Method method = viewClass.getMethod(methodName, Integer.TYPE);
                    method.invoke((Object)view, this.mColorValue);
                    break;
                }
                case 4: {
                    Method method = viewClass.getMethod(methodName, CharSequence.class);
                    method.invoke((Object)view, this.mStringValue);
                    break;
                }
                case 5: {
                    Method method = viewClass.getMethod(methodName, Boolean.TYPE);
                    method.invoke((Object)view, this.mBooleanValue);
                    break;
                }
                case 6: {
                    Method method = viewClass.getMethod(methodName, Float.TYPE);
                    method.invoke((Object)view, Float.valueOf(this.mFloatValue));
                }
            }
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)(viewClass.getName() + " must have a method " + methodName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)(" Custom Attribute \"" + name + "\" not found on " + viewClass.getName()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)(" Custom Attribute \"" + name + "\" not found on " + viewClass.getName()), (Throwable)e);
        }
    }

    private static int clamp(int c) {
        int n = 255;
        c &= ~(c >> 31);
        c -= n;
        c &= c >> 31;
        return c += n;
    }

    public static void parse(Context context, XmlPullParser parser, HashMap<String, ConstraintAttribute> custom) {
        AttributeSet attributeSet = Xml.asAttributeSet((XmlPullParser)parser);
        TypedArray a = context.obtainStyledAttributes(attributeSet, R.styleable.CustomAttribute);
        String name = null;
        boolean method = false;
        Object value = null;
        AttributeType type = null;
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.CustomAttribute_attributeName) {
                name = a.getString(attr2);
                if (name == null || name.length() <= 0) continue;
                name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                continue;
            }
            if (attr2 == R.styleable.CustomAttribute_methodName) {
                method = true;
                name = a.getString(attr2);
                continue;
            }
            if (attr2 == R.styleable.CustomAttribute_customBoolean) {
                value = a.getBoolean(attr2, false);
                type = AttributeType.BOOLEAN_TYPE;
                continue;
            }
            if (attr2 == R.styleable.CustomAttribute_customColorValue) {
                type = AttributeType.COLOR_TYPE;
                value = a.getColor(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.CustomAttribute_customColorDrawableValue) {
                type = AttributeType.COLOR_DRAWABLE_TYPE;
                value = a.getColor(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.CustomAttribute_customPixelDimension) {
                type = AttributeType.DIMENSION_TYPE;
                value = Float.valueOf(TypedValue.applyDimension((int)1, (float)a.getDimension(attr2, 0.0f), (DisplayMetrics)context.getResources().getDisplayMetrics()));
                continue;
            }
            if (attr2 == R.styleable.CustomAttribute_customDimension) {
                type = AttributeType.DIMENSION_TYPE;
                value = Float.valueOf(a.getDimension(attr2, 0.0f));
                continue;
            }
            if (attr2 == R.styleable.CustomAttribute_customFloatValue) {
                type = AttributeType.FLOAT_TYPE;
                value = Float.valueOf(a.getFloat(attr2, Float.NaN));
                continue;
            }
            if (attr2 == R.styleable.CustomAttribute_customIntegerValue) {
                type = AttributeType.INT_TYPE;
                value = a.getInteger(attr2, -1);
                continue;
            }
            if (attr2 == R.styleable.CustomAttribute_customStringValue) {
                type = AttributeType.STRING_TYPE;
                value = a.getString(attr2);
                continue;
            }
            if (attr2 != R.styleable.CustomAttribute_customReference) continue;
            type = AttributeType.REFERENCE_TYPE;
            int tmp = a.getResourceId(attr2, -1);
            if (tmp == -1) {
                tmp = a.getInt(attr2, -1);
            }
            value = tmp;
        }
        if (name != null && value != null) {
            custom.put(name, new ConstraintAttribute(name, type, value, method));
        }
        a.recycle();
    }

    public static enum AttributeType {
        INT_TYPE,
        FLOAT_TYPE,
        COLOR_TYPE,
        COLOR_DRAWABLE_TYPE,
        STRING_TYPE,
        BOOLEAN_TYPE,
        DIMENSION_TYPE,
        REFERENCE_TYPE;

    }
}

