/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.annotation.SuppressLint;
import android.util.Log;
import androidx.constraintlayout.core.Metrics;
import androidx.constraintlayout.widget.ConstraintLayout;
import java.text.DecimalFormat;

public class ConstraintLayoutStatistics {
    public static final int NUMBER_OF_LAYOUTS = 1;
    public static final int NUMBER_OF_ON_MEASURES = 2;
    public static final int NUMBER_OF_CHILD_VIEWS = 3;
    public static final int NUMBER_OF_CHILD_MEASURES = 4;
    public static final int DURATION_OF_CHILD_MEASURES = 5;
    public static final int DURATION_OF_MEASURES = 6;
    public static final int DURATION_OF_LAYOUT = 7;
    public static final int NUMBER_OF_VARIABLES = 8;
    public static final int NUMBER_OF_EQUATIONS = 9;
    public static final int NUMBER_OF_SIMPLE_EQUATIONS = 10;
    private final Metrics mMetrics = new Metrics();
    ConstraintLayout mConstraintLayout;
    private static int MAX_WORD = 25;
    private static final String WORD_PAD = new String(new char[MAX_WORD]).replace('\u0000', ' ');

    public ConstraintLayoutStatistics(ConstraintLayout constraintLayout) {
        this.attach(constraintLayout);
    }

    public ConstraintLayoutStatistics(ConstraintLayoutStatistics copy) {
        this.mMetrics.copy(copy.mMetrics);
    }

    public void attach(ConstraintLayout constraintLayout) {
        constraintLayout.fillMetrics(this.mMetrics);
        this.mConstraintLayout = constraintLayout;
    }

    public void detach() {
        if (this.mConstraintLayout != null) {
            this.mConstraintLayout.fillMetrics(null);
        }
    }

    public void reset() {
        this.mMetrics.reset();
    }

    public ConstraintLayoutStatistics clone() {
        return new ConstraintLayoutStatistics(this);
    }

    private String fmt(DecimalFormat df, float val, int length) {
        String s = new String(new char[length]).replace('\u0000', ' ');
        s = s + df.format(val);
        return s.substring(s.length() - length);
    }

    public void logSummary(String tag) {
        this.log(tag);
    }

    @SuppressLint(value={"LogConditional"})
    private void log(String tag) {
        StackTraceElement s = new Throwable().getStackTrace()[2];
        Log.v((String)tag, (String)("CL Perf: --------  Performance .(" + s.getFileName() + ":" + s.getLineNumber() + ")  ------ "));
        DecimalFormat df = new DecimalFormat("###.000");
        Log.v((String)tag, (String)this.log(df, 5));
        Log.v((String)tag, (String)this.log(df, 7));
        Log.v((String)tag, (String)this.log(df, 6));
        Log.v((String)tag, (String)this.log(1));
        Log.v((String)tag, (String)this.log(2));
        Log.v((String)tag, (String)this.log(3));
        Log.v((String)tag, (String)this.log(4));
        Log.v((String)tag, (String)this.log(8));
        Log.v((String)tag, (String)this.log(9));
        Log.v((String)tag, (String)this.log(10));
    }

    private String log(DecimalFormat df, int param) {
        String value = this.fmt(df, (float)this.getValue(param) * 1.0E-6f, 7);
        String title = this.geName(param);
        title = WORD_PAD + title;
        title = title.substring(title.length() - MAX_WORD);
        title = title + " = ";
        return "CL Perf: " + title + value;
    }

    private String log(int param) {
        String value = Long.toString(this.getValue(param));
        String title = this.geName(param);
        title = WORD_PAD + title;
        title = title.substring(title.length() - MAX_WORD);
        title = title + " = ";
        return "CL Perf: " + title + value;
    }

    private String compare(DecimalFormat df, ConstraintLayoutStatistics relative, int param) {
        String value = this.fmt(df, (float)this.getValue(param) * 1.0E-6f, 7);
        value = value + " -> " + this.fmt(df, (float)relative.getValue(param) * 1.0E-6f, 7) + "ms";
        String title = this.geName(param);
        title = WORD_PAD + title;
        title = title.substring(title.length() - MAX_WORD);
        title = title + " = ";
        return "CL Perf: " + title + value;
    }

    private String compare(ConstraintLayoutStatistics relative, int param) {
        String value = this.getValue(param) + " -> " + relative.getValue(param);
        String title = this.geName(param);
        title = WORD_PAD + title;
        title = title.substring(title.length() - MAX_WORD);
        title = title + " = ";
        return "CL Perf: " + title + value;
    }

    @SuppressLint(value={"LogConditional"})
    public void logSummary(String tag, ConstraintLayoutStatistics prev) {
        if (prev == null) {
            this.log(tag);
            return;
        }
        DecimalFormat df = new DecimalFormat("###.000");
        StackTraceElement s = new Throwable().getStackTrace()[1];
        Log.v((String)tag, (String)("CL Perf: -=  Performance .(" + s.getFileName() + ":" + s.getLineNumber() + ")  =- "));
        Log.v((String)tag, (String)this.compare(df, prev, 5));
        Log.v((String)tag, (String)this.compare(df, prev, 7));
        Log.v((String)tag, (String)this.compare(df, prev, 6));
        Log.v((String)tag, (String)this.compare(prev, 1));
        Log.v((String)tag, (String)this.compare(prev, 2));
        Log.v((String)tag, (String)this.compare(prev, 3));
        Log.v((String)tag, (String)this.compare(prev, 4));
        Log.v((String)tag, (String)this.compare(prev, 8));
        Log.v((String)tag, (String)this.compare(prev, 9));
        Log.v((String)tag, (String)this.compare(prev, 10));
    }

    public long getValue(int type) {
        switch (type) {
            case 1: {
                return this.mMetrics.mNumberOfLayouts;
            }
            case 2: {
                return this.mMetrics.mMeasureCalls;
            }
            case 3: {
                return this.mMetrics.mChildCount;
            }
            case 4: {
                return this.mMetrics.mNumberOfMeasures;
            }
            case 5: {
                return this.mMetrics.measuresWidgetsDuration;
            }
            case 6: {
                return this.mMetrics.mMeasureDuration;
            }
            case 7: {
                return this.mMetrics.measuresLayoutDuration;
            }
            case 8: {
                return this.mMetrics.mVariables;
            }
            case 9: {
                return this.mMetrics.mEquations;
            }
            case 10: {
                return this.mMetrics.mSimpleEquations;
            }
        }
        return 0L;
    }

    String geName(int type) {
        switch (type) {
            case 1: {
                return "NumberOfLayouts";
            }
            case 2: {
                return "MeasureCalls";
            }
            case 3: {
                return "ChildCount";
            }
            case 4: {
                return "ChildrenMeasures";
            }
            case 5: {
                return "MeasuresWidgetsDuration ";
            }
            case 6: {
                return "MeasureDuration";
            }
            case 7: {
                return "MeasuresLayoutDuration";
            }
            case 8: {
                return "SolverVariables";
            }
            case 9: {
                return "SolverEquations";
            }
            case 10: {
                return "SimpleEquations";
            }
        }
        return "";
    }
}

